/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.schemehandlers;

import android.content.Context;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.gotev.uploadservice.extensions.StringExtensionsKt;
import net.gotev.uploadservice.logger.UploadServiceLogger;
import net.gotev.uploadservice.schemehandlers.FileSchemeHandler;
import net.gotev.uploadservice.schemehandlers.SchemeHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/gotev/uploadservice/schemehandlers/FileSchemeHandler;", "Lnet/gotev/uploadservice/schemehandlers/SchemeHandler;", "()V", "file", "Ljava/io/File;", "contentType", "", "context", "Landroid/content/Context;", "delete", "", "init", "", "path", "name", "size", "", "stream", "Ljava/io/FileInputStream;", "uploadservice_release"})
public final class FileSchemeHandler
implements SchemeHandler {
    private File file;

    @Override
    public void init(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.file = new File(path);
    }

    @Override
    public long size(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        File file2 = this.file;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        return file2.length();
    }

    @Override
    @NotNull
    public FileInputStream stream(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        File file2 = this.file;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        return new FileInputStream(file2);
    }

    @Override
    @NotNull
    public String contentType(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        File file2 = this.file;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        String string = file2.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
        return StringExtensionsKt.autoDetectMimeType(string);
    }

    @Override
    @NotNull
    public String name(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        File file2 = this.file;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"file");
        }
        String string = file2.getName();
        if (string == null) {
            StringBuilder stringBuilder = new StringBuilder().append("Can't get file name for ");
            File file3 = this.file;
            if (file3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"file");
            }
            throw (Throwable)new IOException(stringBuilder.append(file3.getAbsolutePath()).toString());
        }
        return string;
    }

    @Override
    public boolean delete(@NotNull Context context) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            File file2 = this.file;
            if (file2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"file");
            }
            bl = file2.delete();
        }
        catch (Throwable exc) {
            String string = this.getClass().getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
            UploadServiceLogger.error(string, "N/A", exc, (Function0<String>)((Function0)delete.1.INSTANCE));
            bl = false;
        }
        return bl;
    }
}

