/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.schemehandlers;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.gotev.uploadservice.logger.UploadServiceLogger;
import net.gotev.uploadservice.schemehandlers.ContentResolverSchemeHandler;
import net.gotev.uploadservice.schemehandlers.SchemeHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/gotev/uploadservice/schemehandlers/ContentResolverSchemeHandler;", "Lnet/gotev/uploadservice/schemehandlers/SchemeHandler;", "()V", "uri", "Landroid/net/Uri;", "contentType", "", "context", "Landroid/content/Context;", "delete", "", "init", "", "path", "name", "size", "", "stream", "Ljava/io/InputStream;", "uploadservice_release"})
public final class ContentResolverSchemeHandler
implements SchemeHandler {
    private Uri uri;

    @Override
    public void init(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Uri uri = Uri.parse((String)path);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(path)");
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long size(@NotNull Context context) {
        Cursor cursor;
        block11: {
            boolean bl;
            Object object;
            block10: {
                Cursor cursor2;
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri = this.uri;
                if (uri == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                }
                if ((cursor = contentResolver.query(uri, null, null, null, null)) == null) break block10;
                object = (Closeable)cursor;
                bl = false;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)object;
                    boolean bl2 = false;
                    it = it.moveToFirst() ? Long.valueOf(it.getLong(it.getColumnIndex("_size"))) : null;
                    cursor2 = it;
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                cursor = cursor2;
                if (cursor2 != null) break block11;
            }
            object = this;
            bl = false;
            boolean bl3 = false;
            ContentResolverSchemeHandler $this$run = (ContentResolverSchemeHandler)object;
            boolean bl4 = false;
            String string = $this$run.getClass().getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
            UploadServiceLogger.error$default(string, "N/A", null, (Function0)new Function0<String>($this$run){
                final /* synthetic */ ContentResolverSchemeHandler $this_run;

                @NotNull
                public final String invoke() {
                    return "no cursor data for " + ContentResolverSchemeHandler.access$getUri$p(this.$this_run) + ", returning size 0";
                }
                {
                    this.$this_run = contentResolverSchemeHandler;
                    super(0);
                }
            }, 4, null);
            return 0L;
        }
        long l = cursor.longValue();
        return l;
    }

    @Override
    @NotNull
    public InputStream stream(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ContentResolver contentResolver = context.getContentResolver();
        Uri uri = this.uri;
        if (uri == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
        }
        InputStream inputStream = contentResolver.openInputStream(uri);
        if (inputStream == null) {
            StringBuilder stringBuilder = new StringBuilder().append("can't open input stream for ");
            Uri uri2 = this.uri;
            if (uri2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
            }
            throw (Throwable)new IOException(stringBuilder.append(uri2).toString());
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"context.contentResolver.\u2026n input stream for $uri\")");
        return inputStream;
    }

    @Override
    @NotNull
    public String contentType(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ContentResolver contentResolver = context.getContentResolver();
        Uri uri = this.uri;
        if (uri == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
        }
        String type = contentResolver.getType(uri);
        CharSequence charSequence = type;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? "application/octet-stream" : type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String name(@NotNull Context context) {
        Object object;
        block12: {
            block11: {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                ContentResolver contentResolver = context.getContentResolver();
                Uri uri = this.uri;
                if (uri == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
                }
                if ((object = contentResolver.query(uri, null, null, null, null)) == null) break block11;
                Closeable closeable = (Closeable)object;
                boolean bl = false;
                Throwable throwable = null;
                try {
                    Cursor it = (Cursor)closeable;
                    boolean bl2 = false;
                    String string2 = it.moveToFirst() ? it.getString(it.getColumnIndex("_display_name")) : null;
                    string = string2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = string;
                if (string != null) break block12;
            }
            Uri uri = this.uri;
            if (uri == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
            }
            String string = uri.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.toString()");
            CharSequence charSequence = string;
            String[] stringArray = new String[1];
            String string3 = File.separator;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"File.separator");
            stringArray[0] = string3;
            object = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)charSequence, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        return object;
    }

    @Override
    public boolean delete(@NotNull Context context) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        try {
            ContentResolver contentResolver = context.getContentResolver();
            Uri uri = this.uri;
            if (uri == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
            }
            bl = contentResolver.delete(uri, null, null) > 0;
        }
        catch (Throwable exc) {
            String string = this.getClass().getSimpleName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
            UploadServiceLogger.error(string, "N/A", exc, (Function0<String>)((Function0)delete.1.INSTANCE));
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ Uri access$getUri$p(ContentResolverSchemeHandler $this) {
        Uri uri = $this.uri;
        if (uri == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"uri");
        }
        return uri;
    }

    public static final /* synthetic */ void access$setUri$p(ContentResolverSchemeHandler $this, Uri uri) {
        $this.uri = uri;
    }
}

