/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.protocols.multipart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.gotev.uploadservice.HttpUploadTask;
import net.gotev.uploadservice.data.NameValue;
import net.gotev.uploadservice.data.UploadFile;
import net.gotev.uploadservice.extensions.CollectionsExtensionsKt;
import net.gotev.uploadservice.extensions.StringExtensionsKt;
import net.gotev.uploadservice.network.BodyWriter;
import net.gotev.uploadservice.protocols.multipart.UploadFileExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001bH\u0016J\f\u0010\u001f\u001a\u00020\u001b*\u00020\u001dH\u0002J\f\u0010 \u001a\u00020\u001b*\u00020\u001dH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u000e\u0010\r\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0011\u001a\u00020\n*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0011\u001a\u00020\n*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0016R\u0018\u0010\u0017\u001a\u00020\u0004*\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lnet/gotev/uploadservice/protocols/multipart/MultipartUploadTask;", "Lnet/gotev/uploadservice/HttpUploadTask;", "()V", "bodyLength", "", "getBodyLength", "()J", "boundary", "", "boundaryBytes", "", "filesLength", "getFilesLength", "newLineBytes", "requestParametersLength", "getRequestParametersLength", "trailerBytes", "multipartHeader", "Lnet/gotev/uploadservice/data/NameValue;", "getMultipartHeader", "(Lnet/gotev/uploadservice/data/NameValue;)[B", "Lnet/gotev/uploadservice/data/UploadFile;", "(Lnet/gotev/uploadservice/data/UploadFile;)[B", "totalMultipartBytes", "getTotalMultipartBytes", "(Lnet/gotev/uploadservice/data/UploadFile;)J", "onWriteRequestBody", "", "bodyWriter", "Lnet/gotev/uploadservice/network/BodyWriter;", "performInitialization", "writeFiles", "writeRequestParameters", "Companion", "uploadservice_release"})
public final class MultipartUploadTask
extends HttpUploadTask {
    private final String boundary = "-------UploadService4.2.3-" + System.nanoTime();
    private final byte[] boundaryBytes = StringExtensionsKt.getAsciiByes("--" + this.boundary + "\r\n");
    private final byte[] trailerBytes = StringExtensionsKt.getAsciiByes("--" + this.boundary + "--" + "\r\n");
    private final byte[] newLineBytes = StringExtensionsKt.getUtf8Bytes("\r\n");
    private static final String BOUNDARY_SIGNATURE = "-------UploadService4.2.3-";
    private static final String NEW_LINE = "\r\n";
    private static final String TWO_HYPHENS = "--";
    public static final Companion Companion = new Companion(null);

    private final byte[] getMultipartHeader(@NotNull NameValue $this$multipartHeader) {
        return ArraysKt.plus((byte[])this.boundaryBytes, (byte[])StringExtensionsKt.getUtf8Bytes("Content-Disposition: form-data; " + "name=\"" + $this$multipartHeader.getName() + "\"\r\n\r\n" + $this$multipartHeader.getValue() + NEW_LINE));
    }

    private final byte[] getMultipartHeader(@NotNull UploadFile $this$multipartHeader) {
        return ArraysKt.plus((byte[])this.boundaryBytes, (byte[])StringExtensionsKt.getUtf8Bytes("Content-Disposition: form-data; " + "name=\"" + UploadFileExtensionsKt.getParameterName($this$multipartHeader) + "\"; " + "filename=\"" + UploadFileExtensionsKt.getRemoteFileName($this$multipartHeader) + "\"\r\n" + "Content-Type: " + UploadFileExtensionsKt.getContentType($this$multipartHeader) + "\r\n\r\n"));
    }

    private final long getTotalMultipartBytes(@NotNull UploadFile $this$totalMultipartBytes) {
        return (long)this.getMultipartHeader($this$totalMultipartBytes).length + $this$totalMultipartBytes.getHandler().size(this.getContext()) + (long)this.newLineBytes.length;
    }

    private final void writeRequestParameters(@NotNull BodyWriter $this$writeRequestParameters) {
        Iterable $this$forEach$iv = this.getHttpParams().getRequestParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NameValue it = (NameValue)element$iv;
            boolean bl = false;
            $this$writeRequestParameters.write(this.getMultipartHeader(it));
        }
    }

    private final void writeFiles(@NotNull BodyWriter $this$writeFiles) {
        for (UploadFile file2 : this.getParams().getFiles()) {
            if (!this.getShouldContinue()) break;
            UploadFile uploadFile = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)uploadFile, (String)"file");
            $this$writeFiles.write(this.getMultipartHeader(uploadFile));
            $this$writeFiles.writeStream(file2.getHandler().stream(this.getContext()));
            $this$writeFiles.write(this.newLineBytes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long getRequestParametersLength() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getHttpParams().getRequestParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NameValue nameValue = (NameValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = this.getMultipartHeader((NameValue)it).length;
            collection.add(l);
        }
        return CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final long getFilesLength() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getParams().getFiles();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UploadFile uploadFile = (UploadFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Long l = this.getTotalMultipartBytes((UploadFile)it);
            collection.add(l);
        }
        return CollectionsKt.sumOfLong((Iterable)((List)destination$iv$iv));
    }

    @Override
    public long getBodyLength() {
        return this.getRequestParametersLength() + this.getFilesLength() + (long)this.trailerBytes.length;
    }

    @Override
    public void performInitialization() {
        ArrayList<NameValue> arrayList = this.getHttpParams().getRequestHeaders();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<NameValue> $this$apply = arrayList;
        boolean bl3 = false;
        CollectionsExtensionsKt.addHeader($this$apply, "Content-Type", "multipart/form-data; boundary=" + this.boundary);
        CollectionsExtensionsKt.addHeader($this$apply, "Connection", this.getParams().getFiles().size() <= 1 ? "close" : "Keep-Alive");
    }

    @Override
    public void onWriteRequestBody(@NotNull BodyWriter bodyWriter) {
        Intrinsics.checkParameterIsNotNull((Object)bodyWriter, (String)"bodyWriter");
        this.resetUploadedBytes();
        this.setAllFilesHaveBeenSuccessfullyUploaded(false);
        BodyWriter bodyWriter2 = bodyWriter;
        boolean bl = false;
        boolean bl2 = false;
        BodyWriter $this$apply = bodyWriter2;
        boolean bl3 = false;
        this.writeRequestParameters($this$apply);
        this.writeFiles($this$apply);
        $this$apply.write(this.trailerBytes);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lnet/gotev/uploadservice/protocols/multipart/MultipartUploadTask$Companion;", "", "()V", "BOUNDARY_SIGNATURE", "", "NEW_LINE", "TWO_HYPHENS", "uploadservice_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

