/*
 * Decompiled with CFR 0.152.
 */
package net.gotev.uploadservice.observer.request;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import androidx.lifecycle.LifecycleObserver;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.gotev.uploadservice.UploadRequest;
import net.gotev.uploadservice.UploadService;
import net.gotev.uploadservice.UploadServiceConfig;
import net.gotev.uploadservice.data.BroadcastData;
import net.gotev.uploadservice.data.UploadInfo;
import net.gotev.uploadservice.network.ServerResponse;
import net.gotev.uploadservice.observer.request.ManualRequestObserver$WhenMappings;
import net.gotev.uploadservice.observer.request.RequestObserver;
import net.gotev.uploadservice.observer.request.RequestObserverDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\f2\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/gotev/uploadservice/observer/request/ManualRequestObserver;", "Landroid/content/BroadcastReceiver;", "Landroidx/lifecycle/LifecycleObserver;", "Lnet/gotev/uploadservice/observer/request/RequestObserver;", "context", "Landroid/content/Context;", "delegate", "Lnet/gotev/uploadservice/observer/request/RequestObserverDelegate;", "(Landroid/content/Context;Lnet/gotev/uploadservice/observer/request/RequestObserverDelegate;)V", "subscribedUploadID", "", "onReceive", "", "intent", "Landroid/content/Intent;", "register", "shouldAcceptEventFrom", "", "uploadInfo", "Lnet/gotev/uploadservice/data/UploadInfo;", "subscribe", "request", "Lnet/gotev/uploadservice/UploadRequest;", "unregister", "uploadservice_release"})
public class ManualRequestObserver
extends BroadcastReceiver
implements LifecycleObserver,
RequestObserver {
    private String subscribedUploadID;
    private final Context context;
    private final RequestObserverDelegate delegate;

    public void onReceive(@NotNull Context context, @Nullable Intent intent) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intent intent2 = intent;
        if (intent2 == null) {
            return;
        }
        Intent safeIntent = intent2;
        if (Intrinsics.areEqual((Object)safeIntent.getAction(), (Object)UploadServiceConfig.getBroadcastStatusAction()) ^ true) {
            return;
        }
        BroadcastData broadcastData = BroadcastData.Companion.fromIntent(safeIntent);
        if (broadcastData == null) {
            return;
        }
        BroadcastData data = broadcastData;
        UploadInfo uploadInfo = data.getUploadInfo();
        if (!this.shouldAcceptEventFrom(uploadInfo)) {
            return;
        }
        switch (ManualRequestObserver$WhenMappings.$EnumSwitchMapping$0[data.getStatus().ordinal()]) {
            case 1: {
                this.delegate.onProgress(context, uploadInfo);
                break;
            }
            case 2: {
                Throwable throwable = data.getException();
                if (throwable == null) {
                    Intrinsics.throwNpe();
                }
                this.delegate.onError(context, uploadInfo, throwable);
                break;
            }
            case 3: {
                ServerResponse serverResponse = data.getServerResponse();
                if (serverResponse == null) {
                    Intrinsics.throwNpe();
                }
                this.delegate.onSuccess(context, uploadInfo, serverResponse);
                break;
            }
            case 4: {
                this.delegate.onCompleted(context, uploadInfo);
            }
        }
    }

    private final boolean shouldAcceptEventFrom(UploadInfo uploadInfo) {
        String string = this.subscribedUploadID;
        if (string == null) {
            return true;
        }
        String uploadId = string;
        return Intrinsics.areEqual((Object)uploadId, (Object)uploadInfo.getUploadId());
    }

    @Override
    public void register() {
        block1: {
            LocalBroadcastManager.getInstance((Context)this.context).registerReceiver((BroadcastReceiver)this, UploadServiceConfig.getBroadcastStatusIntentFilter());
            String string = this.subscribedUploadID;
            if (string == null) break block1;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            if (!UploadService.Companion.getTaskList().contains(it)) {
                this.delegate.onCompletedWhileNotObserving();
            }
        }
    }

    @Override
    public void unregister() {
        LocalBroadcastManager.getInstance((Context)this.context).unregisterReceiver((BroadcastReceiver)this);
    }

    @Override
    public void subscribe(@NotNull UploadRequest<?> request) {
        Intrinsics.checkParameterIsNotNull(request, (String)"request");
        this.subscribedUploadID = request.startUpload();
    }

    public ManualRequestObserver(@NotNull Context context, @NotNull RequestObserverDelegate delegate) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        this.context = context;
        this.delegate = delegate;
    }
}

