/*
 * Decompiled with CFR 0.152.
 */
package net.qiujuer.genius.kit.handler;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import net.qiujuer.genius.kit.handler.Poster;
import net.qiujuer.genius.kit.handler.Task;

final class HandlerPoster
extends Handler
implements Poster {
    private static int MAX_MILLIS_INSIDE_HANDLE_MESSAGE = 16;
    private final Dispatcher mAsyncDispatcher;
    private final Dispatcher mSyncDispatcher;

    HandlerPoster(Looper looper, int maxMillisInsideHandleMessage, boolean onlyAsync) {
        super(looper);
        MAX_MILLIS_INSIDE_HANDLE_MESSAGE = maxMillisInsideHandleMessage;
        this.mAsyncDispatcher = new Dispatcher(new LinkedList<Task>(), new Dispatcher.IPoster(){

            @Override
            public void sendMessage() {
                HandlerPoster.this.sendMessage(0x10101010);
            }
        });
        this.mSyncDispatcher = onlyAsync ? this.mAsyncDispatcher : new Dispatcher(new LinkedList<Task>(), new Dispatcher.IPoster(){

            @Override
            public void sendMessage() {
                HandlerPoster.this.sendMessage(0x20202020);
            }
        });
    }

    @Override
    public void dispose() {
        this.removeCallbacksAndMessages(null);
        this.mAsyncDispatcher.dispose();
        this.mSyncDispatcher.dispose();
    }

    @Override
    public void async(Task task) {
        this.mAsyncDispatcher.offer(task);
    }

    @Override
    public void sync(Task task) {
        this.mSyncDispatcher.offer(task);
    }

    public void handleMessage(Message msg) {
        if (msg.what == 0x10101010) {
            this.mAsyncDispatcher.dispatch();
        } else if (msg.what == 0x20202020) {
            this.mSyncDispatcher.dispatch();
        } else {
            super.handleMessage(msg);
        }
    }

    private void sendMessage(int what) {
        if (!this.sendMessage(this.obtainMessage(what))) {
            throw new RuntimeException("Could not send handler message");
        }
    }

    private static class Dispatcher {
        private final Queue<Task> mPool;
        private IPoster mPoster;
        private boolean isActive;

        Dispatcher(Queue<Task> pool, IPoster poster) {
            this.mPool = pool;
            this.mPoster = poster;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void offer(Task task) {
            Queue<Task> queue = this.mPool;
            synchronized (queue) {
                this.mPool.offer(task);
                task.setPool(this.mPool);
                if (!this.isActive) {
                    this.isActive = true;
                    IPoster poster = this.mPoster;
                    if (poster != null) {
                        poster.sendMessage();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void dispatch() {
            boolean rescheduled = false;
            try {
                long timeInMethod;
                long started = SystemClock.uptimeMillis();
                do {
                    Runnable runnable;
                    if ((runnable = this.poll()) == null) {
                        Queue<Task> queue = this.mPool;
                        synchronized (queue) {
                            runnable = this.poll();
                            if (runnable == null) {
                                this.isActive = false;
                                return;
                            }
                        }
                    }
                    runnable.run();
                } while ((timeInMethod = SystemClock.uptimeMillis() - started) < (long)MAX_MILLIS_INSIDE_HANDLE_MESSAGE);
                IPoster poster = this.mPoster;
                if (poster != null) {
                    poster.sendMessage();
                }
                rescheduled = true;
                return;
            }
            finally {
                this.isActive = rescheduled;
            }
        }

        void dispose() {
            this.mPool.clear();
            this.mPoster = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Runnable poll() {
            Queue<Task> queue = this.mPool;
            synchronized (queue) {
                try {
                    return this.mPool.poll();
                }
                catch (NoSuchElementException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }

        static interface IPoster {
            public void sendMessage();
        }
    }
}

