/*
 * Decompiled with CFR 0.152.
 */
package net.qiujuer.genius.kit.handler;

import java.util.Queue;
import net.qiujuer.genius.kit.handler.Task;
import net.qiujuer.genius.kit.handler.runable.Func;

final class FuncSyncTask<T>
implements Func<T>,
Task {
    private final Func<T> mFunc;
    private T mResult;
    private boolean mDone = false;
    private Queue<Task> mPool = null;

    FuncSyncTask(Func<T> func) {
        this.mFunc = func;
    }

    @Override
    public T call() {
        this.mPool = null;
        return this.mFunc.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.mDone) {
            FuncSyncTask funcSyncTask = this;
            synchronized (funcSyncTask) {
                if (!this.mDone) {
                    this.mResult = this.call();
                    this.mDone = true;
                    try {
                        this.notifyAll();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T waitRun() {
        if (!this.mDone) {
            FuncSyncTask funcSyncTask = this;
            synchronized (funcSyncTask) {
                while (!this.mDone) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        return this.mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T waitRun(long waitMillis, int waitNanos, boolean cancelOnTimeOut) {
        if (!this.mDone) {
            FuncSyncTask funcSyncTask = this;
            synchronized (funcSyncTask) {
                if (!this.mDone) {
                    try {
                        this.wait(waitMillis, waitNanos);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        if (!this.mDone && cancelOnTimeOut) {
                            this.mDone = true;
                        }
                    }
                }
            }
        }
        return this.mResult;
    }

    @Override
    public void setPool(Queue<Task> pool) {
        this.mPool = pool;
    }

    @Override
    public boolean isDone() {
        return this.mDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (!this.mDone) {
            FuncSyncTask funcSyncTask = this;
            synchronized (funcSyncTask) {
                this.mDone = true;
                if (this.mPool != null) {
                    Queue<Task> queue = this.mPool;
                    synchronized (queue) {
                        if (this.mPool != null) {
                            try {
                                this.mPool.remove(this);
                            }
                            catch (Exception e) {
                                e.getStackTrace();
                            }
                            finally {
                                this.mPool = null;
                            }
                        }
                    }
                }
            }
        }
    }
}

