/*
 * Decompiled with CFR 0.152.
 */
package net.qiujuer.genius.kit.handler;

import java.util.Queue;
import net.qiujuer.genius.kit.handler.Task;
import net.qiujuer.genius.kit.handler.runable.Action;

final class ActionSyncTask
implements Action,
Task {
    private final Action mAction;
    private boolean mDone = false;
    private Queue<Task> mPool = null;

    ActionSyncTask(Action action) {
        this.mAction = action;
    }

    @Override
    public void call() {
        this.mPool = null;
        this.mAction.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (!this.mDone) {
            ActionSyncTask actionSyncTask = this;
            synchronized (actionSyncTask) {
                if (!this.mDone) {
                    this.call();
                    this.mDone = true;
                    try {
                        this.notifyAll();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitRun() {
        if (!this.mDone) {
            ActionSyncTask actionSyncTask = this;
            synchronized (actionSyncTask) {
                while (!this.mDone) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitRun(long waitMillis, int waitNanos, boolean cancelOnTimeOut) {
        if (!this.mDone) {
            ActionSyncTask actionSyncTask = this;
            synchronized (actionSyncTask) {
                if (!this.mDone) {
                    try {
                        this.wait(waitMillis, waitNanos);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        if (!this.mDone && cancelOnTimeOut) {
                            this.mDone = true;
                        }
                    }
                }
            }
        }
    }

    @Override
    public void setPool(Queue<Task> pool) {
        this.mPool = pool;
    }

    @Override
    public boolean isDone() {
        return this.mDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (!this.mDone) {
            ActionSyncTask actionSyncTask = this;
            synchronized (actionSyncTask) {
                this.mDone = true;
                if (this.mPool != null) {
                    Queue<Task> queue = this.mPool;
                    synchronized (queue) {
                        if (this.mPool != null) {
                            try {
                                this.mPool.remove(this);
                            }
                            catch (Exception e) {
                                e.getStackTrace();
                            }
                            finally {
                                this.mPool = null;
                            }
                        }
                    }
                }
            }
        }
    }
}

