/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.parser;

import io.jstuff.text.SimpleMatcher;
import io.jstuff.text.StringMatcher;
import io.jstuff.text.WildcardMatcher;
import io.kjson.JSON;
import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONLong;
import io.kjson.JSONNumber;
import io.kjson.JSONObject;
import io.kjson.JSONPrimitive;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.pointer.FindKt;
import io.kjson.pointer.IndexOpKt;
import io.kjson.pointer.JSONPointer;
import io.kjson.resource.ResourceLoader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.output.BasicOutput;
import net.pwall.json.schema.parser.InputDetails;
import net.pwall.json.schema.parser.JSONReader;
import net.pwall.json.schema.parser.Parser;
import net.pwall.json.schema.subschema.AdditionalItemsSchema;
import net.pwall.json.schema.subschema.AdditionalPropertiesSchema;
import net.pwall.json.schema.subschema.AllOfSchema;
import net.pwall.json.schema.subschema.AnyOfSchema;
import net.pwall.json.schema.subschema.ExtensionSchema;
import net.pwall.json.schema.subschema.IfThenElseSchema;
import net.pwall.json.schema.subschema.ItemsArraySchema;
import net.pwall.json.schema.subschema.ItemsSchema;
import net.pwall.json.schema.subschema.OneOfSchema;
import net.pwall.json.schema.subschema.PatternPropertiesSchema;
import net.pwall.json.schema.subschema.PropertiesSchema;
import net.pwall.json.schema.subschema.PropertyNamesSchema;
import net.pwall.json.schema.subschema.RefSchema;
import net.pwall.json.schema.subschema.RequiredSchema;
import net.pwall.json.schema.validation.ArrayValidator;
import net.pwall.json.schema.validation.ConstValidator;
import net.pwall.json.schema.validation.ContainsValidator;
import net.pwall.json.schema.validation.DefaultValidator;
import net.pwall.json.schema.validation.DelegatingValidator;
import net.pwall.json.schema.validation.EnumValidator;
import net.pwall.json.schema.validation.FormatValidator;
import net.pwall.json.schema.validation.NumberValidator;
import net.pwall.json.schema.validation.PatternValidator;
import net.pwall.json.schema.validation.PropertiesValidator;
import net.pwall.json.schema.validation.StringValidator;
import net.pwall.json.schema.validation.TypeValidator;
import net.pwall.json.schema.validation.UniqueItemsValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u0000 \u0090\u00012\u00020\u0001:\u0004\u008f\u0001\u0090\u0001B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0018\b\u0002\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u001c\u00100\u001a\u0002012\u0014\u00102\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010'0\u0005J\u000e\u00106\u001a\u0002012\u0006\u00107\u001a\u00020\u0017J\u000e\u00106\u001a\u0002012\u0006\u00108\u001a\u000209J\u000e\u00106\u001a\u0002012\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u0002052\u0006\u00107\u001a\u00020\u0017J\u000e\u0010=\u001a\u0002052\u0006\u0010>\u001a\u00020\u0017J\u000e\u0010?\u001a\u0002052\u0006\u00108\u001a\u000209J\u000e\u0010?\u001a\u0002052\u0006\u0010@\u001a\u00020\u0006J\u000e\u0010?\u001a\u0002052\u0006\u0010:\u001a\u00020;J\u001a\u0010?\u001a\u0002052\u0006\u0010A\u001a\u00020\u00172\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\u0006J\u001a\u0010?\u001a\u0002052\u0006\u0010B\u001a\u00020\u00192\b\u0010@\u001a\u0004\u0018\u00010\u0006H\u0002J \u0010C\u001a\u0002052\u0006\u0010B\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010E\u001a\u0004\u0018\u00010\u0006J8\u0010F\u001a\u0002012\u0006\u0010G\u001a\u0002052\u0006\u0010H\u001a\u00020\u00182\b\u0010I\u001a\u0004\u0018\u00010\u00192\u0006\u0010J\u001a\u00020\u00182\f\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J$\u0010L\u001a\u0004\u0018\u00010\u00172\u0006\u0010M\u001a\u00020N2\b\u0010@\u001a\u0004\u0018\u00010\u00062\u0006\u0010D\u001a\u00020\u0018H\u0002J\"\u0010O\u001a\u0002052\u0006\u0010B\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u0006H\u0002J\"\u0010P\u001a\u00020Q2\u0006\u0010B\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u0006H\u0002J$\u0010R\u001a\u00020\u001a2\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002JT\u0010T\u001a\u0002052\u0006\u0010B\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010U\u001a\u0004\u0018\u00010\u00192&\u0010V\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u0002050X\u0012\u0004\u0012\u0002050WH\u0002J,\u0010Y\u001a\u00020Z2\u0006\u0010B\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J,\u0010[\u001a\u00020\\2\u0006\u0010B\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J,\u0010]\u001a\u00020^2\u0006\u0010B\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J,\u0010_\u001a\u00020`2\u0006\u0010B\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J\"\u0010a\u001a\u00020b2\u0006\u0010B\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u0006H\u0002J,\u0010c\u001a\u00020d2\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\u0006\u0010e\u001a\u00020f2\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J$\u0010g\u001a\u00020h2\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J$\u0010i\u001a\u00020j2\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J$\u0010k\u001a\u00020l2\b\u0010m\u001a\u0004\u0018\u00010\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u0006H\u0002J$\u0010n\u001a\u00020o2\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J,\u0010p\u001a\u00020q2\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\u0006\u0010e\u001a\u00020r2\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J,\u0010s\u001a\u00020t2\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\u0006\u0010e\u001a\u00020u2\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J,\u0010v\u001a\u00020w2\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\u0006\u0010e\u001a\u00020x2\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J&\u0010y\u001a\u0004\u0018\u00010z2\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J$\u0010{\u001a\u00020|2\u0006\u0010D\u001a\u00020\u00182\b\u0010@\u001a\u0004\u0018\u00010\u00062\b\u0010S\u001a\u0004\u0018\u00010\u0019H\u0002J\"\u0010}\u001a\u0002052\u0006\u0010B\u001a\u00020\u00192\u0006\u0010D\u001a\u00020\u00182\b\u0010E\u001a\u0004\u0018\u00010\u0006H\u0002J\u001c\u0010~\u001a\u0002012\u0014\u0010\u007f\u001a\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010*0\u0005J$\u0010\u0080\u0001\u001a\u0002012\u0007\u0010\u0081\u0001\u001a\u00020\u00172\u0007\u0010\u0082\u0001\u001a\u00020\u00172\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0017J%\u0010\u0080\u0001\u001a\u0002012\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0007\u0010\u0082\u0001\u001a\u00020\u00172\t\u0010\u0083\u0001\u001a\u0004\u0018\u00010\u0017J1\u0010\u0086\u0001\u001a\u0002012\u0007\u0010\u0087\u0001\u001a\u00020\u00172\n\b\u0002\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008a\u0001\u001a\u00020\u00172\n\b\u0002\u0010\u008b\u0001\u001a\u00030\u0089\u0001J2\u0010\u0086\u0001\u001a\u0002012\b\u0010\u008c\u0001\u001a\u00030\u0085\u00012\n\b\u0002\u0010\u0088\u0001\u001a\u00030\u0089\u00012\u0007\u0010\u008a\u0001\u001a\u00020\u00172\n\b\u0002\u0010\u008b\u0001\u001a\u00030\u0089\u0001J\u0019\u0010\u0086\u0001\u001a\u0002012\u0007\u0010\u008d\u0001\u001a\u00020\u00172\u0007\u0010\u008e\u0001\u001a\u00020\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R>\u0010\u0015\u001a&\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR(\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010 0\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010'0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\"R%\u0010)\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020*\u0012\u0006\u0012\u0004\u0018\u00010*0\u00050\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0012R\u0011\u0010,\u001a\u00020-\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020504X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0091\u0001"}, d2={"Lnet/pwall/json/schema/parser/Parser;", "", "options", "Lnet/pwall/json/schema/parser/Parser$Options;", "uriResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "<init>", "(Lnet/pwall/json/schema/parser/Parser$Options;Lkotlin/jvm/functions/Function1;)V", "getOptions", "()Lnet/pwall/json/schema/parser/Parser$Options;", "setOptions", "(Lnet/pwall/json/schema/parser/Parser$Options;)V", "examplesValidationErrors", "", "Lnet/pwall/json/schema/output/BasicOutput;", "getExamplesValidationErrors", "()Ljava/util/List;", "defaultValidationErrors", "getDefaultValidationErrors", "customValidationHandler", "Lkotlin/Function4;", "", "Lio/kjson/pointer/JSONPointer;", "Lio/kjson/JSONValue;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "getCustomValidationHandler", "()Lkotlin/jvm/functions/Function4;", "setCustomValidationHandler", "(Lkotlin/jvm/functions/Function4;)V", "nonstandardFormatHandler", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "getNonstandardFormatHandler", "()Lkotlin/jvm/functions/Function1;", "setNonstandardFormatHandler", "(Lkotlin/jvm/functions/Function1;)V", "defaultURIResolver", "defaultExtendedResolver", "Lnet/pwall/json/schema/parser/InputDetails;", "getDefaultExtendedResolver", "connectionFilters", "Ljava/net/URLConnection;", "getConnectionFilters", "jsonReader", "Lnet/pwall/json/schema/parser/JSONReader;", "getJsonReader", "()Lnet/pwall/json/schema/parser/JSONReader;", "setExtendedResolver", "", "extendedResolver", "schemaCache", "", "Lnet/pwall/json/schema/JSONSchema;", "preLoad", "filename", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "parseFile", "parseURI", "uriString", "parse", "uri", "string", "json", "parseSchema", "pointer", "parentUri", "validateExample", "schema", "relativeLocation", "root", "location", "errorList", "getDescription", "schemaJSON", "Lio/kjson/JSONObject;", "parseIf", "parseContains", "Lnet/pwall/json/schema/validation/ContainsValidator;", "parseFormat", "value", "parseCombinationSchema", "array", "creator", "Lkotlin/Function3;", "", "parseRef", "Lnet/pwall/json/schema/subschema/RefSchema;", "parseItems", "Lnet/pwall/json/schema/JSONSchema$SubSchema;", "parseProperties", "Lnet/pwall/json/schema/subschema/PropertiesSchema;", "parsePatternProperties", "Lnet/pwall/json/schema/subschema/PatternPropertiesSchema;", "parsePropertyNames", "Lnet/pwall/json/schema/subschema/PropertyNamesSchema;", "parsePropertiesSize", "Lnet/pwall/json/schema/validation/PropertiesValidator;", "condition", "Lnet/pwall/json/schema/validation/PropertiesValidator$ValidationType;", "parseRequired", "Lnet/pwall/json/schema/subschema/RequiredSchema;", "parseType", "Lnet/pwall/json/schema/validation/TypeValidator;", "checkType", "Lnet/pwall/json/schema/JSONSchema$Type;", "item", "parseEnum", "Lnet/pwall/json/schema/validation/EnumValidator;", "parseNumberLimit", "Lnet/pwall/json/schema/validation/NumberValidator;", "Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "parseStringLength", "Lnet/pwall/json/schema/validation/StringValidator;", "Lnet/pwall/json/schema/validation/StringValidator$ValidationType;", "parseArrayNumberOfItems", "Lnet/pwall/json/schema/validation/ArrayValidator;", "Lnet/pwall/json/schema/validation/ArrayValidator$ValidationType;", "parseArrayUniqueItems", "Lnet/pwall/json/schema/validation/UniqueItemsValidator;", "parsePattern", "Lnet/pwall/json/schema/validation/PatternValidator;", "parseDraft07", "addConnectionFilter", "filter", "addAuthorizationFilter", "host", "headerName", "headerValue", "hostMatcher", "Lio/jstuff/text/StringMatcher;", "addRedirectionFilter", "fromHost", "fromPort", "", "toHost", "toPort", "fromHostMatcher", "fromPrefix", "toPrefix", "Options", "Companion", "json-kotlin-schema"})
@SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Parser.kt\nnet/pwall/json/schema/parser/Parser$Companion\n*L\n1#1,685:1\n1#2:686\n1#2:719\n1557#3:687\n1628#3,3:688\n1557#3:691\n1628#3,3:692\n1557#3:695\n1628#3,3:696\n1557#3:699\n1628#3,3:700\n1567#3:703\n1598#3,4:704\n1567#3:708\n1598#3,4:709\n1557#3:713\n1628#3,3:714\n591#4,2:717\n593#4:720\n*S KotlinDebug\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser\n*L\n126#1:719\n371#1:687\n371#1:688,3\n425#1:691\n425#1:692,3\n433#1:695\n433#1:696,3\n440#1:699\n440#1:700,3\n460#1:703\n460#1:704,4\n470#1:708\n470#1:709,4\n125#1:713\n125#1:714,3\n126#1:717,2\n126#1:720\n*E\n"})
public final class Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Options options;
    @NotNull
    private final List<BasicOutput> examplesValidationErrors;
    @NotNull
    private final List<BasicOutput> defaultValidationErrors;
    @NotNull
    private Function4<? super String, ? super URI, ? super JSONPointer, ? super JSONValue, ? extends JSONSchema.Validator> customValidationHandler;
    @NotNull
    private Function1<? super String, ? extends FormatValidator.FormatChecker> nonstandardFormatHandler;
    @NotNull
    private final Function1<URI, InputStream> defaultURIResolver;
    @NotNull
    private final Function1<URI, InputDetails> defaultExtendedResolver;
    @NotNull
    private final List<Function1<URLConnection, URLConnection>> connectionFilters;
    @NotNull
    private final JSONReader jsonReader;
    @NotNull
    private final Map<URI, JSONSchema> schemaCache;
    @NotNull
    private static final List<String> schemaVersion202012;
    @NotNull
    private static final List<String> schemaVersion201909;
    @NotNull
    private static final List<String> schemaVersionDraft07;

    public Parser(@NotNull Options options, @Nullable Function1<? super URI, ? extends InputStream> uriResolver) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.options = options;
        this.examplesValidationErrors = new ArrayList();
        this.defaultValidationErrors = new ArrayList();
        this.customValidationHandler = customValidationHandler.1.INSTANCE;
        this.nonstandardFormatHandler = nonstandardFormatHandler.1.INSTANCE;
        this.defaultURIResolver = arg_0 -> Parser.defaultURIResolver$lambda$0(this, arg_0);
        this.defaultExtendedResolver = arg_0 -> Parser.defaultExtendedResolver$lambda$4(this, arg_0);
        this.connectionFilters = new ArrayList();
        Function1<? super URI, ? extends InputStream> function1 = uriResolver;
        if (function1 == null) {
            function1 = this.defaultURIResolver;
        }
        this.jsonReader = new JSONReader(function1);
        this.schemaCache = new LinkedHashMap();
    }

    public /* synthetic */ Parser(Options options, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            options = new Options(false, false, false, 7, null);
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        this(options, (Function1<? super URI, ? extends InputStream>)function1);
    }

    @NotNull
    public final Options getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"<set-?>");
        this.options = options;
    }

    @NotNull
    public final List<BasicOutput> getExamplesValidationErrors() {
        return this.examplesValidationErrors;
    }

    @NotNull
    public final List<BasicOutput> getDefaultValidationErrors() {
        return this.defaultValidationErrors;
    }

    @NotNull
    public final Function4<String, URI, JSONPointer, JSONValue, JSONSchema.Validator> getCustomValidationHandler() {
        return this.customValidationHandler;
    }

    public final void setCustomValidationHandler(@NotNull Function4<? super String, ? super URI, ? super JSONPointer, ? super JSONValue, ? extends JSONSchema.Validator> function4) {
        Intrinsics.checkNotNullParameter(function4, (String)"<set-?>");
        this.customValidationHandler = function4;
    }

    @NotNull
    public final Function1<String, FormatValidator.FormatChecker> getNonstandardFormatHandler() {
        return this.nonstandardFormatHandler;
    }

    public final void setNonstandardFormatHandler(@NotNull Function1<? super String, ? extends FormatValidator.FormatChecker> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.nonstandardFormatHandler = function1;
    }

    @NotNull
    public final Function1<URI, InputDetails> getDefaultExtendedResolver() {
        return this.defaultExtendedResolver;
    }

    @NotNull
    public final List<Function1<URLConnection, URLConnection>> getConnectionFilters() {
        return this.connectionFilters;
    }

    @NotNull
    public final JSONReader getJsonReader() {
        return this.jsonReader;
    }

    public final void setExtendedResolver(@NotNull Function1<? super URI, InputDetails> extendedResolver) {
        Intrinsics.checkNotNullParameter(extendedResolver, (String)"extendedResolver");
        this.jsonReader.setExtendedResolver(extendedResolver);
    }

    public final void preLoad(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.jsonReader.preLoad(filename);
    }

    public final void preLoad(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.jsonReader.preLoad(file);
    }

    public final void preLoad(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.jsonReader.preLoad(path);
    }

    @NotNull
    public final JSONSchema parseFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.parse(new File(filename));
    }

    @NotNull
    public final JSONSchema parseURI(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        return this.parse(new URI(uriString));
    }

    @NotNull
    public final JSONSchema parse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) {
            throw new JSONSchemaException("Invalid file - " + file, null, 2, null);
        }
        URI uri = file.toURI();
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema it = jSONSchema;
            boolean bl = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(file);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema it = jSONSchema;
            boolean bl = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(uri);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new JSONSchemaException("Invalid file - " + path, null, 2, null);
        }
        URI uri = path.toUri();
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema it = jSONSchema;
            boolean bl = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(path);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull String string, @Nullable URI uri) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        JSONValue json = this.jsonReader.readJSON(string, uri);
        return this.parse(json, uri);
    }

    public static /* synthetic */ JSONSchema parse$default(Parser parser, String string, URI uRI, int n, Object object) {
        if ((n & 2) != 0) {
            uRI = null;
        }
        return parser.parse(string, uRI);
    }

    private final JSONSchema parse(JSONValue json, URI uri) {
        JSONObject jSONObject = json instanceof JSONObject ? (JSONObject)json : null;
        String schemaVersion = jSONObject != null ? Companion.getStringOrNull(jSONObject, uri, JSONPointer.Companion.getRoot().child("$schema")) : null;
        JSONPointer pointer = JSONPointer.Companion.getRoot();
        String string = schemaVersion;
        return CollectionsKt.contains((Iterable)schemaVersion201909, (Object)string) ? this.parseSchema(json, pointer, uri) : (CollectionsKt.contains((Iterable)schemaVersionDraft07, (Object)string) ? this.parseDraft07(json, pointer, uri) : this.parseSchema(json, pointer, uri));
    }

    @NotNull
    public final JSONSchema parseSchema(@NotNull JSONValue json, @NotNull JSONPointer pointer, @Nullable URI parentUri) {
        JSONSchema.General result;
        block84: {
            URI uri;
            URI uRI;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            JSONValue schemaJSON = IndexOpKt.get((JSONValue)json, (JSONPointer)pointer);
            if (schemaJSON instanceof JSONBoolean) {
                return JSONSchema.Companion.booleanSchema((Boolean)((JSONBoolean)schemaJSON).getValue(), parentUri, pointer);
            }
            if (!(schemaJSON instanceof JSONObject)) {
                throw new JSONSchemaException("Schema is not boolean or object - " + Parser.Companion.errorPointer(parentUri, pointer), null, 2, null);
            }
            String id = Companion.getIdOrNull(schemaJSON);
            if (id == null) {
                uRI = parentUri;
            } else if (parentUri == null) {
                uRI = Companion.dropFragment(new URI(id));
            } else {
                URI uRI2 = parentUri.resolve(id);
                Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"resolve(...)");
                uRI = Companion.dropFragment(uRI2);
            }
            URI uRI3 = uri = uRI;
            if (uRI3 != null) {
                URI it = uRI3;
                boolean bl = false;
                URI fragmentURI = Companion.withFragment(uri, pointer);
                JSONSchema jSONSchema = this.schemaCache.get(fragmentURI);
                if (jSONSchema != null) {
                    JSONSchema it2 = jSONSchema;
                    boolean bl2 = false;
                    if (it2 instanceof JSONSchema.False) {
                        Parser.Companion.fatal("Recursive $ref", uri, pointer);
                        throw new KotlinNothingValueException();
                    }
                    return it2;
                }
                this.schemaCache.put(fragmentURI, new JSONSchema.False(uri, pointer));
            }
            String title = Companion.getStringOrNull((JSONObject)schemaJSON, uri, "title");
            String description = this.getDescription((JSONObject)schemaJSON, uri, pointer);
            List children = new ArrayList();
            result = new JSONSchema.General(schemaVersion201909.get(0), title, description, uri, pointer, children);
            for (Map.Entry bl2 : ((JSONObject)schemaJSON).entrySet()) {
                String key = (String)bl2.getKey();
                JSONValue value = (JSONValue)bl2.getValue();
                JSONPointer childPointer = pointer.child(key);
                String string = key;
                if (Intrinsics.areEqual((Object)string, (Object)"$schema")) {
                    if (!Intrinsics.areEqual((Object)pointer, (Object)JSONPointer.Companion.getRoot())) {
                        Parser.Companion.fatal("May only appear in the root of the document", uri, childPointer);
                        throw new KotlinNothingValueException();
                    }
                    if (!(value instanceof JSONString)) {
                        Parser.Companion.fatal("String expected", uri, childPointer);
                        throw new KotlinNothingValueException();
                    }
                } else if (!(Intrinsics.areEqual((Object)string, (Object)"$id") || Intrinsics.areEqual((Object)string, (Object)"$defs") || Intrinsics.areEqual((Object)string, (Object)"title") || Intrinsics.areEqual((Object)string, (Object)"description") || Intrinsics.areEqual((Object)string, (Object)"then") || Intrinsics.areEqual((Object)string, (Object)"else") || Intrinsics.areEqual((Object)string, (Object)"minContains") || Intrinsics.areEqual((Object)string, (Object)"maxContains") || Intrinsics.areEqual((Object)string, (Object)"example"))) {
                    JSONSchema.Validator it;
                    if (Intrinsics.areEqual((Object)string, (Object)"$comment")) {
                        if (!(value instanceof JSONString)) {
                            Parser.Companion.fatal("String expected", uri, childPointer);
                            throw new KotlinNothingValueException();
                        }
                    } else if (Intrinsics.areEqual((Object)string, (Object)"examples")) {
                        if (!(value instanceof JSONArray)) {
                            Parser.Companion.fatal("Must be array", uri, childPointer);
                            throw new KotlinNothingValueException();
                        }
                    } else if (Intrinsics.areEqual((Object)string, (Object)"$ref")) {
                        children.add(this.parseRef(json, childPointer, uri, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"default")) {
                        children.add(new DefaultValidator(uri, childPointer, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"allOf")) {
                        children.add(this.parseCombinationSchema(json, childPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AllOfSchema>((Object)JSONSchema.Companion){

                            public final AllOfSchema invoke(URI p0, JSONPointer p1, List<? extends JSONSchema> p2) {
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                return ((JSONSchema.Companion)this.receiver).allOf(p0, p1, p2);
                            }
                        })));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"anyOf")) {
                        children.add(this.parseCombinationSchema(json, childPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AnyOfSchema>((Object)JSONSchema.Companion){

                            public final AnyOfSchema invoke(URI p0, JSONPointer p1, List<? extends JSONSchema> p2) {
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                return ((JSONSchema.Companion)this.receiver).anyOf(p0, p1, p2);
                            }
                        })));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"oneOf")) {
                        children.add(this.parseCombinationSchema(json, childPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, OneOfSchema>((Object)JSONSchema.Companion){

                            public final OneOfSchema invoke(URI p0, JSONPointer p1, List<? extends JSONSchema> p2) {
                                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                return ((JSONSchema.Companion)this.receiver).oneOf(p0, p1, p2);
                            }
                        })));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"not")) {
                        children.add(new JSONSchema.Not(uri, childPointer, this.parseSchema(json, pointer.child("not"), uri)));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"if")) {
                        children.add(this.parseIf(json, pointer, uri));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"type")) {
                        children.add(this.parseType(childPointer, uri, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"enum")) {
                        children.add(this.parseEnum(childPointer, uri, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"const")) {
                        children.add(new ConstValidator(uri, childPointer, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"properties")) {
                        children.add(this.parseProperties(json, childPointer, uri, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"patternProperties")) {
                        children.add(this.parsePatternProperties(json, childPointer, uri, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"propertyNames")) {
                        children.add(this.parsePropertyNames(json, childPointer, uri));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"minProperties")) {
                        children.add(this.parsePropertiesSize(childPointer, uri, PropertiesValidator.ValidationType.MIN_PROPERTIES, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"maxProperties")) {
                        children.add(this.parsePropertiesSize(childPointer, uri, PropertiesValidator.ValidationType.MAX_PROPERTIES, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"required")) {
                        children.add(this.parseRequired(childPointer, uri, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"items")) {
                        children.add(this.parseItems(json, childPointer, uri, value));
                    } else if (NumberValidator.Companion.getTypeKeywords().contains(string)) {
                        children.add(this.parseNumberLimit(childPointer, uri, NumberValidator.Companion.findType(key), value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"maxItems")) {
                        children.add(this.parseArrayNumberOfItems(childPointer, uri, ArrayValidator.ValidationType.MAX_ITEMS, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"minItems")) {
                        children.add(this.parseArrayNumberOfItems(childPointer, uri, ArrayValidator.ValidationType.MIN_ITEMS, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"uniqueItems")) {
                        if (this.parseArrayUniqueItems(childPointer, uri, value) != null) {
                            boolean bl = false;
                            children.add(it);
                        }
                    } else if (Intrinsics.areEqual((Object)string, (Object)"maxLength")) {
                        children.add(this.parseStringLength(childPointer, uri, StringValidator.ValidationType.MAX_LENGTH, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"minLength")) {
                        children.add(this.parseStringLength(childPointer, uri, StringValidator.ValidationType.MIN_LENGTH, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"pattern")) {
                        children.add(this.parsePattern(childPointer, uri, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"format")) {
                        children.add(this.parseFormat(childPointer, uri, value));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"additionalProperties")) {
                        children.add(new AdditionalPropertiesSchema(result, uri, childPointer, this.parseSchema(json, childPointer, uri)));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"additionalItems")) {
                        children.add(new AdditionalItemsSchema(result, uri, childPointer, this.parseSchema(json, childPointer, uri)));
                    } else if (Intrinsics.areEqual((Object)string, (Object)"contains")) {
                        children.add(this.parseContains(json, pointer, uri));
                    } else if ((JSONSchema.Validator)this.customValidationHandler.invoke((Object)key, (Object)uri, (Object)childPointer, (Object)value) != null) {
                        boolean bl = false;
                        children.add(new DelegatingValidator(it.getUri(), it.getLocation(), key, it));
                    }
                }
                if (!StringsKt.startsWith$default((String)key, (String)"x-", (boolean)false, (int)2, null)) continue;
                JSONValue jSONValue = value;
                children.add(new ExtensionSchema(uri, childPointer, key, jSONValue != null ? Companion.toSimpleValue(jSONValue) : null));
            }
            if (this.options.getValidateExamples()) {
                if (((JSONObject)schemaJSON).containsKey((Object)"example")) {
                    this.validateExample(result, pointer, json, pointer.child("example"), this.examplesValidationErrors);
                }
                if (((JSONObject)schemaJSON).containsKey((Object)"examples")) {
                    Object object = ((JSONObject)schemaJSON).get((Object)"examples");
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.kjson.JSONArray");
                    JSONArray examplesArray = (JSONArray)object;
                    JSONPointer examplesPointer = pointer.child("examples");
                    int n = ((Collection)examplesArray).size();
                    for (int i = 0; i < n; ++i) {
                        this.validateExample(result, pointer, json, examplesPointer.child(i), this.examplesValidationErrors);
                    }
                }
            }
            if (this.options.getValidateDefault() && ((JSONObject)schemaJSON).containsKey((Object)"default")) {
                this.validateExample(result, pointer, json, pointer.child("default"), this.defaultValidationErrors);
            }
            URI uRI4 = uri;
            if (uRI4 == null) break block84;
            URI it = uRI4;
            boolean bl = false;
            this.schemaCache.put(Companion.withFragment(uri, pointer), result);
        }
        return result;
    }

    private final void validateExample(JSONSchema schema, JSONPointer relativeLocation, JSONValue root, JSONPointer location, List<BasicOutput> errorList) {
        BasicOutput result = schema.validateBasic(relativeLocation, root, location);
        if (!result.getValid()) {
            errorList.add(result);
        }
    }

    private final String getDescription(JSONObject schemaJSON, URI uri, JSONPointer pointer) {
        JSONValue ref;
        JSONValue jSONValue = (JSONValue)schemaJSON.get((Object)"description");
        if (jSONValue == null) {
            return null;
        }
        JSONValue value = jSONValue;
        if (value instanceof JSONString) {
            return ((JSONString)value).getValue();
        }
        if (this.options.getAllowDescriptionRef() && value instanceof JSONObject && ((JSONObject)value).size() == 1 && (ref = (JSONValue)((JSONObject)value).get((Object)"$ref")) instanceof JSONString) {
            try {
                URI uRI = uri;
                URL uRL = (uRI == null ? new URI(((JSONString)ref).getValue()) : uRI.resolve(((JSONString)ref).getValue())).toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                return new String(byArray, charset);
            }
            catch (Exception e) {
                Parser.Companion.fatal("Error reading external description " + ref, uri, pointer);
                throw new KotlinNothingValueException();
            }
        }
        Parser.Companion.fatal("Invalid description", uri, pointer);
        throw new KotlinNothingValueException();
    }

    private final JSONSchema parseIf(JSONValue json, JSONPointer pointer, URI uri) {
        JSONSchema ifSchema = this.parseSchema(json, pointer.child("if"), uri);
        JSONPointer it = pointer.child("then");
        boolean bl = false;
        JSONSchema thenSchema = FindKt.existsIn((JSONPointer)it, (JSONValue)json) ? this.parseSchema(json, it, uri) : null;
        JSONPointer it2 = pointer.child("else");
        boolean bl2 = false;
        JSONSchema elseSchema = FindKt.existsIn((JSONPointer)it2, (JSONValue)json) ? this.parseSchema(json, it2, uri) : null;
        return new IfThenElseSchema(uri, pointer, ifSchema, thenSchema, elseSchema);
    }

    private final ContainsValidator parseContains(JSONValue json, JSONPointer pointer, URI uri) {
        JSONSchema containsSchema = this.parseSchema(json, pointer.child("contains"), uri);
        JSONPointer it = pointer.child("minContains");
        boolean bl = false;
        Integer minContains = FindKt.existsIn((JSONPointer)it, (JSONValue)json) ? Integer.valueOf(Companion.getNonNegativeInteger(json, uri, it)) : null;
        JSONPointer it2 = pointer.child("maxContains");
        boolean bl2 = false;
        Integer maxContains = FindKt.existsIn((JSONPointer)it2, (JSONValue)json) ? Integer.valueOf(Companion.getNonNegativeInteger(json, uri, it2)) : null;
        return new ContainsValidator(uri, pointer.child("contains"), containsSchema, minContains, maxContains);
    }

    private final JSONSchema.Validator parseFormat(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONString)) {
            Parser.Companion.fatal("String expected", uri, pointer);
            throw new KotlinNothingValueException();
        }
        String keyword = ((JSONString)value).getValue();
        boolean bl = false;
        FormatValidator.FormatChecker formatChecker = (FormatValidator.FormatChecker)this.nonstandardFormatHandler.invoke((Object)keyword);
        if (formatChecker == null && (formatChecker = FormatValidator.Companion.findChecker(keyword)) == null) {
            formatChecker = new FormatValidator.NullFormatChecker(keyword);
        }
        FormatValidator.FormatChecker checker = formatChecker;
        return new FormatValidator(uri, pointer, checker);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema parseCombinationSchema(JSONValue json, JSONPointer pointer, URI uri, JSONValue array, Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> creator) {
        Collection<JSONSchema> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(array instanceof JSONArray)) {
            Parser.Companion.fatal("Compound must take array", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)((Collection)array));
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> function3 = creator;
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.parseSchema(json, pointer.child((int)i), uri));
        }
        collection = (List)destination$iv$iv;
        return (JSONSchema)function3.invoke((Object)uRI, (Object)jSONPointer, (Object)collection);
    }

    private final RefSchema parseRef(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONString)) {
            Parser.Companion.fatal("$ref must be string", uri, pointer);
            throw new KotlinNothingValueException();
        }
        String refString = ((JSONString)value).getValue();
        URI refURI = null;
        JSONValue refJSON = null;
        String refURIFragment = null;
        JSONPointer refPointer = null;
        int hashIndex = StringsKt.indexOf$default((CharSequence)refString, (char)'#', (int)0, (boolean)false, (int)6, null);
        if (hashIndex < 0) {
            URI uRI = uri;
            if (uRI == null || (uRI = uRI.resolve(refString)) == null) {
                uRI = new URI(refString);
            }
            refURI = uRI;
            refJSON = this.jsonReader.readJSON(refURI);
            refURIFragment = null;
            refPointer = JSONPointer.Companion.getRoot();
        } else if (hashIndex == 0) {
            refURI = uri;
            refJSON = json;
            String string = refString.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            refURIFragment = string;
            String string2 = refString.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            refPointer = JSONPointer.Companion.fromURIFragment(string2);
        } else {
            String string = refString.substring(0, hashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String refStringWithoutFragment = string;
            if (uri != null && Intrinsics.areEqual((Object)uri.toString(), (Object)refStringWithoutFragment)) {
                refURI = uri;
                refJSON = json;
            } else {
                URI uRI = uri;
                if (uRI == null || (uRI = uRI.resolve(refStringWithoutFragment)) == null) {
                    uRI = new URI(refStringWithoutFragment);
                }
                refURI = uRI;
                refJSON = this.jsonReader.readJSON(refURI);
            }
            String string3 = refString.substring(hashIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            refURIFragment = string3;
            String string4 = refString.substring(hashIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            refPointer = JSONPointer.Companion.fromURIFragment(string4);
        }
        if (!FindKt.existsIn((JSONPointer)refPointer, (JSONValue)refJSON)) {
            Parser.Companion.fatal("$ref not found " + refString, uri, pointer);
            throw new KotlinNothingValueException();
        }
        return new RefSchema(uri, pointer, this.parseSchema(refJSON, refPointer, refURI), refURIFragment);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema.SubSchema parseItems(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        JSONSchema.SubSchema subSchema;
        if (value instanceof JSONArray) {
            Collection<JSONSchema> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = (Iterable)CollectionsKt.getIndices((Collection)((Collection)value));
            JSONPointer jSONPointer = pointer;
            URI uRI = uri;
            boolean $i$f$map = false;
            void var7_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void i;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.parseSchema(json, pointer.child((int)i), uri));
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            JSONPointer jSONPointer2 = jSONPointer;
            URI uRI2 = uRI;
            subSchema = new ItemsArraySchema(uRI2, jSONPointer2, list);
        } else {
            subSchema = new ItemsSchema(uri, pointer, this.parseSchema(json, pointer, uri));
        }
        return subSchema;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertiesSchema parseProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(value instanceof JSONObject)) {
            Parser.Companion.fatal("properties must be object", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Iterable iterable = ((JSONObject)value).keySet();
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)this.parseSchema(json, pointer.child((String)it), uri)));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer2 = jSONPointer;
        URI uRI2 = uRI;
        return new PropertiesSchema(uRI2, jSONPointer2, list);
    }

    /*
     * WARNING - void declaration
     */
    private final PatternPropertiesSchema parsePatternProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(value instanceof JSONObject)) {
            Parser.Companion.fatal("patternProperties must be object", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Iterable iterable = ((JSONObject)value).keySet();
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Regex regex;
            void key;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JSONPointer childPointer = pointer.child((String)key);
            try {
                regex = new Regex((String)key);
            }
            catch (Exception e) {
                Parser.Companion.fatal("Invalid regex in patternProperties", uri, childPointer);
                throw new KotlinNothingValueException();
            }
            Regex regex2 = regex;
            collection.add(TuplesKt.to((Object)regex2, (Object)this.parseSchema(json, childPointer, uri)));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer2 = jSONPointer;
        URI uRI2 = uRI;
        return new PatternPropertiesSchema(uRI2, jSONPointer2, list);
    }

    private final PropertyNamesSchema parsePropertyNames(JSONValue json, JSONPointer pointer, URI uri) {
        return new PropertyNamesSchema(uri, pointer, this.parseSchema(json, pointer, uri));
    }

    private final PropertiesValidator parsePropertiesSize(JSONPointer pointer, URI uri, PropertiesValidator.ValidationType condition, JSONValue value) {
        return new PropertiesValidator(uri, pointer, condition, Companion.getInteger(value, uri, pointer));
    }

    /*
     * WARNING - void declaration
     */
    private final RequiredSchema parseRequired(JSONPointer pointer, URI uri, JSONValue value) {
        Collection<String> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!(value instanceof JSONArray)) {
            Parser.Companion.fatal("required must be array", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Iterable iterable = (Iterable)value;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$mapIndexed = false;
        void var6_8 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void entry;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSONValue jSONValue = (JSONValue)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            if (!(entry instanceof JSONString)) {
                void i;
                Parser.Companion.fatal("required item must be string", uri, pointer.child((int)i));
                throw new KotlinNothingValueException();
            }
            collection.add(((JSONString)entry).getValue());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer2 = jSONPointer;
        URI uRI2 = uRI;
        return new RequiredSchema(uRI2, jSONPointer2, list);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeValidator parseType(JSONPointer pointer, URI uri, JSONValue value) {
        List list;
        JSONValue jSONValue = value;
        if (jSONValue instanceof JSONString) {
            list = CollectionsKt.listOf((Object)((Object)this.checkType(value, pointer, uri)));
        } else if (jSONValue instanceof JSONArray) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = (Iterable)value;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void item;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JSONValue jSONValue2 = (JSONValue)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.checkType((JSONValue)item, pointer.child((int)index), uri));
            }
            list = (List)destination$iv$iv;
        } else {
            Parser.Companion.fatal("Invalid type", uri, pointer);
            throw new KotlinNothingValueException();
        }
        List types = list;
        return new TypeValidator(uri, pointer, types);
    }

    private final JSONSchema.Type checkType(JSONValue item, JSONPointer pointer, URI uri) {
        if (item instanceof JSONString) {
            for (JSONSchema.Type type : JSONSchema.Type.getEntries()) {
                if (!Intrinsics.areEqual((Object)((JSONString)item).getValue(), (Object)type.getValue())) continue;
                return type;
            }
        }
        Parser.Companion.fatal("Invalid type", uri, pointer);
        throw new KotlinNothingValueException();
    }

    private final EnumValidator parseEnum(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONArray)) {
            Parser.Companion.fatal("enum must be array", uri, pointer);
            throw new KotlinNothingValueException();
        }
        return new EnumValidator(uri, pointer, (JSONArray)value);
    }

    private final NumberValidator parseNumberLimit(JSONPointer pointer, URI uri, NumberValidator.ValidationType condition, JSONValue value) {
        Number number;
        if (!(value instanceof JSONNumber)) {
            Parser.Companion.fatal("Must be number (was " + JSON.displayValue$default((JSON)JSON.INSTANCE, (JSONValue)value, (int)0, (int)0, (int)0, (int)7, null) + ')', uri, pointer);
            throw new KotlinNothingValueException();
        }
        JSONNumber jSONNumber = (JSONNumber)value;
        Number number2 = jSONNumber instanceof JSONDecimal ? (Number)((JSONDecimal)value).getValue() : (Number)(number = jSONNumber instanceof JSONLong ? (Number)((JSONLong)value).longValue() : (Number)((JSONNumber)value).intValue());
        if (condition == NumberValidator.ValidationType.MULTIPLE_OF && !Companion.isPositive(number)) {
            Parser.Companion.fatal("multipleOf must be greater than 0", uri, pointer);
            throw new KotlinNothingValueException();
        }
        return new NumberValidator(uri, pointer, number, condition);
    }

    private final StringValidator parseStringLength(JSONPointer pointer, URI uri, StringValidator.ValidationType condition, JSONValue value) {
        return new StringValidator(uri, pointer, condition, Companion.getInteger(value, uri, pointer));
    }

    private final ArrayValidator parseArrayNumberOfItems(JSONPointer pointer, URI uri, ArrayValidator.ValidationType condition, JSONValue value) {
        return new ArrayValidator(uri, pointer, condition, Companion.getInteger(value, uri, pointer));
    }

    private final UniqueItemsValidator parseArrayUniqueItems(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONBoolean)) {
            Parser.Companion.fatal("Must be boolean", uri, pointer);
            throw new KotlinNothingValueException();
        }
        return (Boolean)((JSONBoolean)value).getValue() != false ? new UniqueItemsValidator(uri, pointer) : null;
    }

    private final PatternValidator parsePattern(JSONPointer pointer, URI uri, JSONValue value) {
        Regex regex;
        if (!(value instanceof JSONString)) {
            Parser.Companion.fatal("Must be string", uri, pointer);
            throw new KotlinNothingValueException();
        }
        try {
            regex = new Regex(((JSONString)value).getValue());
        }
        catch (Exception e) {
            String string;
            block7: {
                block6: {
                    string = e.getMessage();
                    if (string == null) break block6;
                    String it = string;
                    boolean bl = false;
                    String string2 = "- " + ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)it, (char)'\n', null, (int)2, null))).toString();
                    string = string2;
                    if (string2 != null) break block7;
                }
                string = "";
            }
            String msg = string;
            Parser.Companion.fatal("Pattern invalid " + msg + " (" + JSON.displayValue$default((JSON)JSON.INSTANCE, (JSONValue)value, (int)0, (int)0, (int)0, (int)7, null) + ')', uri, pointer);
            throw new KotlinNothingValueException();
        }
        Regex regex2 = regex;
        return new PatternValidator(uri, pointer, regex2);
    }

    private final JSONSchema parseDraft07(JSONValue json, JSONPointer pointer, URI parentUri) {
        return this.parseSchema(json, pointer, parentUri);
    }

    public final void addConnectionFilter(@NotNull Function1<? super URLConnection, ? extends URLConnection> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        this.connectionFilters.add(filter);
    }

    public final void addAuthorizationFilter(@NotNull String host, @NotNull String headerName, @Nullable String headerValue) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        WildcardMatcher wildcardMatcher = StringMatcher.wildcard((String)host);
        Intrinsics.checkNotNullExpressionValue((Object)wildcardMatcher, (String)"wildcard(...)");
        this.addConnectionFilter((Function1<? super URLConnection, ? extends URLConnection>)((Function1)new ResourceLoader.AuthorizationFilter((StringMatcher)wildcardMatcher, headerName, headerValue)));
    }

    public final void addAuthorizationFilter(@NotNull StringMatcher hostMatcher, @NotNull String headerName, @Nullable String headerValue) {
        Intrinsics.checkNotNullParameter((Object)hostMatcher, (String)"hostMatcher");
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        this.addConnectionFilter((Function1<? super URLConnection, ? extends URLConnection>)((Function1)new ResourceLoader.AuthorizationFilter(hostMatcher, headerName, headerValue)));
    }

    public final void addRedirectionFilter(@NotNull String fromHost, int fromPort, @NotNull String toHost, int toPort) {
        Intrinsics.checkNotNullParameter((Object)fromHost, (String)"fromHost");
        Intrinsics.checkNotNullParameter((Object)toHost, (String)"toHost");
        SimpleMatcher simpleMatcher = StringMatcher.simple((String)fromHost);
        Intrinsics.checkNotNullExpressionValue((Object)simpleMatcher, (String)"simple(...)");
        this.addConnectionFilter((Function1<? super URLConnection, ? extends URLConnection>)((Function1)new ResourceLoader.RedirectionFilter((StringMatcher)simpleMatcher, fromPort, toHost, toPort)));
    }

    public static /* synthetic */ void addRedirectionFilter$default(Parser parser, String string, int n, String string2, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        parser.addRedirectionFilter(string, n, string2, n2);
    }

    public final void addRedirectionFilter(@NotNull StringMatcher fromHostMatcher, int fromPort, @NotNull String toHost, int toPort) {
        Intrinsics.checkNotNullParameter((Object)fromHostMatcher, (String)"fromHostMatcher");
        Intrinsics.checkNotNullParameter((Object)toHost, (String)"toHost");
        this.addConnectionFilter((Function1<? super URLConnection, ? extends URLConnection>)((Function1)new ResourceLoader.RedirectionFilter(fromHostMatcher, fromPort, toHost, toPort)));
    }

    public static /* synthetic */ void addRedirectionFilter$default(Parser parser, StringMatcher stringMatcher, int n, String string, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = -1;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        parser.addRedirectionFilter(stringMatcher, n, string, n2);
    }

    public final void addRedirectionFilter(@NotNull String fromPrefix, @NotNull String toPrefix) {
        Intrinsics.checkNotNullParameter((Object)fromPrefix, (String)"fromPrefix");
        Intrinsics.checkNotNullParameter((Object)toPrefix, (String)"toPrefix");
        this.addConnectionFilter((Function1<? super URLConnection, ? extends URLConnection>)((Function1)new ResourceLoader.PrefixRedirectionFilter(fromPrefix, toPrefix)));
    }

    private static final InputStream defaultURIResolver$lambda$0(Parser this$0, URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        URLConnection uRLConnection = uri.toURL().openConnection();
        Intrinsics.checkNotNullExpressionValue((Object)uRLConnection, (String)"openConnection(...)");
        URLConnection conn = uRLConnection;
        for (Function1<URLConnection, URLConnection> filter : this$0.connectionFilters) {
            if ((URLConnection)filter.invoke((Object)conn) != null) continue;
            throw new RuntimeException("Connection vetoed - " + uri);
        }
        return conn instanceof HttpURLConnection ? (((HttpURLConnection)conn).getResponseCode() == 404 ? null : ((HttpURLConnection)conn).getInputStream()) : conn.getInputStream();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final InputDetails defaultExtendedResolver$lambda$4(Parser this$0, URI uri) {
        block12: {
            block10: {
                block9: {
                    block11: {
                        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
                        conn = null;
                        v0 = uri.toURL().openConnection();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"openConnection(...)");
                        conn = v0;
                        for (Function1<URLConnection, URLConnection> filter : this$0.connectionFilters) {
                            if ((URLConnection)filter.invoke((Object)conn) != null) continue;
                            throw new RuntimeException("Connection vetoed - " + uri);
                        }
                        if (!(conn instanceof HttpURLConnection)) break block10;
                        if (((HttpURLConnection)conn).getResponseCode() != 404) break block11;
                        v1 = null;
                        break block12;
                    }
                    v2 = ((HttpURLConnection)conn).getContentType();
                    if (v2 != null && (v2 = StringsKt.split$default((CharSequence)((CharSequence)v2), (char[])(var7_5 /* !! */  = new char[]{';'}), (boolean)false, (int)0, (int)6, null)) != null) {
                        $this$map$iv = (Iterable)v2;
                        $i$f$map = false;
                        var9_9 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var14_21 = (String)item$iv$iv;
                            var17_25 = destination$iv$iv;
                            $i$a$-map-Parser$defaultExtendedResolver$1$contentType$1 = false;
                            var17_25.add(StringsKt.trim((CharSequence)((CharSequence)it)).toString());
                        }
                        v3 = (List)destination$iv$iv;
                    } else {
                        v3 = contentType = null;
                    }
                    if (contentType == null) ** GOTO lbl-1000
                    $this$map$iv = Parser.Companion;
                    $i$f$map = contentType;
                    index$iv = 1;
                    $i$f$findStartingFrom = false;
                    var12_18 = $this$findStartingFrom$iv.size();
                    for (i$iv = index$iv; i$iv < var12_18; ++i$iv) {
                        it$iv = $this$findStartingFrom$iv.get(i$iv);
                        $i$a$-let-Parser$Companion$findStartingFrom$1$iv = false;
                        it = (String)it$iv;
                        $i$a$-findStartingFrom-Parser$defaultExtendedResolver$1$charset$1 = false;
                        if (!StringsKt.startsWith$default((String)it, (String)"charset=", (boolean)false, (int)2, null)) continue;
                        v4 = it$iv;
                        break block9;
                    }
                    v4 = null;
                }
                var6_27 = v4;
                if (var6_27 != null && (var7_5 /* !! */  = (char[])StringsKt.drop((String)var6_27, (int)8)) != null) {
                    v5 = StringsKt.trim((CharSequence)((CharSequence)var7_5 /* !! */ )).toString();
                } else lbl-1000:
                // 2 sources

                {
                    v5 = null;
                }
                v6 = charset = v5;
                if (v6 != null) {
                    it = v6;
                    $i$a$-let-Parser$defaultExtendedResolver$1$reader$1 = false;
                    v7 = ((HttpURLConnection)conn).getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getInputStream(...)");
                    var11_16 = v7;
                    v8 = Charset.forName(it);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"forName(...)");
                    var12_19 = v8;
                    v9 = new InputStreamReader(var11_16, var12_19);
                } else {
                    v10 = ((HttpURLConnection)conn).getInputStream();
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"getInputStream(...)");
                    var8_8 = v10;
                    var9_11 = Charsets.UTF_8;
                    v9 = new InputStreamReader(var8_8, var9_11);
                }
                reader = v9;
                v11 = contentType;
                v1 = new InputDetails(reader, v11 != null ? (String)v11.get(0) : null);
                break block12;
            }
            v12 = conn.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"getInputStream(...)");
            var4_4 = v12;
            var5_29 = Charsets.UTF_8;
            v13 = new InputDetails(new InputStreamReader(var4_4, var5_29), null, 2, null);
            v1 = v13;
        }
        return v1;
    }

    public Parser() {
        this(null, null, 3, null);
    }

    static {
        Object[] objectArray = new String[]{"http://json-schema.org/draft/2020-12/schema", "https://json-schema.org/draft/2020-12/schema"};
        schemaVersion202012 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"http://json-schema.org/draft/2019-09/schema", "https://json-schema.org/draft/2019-09/schema"};
        schemaVersion201909 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"http://json-schema.org/draft-07/schema", "https://json-schema.org/draft-07/schema"};
        schemaVersionDraft07 = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u000e\u001a\u0004\u0018\u0001H\u000f\"\u0004\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0\u00052\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u00140\u0013H\u0082\b\u00a2\u0006\u0002\u0010\u0015J\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0017J\u0014\u0010\u0018\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0012\u0010\u0018\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001a\u0010 \u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010!\u001a\u00020\u0006*\u00020\u001bH\u0002J\"\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020$2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010'\u001a\u0004\u0018\u00010\u0006*\u00020(2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010)\u001a\u00020\u0006J\u001e\u0010'\u001a\u0004\u0018\u00010\u0006*\u00020(2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010*\u001a\u0004\u0018\u00010\u0006*\u00020(2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010+\u001a\u0004\u0018\u00010\u0006J\n\u0010,\u001a\u00020\u0014*\u00020-J\n\u0010.\u001a\u00020\u0014*\u00020-J\u0010\u0010/\u001a\u0004\u0018\u00010\u00062\u0006\u00100\u001a\u00020$J\f\u00101\u001a\u0004\u0018\u00010\u0001*\u00020$R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u00062"}, d2={"Lnet/pwall/json/schema/parser/Parser$Companion;", "", "<init>", "()V", "schemaVersion202012", "", "", "getSchemaVersion202012$annotations", "getSchemaVersion202012", "()Ljava/util/List;", "schemaVersion201909", "getSchemaVersion201909", "schemaVersionDraft07", "getSchemaVersionDraft07", "findStartingFrom", "T", "index", "", "predicate", "Lkotlin/Function1;", "", "(Ljava/util/List;ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "dropFragment", "Ljava/net/URI;", "withFragment", "newFragment", "pointer", "Lio/kjson/pointer/JSONPointer;", "fatal", "", "message", "uri", "errorPointer", "pointerOrRoot", "getInteger", "value", "Lio/kjson/JSONValue;", "getNonNegativeInteger", "json", "getStringOrNull", "Lio/kjson/JSONObject;", "key", "getStringOrDefault", "default", "isZero", "", "isPositive", "getIdOrNull", "jsonValue", "toSimpleValue", "json-kotlin-schema"})
    @SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 JSON.kt\nio/kjson/JSON\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,685:1\n1#2:686\n488#3:687\n1557#4:688\n1628#4,3:689\n1246#4,4:694\n462#5:692\n412#5:693\n*S KotlinDebug\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser$Companion\n*L\n622#1:687\n678#1:688\n678#1:689,3\n679#1:694,4\n679#1:692\n679#1:693\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getSchemaVersion202012() {
            return schemaVersion202012;
        }

        public static /* synthetic */ void getSchemaVersion202012$annotations() {
        }

        @NotNull
        public final List<String> getSchemaVersion201909() {
            return schemaVersion201909;
        }

        @NotNull
        public final List<String> getSchemaVersionDraft07() {
            return schemaVersionDraft07;
        }

        private final <T> T findStartingFrom(List<? extends T> $this$findStartingFrom, int index, Function1<? super T, Boolean> predicate) {
            boolean $i$f$findStartingFrom = false;
            int n = $this$findStartingFrom.size();
            for (int i = index; i < n; ++i) {
                T it = $this$findStartingFrom.get(i);
                boolean bl = false;
                if (!((Boolean)predicate.invoke(it)).booleanValue()) continue;
                return it;
            }
            return null;
        }

        static /* synthetic */ Object findStartingFrom$default(Companion $this, List $receiver, int index, Function1 predicate, int n, Object object) {
            if ((n & 1) != 0) {
                index = 0;
            }
            boolean $i$f$findStartingFrom = false;
            int n2 = $receiver.size();
            for (int i = index; i < n2; ++i) {
                Object it = $receiver.get(i);
                boolean bl = false;
                if (!((Boolean)predicate.invoke(it)).booleanValue()) continue;
                return it;
            }
            return null;
        }

        @NotNull
        public final URI dropFragment(@NotNull URI $this$dropFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$dropFragment, (String)"<this>");
            return $this$dropFragment.getFragment() == null ? $this$dropFragment : ($this$dropFragment.isOpaque() ? new URI($this$dropFragment.getScheme(), $this$dropFragment.getSchemeSpecificPart(), null) : new URI($this$dropFragment.getScheme(), $this$dropFragment.getAuthority(), $this$dropFragment.getPath(), $this$dropFragment.getQuery(), null));
        }

        private final URI withFragment(URI $this$withFragment, String newFragment) {
            return $this$withFragment.isOpaque() ? new URI($this$withFragment.getScheme(), $this$withFragment.getSchemeSpecificPart(), newFragment) : new URI($this$withFragment.getScheme(), $this$withFragment.getAuthority(), $this$withFragment.getPath(), $this$withFragment.getQuery(), newFragment);
        }

        @NotNull
        public final URI withFragment(@NotNull URI $this$withFragment, @NotNull JSONPointer pointer) {
            URI uRI;
            Intrinsics.checkNotNullParameter((Object)$this$withFragment, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (Intrinsics.areEqual((Object)pointer, (Object)JSONPointer.Companion.getRoot())) {
                uRI = this.dropFragment($this$withFragment);
            } else {
                String string = pointer.toURIFragment().substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                uRI = this.withFragment($this$withFragment, string);
            }
            return uRI;
        }

        private final Void fatal(String message, URI uri, JSONPointer pointer) {
            throw new JSONSchemaException(message + " - " + this.errorPointer(uri, pointer), null, 2, null);
        }

        private final String errorPointer(URI uri, JSONPointer pointer) {
            Object object = uri;
            if (object == null || (object = this.withFragment((URI)object, pointer)) == null || (object = ((URI)object).toString()) == null) {
                object = this.pointerOrRoot(pointer);
            }
            return object;
        }

        private final String pointerOrRoot(JSONPointer $this$pointerOrRoot) {
            return Intrinsics.areEqual((Object)$this$pointerOrRoot, (Object)JSONPointer.Companion.getRoot()) ? "root" : $this$pointerOrRoot.toString();
        }

        public final int getInteger(@Nullable JSONValue value, @Nullable URI uri, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            JSON jSON = JSON.INSTANCE;
            JSONValue $this$asIntOr$iv = value;
            boolean $i$f$asIntOr = false;
            if (!($this$asIntOr$iv instanceof JSONNumber) || !((JSONNumber)$this$asIntOr$iv).isInt()) {
                JSONValue $this$getInteger_u24lambda_u241 = $this$asIntOr$iv;
                boolean bl = false;
                Companion.fatal("Must be integer", uri, pointer);
                throw new KotlinNothingValueException();
            }
            return ((JSONNumber)$this$asIntOr$iv).intValue();
        }

        public final int getNonNegativeInteger(@NotNull JSONValue json, @Nullable URI uri, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            JSONValue value = IndexOpKt.get((JSONValue)json, (JSONPointer)pointer);
            if (value instanceof JSONNumber && ((JSONNumber)value).isInt() && ((JSONNumber)value).isNotNegative()) {
                return ((JSONNumber)value).intValue();
            }
            this.fatal("Must be non-negative integer", uri, pointer);
            throw new KotlinNothingValueException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String getStringOrNull(@NotNull JSONObject $this$getStringOrNull, @Nullable URI uri, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)$this$getStringOrNull, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            JSONValue jSONValue = (JSONValue)$this$getStringOrNull.get((Object)key);
            if (jSONValue == null) return null;
            JSONValue it = jSONValue;
            boolean bl = false;
            if (!(it instanceof JSONString)) {
                Companion.fatal("Must be string", uri, JSONPointer.Companion.getRoot().child(key));
                throw new KotlinNothingValueException();
            }
            String string = ((JSONString)it).getValue();
            return string;
        }

        @Nullable
        public final String getStringOrNull(@NotNull JSONObject $this$getStringOrNull, @Nullable URI uri, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter((Object)$this$getStringOrNull, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (!FindKt.existsIn((JSONPointer)pointer, (JSONValue)((JSONValue)$this$getStringOrNull))) {
                return null;
            }
            JSONValue value = IndexOpKt.get((JSONValue)((JSONValue)$this$getStringOrNull), (JSONPointer)pointer);
            if (!(value instanceof JSONString)) {
                this.fatal("Must be string", uri, pointer);
                throw new KotlinNothingValueException();
            }
            return ((JSONString)value).getValue();
        }

        @Nullable
        public final String getStringOrDefault(@NotNull JSONObject $this$getStringOrDefault, @NotNull JSONPointer pointer, @Nullable String string) {
            Intrinsics.checkNotNullParameter((Object)$this$getStringOrDefault, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (!FindKt.existsIn((JSONPointer)pointer, (JSONValue)((JSONValue)$this$getStringOrDefault))) {
                return string;
            }
            JSONValue value = IndexOpKt.get((JSONValue)((JSONValue)$this$getStringOrDefault), (JSONPointer)pointer);
            if (!(value instanceof JSONString)) {
                throw new JSONSchemaException("Incorrect " + pointer, null, 2, null);
            }
            return ((JSONString)value).getValue();
        }

        public final boolean isZero(@NotNull Number $this$isZero) {
            Intrinsics.checkNotNullParameter((Object)$this$isZero, (String)"<this>");
            Number number = $this$isZero;
            return number instanceof BigDecimal ? ((BigDecimal)$this$isZero).compareTo(BigDecimal.ZERO) == 0 : (number instanceof BigInteger ? Intrinsics.areEqual((Object)$this$isZero, (Object)BigInteger.ZERO) : (number instanceof Double ? $this$isZero.doubleValue() == 0.0 : (number instanceof Float ? $this$isZero.floatValue() == 0.0f : (number instanceof Long ? Intrinsics.areEqual((Object)$this$isZero, (Object)0L) : $this$isZero.intValue() == 0))));
        }

        public final boolean isPositive(@NotNull Number $this$isPositive) {
            Intrinsics.checkNotNullParameter((Object)$this$isPositive, (String)"<this>");
            Number number = $this$isPositive;
            return number instanceof BigDecimal ? ((BigDecimal)$this$isPositive).compareTo(BigDecimal.ZERO) > 0 : (number instanceof BigInteger ? ((BigInteger)$this$isPositive).compareTo(BigInteger.ZERO) > 0 : (number instanceof Double ? $this$isPositive.doubleValue() > 0.0 : (number instanceof Float ? $this$isPositive.floatValue() > 0.0f : (number instanceof Long ? $this$isPositive.longValue() > 0L : $this$isPositive.intValue() > 0))));
        }

        @Nullable
        public final String getIdOrNull(@NotNull JSONValue jsonValue) {
            Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
            JSONObject jSONObject = jsonValue instanceof JSONObject ? (JSONObject)jsonValue : null;
            JSONValue jSONValue = jSONObject != null ? (JSONValue)jSONObject.get((Object)"$id") : null;
            JSONString jSONString = jSONValue instanceof JSONString ? (JSONString)jSONValue : null;
            return jSONString != null ? jSONString.getValue() : null;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Object toSimpleValue(@NotNull JSONValue $this$toSimpleValue) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$toSimpleValue, (String)"<this>");
            JSONValue jSONValue = $this$toSimpleValue;
            if (jSONValue instanceof JSONPrimitive) {
                object = ((JSONPrimitive)$this$toSimpleValue).getValue();
            } else if (jSONValue instanceof JSONArray) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)$this$toSimpleValue;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JSONValue jSONValue2 = (JSONValue)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    void v1 = it;
                    collection.add(v1 != null ? Companion.toSimpleValue((JSONValue)v1) : null);
                }
                object = (List)destination$iv$iv;
            } else if (jSONValue instanceof JSONObject) {
                void $this$mapValuesTo$iv$iv;
                Map $this$mapValues$iv = (Map)$this$toSimpleValue;
                boolean $i$f$mapValues = false;
                Map $this$mapTo$iv$iv = $this$mapValues$iv;
                Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map = destination$iv$iv;
                    boolean bl = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    Map map2 = map;
                    boolean bl2 = false;
                    JSONValue jSONValue3 = (JSONValue)it.getValue();
                    Object object2 = jSONValue3 != null ? Companion.toSimpleValue(jSONValue3) : null;
                    map2.put(k, object2);
                }
                object = destination$iv$iv;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lnet/pwall/json/schema/parser/Parser$Options;", "", "allowDescriptionRef", "", "validateExamples", "validateDefault", "<init>", "(ZZZ)V", "getAllowDescriptionRef", "()Z", "setAllowDescriptionRef", "(Z)V", "getValidateExamples", "setValidateExamples", "getValidateDefault", "setValidateDefault", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "", "json-kotlin-schema"})
    public static final class Options {
        private boolean allowDescriptionRef;
        private boolean validateExamples;
        private boolean validateDefault;

        public Options(boolean allowDescriptionRef, boolean validateExamples, boolean validateDefault) {
            this.allowDescriptionRef = allowDescriptionRef;
            this.validateExamples = validateExamples;
            this.validateDefault = validateDefault;
        }

        public /* synthetic */ Options(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            this(bl, bl2, bl3);
        }

        public final boolean getAllowDescriptionRef() {
            return this.allowDescriptionRef;
        }

        public final void setAllowDescriptionRef(boolean bl) {
            this.allowDescriptionRef = bl;
        }

        public final boolean getValidateExamples() {
            return this.validateExamples;
        }

        public final void setValidateExamples(boolean bl) {
            this.validateExamples = bl;
        }

        public final boolean getValidateDefault() {
            return this.validateDefault;
        }

        public final void setValidateDefault(boolean bl) {
            this.validateDefault = bl;
        }

        public final boolean component1() {
            return this.allowDescriptionRef;
        }

        public final boolean component2() {
            return this.validateExamples;
        }

        public final boolean component3() {
            return this.validateDefault;
        }

        @NotNull
        public final Options copy(boolean allowDescriptionRef, boolean validateExamples, boolean validateDefault) {
            return new Options(allowDescriptionRef, validateExamples, validateDefault);
        }

        public static /* synthetic */ Options copy$default(Options options, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                bl = options.allowDescriptionRef;
            }
            if ((n & 2) != 0) {
                bl2 = options.validateExamples;
            }
            if ((n & 4) != 0) {
                bl3 = options.validateDefault;
            }
            return options.copy(bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "Options(allowDescriptionRef=" + this.allowDescriptionRef + ", validateExamples=" + this.validateExamples + ", validateDefault=" + this.validateDefault + ')';
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.allowDescriptionRef);
            result = result * 31 + Boolean.hashCode(this.validateExamples);
            result = result * 31 + Boolean.hashCode(this.validateDefault);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Options)) {
                return false;
            }
            Options options = (Options)other;
            if (this.allowDescriptionRef != options.allowDescriptionRef) {
                return false;
            }
            if (this.validateExamples != options.validateExamples) {
                return false;
            }
            return this.validateDefault == options.validateDefault;
        }

        public Options() {
            this(false, false, false, 7, null);
        }
    }
}

