/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import io.kjson.JSONDecimal;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONNumber;
import io.kjson.JSONValue;
import io.kjson.pointer.IndexOpKt;
import io.kjson.pointer.JSONPointer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.output.BasicErrorEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010%\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\f\u0010&\u001a\u00020'*\u00020\u0007H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lnet/pwall/json/schema/validation/NumberValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lio/kjson/pointer/JSONPointer;", "value", "", "condition", "Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "(Ljava/net/URI;Lio/kjson/pointer/JSONPointer;Ljava/lang/Number;Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;)V", "getCondition", "()Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "getValue", "()Ljava/lang/Number;", "childLocation", "pointer", "equals", "", "other", "", "exclusiveMaximum", "instance", "Lio/kjson/JSONNumber;", "exclusiveMinimum", "getErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "relativeLocation", "json", "Lio/kjson/JSONValue;", "instanceLocation", "hashCode", "", "maximum", "minimum", "multipleOf", "validNumber", "validate", "toBigDecimal", "Ljava/math/BigDecimal;", "Companion", "ValidationType", "json-kotlin-schema"})
@SourceDebugExtension(value={"SMAP\nNumberValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberValidator.kt\nnet/pwall/json/schema/validation/NumberValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1549#2:141\n1620#2,3:142\n*S KotlinDebug\n*F\n+ 1 NumberValidator.kt\nnet/pwall/json/schema/validation/NumberValidator\n*L\n130#1:141\n130#1:142,3\n*E\n"})
public final class NumberValidator
extends JSONSchema.Validator {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Number value;
    @NotNull
    private final ValidationType condition;
    @NotNull
    private static final List<String> typeKeywords;

    public NumberValidator(@Nullable URI uri, @NotNull JSONPointer location, @NotNull Number value, @NotNull ValidationType condition) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)condition), (String)"condition");
        super(uri, location);
        this.value = value;
        this.condition = condition;
    }

    @NotNull
    public final Number getValue() {
        return this.value;
    }

    @NotNull
    public final ValidationType getCondition() {
        return this.condition;
    }

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        return pointer.child(this.condition.getKeyword());
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = IndexOpKt.get((JSONValue)json, (JSONPointer)instanceLocation);
        return !(instance instanceof JSONNumber) || this.validNumber((JSONNumber)instance);
    }

    @Override
    @Nullable
    public BasicErrorEntry getErrorEntry(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = IndexOpKt.get((JSONValue)json, (JSONPointer)instanceLocation);
        return !(instance instanceof JSONNumber) || this.validNumber((JSONNumber)instance) ? null : this.createBasicErrorEntry(relativeLocation, instanceLocation, "Number fails check: " + this.condition.getKeyword() + ' ' + this.value + ", was " + instance);
    }

    private final boolean validNumber(JSONNumber instance) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.condition.ordinal()]) {
            case 1: {
                bl = this.multipleOf(instance);
                break;
            }
            case 2: {
                bl = this.maximum(instance);
                break;
            }
            case 3: {
                bl = this.exclusiveMaximum(instance);
                break;
            }
            case 4: {
                bl = this.minimum(instance);
                break;
            }
            case 5: {
                bl = this.exclusiveMinimum(instance);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean multipleOf(JSONNumber instance) {
        Number number = this.value;
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = instance.toDecimal().remainder((BigDecimal)this.value);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"remainder(...)");
            if (bigDecimal.compareTo(BigDecimal.ZERO) != 0) return false;
            return true;
        }
        if (number instanceof Long) {
            JSONNumber jSONNumber = instance;
            if (jSONNumber instanceof JSONDecimal) {
                BigDecimal bigDecimal = ((JSONDecimal)instance).getValue().remainder(new BigDecimal(this.value.longValue()));
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"remainder(...)");
                if (bigDecimal.compareTo(BigDecimal.ZERO) != 0) return false;
                return true;
            }
            if (jSONNumber instanceof JSONLong) {
                if (((JSONLong)instance).getValue() % this.value.longValue() != 0L) return false;
                return true;
            }
            if (!(jSONNumber instanceof JSONInt)) throw new JSONSchemaException("Impossible type", null, 2, null);
            if (instance.longValue() % this.value.longValue() != 0L) return false;
            return true;
        }
        if (!(number instanceof Integer)) throw new JSONSchemaException("Impossible type", null, 2, null);
        JSONNumber jSONNumber = instance;
        if (jSONNumber instanceof JSONDecimal) {
            BigDecimal bigDecimal = ((JSONDecimal)instance).getValue().remainder(new BigDecimal(this.value.intValue()));
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"remainder(...)");
            if (bigDecimal.compareTo(BigDecimal.ZERO) != 0) return false;
            return true;
        }
        if (jSONNumber instanceof JSONLong) {
            if (((JSONLong)instance).getValue() % this.value.longValue() != 0L) return false;
            return true;
        }
        if (!(jSONNumber instanceof JSONInt)) throw new JSONSchemaException("Impossible type", null, 2, null);
        if (instance.longValue() % this.value.longValue() != 0L) return false;
        return true;
    }

    private final boolean maximum(JSONNumber instance) {
        return instance instanceof JSONDecimal ? ((JSONDecimal)instance).getValue().compareTo(this.toBigDecimal(this.value)) <= 0 : instance.longValue() <= this.value.longValue();
    }

    private final boolean exclusiveMaximum(JSONNumber instance) {
        return instance instanceof JSONDecimal ? ((JSONDecimal)instance).getValue().compareTo(this.toBigDecimal(this.value)) < 0 : instance.longValue() < this.value.longValue();
    }

    private final boolean minimum(JSONNumber instance) {
        return instance instanceof JSONDecimal ? ((JSONDecimal)instance).getValue().compareTo(this.toBigDecimal(this.value)) >= 0 : instance.longValue() >= this.value.longValue();
    }

    private final boolean exclusiveMinimum(JSONNumber instance) {
        return instance instanceof JSONDecimal ? ((JSONDecimal)instance).getValue().compareTo(this.toBigDecimal(this.value)) > 0 : instance.longValue() > this.value.longValue();
    }

    private final BigDecimal toBigDecimal(Number $this$toBigDecimal) {
        Number number = $this$toBigDecimal;
        return number instanceof BigDecimal ? (BigDecimal)$this$toBigDecimal : (number instanceof BigInteger ? new BigDecimal((BigInteger)$this$toBigDecimal) : (number instanceof Double ? new BigDecimal($this$toBigDecimal.doubleValue()) : (number instanceof Float ? new BigDecimal($this$toBigDecimal.doubleValue()) : new BigDecimal($this$toBigDecimal.longValue()))));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof NumberValidator && super.equals(other) && Intrinsics.areEqual((Object)this.value, (Object)((NumberValidator)other).value) && this.condition == ((NumberValidator)other).condition;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.value.hashCode() ^ this.condition.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        Iterable $this$map$iv = (Iterable)ValidationType.getEntries();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ValidationType validationType = (ValidationType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKeyword());
        }
        typeKeywords = (List)var3_3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/NumberValidator$Companion;", "", "()V", "typeKeywords", "", "", "getTypeKeywords", "()Ljava/util/List;", "findType", "Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "keyword", "json-kotlin-schema"})
    @SourceDebugExtension(value={"SMAP\nNumberValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberValidator.kt\nnet/pwall/json/schema/validation/NumberValidator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n1855#2,2:141\n*S KotlinDebug\n*F\n+ 1 NumberValidator.kt\nnet/pwall/json/schema/validation/NumberValidator$Companion\n*L\n133#1:141,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getTypeKeywords() {
            return typeKeywords;
        }

        @NotNull
        public final ValidationType findType(@NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            Iterable $this$forEach$iv = (Iterable)ValidationType.getEntries();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ValidationType it = (ValidationType)((Object)element$iv);
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKeyword(), (Object)keyword)) continue;
                return it;
            }
            throw new RuntimeException("Can't find validation type - should not happen");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "", "keyword", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getKeyword", "()Ljava/lang/String;", "MULTIPLE_OF", "MAXIMUM", "EXCLUSIVE_MAXIMUM", "MINIMUM", "EXCLUSIVE_MINIMUM", "json-kotlin-schema"})
    public static final class ValidationType
    extends Enum<ValidationType> {
        @NotNull
        private final String keyword;
        public static final /* enum */ ValidationType MULTIPLE_OF = new ValidationType("multipleOf");
        public static final /* enum */ ValidationType MAXIMUM = new ValidationType("maximum");
        public static final /* enum */ ValidationType EXCLUSIVE_MAXIMUM = new ValidationType("exclusiveMaximum");
        public static final /* enum */ ValidationType MINIMUM = new ValidationType("minimum");
        public static final /* enum */ ValidationType EXCLUSIVE_MINIMUM = new ValidationType("exclusiveMinimum");
        private static final /* synthetic */ ValidationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ValidationType(String keyword) {
            this.keyword = keyword;
        }

        @NotNull
        public final String getKeyword() {
            return this.keyword;
        }

        public static ValidationType[] values() {
            return (ValidationType[])$VALUES.clone();
        }

        public static ValidationType valueOf(String value) {
            return Enum.valueOf(ValidationType.class, value);
        }

        @NotNull
        public static EnumEntries<ValidationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = validationTypeArray = new ValidationType[]{ValidationType.MULTIPLE_OF, ValidationType.MAXIMUM, ValidationType.EXCLUSIVE_MAXIMUM, ValidationType.MINIMUM, ValidationType.EXCLUSIVE_MINIMUM};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidationType.values().length];
            try {
                nArray[ValidationType.MULTIPLE_OF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationType.MAXIMUM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationType.EXCLUSIVE_MAXIMUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationType.MINIMUM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationType.EXCLUSIVE_MINIMUM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

