/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.parser;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.pwall.json.JSONBoolean;
import net.pwall.json.JSONDecimal;
import net.pwall.json.JSONDouble;
import net.pwall.json.JSONFloat;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONMapping;
import net.pwall.json.JSONNumberValue;
import net.pwall.json.JSONSequence;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.JSONZero;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.parser.InputDetails;
import net.pwall.json.schema.parser.JSONReader;
import net.pwall.json.schema.parser.Parser;
import net.pwall.json.schema.subschema.AdditionalItemsSchema;
import net.pwall.json.schema.subschema.AdditionalPropertiesSchema;
import net.pwall.json.schema.subschema.AllOfSchema;
import net.pwall.json.schema.subschema.AnyOfSchema;
import net.pwall.json.schema.subschema.ExtensionSchema;
import net.pwall.json.schema.subschema.IfThenElseSchema;
import net.pwall.json.schema.subschema.ItemsArraySchema;
import net.pwall.json.schema.subschema.ItemsSchema;
import net.pwall.json.schema.subschema.OneOfSchema;
import net.pwall.json.schema.subschema.PatternPropertiesSchema;
import net.pwall.json.schema.subschema.PropertiesSchema;
import net.pwall.json.schema.subschema.PropertyNamesSchema;
import net.pwall.json.schema.subschema.RefSchema;
import net.pwall.json.schema.subschema.RequiredSchema;
import net.pwall.json.schema.validation.ArrayValidator;
import net.pwall.json.schema.validation.ConstValidator;
import net.pwall.json.schema.validation.ContainsValidator;
import net.pwall.json.schema.validation.DefaultValidator;
import net.pwall.json.schema.validation.DelegatingValidator;
import net.pwall.json.schema.validation.EnumValidator;
import net.pwall.json.schema.validation.FormatValidator;
import net.pwall.json.schema.validation.NumberValidator;
import net.pwall.json.schema.validation.PatternValidator;
import net.pwall.json.schema.validation.PropertiesValidator;
import net.pwall.json.schema.validation.StringValidator;
import net.pwall.json.schema.validation.TypeValidator;
import net.pwall.json.schema.validation.UniqueItemsValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 j2\u00020\u0001:\u0002jkB'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ$\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010\r2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u0006H\u0002J(\u0010)\u001a\u0004\u0018\u00010\u000b2\n\u0010*\u001a\u0006\u0012\u0002\b\u00030+2\b\u0010(\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\fH\u0002J\u000e\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020.J\u000e\u0010,\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010,\u001a\u00020#2\u0006\u0010/\u001a\u000200J\u001a\u0010,\u001a\u00020#2\u0006\u00101\u001a\u00020\u000b2\n\b\u0002\u0010(\u001a\u0004\u0018\u00010\u0006J\u001a\u0010,\u001a\u00020#2\u0006\u00102\u001a\u00020\r2\b\u0010(\u001a\u0004\u0018\u00010\u0006H\u0002J,\u00103\u001a\u0002042\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J&\u00108\u001a\u0004\u0018\u0001092\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002JT\u0010:\u001a\u00020#2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u0010;\u001a\u0004\u0018\u00010\r2&\u0010<\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0>\u0012\u0004\u0012\u00020#0=H\u0002J\"\u0010?\u001a\u00020@2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u0006H\u0002J\"\u0010A\u001a\u00020#2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\f2\b\u0010B\u001a\u0004\u0018\u00010\u0006H\u0002J$\u0010C\u001a\u00020D2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010E\u001a\u00020#2\u0006\u0010F\u001a\u00020\u000bJ$\u0010G\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010H\u001a\u00020#2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u0006H\u0002J,\u0010I\u001a\u00020J2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J,\u0010K\u001a\u00020L2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\u0006\u00105\u001a\u00020M2\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J$\u0010N\u001a\u00020O2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J,\u0010P\u001a\u00020Q2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J,\u0010R\u001a\u00020S2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J,\u0010T\u001a\u00020U2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\u0006\u00105\u001a\u00020V2\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010W\u001a\u00020X2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u0006H\u0002J,\u0010Y\u001a\u00020Z2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J$\u0010[\u001a\u00020\\2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J \u0010]\u001a\u00020#2\u0006\u00102\u001a\u00020\r2\u0006\u0010'\u001a\u00020\f2\b\u0010B\u001a\u0004\u0018\u00010\u0006J,\u0010^\u001a\u00020_2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\u0006\u00105\u001a\u00020`2\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J$\u0010a\u001a\u00020b2\u0006\u0010'\u001a\u00020\f2\b\u0010(\u001a\u0004\u0018\u00010\u00062\b\u00107\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010c\u001a\u00020#2\u0006\u0010d\u001a\u00020\u000bJ\u000e\u0010e\u001a\u00020f2\u0006\u0010-\u001a\u00020.J\u000e\u0010e\u001a\u00020f2\u0006\u0010/\u001a\u000200J\u000e\u0010e\u001a\u00020f2\u0006\u0010F\u001a\u00020\u000bJ\u001c\u0010g\u001a\u00020f2\u0014\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010i0\u0005R>\u0010\t\u001a&\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R(\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lnet/pwall/json/schema/parser/Parser;", "", "options", "Lnet/pwall/json/schema/parser/Parser$Options;", "uriResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "(Lnet/pwall/json/schema/parser/Parser$Options;Lkotlin/jvm/functions/Function1;)V", "customValidationHandler", "Lkotlin/Function4;", "", "Lnet/pwall/json/pointer/JSONPointer;", "Lnet/pwall/json/JSONValue;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "getCustomValidationHandler", "()Lkotlin/jvm/functions/Function4;", "setCustomValidationHandler", "(Lkotlin/jvm/functions/Function4;)V", "jsonReader", "Lnet/pwall/json/schema/parser/JSONReader;", "getJsonReader", "()Lnet/pwall/json/schema/parser/JSONReader;", "nonstandardFormatHandler", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "getNonstandardFormatHandler", "()Lkotlin/jvm/functions/Function1;", "setNonstandardFormatHandler", "(Lkotlin/jvm/functions/Function1;)V", "getOptions", "()Lnet/pwall/json/schema/parser/Parser$Options;", "setOptions", "(Lnet/pwall/json/schema/parser/Parser$Options;)V", "schemaCache", "", "Lnet/pwall/json/schema/JSONSchema;", "checkType", "Lnet/pwall/json/schema/JSONSchema$Type;", "item", "pointer", "uri", "getDescription", "schemaJSON", "Lnet/pwall/json/JSONMapping;", "parse", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "string", "json", "parseArrayNumberOfItems", "Lnet/pwall/json/schema/validation/ArrayValidator;", "condition", "Lnet/pwall/json/schema/validation/ArrayValidator$ValidationType;", "value", "parseArrayUniqueItems", "Lnet/pwall/json/schema/validation/UniqueItemsValidator;", "parseCombinationSchema", "array", "creator", "Lkotlin/Function3;", "", "parseContains", "Lnet/pwall/json/schema/validation/ContainsValidator;", "parseDraft07", "parentUri", "parseEnum", "Lnet/pwall/json/schema/validation/EnumValidator;", "parseFile", "filename", "parseFormat", "parseIf", "parseItems", "Lnet/pwall/json/schema/JSONSchema$SubSchema;", "parseNumberLimit", "Lnet/pwall/json/schema/validation/NumberValidator;", "Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "parsePattern", "Lnet/pwall/json/schema/validation/PatternValidator;", "parsePatternProperties", "Lnet/pwall/json/schema/subschema/PatternPropertiesSchema;", "parseProperties", "Lnet/pwall/json/schema/subschema/PropertiesSchema;", "parsePropertiesSize", "Lnet/pwall/json/schema/validation/PropertiesValidator;", "Lnet/pwall/json/schema/validation/PropertiesValidator$ValidationType;", "parsePropertyNames", "Lnet/pwall/json/schema/subschema/PropertyNamesSchema;", "parseRef", "Lnet/pwall/json/schema/subschema/RefSchema;", "parseRequired", "Lnet/pwall/json/schema/subschema/RequiredSchema;", "parseSchema", "parseStringLength", "Lnet/pwall/json/schema/validation/StringValidator;", "Lnet/pwall/json/schema/validation/StringValidator$ValidationType;", "parseType", "Lnet/pwall/json/schema/validation/TypeValidator;", "parseURI", "uriString", "preLoad", "", "setExtendedResolver", "extendedResolver", "Lnet/pwall/json/schema/parser/InputDetails;", "Companion", "Options", "json-kotlin-schema"})
@SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,589:1\n1#2:590\n1559#3:591\n1590#3,4:592\n1559#3:596\n1590#3,4:597\n1549#3:601\n1620#3,3:602\n1549#3:605\n1620#3,3:606\n1559#3:609\n1590#3,4:610\n1559#3:614\n1590#3,4:615\n*S KotlinDebug\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser\n*L\n303#1:591\n303#1:592,4\n349#1:596\n349#1:597,4\n357#1:601\n357#1:602,3\n364#1:605\n364#1:606,3\n384#1:609\n384#1:610,4\n394#1:614\n394#1:615,4\n*E\n"})
public final class Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Options options;
    @NotNull
    private Function4<? super String, ? super URI, ? super JSONPointer, ? super JSONValue, ? extends JSONSchema.Validator> customValidationHandler;
    @NotNull
    private Function1<? super String, ? extends FormatValidator.FormatChecker> nonstandardFormatHandler;
    @NotNull
    private final JSONReader jsonReader;
    @NotNull
    private final Map<URI, JSONSchema> schemaCache;
    @NotNull
    private static final List<String> schemaVersion202012;
    @NotNull
    private static final List<String> schemaVersion201909;
    @NotNull
    private static final List<String> schemaVersionDraft07;
    @NotNull
    private static final Function1<URI, InputStream> defaultURIResolver;
    @NotNull
    private static final Function1<URI, InputDetails> defaultExtendedResolver;

    public Parser(@NotNull Options options, @NotNull Function1<? super URI, ? extends InputStream> uriResolver) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(uriResolver, (String)"uriResolver");
        this.options = options;
        this.customValidationHandler = customValidationHandler.1.INSTANCE;
        this.nonstandardFormatHandler = nonstandardFormatHandler.1.INSTANCE;
        this.jsonReader = new JSONReader(uriResolver);
        this.schemaCache = new LinkedHashMap();
    }

    public /* synthetic */ Parser(Options options, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            options = new Options(false, 1, null);
        }
        if ((n & 2) != 0) {
            function1 = defaultURIResolver;
        }
        this(options, function1);
    }

    @NotNull
    public final Options getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"<set-?>");
        this.options = options;
    }

    @NotNull
    public final Function4<String, URI, JSONPointer, JSONValue, JSONSchema.Validator> getCustomValidationHandler() {
        return this.customValidationHandler;
    }

    public final void setCustomValidationHandler(@NotNull Function4<? super String, ? super URI, ? super JSONPointer, ? super JSONValue, ? extends JSONSchema.Validator> function4) {
        Intrinsics.checkNotNullParameter(function4, (String)"<set-?>");
        this.customValidationHandler = function4;
    }

    @NotNull
    public final Function1<String, FormatValidator.FormatChecker> getNonstandardFormatHandler() {
        return this.nonstandardFormatHandler;
    }

    public final void setNonstandardFormatHandler(@NotNull Function1<? super String, ? extends FormatValidator.FormatChecker> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.nonstandardFormatHandler = function1;
    }

    @NotNull
    public final JSONReader getJsonReader() {
        return this.jsonReader;
    }

    public final void setExtendedResolver(@NotNull Function1<? super URI, InputDetails> extendedResolver) {
        Intrinsics.checkNotNullParameter(extendedResolver, (String)"extendedResolver");
        this.jsonReader.setExtendedResolver(extendedResolver);
    }

    public final void preLoad(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.jsonReader.preLoad(filename);
    }

    public final void preLoad(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.jsonReader.preLoad(file);
    }

    public final void preLoad(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.jsonReader.preLoad(path);
    }

    @NotNull
    public final JSONSchema parseFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.parse(new File(filename));
    }

    @NotNull
    public final JSONSchema parseURI(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        return this.parse(new URI(uriString));
    }

    @NotNull
    public final JSONSchema parse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) {
            throw new JSONSchemaException("Invalid file - " + file);
        }
        URI uri = file.toURI();
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema it = jSONSchema;
            boolean bl = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(file);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema it = jSONSchema;
            boolean bl = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(uri);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new JSONSchemaException("Invalid file - " + path);
        }
        URI uri = path.toUri();
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema it = jSONSchema;
            boolean bl = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(path);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull String string, @Nullable URI uri) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        JSONValue json = this.jsonReader.readJSON(string, uri);
        return this.parse(json, uri);
    }

    public static /* synthetic */ JSONSchema parse$default(Parser parser2, String string, URI uRI, int n, Object object) {
        if ((n & 2) != 0) {
            uRI = null;
        }
        return parser2.parse(string, uRI);
    }

    private final JSONSchema parse(JSONValue json, URI uri) {
        JSONSchema jSONSchema;
        String string;
        JSONMapping jSONMapping = json instanceof JSONMapping ? (JSONMapping)json : null;
        if (jSONMapping != null) {
            JSONPointer jSONPointer = JSONPointer.root.child("$schema");
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"root.child(\"\\$schema\")");
            string = Companion.getStringOrNull(jSONMapping, uri, jSONPointer);
        } else {
            string = null;
        }
        String schemaVersion = string;
        JSONPointer pointer = JSONPointer.root;
        String string2 = schemaVersion;
        if (CollectionsKt.contains((Iterable)schemaVersion201909, (Object)string2)) {
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"pointer");
            jSONSchema = this.parseSchema(json, pointer, uri);
        } else if (CollectionsKt.contains((Iterable)schemaVersionDraft07, (Object)string2)) {
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"pointer");
            jSONSchema = this.parseDraft07(json, pointer, uri);
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"pointer");
            jSONSchema = this.parseSchema(json, pointer, uri);
        }
        return jSONSchema;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final JSONSchema parseSchema(@NotNull JSONValue json, @NotNull JSONPointer pointer, @Nullable URI parentUri) {
        block96: {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            schemaJSON = pointer.eval(json);
            if (schemaJSON instanceof JSONBoolean) {
                return JSONSchema.Companion.booleanSchema(((JSONBoolean)schemaJSON).booleanValue(), parentUri, pointer);
            }
            if (!(schemaJSON instanceof JSONMapping)) {
                throw new JSONSchemaException("Schema is not boolean or object - " + net.pwall.json.schema.parser.Parser$Companion.access$errorPointer(Parser.Companion, parentUri, pointer));
            }
            id = Parser.Companion.getIdOrNull(schemaJSON);
            if (id == null) {
                v0 = parentUri;
            } else if (parentUri == null) {
                v0 = Parser.Companion.dropFragment(new URI(id));
            } else {
                v1 = parentUri.resolve(id);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"parentUri.resolve(id)");
                v0 = Parser.Companion.dropFragment(v1);
            }
            v2 = uri = v0;
            if (v2 != null) {
                it = v2;
                $i$a$-let-Parser$parseSchema$1 = false;
                fragmentURI = Parser.Companion.withFragment(uri, pointer);
                v3 = this.schemaCache.get(fragmentURI);
                if (v3 != null) {
                    it = v3;
                    $i$a$-let-Parser$parseSchema$1$1 = false;
                    if (it instanceof JSONSchema.False) {
                        net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "Recursive $ref", uri, pointer);
                        throw new KotlinNothingValueException();
                    }
                    return it;
                }
                this.schemaCache.put(fragmentURI, new JSONSchema.False(uri, pointer));
            }
            title = Parser.Companion.getStringOrNull((JSONMapping)schemaJSON, uri, "title");
            description = this.getDescription((JSONMapping)schemaJSON, uri, pointer);
            children = new ArrayList<E>();
            result = new JSONSchema.General(Parser.schemaVersion201909.get(0), title, description, uri, pointer, children);
            for (Map.Entry $i$a$-let-Parser$parseSchema$1$1 : ((JSONMapping)schemaJSON).entrySet()) {
                block93: {
                    block95: {
                        block94: {
                            block92: {
                                Intrinsics.checkNotNullExpressionValue((Object)$i$a$-let-Parser$parseSchema$1$1, (String)"schemaJSON.entries");
                                key = (String)$i$a$-let-Parser$parseSchema$1$1.getKey();
                                value = (JSONValue)$i$a$-let-Parser$parseSchema$1$1.getValue();
                                childPointer = pointer.child(key);
                                var16_20 = key;
                                if (!Intrinsics.areEqual((Object)var16_20, (Object)"$schema")) break block92;
                                if (!Intrinsics.areEqual((Object)pointer, (Object)JSONPointer.root)) {
                                    Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                                    net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "May only appear in the root of the document", uri, childPointer);
                                    throw new KotlinNothingValueException();
                                }
                                if (!(value instanceof JSONString)) {
                                    Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                                    net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "String expected", uri, childPointer);
                                    throw new KotlinNothingValueException();
                                }
                                break block93;
                            }
                            if (var16_20 == null) break block94;
                            switch (var16_20.hashCode()) {
                                case 3116345: {
                                    if (!var16_20.equals("else")) {
                                        break;
                                    }
                                    ** GOTO lbl87
                                }
                                case 36326194: {
                                    if (!var16_20.equals("$defs")) {
                                        break;
                                    }
                                    ** GOTO lbl87
                                }
                                case -1724546052: {
                                    if (!var16_20.equals("description")) {
                                        break;
                                    }
                                    ** GOTO lbl87
                                }
                                case 3558941: {
                                    if (!var16_20.equals("then")) {
                                        break;
                                    }
                                    ** GOTO lbl87
                                }
                                case 110371416: {
                                    if (!var16_20.equals("title")) {
                                        break;
                                    }
                                    ** GOTO lbl87
                                }
                                case 787418769: {
                                    if (!var16_20.equals("minContains")) {
                                        break;
                                    }
                                    ** GOTO lbl87
                                }
                                case 37951: {
                                    if (!var16_20.equals("$id")) break;
lbl87:
                                    // 7 sources

                                    v4 = true;
                                    break block95;
                                }
                            }
                        }
                        v4 = Intrinsics.areEqual((Object)var16_20, (Object)"maxContains");
                    }
                    if (!v4) {
                        if (Intrinsics.areEqual((Object)var16_20, (Object)"$comment")) {
                            if (!(value instanceof JSONString)) {
                                Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                                net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "String expected", uri, childPointer);
                                throw new KotlinNothingValueException();
                            }
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"examples")) {
                            if (!(value instanceof JSONSequence)) {
                                Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                                net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "Must be array", uri, childPointer);
                                throw new KotlinNothingValueException();
                            }
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"$ref")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseRef(json, childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"default")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(new DefaultValidator(uri, childPointer, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"allOf")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseCombinationSchema(json, childPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AllOfSchema>((Object)JSONSchema.Companion){

                                @NotNull
                                public final AllOfSchema invoke(@Nullable URI p0, @NotNull JSONPointer p1, @NotNull List<? extends JSONSchema> p2) {
                                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                    Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                    return ((JSONSchema.Companion)this.receiver).allOf(p0, p1, p2);
                                }
                            })));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"anyOf")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseCombinationSchema(json, childPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AnyOfSchema>((Object)JSONSchema.Companion){

                                @NotNull
                                public final AnyOfSchema invoke(@Nullable URI p0, @NotNull JSONPointer p1, @NotNull List<? extends JSONSchema> p2) {
                                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                    Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                    return ((JSONSchema.Companion)this.receiver).anyOf(p0, p1, p2);
                                }
                            })));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"oneOf")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseCombinationSchema(json, childPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, OneOfSchema>((Object)JSONSchema.Companion){

                                @NotNull
                                public final OneOfSchema invoke(@Nullable URI p0, @NotNull JSONPointer p1, @NotNull List<? extends JSONSchema> p2) {
                                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                                    Intrinsics.checkNotNullParameter(p2, (String)"p2");
                                    return ((JSONSchema.Companion)this.receiver).oneOf(p0, p1, p2);
                                }
                            })));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"not")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            v5 = pointer.child("not");
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"pointer.child(\"not\")");
                            children.add(new JSONSchema.Not(uri, childPointer, this.parseSchema(json, v5, uri)));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"if")) {
                            children.add(this.parseIf(json, pointer, uri));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"type")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseType(childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"enum")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseEnum(childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"const")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(new ConstValidator(uri, childPointer, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"properties")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseProperties(json, childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"patternProperties")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parsePatternProperties(json, childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"propertyNames")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parsePropertyNames(json, childPointer, uri));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"minProperties")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parsePropertiesSize(childPointer, uri, PropertiesValidator.ValidationType.MIN_PROPERTIES, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"maxProperties")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parsePropertiesSize(childPointer, uri, PropertiesValidator.ValidationType.MAX_PROPERTIES, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"required")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseRequired(childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"items")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseItems(json, childPointer, uri, value));
                        } else if (NumberValidator.Companion.getTypeKeywords().contains(var16_20)) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                            children.add(this.parseNumberLimit(childPointer, uri, NumberValidator.Companion.findType(key), value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"maxItems")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseArrayNumberOfItems(childPointer, uri, ArrayValidator.ValidationType.MAX_ITEMS, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"minItems")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseArrayNumberOfItems(childPointer, uri, ArrayValidator.ValidationType.MIN_ITEMS, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"uniqueItems")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            if (this.parseArrayUniqueItems(childPointer, uri, value) != null) {
                                $i$a$-let-Parser$parseSchema$5 = false;
                                children.add(it);
                            }
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"maxLength")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseStringLength(childPointer, uri, StringValidator.ValidationType.MAX_LENGTH, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"minLength")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseStringLength(childPointer, uri, StringValidator.ValidationType.MIN_LENGTH, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"pattern")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parsePattern(childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"format")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(this.parseFormat(childPointer, uri, value));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"additionalProperties")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(new AdditionalPropertiesSchema(result, uri, childPointer, this.parseSchema(json, childPointer, uri)));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"additionalItems")) {
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            children.add(new AdditionalItemsSchema(result, uri, childPointer, this.parseSchema(json, childPointer, uri)));
                        } else if (Intrinsics.areEqual((Object)var16_20, (Object)"contains")) {
                            children.add(this.parseContains(json, pointer, uri));
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                            if ((JSONSchema.Validator)this.customValidationHandler.invoke((Object)key, (Object)uri, (Object)childPointer, (Object)value) != null) {
                                $i$a$-let-Parser$parseSchema$6 = false;
                                children.add(new DelegatingValidator(it.getUri(), it.getLocation(), key, it));
                            }
                        }
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                if (!StringsKt.startsWith$default((String)key, (String)"x-", (boolean)false, (int)2, null)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                v6 = value;
                children.add(new ExtensionSchema(uri, childPointer, key, v6 != null ? v6.toSimpleValue() : null));
            }
            v7 = uri;
            if (v7 == null) break block96;
            it = v7;
            $i$a$-let-Parser$parseSchema$7 = false;
            this.schemaCache.put(Parser.Companion.withFragment(uri, pointer), result);
        }
        return result;
    }

    private final String getDescription(JSONMapping<?> schemaJSON, URI uri, JSONPointer pointer) {
        JSONValue ref;
        JSONValue jSONValue = (JSONValue)schemaJSON.get((Object)"description");
        if (jSONValue == null) {
            return null;
        }
        JSONValue value = jSONValue;
        if (value instanceof JSONString) {
            return ((JSONString)value).getValue();
        }
        if (this.options.getAllowDescriptionRef() && value instanceof JSONMapping && ((JSONMapping)value).size() == 1 && (ref = (JSONValue)((JSONMapping)value).get((Object)"$ref")) instanceof JSONString) {
            try {
                URI uRI = uri;
                URL uRL = (uRI == null ? new URI(((JSONString)ref).getValue()) : uRI.resolve(((JSONString)ref).getValue())).toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"if (uri == null) URI(ref\u2026solve(ref.value)).toURL()");
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                return new String(byArray, charset);
            }
            catch (Exception e) {
                Parser.Companion.fatal("Error reading external description " + ref, uri, pointer);
                throw new KotlinNothingValueException();
            }
        }
        Parser.Companion.fatal("Invalid description", uri, pointer);
        throw new KotlinNothingValueException();
    }

    private final JSONSchema parseIf(JSONValue json, JSONPointer pointer, URI uri) {
        JSONSchema jSONSchema;
        JSONSchema jSONSchema2;
        JSONPointer jSONPointer = pointer.child("if");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(\"if\")");
        JSONSchema ifSchema = this.parseSchema(json, jSONPointer, uri);
        JSONPointer it = pointer.child("then");
        boolean bl = false;
        if (it.exists(json)) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            jSONSchema2 = this.parseSchema(json, it, uri);
        } else {
            jSONSchema2 = null;
        }
        JSONSchema thenSchema = jSONSchema2;
        JSONPointer it2 = pointer.child("else");
        boolean bl2 = false;
        if (it2.exists(json)) {
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            jSONSchema = this.parseSchema(json, it2, uri);
        } else {
            jSONSchema = null;
        }
        JSONSchema elseSchema = jSONSchema;
        return new IfThenElseSchema(uri, pointer, ifSchema, thenSchema, elseSchema);
    }

    private final ContainsValidator parseContains(JSONValue json, JSONPointer pointer, URI uri) {
        Integer n;
        Integer n2;
        JSONPointer jSONPointer = pointer.child("contains");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(\"contains\")");
        JSONSchema containsSchema = this.parseSchema(json, jSONPointer, uri);
        JSONPointer it = pointer.child("minContains");
        boolean bl = false;
        if (it.exists(json)) {
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            n2 = Companion.getNonNegativeInteger(json, uri, it);
        } else {
            n2 = null;
        }
        Integer minContains = n2;
        JSONPointer it2 = pointer.child("maxContains");
        boolean bl2 = false;
        if (it2.exists(json)) {
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            n = Companion.getNonNegativeInteger(json, uri, it2);
        } else {
            n = null;
        }
        Integer maxContains = n;
        JSONPointer jSONPointer2 = pointer.child("contains");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(\"contains\")");
        return new ContainsValidator(uri, jSONPointer2, containsSchema, minContains, maxContains);
    }

    private final JSONSchema.Validator parseFormat(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONString)) {
            Parser.Companion.fatal("String expected", uri, pointer);
            throw new KotlinNothingValueException();
        }
        String keyword = ((JSONString)value).getValue();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)keyword, (String)"keyword");
        FormatValidator.FormatChecker formatChecker = (FormatValidator.FormatChecker)this.nonstandardFormatHandler.invoke((Object)keyword);
        if (formatChecker == null && (formatChecker = FormatValidator.Companion.findChecker(keyword)) == null) {
            formatChecker = new FormatValidator.NullFormatChecker(keyword);
        }
        FormatValidator.FormatChecker checker = formatChecker;
        return new FormatValidator(uri, pointer, checker);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema parseCombinationSchema(JSONValue json, JSONPointer pointer, URI uri, JSONValue array, Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> creator) {
        Collection<JSONSchema> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!(array instanceof JSONSequence)) {
            Parser.Companion.fatal("Compound must take array", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Iterable iterable = (Iterable)array;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> function3 = creator;
        boolean $i$f$mapIndexed = false;
        void var8_11 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSONValue cfr_ignored_0 = (JSONValue)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            JSONPointer jSONPointer2 = pointer.child((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(i)");
            collection.add(this.parseSchema(json, jSONPointer2, uri));
        }
        collection = (List)destination$iv$iv;
        return (JSONSchema)function3.invoke((Object)uRI, (Object)jSONPointer, (Object)collection);
    }

    /*
     * Unable to fully structure code
     */
    private final RefSchema parseRef(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONString)) {
            net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "$ref must be string", uri, pointer);
            throw new KotlinNothingValueException();
        }
        refString = ((JSONString)value).getValue();
        refURI = null;
        refPointer = null;
        refJSON = null;
        refURIFragment = null;
        Intrinsics.checkNotNullExpressionValue((Object)refString, (String)"refString");
        hashIndex = StringsKt.indexOf$default((CharSequence)refString, (char)'#', (int)0, (boolean)false, (int)6, null);
        if (hashIndex == 0) ** GOTO lbl-1000
        if (hashIndex > 0 && uri != null) {
            v0 = uri.toString();
            v1 = refString.substring(0, hashIndex);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            ** if (!Intrinsics.areEqual((Object)v0, (Object)v1)) goto lbl-1000
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v2 = refString.substring(hashIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"this as java.lang.String).substring(startIndex)");
            refURIFragment = v2;
            refURI = uri;
            v3 = JSONPointer.fromURIFragment((String)refString);
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"fromURIFragment(refString)");
            refPointer = v3;
            refJSON = json;
            ** GOTO lbl53
        }
lbl-1000:
        // 2 sources

        {
            if (hashIndex < 0) {
                refURIFragment = null;
                v4 = uri;
                if (v4 == null || (v4 = v4.resolve(refString)) == null) {
                    v4 = new URI(refString);
                }
                refURI = v4;
                v5 = JSONPointer.root;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"root");
                refPointer = v5;
                refJSON = this.jsonReader.readJSON(refURI);
            } else {
                v6 = refString.substring(hashIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"this as java.lang.String).substring(startIndex)");
                refURIFragment = v6;
                v7 = refString.substring(0, hashIndex);
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                refStringWithoutFragment = v7;
                v8 = uri;
                if (v8 == null || (v8 = v8.resolve(refStringWithoutFragment)) == null) {
                    v8 = new URI(refStringWithoutFragment);
                }
                refURI = v8;
                v9 = refString.substring(hashIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"this as java.lang.String).substring(startIndex)");
                refPointer = new JSONPointer(v9);
                refJSON = this.jsonReader.readJSON(refURI);
            }
        }
lbl53:
        // 3 sources

        if (!refPointer.exists(refJSON)) {
            net.pwall.json.schema.parser.Parser$Companion.access$fatal(Parser.Companion, "$ref not found " + refString, uri, pointer);
            throw new KotlinNothingValueException();
        }
        return new RefSchema(uri, pointer, this.parseSchema(refJSON, refPointer, refURI), refURIFragment);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema.SubSchema parseItems(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        JSONSchema.SubSchema subSchema;
        if (value instanceof JSONSequence) {
            Collection<JSONSchema> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable iterable = (Iterable)value;
            JSONPointer jSONPointer = pointer;
            URI uRI = uri;
            boolean $i$f$mapIndexed = false;
            void var7_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JSONValue cfr_ignored_0 = (JSONValue)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl = false;
                JSONPointer jSONPointer2 = pointer.child((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(i)");
                collection.add(this.parseSchema(json, jSONPointer2, uri));
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            JSONPointer jSONPointer3 = jSONPointer;
            URI uRI2 = uRI;
            subSchema = new ItemsArraySchema(uRI2, jSONPointer3, list);
        } else {
            subSchema = new ItemsSchema(uri, pointer, this.parseSchema(json, pointer, uri));
        }
        return subSchema;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertiesSchema parseProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(value instanceof JSONMapping)) {
            Parser.Companion.fatal("properties must be object", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Set set = ((JSONMapping)value).keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value.keys");
        Iterable iterable = set;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JSONPointer jSONPointer2 = pointer.child((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(it)");
            collection.add(TuplesKt.to((Object)it, (Object)this.parseSchema(json, jSONPointer2, uri)));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer3 = jSONPointer;
        URI uRI2 = uRI;
        return new PropertiesSchema(uRI2, jSONPointer3, list);
    }

    /*
     * WARNING - void declaration
     */
    private final PatternPropertiesSchema parsePatternProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(value instanceof JSONMapping)) {
            Parser.Companion.fatal("patternProperties must be object", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Set set = ((JSONMapping)value).keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value.keys");
        Iterable iterable = set;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Regex regex;
            void key;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JSONPointer childPointer = pointer.child((String)key);
            try {
                Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                regex = new Regex((String)key);
            }
            catch (Exception e) {
                Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
                Parser.Companion.fatal("Invalid regex in patternProperties", uri, childPointer);
                throw new KotlinNothingValueException();
            }
            Regex regex2 = regex;
            Intrinsics.checkNotNullExpressionValue((Object)childPointer, (String)"childPointer");
            collection.add(TuplesKt.to((Object)regex2, (Object)this.parseSchema(json, childPointer, uri)));
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer2 = jSONPointer;
        URI uRI2 = uRI;
        return new PatternPropertiesSchema(uRI2, jSONPointer2, list);
    }

    private final PropertyNamesSchema parsePropertyNames(JSONValue json, JSONPointer pointer, URI uri) {
        return new PropertyNamesSchema(uri, pointer, this.parseSchema(json, pointer, uri));
    }

    private final PropertiesValidator parsePropertiesSize(JSONPointer pointer, URI uri, PropertiesValidator.ValidationType condition, JSONValue value) {
        return new PropertiesValidator(uri, pointer, condition, Companion.getInteger(value, uri, pointer));
    }

    /*
     * WARNING - void declaration
     */
    private final RequiredSchema parseRequired(JSONPointer pointer, URI uri, JSONValue value) {
        Collection<String> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!(value instanceof JSONSequence)) {
            Parser.Companion.fatal("required must be array", uri, pointer);
            throw new KotlinNothingValueException();
        }
        Iterable iterable = (Iterable)value;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$mapIndexed = false;
        void var6_8 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void entry;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSONValue jSONValue = (JSONValue)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            if (!(entry instanceof JSONString)) {
                void i;
                JSONPointer jSONPointer2 = pointer.child((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(i)");
                Parser.Companion.fatal("required item must be string", uri, jSONPointer2);
                throw new KotlinNothingValueException();
            }
            collection.add(((JSONString)entry).getValue());
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer3 = jSONPointer;
        URI uRI2 = uRI;
        return new RequiredSchema(uRI2, jSONPointer3, list);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeValidator parseType(JSONPointer pointer, URI uri, JSONValue value) {
        List list;
        JSONValue jSONValue = value;
        if (jSONValue instanceof JSONString) {
            list = CollectionsKt.listOf((Object)((Object)this.checkType(value, pointer, uri)));
        } else if (jSONValue instanceof JSONSequence) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = (Iterable)value;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void item;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JSONValue jSONValue2 = (JSONValue)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JSONPointer jSONPointer = pointer.child((int)index);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(index)");
                collection.add(this.checkType((JSONValue)item, jSONPointer, uri));
            }
            list = (List)destination$iv$iv;
        } else {
            Parser.Companion.fatal("Invalid type", uri, pointer);
            throw new KotlinNothingValueException();
        }
        List types = list;
        return new TypeValidator(uri, pointer, types);
    }

    private final JSONSchema.Type checkType(JSONValue item, JSONPointer pointer, URI uri) {
        if (item instanceof JSONString) {
            for (JSONSchema.Type type : JSONSchema.Type.values()) {
                if (!Intrinsics.areEqual((Object)((JSONString)item).getValue(), (Object)type.getValue())) continue;
                return type;
            }
        }
        Parser.Companion.fatal("Invalid type", uri, pointer);
        throw new KotlinNothingValueException();
    }

    private final EnumValidator parseEnum(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONSequence)) {
            Parser.Companion.fatal("enum must be array", uri, pointer);
            throw new KotlinNothingValueException();
        }
        return new EnumValidator(uri, pointer, (JSONSequence)value);
    }

    private final NumberValidator parseNumberLimit(JSONPointer pointer, URI uri, NumberValidator.ValidationType condition, JSONValue value) {
        Number number;
        Number number2;
        if (!(value instanceof JSONNumberValue)) {
            Parser.Companion.fatal("Must be number (was " + JSONSchema.Companion.toErrorDisplay(value) + ')', uri, pointer);
            throw new KotlinNothingValueException();
        }
        JSONNumberValue jSONNumberValue = (JSONNumberValue)value;
        if ((jSONNumberValue instanceof JSONDouble ? true : jSONNumberValue instanceof JSONFloat) ? true : jSONNumberValue instanceof JSONDecimal) {
            BigDecimal bigDecimal = ((JSONNumberValue)value).bigDecimalValue();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.bigDecimalValue()");
            number2 = bigDecimal;
        } else {
            number2 = number = jSONNumberValue instanceof JSONLong ? (Number)((JSONNumberValue)value).longValue() : (Number)((JSONNumberValue)value).intValue();
        }
        if (condition == NumberValidator.ValidationType.MULTIPLE_OF && !Companion.isPositive(number)) {
            Parser.Companion.fatal("multipleOf must be greater than 0", uri, pointer);
            throw new KotlinNothingValueException();
        }
        return new NumberValidator(uri, pointer, number, condition);
    }

    private final StringValidator parseStringLength(JSONPointer pointer, URI uri, StringValidator.ValidationType condition, JSONValue value) {
        return new StringValidator(uri, pointer, condition, Companion.getInteger(value, uri, pointer));
    }

    private final ArrayValidator parseArrayNumberOfItems(JSONPointer pointer, URI uri, ArrayValidator.ValidationType condition, JSONValue value) {
        return new ArrayValidator(uri, pointer, condition, Companion.getInteger(value, uri, pointer));
    }

    private final UniqueItemsValidator parseArrayUniqueItems(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONBoolean)) {
            Parser.Companion.fatal("Must be boolean", uri, pointer);
            throw new KotlinNothingValueException();
        }
        return ((JSONBoolean)value).booleanValue() ? new UniqueItemsValidator(uri, pointer) : null;
    }

    private final PatternValidator parsePattern(JSONPointer pointer, URI uri, JSONValue value) {
        Regex regex;
        if (!(value instanceof JSONString)) {
            Parser.Companion.fatal("Must be string", uri, pointer);
            throw new KotlinNothingValueException();
        }
        try {
            String string = ((JSONString)value).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.value");
            regex = new Regex(string);
        }
        catch (Exception e) {
            String string;
            block7: {
                block6: {
                    string = e.getMessage();
                    if (string == null) break block6;
                    String it = string;
                    boolean bl = false;
                    String string2 = "- " + ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)it, (char)'\n', null, (int)2, null))).toString();
                    string = string2;
                    if (string2 != null) break block7;
                }
                string = "";
            }
            String msg = string;
            Parser.Companion.fatal("Pattern invalid " + msg + " (" + JSONSchema.Companion.toErrorDisplay(value) + ')', uri, pointer);
            throw new KotlinNothingValueException();
        }
        Regex regex2 = regex;
        return new PatternValidator(uri, pointer, regex2);
    }

    private final JSONSchema parseDraft07(JSONValue json, JSONPointer pointer, URI parentUri) {
        return this.parseSchema(json, pointer, parentUri);
    }

    public Parser() {
        this(null, null, 3, null);
    }

    static {
        Object[] objectArray = new String[]{"http://json-schema.org/draft/2020-12/schema", "https://json-schema.org/draft/2020-12/schema"};
        schemaVersion202012 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"http://json-schema.org/draft/2019-09/schema", "https://json-schema.org/draft/2019-09/schema"};
        schemaVersion201909 = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"http://json-schema.org/draft-07/schema", "https://json-schema.org/draft-07/schema"};
        schemaVersionDraft07 = CollectionsKt.listOf((Object[])objectArray);
        defaultURIResolver = Companion.defaultURIResolver.1.INSTANCE;
        defaultExtendedResolver = Companion.defaultExtendedResolver.1.INSTANCE;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\"\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019J \u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020\u001f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\n\u0010%\u001a\u00020\u0005*\u00020\u0005J>\u0010&\u001a\u0004\u0018\u0001H'\"\u0004\b\u0000\u0010'*\b\u0012\u0004\u0012\u0002H'0\r2\b\b\u0002\u0010(\u001a\u00020!2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u0002H'\u0012\u0004\u0012\u00020*0\u0004H\u0082\b\u00a2\u0006\u0002\u0010+J\"\u0010,\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030-2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010.\u001a\u0004\u0018\u00010\u000eJ\"\u0010/\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030-2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u00100\u001a\u00020\u000eJ\"\u0010/\u001a\u0004\u0018\u00010\u000e*\u0006\u0012\u0002\b\u00030-2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u0019J\n\u00101\u001a\u00020**\u000202J\n\u00103\u001a\u00020**\u000202J\f\u00104\u001a\u00020\u000e*\u00020\u0019H\u0002J\u0014\u00105\u001a\u00020\u0005*\u00020\u00052\u0006\u00106\u001a\u00020\u000eH\u0002J\u0012\u00105\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001f\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\u0002\u001a\u0004\b\u0013\u0010\u0010R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010\u00a8\u00067"}, d2={"Lnet/pwall/json/schema/parser/Parser$Companion;", "", "()V", "defaultExtendedResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Lnet/pwall/json/schema/parser/InputDetails;", "getDefaultExtendedResolver", "()Lkotlin/jvm/functions/Function1;", "defaultURIResolver", "Ljava/io/InputStream;", "getDefaultURIResolver", "schemaVersion201909", "", "", "getSchemaVersion201909", "()Ljava/util/List;", "schemaVersion202012", "getSchemaVersion202012$annotations", "getSchemaVersion202012", "schemaVersionDraft07", "getSchemaVersionDraft07", "errorPointer", "uri", "pointer", "Lnet/pwall/json/pointer/JSONPointer;", "fatal", "", "message", "getIdOrNull", "jsonValue", "Lnet/pwall/json/JSONValue;", "getInteger", "", "value", "getNonNegativeInteger", "json", "dropFragment", "findStartingFrom", "T", "index", "predicate", "", "(Ljava/util/List;ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "getStringOrDefault", "Lnet/pwall/json/JSONMapping;", "default", "getStringOrNull", "key", "isPositive", "", "isZero", "pointerOrRoot", "withFragment", "newFragment", "json-kotlin-schema"})
    @SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\nnet/pwall/json/schema/parser/Parser$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,589:1\n1#2:590\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getSchemaVersion202012() {
            return schemaVersion202012;
        }

        public static /* synthetic */ void getSchemaVersion202012$annotations() {
        }

        @NotNull
        public final List<String> getSchemaVersion201909() {
            return schemaVersion201909;
        }

        @NotNull
        public final List<String> getSchemaVersionDraft07() {
            return schemaVersionDraft07;
        }

        @NotNull
        public final Function1<URI, InputStream> getDefaultURIResolver() {
            return defaultURIResolver;
        }

        @NotNull
        public final Function1<URI, InputDetails> getDefaultExtendedResolver() {
            return defaultExtendedResolver;
        }

        private final <T> T findStartingFrom(List<? extends T> $this$findStartingFrom, int index, Function1<? super T, Boolean> predicate) {
            boolean $i$f$findStartingFrom = false;
            int n = $this$findStartingFrom.size();
            for (int i = index; i < n; ++i) {
                T it = $this$findStartingFrom.get(i);
                boolean bl = false;
                if (!((Boolean)predicate.invoke(it)).booleanValue()) continue;
                return it;
            }
            return null;
        }

        static /* synthetic */ Object findStartingFrom$default(Companion $this, List $receiver, int index, Function1 predicate, int n, Object object) {
            if ((n & 1) != 0) {
                index = 0;
            }
            boolean $i$f$findStartingFrom = false;
            int n2 = $receiver.size();
            for (int i = index; i < n2; ++i) {
                Object it = $receiver.get(i);
                boolean bl = false;
                if (!((Boolean)predicate.invoke(it)).booleanValue()) continue;
                return it;
            }
            return null;
        }

        @NotNull
        public final URI dropFragment(@NotNull URI $this$dropFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$dropFragment, (String)"<this>");
            return $this$dropFragment.getFragment() == null ? $this$dropFragment : ($this$dropFragment.isOpaque() ? new URI($this$dropFragment.getScheme(), $this$dropFragment.getSchemeSpecificPart(), null) : new URI($this$dropFragment.getScheme(), $this$dropFragment.getAuthority(), $this$dropFragment.getPath(), $this$dropFragment.getQuery(), null));
        }

        private final URI withFragment(URI $this$withFragment, String newFragment) {
            return $this$withFragment.isOpaque() ? new URI($this$withFragment.getScheme(), $this$withFragment.getSchemeSpecificPart(), newFragment) : new URI($this$withFragment.getScheme(), $this$withFragment.getAuthority(), $this$withFragment.getPath(), $this$withFragment.getQuery(), newFragment);
        }

        @NotNull
        public final URI withFragment(@NotNull URI $this$withFragment, @NotNull JSONPointer pointer) {
            URI uRI;
            Intrinsics.checkNotNullParameter((Object)$this$withFragment, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (Intrinsics.areEqual((Object)pointer, (Object)JSONPointer.root)) {
                uRI = this.dropFragment($this$withFragment);
            } else {
                String string = pointer.toURIFragment();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pointer.toURIFragment()");
                String string2 = string;
                int n = 1;
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                uRI = this.withFragment($this$withFragment, string3);
            }
            return uRI;
        }

        private final Void fatal(String message, URI uri, JSONPointer pointer) {
            throw new JSONSchemaException(message + " - " + this.errorPointer(uri, pointer));
        }

        private final String errorPointer(URI uri, JSONPointer pointer) {
            String string;
            URI uRI = uri;
            if ((uRI != null && (uRI = this.withFragment(uRI, pointer)) != null ? uRI.toString() : (string = null)) == null) {
                string = this.pointerOrRoot(pointer);
            }
            return string;
        }

        private final String pointerOrRoot(JSONPointer $this$pointerOrRoot) {
            String string;
            if (Intrinsics.areEqual((Object)$this$pointerOrRoot, (Object)JSONPointer.root)) {
                string = "root";
            } else {
                String string2 = $this$pointerOrRoot.toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
            }
            return string;
        }

        public final int getInteger(@Nullable JSONValue value, @Nullable URI uri, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (value instanceof JSONZero) {
                return 0;
            }
            if (value instanceof JSONInteger) {
                return ((JSONInteger)value).getValue();
            }
            this.fatal("Must be integer", uri, pointer);
            throw new KotlinNothingValueException();
        }

        public final int getNonNegativeInteger(@NotNull JSONValue json, @Nullable URI uri, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            JSONValue value = pointer.find(json);
            if (value instanceof JSONZero) {
                return 0;
            }
            if (value instanceof JSONInteger && ((JSONInteger)value).getValue() >= 0) {
                return ((JSONInteger)value).getValue();
            }
            this.fatal("Must be non-negative integer", uri, pointer);
            throw new KotlinNothingValueException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String getStringOrNull(@NotNull JSONMapping<?> $this$getStringOrNull, @Nullable URI uri, @NotNull String key) {
            Intrinsics.checkNotNullParameter($this$getStringOrNull, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            JSONValue jSONValue = (JSONValue)$this$getStringOrNull.get((Object)key);
            if (jSONValue == null) return null;
            JSONValue it = jSONValue;
            boolean bl = false;
            if (!(it instanceof JSONString)) {
                JSONPointer jSONPointer = JSONPointer.root.child(key);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"root.child(key)");
                Companion.fatal("Must be string", uri, jSONPointer);
                throw new KotlinNothingValueException();
            }
            String string = ((JSONString)it).getValue();
            return string;
        }

        @Nullable
        public final String getStringOrNull(@NotNull JSONMapping<?> $this$getStringOrNull, @Nullable URI uri, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter($this$getStringOrNull, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (!pointer.exists((JSONValue)$this$getStringOrNull)) {
                return null;
            }
            JSONValue value = pointer.eval((JSONValue)$this$getStringOrNull);
            if (!(value instanceof JSONString)) {
                this.fatal("Must be string", uri, pointer);
                throw new KotlinNothingValueException();
            }
            return ((JSONString)value).getValue();
        }

        @Nullable
        public final String getStringOrDefault(@NotNull JSONMapping<?> $this$getStringOrDefault, @NotNull JSONPointer pointer, @Nullable String string) {
            Intrinsics.checkNotNullParameter($this$getStringOrDefault, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (!pointer.exists((JSONValue)$this$getStringOrDefault)) {
                return string;
            }
            JSONValue value = pointer.eval((JSONValue)$this$getStringOrDefault);
            if (!(value instanceof JSONString)) {
                throw new JSONSchemaException("Incorrect " + pointer);
            }
            return ((JSONString)value).getValue();
        }

        public final boolean isZero(@NotNull Number $this$isZero) {
            Intrinsics.checkNotNullParameter((Object)$this$isZero, (String)"<this>");
            Number number = $this$isZero;
            return number instanceof BigDecimal ? ((BigDecimal)$this$isZero).compareTo(BigDecimal.ZERO) == 0 : (number instanceof BigInteger ? Intrinsics.areEqual((Object)$this$isZero, (Object)BigInteger.ZERO) : (number instanceof Double ? $this$isZero.doubleValue() == 0.0 : (number instanceof Float ? $this$isZero.floatValue() == 0.0f : (number instanceof Long ? Intrinsics.areEqual((Object)$this$isZero, (Object)0L) : $this$isZero.intValue() == 0))));
        }

        public final boolean isPositive(@NotNull Number $this$isPositive) {
            Intrinsics.checkNotNullParameter((Object)$this$isPositive, (String)"<this>");
            Number number = $this$isPositive;
            return number instanceof BigDecimal ? ((BigDecimal)$this$isPositive).compareTo(BigDecimal.ZERO) > 0 : (number instanceof BigInteger ? ((BigInteger)$this$isPositive).compareTo(BigInteger.ZERO) > 0 : (number instanceof Double ? $this$isPositive.doubleValue() > 0.0 : (number instanceof Float ? $this$isPositive.floatValue() > 0.0f : (number instanceof Long ? $this$isPositive.longValue() > 0L : $this$isPositive.intValue() > 0))));
        }

        @Nullable
        public final String getIdOrNull(@NotNull JSONValue jsonValue) {
            Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
            JSONMapping jSONMapping = jsonValue instanceof JSONMapping ? (JSONMapping)jsonValue : null;
            JSONValue jSONValue = jSONMapping != null ? (JSONValue)jSONMapping.get((Object)"$id") : null;
            JSONString jSONString = jSONValue instanceof JSONString ? (JSONString)jSONValue : null;
            return jSONString != null ? jSONString.getValue() : null;
        }

        public static final /* synthetic */ String access$errorPointer(Companion $this, URI uri, JSONPointer pointer) {
            return $this.errorPointer(uri, pointer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lnet/pwall/json/schema/parser/Parser$Options;", "", "allowDescriptionRef", "", "(Z)V", "getAllowDescriptionRef", "()Z", "setAllowDescriptionRef", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "json-kotlin-schema"})
    public static final class Options {
        private boolean allowDescriptionRef;

        public Options(boolean allowDescriptionRef) {
            this.allowDescriptionRef = allowDescriptionRef;
        }

        public /* synthetic */ Options(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getAllowDescriptionRef() {
            return this.allowDescriptionRef;
        }

        public final void setAllowDescriptionRef(boolean bl) {
            this.allowDescriptionRef = bl;
        }

        public final boolean component1() {
            return this.allowDescriptionRef;
        }

        @NotNull
        public final Options copy(boolean allowDescriptionRef) {
            return new Options(allowDescriptionRef);
        }

        public static /* synthetic */ Options copy$default(Options options, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = options.allowDescriptionRef;
            }
            return options.copy(bl);
        }

        @NotNull
        public String toString() {
            return "Options(allowDescriptionRef=" + this.allowDescriptionRef + ')';
        }

        public int hashCode() {
            int n = this.allowDescriptionRef ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Options)) {
                return false;
            }
            Options options = (Options)other;
            return this.allowDescriptionRef == options.allowDescriptionRef;
        }

        public Options() {
            this(false, 1, null);
        }
    }
}

