/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import java.net.URI;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicErrorEntry;
import net.pwall.pipeline.IntAcceptor;
import net.pwall.pipeline.IntCounter;
import net.pwall.pipeline.codec.UTF16_CodePoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0002 !B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001a\u0010\u001f\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lnet/pwall/json/schema/validation/StringValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "condition", "Lnet/pwall/json/schema/validation/StringValidator$ValidationType;", "value", "", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Lnet/pwall/json/schema/validation/StringValidator$ValidationType;I)V", "getCondition", "()Lnet/pwall/json/schema/validation/StringValidator$ValidationType;", "getValue", "()I", "childLocation", "pointer", "equals", "", "other", "", "getErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "relativeLocation", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "hashCode", "validLength", "instance", "Lnet/pwall/json/JSONString;", "validate", "Companion", "ValidationType", "json-kotlin-schema"})
public final class StringValidator
extends JSONSchema.Validator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ValidationType condition;
    private final int value;

    public StringValidator(@Nullable URI uri, @NotNull JSONPointer location, @NotNull ValidationType condition, int value) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)((Object)condition), (String)"condition");
        super(uri, location);
        this.condition = condition;
        this.value = value;
    }

    @NotNull
    public final ValidationType getCondition() {
        return this.condition;
    }

    public final int getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        JSONPointer jSONPointer = pointer.child(this.condition.getKeyword());
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(condition.keyword)");
        return jSONPointer;
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        return !(instance instanceof JSONString) || this.validLength((JSONString)instance);
    }

    @Override
    @Nullable
    public BasicErrorEntry getErrorEntry(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        return !(instance instanceof JSONString) || this.validLength((JSONString)instance) ? null : this.createBasicErrorEntry(relativeLocation, instanceLocation, "String fails length check: " + this.condition.getKeyword() + ' ' + this.value + ", was " + Companion.unicodeLength((JSONString)instance));
    }

    private final boolean validLength(JSONString instance) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.condition.ordinal()]) {
            case 1: {
                if (Companion.unicodeLength(instance) <= this.value) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                if (Companion.unicodeLength(instance) >= this.value) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof StringValidator && super.equals(other) && this.condition == ((StringValidator)other).condition && this.value == ((StringValidator)other).value;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.condition.hashCode() ^ this.value;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lnet/pwall/json/schema/validation/StringValidator$ValidationType;", "", "keyword", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getKeyword", "()Ljava/lang/String;", "MAX_LENGTH", "MIN_LENGTH", "json-kotlin-schema"})
    public static final class ValidationType
    extends Enum<ValidationType> {
        @NotNull
        private final String keyword;
        public static final /* enum */ ValidationType MAX_LENGTH = new ValidationType("maxLength");
        public static final /* enum */ ValidationType MIN_LENGTH = new ValidationType("minLength");
        private static final /* synthetic */ ValidationType[] $VALUES;

        private ValidationType(String keyword) {
            this.keyword = keyword;
        }

        @NotNull
        public final String getKeyword() {
            return this.keyword;
        }

        public static ValidationType[] values() {
            return (ValidationType[])$VALUES.clone();
        }

        public static ValidationType valueOf(String value) {
            return Enum.valueOf(ValidationType.class, value);
        }

        static {
            $VALUES = validationTypeArray = new ValidationType[]{ValidationType.MAX_LENGTH, ValidationType.MIN_LENGTH};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lnet/pwall/json/schema/validation/StringValidator$Companion;", "", "()V", "unicodeLength", "", "Lnet/pwall/json/JSONString;", "json-kotlin-schema"})
    public static final class Companion {
        private Companion() {
        }

        public final int unicodeLength(@NotNull JSONString $this$unicodeLength) {
            UTF16_CodePoint uTF16_CodePoint;
            Intrinsics.checkNotNullParameter((Object)$this$unicodeLength, (String)"<this>");
            UTF16_CodePoint $this$unicodeLength_u24lambda_u240 = uTF16_CodePoint = new UTF16_CodePoint((IntAcceptor)new IntCounter());
            boolean bl = false;
            $this$unicodeLength_u24lambda_u240.accept((CharSequence)$this$unicodeLength.getValue());
            Object object = uTF16_CodePoint.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UTF16_CodePoint(IntCount\u2026 { accept(value) }.result");
            return ((Number)object).intValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ValidationType.values().length];
            try {
                nArray[ValidationType.MAX_LENGTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ValidationType.MIN_LENGTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

