/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONSequence;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicErrorEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J$\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\u001a\u0010\u001a\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001b"}, d2={"Lnet/pwall/json/schema/validation/ContainsValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "containsSchema", "Lnet/pwall/json/schema/JSONSchema;", "minContains", "", "maxContains", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Lnet/pwall/json/schema/JSONSchema;Ljava/lang/Integer;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "childLocation", "pointer", "equals", "", "other", "", "getErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "relativeLocation", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "hashCode", "validate", "json-kotlin-schema"})
public final class ContainsValidator
extends JSONSchema.Validator {
    @NotNull
    private final JSONSchema containsSchema;
    @Nullable
    private final Integer minContains;
    @Nullable
    private final Integer maxContains;

    public ContainsValidator(@Nullable URI uri, @NotNull JSONPointer location, @NotNull JSONSchema containsSchema, @Nullable Integer minContains, @Nullable Integer maxContains) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)containsSchema, (String)"containsSchema");
        super(uri, location);
        this.containsSchema = containsSchema;
        this.minContains = minContains;
        this.maxContains = maxContains;
    }

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        JSONPointer jSONPointer = pointer.child("contains");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(\"contains\")");
        return jSONPointer;
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        int it;
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONSequence)) {
            return true;
        }
        int count = 0;
        int n = ((JSONSequence)instance).size();
        for (int i = 0; i < n; ++i) {
            JSONPointer jSONPointer = instanceLocation.child(i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"instanceLocation.child(i)");
            if (!this.containsSchema.validate(json, jSONPointer)) continue;
            int n2 = count;
            count = n2 + 1;
        }
        if (this.minContains == null && count == 0) {
            return false;
        }
        Integer n3 = this.minContains;
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl = false;
            if (count < it) {
                return false;
            }
        }
        Integer n4 = this.maxContains;
        if (n4 != null) {
            it = ((Number)n4).intValue();
            boolean bl = false;
            if (count > it) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public BasicErrorEntry getErrorEntry(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        int it;
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONSequence)) {
            return null;
        }
        int count = 0;
        int n = ((JSONSequence)instance).size();
        for (int i = 0; i < n; ++i) {
            JSONPointer jSONPointer = instanceLocation.child(i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"instanceLocation.child(i)");
            if (!this.containsSchema.validate(json, jSONPointer)) continue;
            int n2 = count;
            count = n2 + 1;
        }
        if (this.minContains == null && count == 0) {
            return this.createBasicErrorEntry(relativeLocation, instanceLocation, "No matching entry");
        }
        Integer n3 = this.minContains;
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl = false;
            if (count < it) {
                String string;
                JSONPointer jSONPointer = relativeLocation.parent().child("minContains");
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"relativeLocation.parent().child(\"minContains\")");
                String string2 = JSONSchema.Companion.schemaURIFragment(jSONPointer);
                URI uRI = this.getUri();
                if (uRI != null) {
                    void x;
                    URI uRI2 = uRI;
                    String string3 = string2;
                    boolean bl2 = false;
                    StringBuilder stringBuilder = new StringBuilder().append(x);
                    JSONPointer jSONPointer2 = this.getLocation().parent().child("minContains");
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"location.parent().child(\"minContains\")");
                    string = stringBuilder.append(JSONSchema.Companion.schemaURIFragment(jSONPointer2)).toString();
                    string2 = string3;
                } else {
                    string = null;
                }
                String string4 = "Matching entry minimum " + it + ", was " + count;
                String string5 = JSONSchema.Companion.schemaURIFragment(instanceLocation);
                String string6 = string;
                String string7 = string2;
                return new BasicErrorEntry(string7, string6, string5, string4);
            }
        }
        Integer n4 = this.maxContains;
        if (n4 != null) {
            it = ((Number)n4).intValue();
            boolean bl = false;
            if (count > it) {
                String string;
                JSONPointer jSONPointer = relativeLocation.parent().child("maxContains");
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"relativeLocation.parent().child(\"maxContains\")");
                String string8 = JSONSchema.Companion.schemaURIFragment(jSONPointer);
                URI uRI = this.getUri();
                if (uRI != null) {
                    URI x = uRI;
                    String string9 = string8;
                    boolean bl3 = false;
                    StringBuilder stringBuilder = new StringBuilder().append(x);
                    JSONPointer jSONPointer3 = this.getLocation().parent().child("maxContains");
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer3, (String)"location.parent().child(\"maxContains\")");
                    string = stringBuilder.append(JSONSchema.Companion.schemaURIFragment(jSONPointer3)).toString();
                    string8 = string9;
                } else {
                    string = null;
                }
                String string10 = "Matching entry maximum " + it + ", was " + count;
                String string11 = JSONSchema.Companion.schemaURIFragment(instanceLocation);
                String string12 = string;
                String string13 = string8;
                return new BasicErrorEntry(string13, string12, string11, string10);
            }
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof ContainsValidator && super.equals(other) && Intrinsics.areEqual((Object)this.containsSchema, (Object)((ContainsValidator)other).containsSchema) && Intrinsics.areEqual((Object)this.minContains, (Object)((ContainsValidator)other).minContains) && Intrinsics.areEqual((Object)this.maxContains, (Object)((ContainsValidator)other).maxContains);
    }

    @Override
    public int hashCode() {
        Integer n = this.minContains;
        Integer n2 = this.maxContains;
        return super.hashCode() ^ this.containsSchema.hashCode() ^ (n != null ? ((Object)n).hashCode() : 0) ^ (n2 != null ? ((Object)n2).hashCode() : 0);
    }
}

