/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONArray;
import net.pwall.json.JSONBoolean;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONNumberValue;
import net.pwall.json.JSONObject;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.JSONZero;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicErrorEntry;
import net.pwall.json.schema.validation.TypeValidator;
import net.pwall.json.schema.validation.TypeValidator$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J$\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\"\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lnet/pwall/json/schema/validation/TypeValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "types", "", "Lnet/pwall/json/schema/JSONSchema$Type;", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Ljava/util/List;)V", "getTypes", "()Ljava/util/List;", "childLocation", "pointer", "equals", "", "other", "", "getErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "relativeLocation", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "hashCode", "", "validate", "json-kotlin-schema"})
public final class TypeValidator
extends JSONSchema.Validator {
    @NotNull
    private final List<JSONSchema.Type> types;

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkParameterIsNotNull((Object)pointer, (String)"pointer");
        return pointer.child("type");
    }

    @Override
    public boolean validate(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkParameterIsNotNull((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        for (JSONSchema.Type type : this.types) {
            switch (TypeValidator$WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (instance != null) break;
                    return true;
                }
                case 2: {
                    if (!(instance instanceof JSONBoolean)) break;
                    return true;
                }
                case 3: {
                    if (!(instance instanceof JSONObject)) break;
                    return true;
                }
                case 4: {
                    if (!(instance instanceof JSONArray)) break;
                    return true;
                }
                case 5: {
                    if (!(instance instanceof JSONNumberValue)) break;
                    return true;
                }
                case 6: {
                    if (!(instance instanceof JSONString)) break;
                    return true;
                }
                case 7: {
                    if (!(instance instanceof JSONInteger) && !(instance instanceof JSONLong) && !(instance instanceof JSONZero)) break;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    @Nullable
    public BasicErrorEntry getErrorEntry(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkParameterIsNotNull((Object)instanceLocation, (String)"instanceLocation");
        return this.validate(relativeLocation, json, instanceLocation) ? null : this.createBasicErrorEntry(relativeLocation, instanceLocation, "Incorrect type, expected " + CollectionsKt.joinToString$default((Iterable)this.types, (CharSequence)" or ", null, null, (int)0, null, (Function1)getErrorEntry.1.INSTANCE, (int)30, null));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TypeValidator && super.equals(other) && Intrinsics.areEqual(this.types, ((TypeValidator)other).types);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.types).hashCode();
    }

    @NotNull
    public final List<JSONSchema.Type> getTypes() {
        return this.types;
    }

    public TypeValidator(@Nullable URI uri, @NotNull JSONPointer location, @NotNull List<? extends JSONSchema.Type> types) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull(types, (String)"types");
        super(uri, location);
        this.types = types;
    }
}

