/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicErrorEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J$\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\"\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lnet/pwall/json/schema/validation/PatternValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "regex", "Lkotlin/text/Regex;", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Lkotlin/text/Regex;)V", "getRegex", "()Lkotlin/text/Regex;", "childLocation", "pointer", "equals", "", "other", "", "getErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "relativeLocation", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "hashCode", "", "validate", "json-kotlin-schema"})
public final class PatternValidator
extends JSONSchema.Validator {
    @NotNull
    private final Regex regex;

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkParameterIsNotNull((Object)pointer, (String)"pointer");
        return pointer.child("pattern");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validate(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkParameterIsNotNull((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONString)) return true;
        String string = ((JSONString)instance).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"instance.get()");
        CharSequence charSequence = string;
        Regex regex = this.regex;
        boolean bl = false;
        if (!regex.matches(charSequence)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public BasicErrorEntry getErrorEntry(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkParameterIsNotNull((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkParameterIsNotNull((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONString)) return null;
        String string = ((JSONString)instance).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"instance.get()");
        CharSequence charSequence = string;
        Regex regex = this.regex;
        boolean bl = false;
        if (regex.matches(charSequence)) {
            return null;
        }
        BasicErrorEntry basicErrorEntry = this.createBasicErrorEntry(relativeLocation, instanceLocation, "String doesn't match pattern " + this.regex + " - " + JSONSchema.Companion.toErrorDisplay(instance));
        return basicErrorEntry;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof PatternValidator && super.equals(other) && Intrinsics.areEqual((Object)this.regex, (Object)((PatternValidator)other).regex);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.regex.hashCode();
    }

    @NotNull
    public final Regex getRegex() {
        return this.regex;
    }

    public PatternValidator(@Nullable URI uri, @NotNull JSONPointer location, @NotNull Regex regex) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)regex, (String)"regex");
        super(uri, location);
        this.regex = regex;
    }
}

