/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONBoolean;
import net.pwall.json.JSONDecimal;
import net.pwall.json.JSONDouble;
import net.pwall.json.JSONFloat;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONMapping;
import net.pwall.json.JSONNumberValue;
import net.pwall.json.JSONSequence;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.JSONZero;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.BasicErrorEntry;
import net.pwall.json.schema.validation.TypeValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J$\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010\u001c\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lnet/pwall/json/schema/validation/TypeValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "types", "", "Lnet/pwall/json/schema/JSONSchema$Type;", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Ljava/util/List;)V", "getTypes", "()Ljava/util/List;", "childLocation", "pointer", "equals", "", "other", "", "getErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "relativeLocation", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "hashCode", "", "isInteger", "instance", "validate", "json-kotlin-schema"})
public final class TypeValidator
extends JSONSchema.Validator {
    @NotNull
    private final List<JSONSchema.Type> types;

    public TypeValidator(@Nullable URI uri, @NotNull JSONPointer location, @NotNull List<? extends JSONSchema.Type> types) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        super(uri, location);
        this.types = types;
    }

    @NotNull
    public final List<JSONSchema.Type> getTypes() {
        return this.types;
    }

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        JSONPointer jSONPointer = pointer.child("type");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(\"type\")");
        return jSONPointer;
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        block9: for (JSONSchema.Type type : this.types) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (instance != null) continue block9;
                    return true;
                }
                case 2: {
                    if (!(instance instanceof JSONBoolean)) continue block9;
                    return true;
                }
                case 3: {
                    if (!(instance instanceof JSONMapping)) continue block9;
                    return true;
                }
                case 4: {
                    if (!(instance instanceof JSONSequence)) continue block9;
                    return true;
                }
                case 5: {
                    if (!(instance instanceof JSONNumberValue)) continue block9;
                    return true;
                }
                case 6: {
                    if (!(instance instanceof JSONString)) continue block9;
                    return true;
                }
                case 7: {
                    if (!this.isInteger(instance)) continue block9;
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean isInteger(JSONValue instance) {
        boolean bl;
        JSONValue jSONValue = instance;
        if (jSONValue instanceof JSONInteger) {
            bl = true;
        } else if (jSONValue instanceof JSONLong) {
            bl = true;
        } else if (jSONValue instanceof JSONZero) {
            bl = true;
        } else if (jSONValue instanceof JSONDecimal) {
            BigDecimal bigDecimal = ((JSONDecimal)instance).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"instance.value");
            BigDecimal value = bigDecimal;
            bl = value.scale() <= 0 || value.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) == 0;
        } else {
            double value;
            bl = jSONValue instanceof JSONDouble ? (value = ((JSONDouble)instance).getValue()) % 1.0 == 0.0 : (jSONValue instanceof JSONFloat ? (value = ((JSONFloat)instance).getValue()) % 1.0f == 0.0f : false);
        }
        return bl;
    }

    @Override
    @Nullable
    public BasicErrorEntry getErrorEntry(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        return this.validate(json, instanceLocation) ? null : this.createBasicErrorEntry(relativeLocation, instanceLocation, Intrinsics.stringPlus((String)"Incorrect type, expected ", (Object)CollectionsKt.joinToString$default((Iterable)this.types, (CharSequence)" or ", null, null, (int)0, null, (Function1)getErrorEntry.1.INSTANCE, (int)30, null)));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof TypeValidator && super.equals(other) && Intrinsics.areEqual(this.types, ((TypeValidator)other).types);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ ((Object)this.types).hashCode();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JSONSchema.Type.values().length];
            nArray[JSONSchema.Type.NULL.ordinal()] = 1;
            nArray[JSONSchema.Type.BOOLEAN.ordinal()] = 2;
            nArray[JSONSchema.Type.OBJECT.ordinal()] = 3;
            nArray[JSONSchema.Type.ARRAY.ordinal()] = 4;
            nArray[JSONSchema.Type.NUMBER.ordinal()] = 5;
            nArray[JSONSchema.Type.STRING.ordinal()] = 6;
            nArray[JSONSchema.Type.INTEGER.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

