/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONDecimal;
import net.pwall.json.JSONDouble;
import net.pwall.json.JSONFloat;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONNumberValue;
import net.pwall.json.JSONValue;
import net.pwall.json.JSONZero;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.output.BasicErrorEntry;
import net.pwall.json.schema.validation.NumberValidator$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0002()B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\"\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001a\u0010%\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\f\u0010&\u001a\u00020'*\u00020\u0007H\u0002J\f\u0010&\u001a\u00020'*\u00020\u0017H\u0002R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lnet/pwall/json/schema/validation/NumberValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "value", "", "condition", "Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Ljava/lang/Number;Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;)V", "getCondition", "()Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "getValue", "()Ljava/lang/Number;", "childLocation", "pointer", "equals", "", "other", "", "exclusiveMaximum", "instance", "Lnet/pwall/json/JSONNumberValue;", "exclusiveMinimum", "getErrorEntry", "Lnet/pwall/json/schema/output/BasicErrorEntry;", "relativeLocation", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "hashCode", "", "maximum", "minimum", "multipleOf", "validNumber", "validate", "toBigDecimal", "Ljava/math/BigDecimal;", "Companion", "ValidationType", "json-kotlin-schema"})
public final class NumberValidator
extends JSONSchema.Validator {
    @NotNull
    private final Number value;
    @NotNull
    private final ValidationType condition;
    @NotNull
    private static final List<String> typeKeywords;
    public static final Companion Companion;

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        JSONPointer jSONPointer = pointer.child(this.condition.getKeyword());
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(condition.keyword)");
        return jSONPointer;
    }

    @Override
    public boolean validate(@Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        return !(instance instanceof JSONNumberValue) || this.validNumber((JSONNumberValue)instance);
    }

    @Override
    @Nullable
    public BasicErrorEntry getErrorEntry(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        Intrinsics.checkNotNullParameter((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkNotNullParameter((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        return !(instance instanceof JSONNumberValue) || this.validNumber((JSONNumberValue)instance) ? null : this.createBasicErrorEntry(relativeLocation, instanceLocation, "Number fails check: " + this.condition.getKeyword() + ' ' + this.value + ", was " + instance);
    }

    private final boolean validNumber(JSONNumberValue instance) {
        boolean bl;
        switch (NumberValidator$WhenMappings.$EnumSwitchMapping$0[this.condition.ordinal()]) {
            case 1: {
                bl = this.multipleOf(instance);
                break;
            }
            case 2: {
                bl = this.maximum(instance);
                break;
            }
            case 3: {
                bl = this.exclusiveMaximum(instance);
                break;
            }
            case 4: {
                bl = this.minimum(instance);
                break;
            }
            case 5: {
                bl = this.exclusiveMinimum(instance);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean multipleOf(JSONNumberValue instance) {
        Number number = this.value;
        if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = this.toBigDecimal(instance);
            BigDecimal bigDecimal2 = (BigDecimal)this.value;
            boolean bl = false;
            BigDecimal bigDecimal3 = bigDecimal.remainder(bigDecimal2);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.remainder(other)");
            if (bigDecimal3.compareTo(BigDecimal.ZERO) != 0) return false;
            return true;
        }
        if (number instanceof Double) {
            if (instance.doubleValue() % this.value.doubleValue() != 0.0) return false;
            return true;
        }
        if (number instanceof Float) {
            if (instance.floatValue() % this.value.floatValue() != 0.0f) return false;
            return true;
        }
        if (number instanceof Long) {
            JSONNumberValue jSONNumberValue = instance;
            if (jSONNumberValue instanceof JSONDecimal) {
                BigDecimal bigDecimal = ((JSONDecimal)instance).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"instance.value");
                BigDecimal bigDecimal4 = bigDecimal;
                BigDecimal bigDecimal5 = new BigDecimal(this.value.longValue());
                boolean bl = false;
                BigDecimal bigDecimal6 = bigDecimal4.remainder(bigDecimal5);
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal6, (String)"this.remainder(other)");
                if (bigDecimal6.compareTo(BigDecimal.ZERO) != 0) return false;
                return true;
            }
            if (jSONNumberValue instanceof JSONDouble) {
                if (((JSONDouble)instance).getValue() % this.value.doubleValue() != 0.0) return false;
                return true;
            }
            if (jSONNumberValue instanceof JSONFloat) {
                if (((JSONFloat)instance).getValue() % this.value.floatValue() != 0.0f) return false;
                return true;
            }
            if (jSONNumberValue instanceof JSONLong) {
                if (((JSONLong)instance).getValue() % this.value.longValue() != 0L) return false;
                return true;
            }
            if (jSONNumberValue instanceof JSONInteger) {
                if (instance.longValue() % this.value.longValue() != 0L) return false;
                return true;
            }
            if (!(jSONNumberValue instanceof JSONZero)) throw (Throwable)((Object)new JSONSchemaException("Impossible type"));
            return true;
        }
        if (!(number instanceof Integer)) throw (Throwable)((Object)new JSONSchemaException("Impossible type"));
        JSONNumberValue jSONNumberValue = instance;
        if (jSONNumberValue instanceof JSONDecimal) {
            BigDecimal bigDecimal = ((JSONDecimal)instance).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"instance.value");
            BigDecimal bigDecimal7 = bigDecimal;
            BigDecimal bigDecimal8 = new BigDecimal(this.value.intValue());
            boolean bl = false;
            BigDecimal bigDecimal9 = bigDecimal7.remainder(bigDecimal8);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal9, (String)"this.remainder(other)");
            if (bigDecimal9.compareTo(BigDecimal.ZERO) != 0) return false;
            return true;
        }
        if (jSONNumberValue instanceof JSONDouble) {
            if (((JSONDouble)instance).getValue() % this.value.doubleValue() != 0.0) return false;
            return true;
        }
        if (jSONNumberValue instanceof JSONFloat) {
            if (((JSONFloat)instance).getValue() % this.value.floatValue() != 0.0f) return false;
            return true;
        }
        if (jSONNumberValue instanceof JSONLong) {
            if (((JSONLong)instance).getValue() % this.value.longValue() != 0L) return false;
            return true;
        }
        if (jSONNumberValue instanceof JSONInteger) {
            if (instance.longValue() % this.value.longValue() != 0L) return false;
            return true;
        }
        if (!(jSONNumberValue instanceof JSONZero)) throw (Throwable)((Object)new JSONSchemaException("Impossible type"));
        return true;
    }

    private final boolean maximum(JSONNumberValue instance) {
        JSONNumberValue jSONNumberValue = instance;
        return jSONNumberValue instanceof JSONDecimal ? ((JSONDecimal)instance).getValue().compareTo(this.toBigDecimal(this.value)) <= 0 : (jSONNumberValue instanceof JSONDouble ? ((JSONDouble)instance).getValue() <= this.value.doubleValue() : (jSONNumberValue instanceof JSONFloat ? ((JSONFloat)instance).getValue() <= this.value.floatValue() : instance.longValue() <= this.value.longValue()));
    }

    private final boolean exclusiveMaximum(JSONNumberValue instance) {
        JSONNumberValue jSONNumberValue = instance;
        return jSONNumberValue instanceof JSONDecimal ? ((JSONDecimal)instance).getValue().compareTo(this.toBigDecimal(this.value)) < 0 : (jSONNumberValue instanceof JSONDouble ? ((JSONDouble)instance).getValue() < this.value.doubleValue() : (jSONNumberValue instanceof JSONFloat ? ((JSONFloat)instance).getValue() < this.value.floatValue() : instance.longValue() < this.value.longValue()));
    }

    private final boolean minimum(JSONNumberValue instance) {
        JSONNumberValue jSONNumberValue = instance;
        return jSONNumberValue instanceof JSONDecimal ? ((JSONDecimal)instance).getValue().compareTo(this.toBigDecimal(this.value)) >= 0 : (jSONNumberValue instanceof JSONDouble ? ((JSONDouble)instance).getValue() >= this.value.doubleValue() : (jSONNumberValue instanceof JSONFloat ? ((JSONFloat)instance).getValue() >= this.value.floatValue() : instance.longValue() >= this.value.longValue()));
    }

    private final boolean exclusiveMinimum(JSONNumberValue instance) {
        JSONNumberValue jSONNumberValue = instance;
        return jSONNumberValue instanceof JSONDecimal ? ((JSONDecimal)instance).getValue().compareTo(this.toBigDecimal(this.value)) > 0 : (jSONNumberValue instanceof JSONDouble ? ((JSONDouble)instance).getValue() > this.value.doubleValue() : (jSONNumberValue instanceof JSONFloat ? ((JSONFloat)instance).getValue() > this.value.floatValue() : instance.longValue() > this.value.longValue()));
    }

    private final BigDecimal toBigDecimal(Number $this$toBigDecimal) {
        Number number = $this$toBigDecimal;
        return number instanceof BigDecimal ? (BigDecimal)$this$toBigDecimal : (number instanceof BigInteger ? new BigDecimal((BigInteger)$this$toBigDecimal) : (number instanceof Double ? new BigDecimal($this$toBigDecimal.doubleValue()) : (number instanceof Float ? new BigDecimal($this$toBigDecimal.doubleValue()) : new BigDecimal($this$toBigDecimal.longValue()))));
    }

    private final BigDecimal toBigDecimal(JSONNumberValue $this$toBigDecimal) {
        BigDecimal bigDecimal;
        JSONNumberValue jSONNumberValue = $this$toBigDecimal;
        if (jSONNumberValue instanceof JSONDecimal) {
            BigDecimal bigDecimal2 = ((JSONDecimal)$this$toBigDecimal).getValue();
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.value");
        } else if (jSONNumberValue instanceof JSONDouble) {
            bigDecimal = new BigDecimal(((JSONDouble)$this$toBigDecimal).getValue());
        } else if (jSONNumberValue instanceof JSONFloat) {
            bigDecimal = new BigDecimal(((JSONFloat)$this$toBigDecimal).getValue());
        } else if (jSONNumberValue instanceof JSONLong) {
            bigDecimal = new BigDecimal(((JSONLong)$this$toBigDecimal).getValue());
        } else if (jSONNumberValue instanceof JSONInteger) {
            bigDecimal = new BigDecimal(((JSONInteger)$this$toBigDecimal).getValue());
        } else if (jSONNumberValue instanceof JSONZero) {
            BigDecimal bigDecimal3 = BigDecimal.ZERO;
            bigDecimal = bigDecimal3;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"BigDecimal.ZERO");
        } else {
            throw (Throwable)((Object)new JSONSchemaException("Incorrect JSON value"));
        }
        return bigDecimal;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof NumberValidator && super.equals(other) && Intrinsics.areEqual((Object)this.value, (Object)((NumberValidator)other).value) && this.condition == ((NumberValidator)other).condition;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.value.hashCode() ^ this.condition.hashCode();
    }

    @NotNull
    public final Number getValue() {
        return this.value;
    }

    @NotNull
    public final ValidationType getCondition() {
        return this.condition;
    }

    public NumberValidator(@Nullable URI uri, @NotNull JSONPointer location, @NotNull Number value, @NotNull ValidationType condition) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)((Object)condition), (String)"condition");
        super(uri, location);
        this.value = value;
        this.condition = condition;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        ValidationType[] $this$map$iv = ValidationType.values();
        boolean $i$f$map = false;
        ValidationType[] validationTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var5_5 = $this$mapTo$iv$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = var5_5[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getKeyword();
            collection.add(string);
        }
        typeKeywords = (List)var3_3;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "", "keyword", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getKeyword", "()Ljava/lang/String;", "MULTIPLE_OF", "MAXIMUM", "EXCLUSIVE_MAXIMUM", "MINIMUM", "EXCLUSIVE_MINIMUM", "json-kotlin-schema"})
    public static final class ValidationType
    extends Enum<ValidationType> {
        public static final /* enum */ ValidationType MULTIPLE_OF;
        public static final /* enum */ ValidationType MAXIMUM;
        public static final /* enum */ ValidationType EXCLUSIVE_MAXIMUM;
        public static final /* enum */ ValidationType MINIMUM;
        public static final /* enum */ ValidationType EXCLUSIVE_MINIMUM;
        private static final /* synthetic */ ValidationType[] $VALUES;
        @NotNull
        private final String keyword;

        static {
            ValidationType[] validationTypeArray = new ValidationType[5];
            ValidationType[] validationTypeArray2 = validationTypeArray;
            validationTypeArray[0] = MULTIPLE_OF = new ValidationType("multipleOf");
            validationTypeArray[1] = MAXIMUM = new ValidationType("maximum");
            validationTypeArray[2] = EXCLUSIVE_MAXIMUM = new ValidationType("exclusiveMaximum");
            validationTypeArray[3] = MINIMUM = new ValidationType("minimum");
            validationTypeArray[4] = EXCLUSIVE_MINIMUM = new ValidationType("exclusiveMinimum");
            $VALUES = validationTypeArray;
        }

        @NotNull
        public final String getKeyword() {
            return this.keyword;
        }

        private ValidationType(String keyword) {
            this.keyword = keyword;
        }

        public static ValidationType[] values() {
            return (ValidationType[])$VALUES.clone();
        }

        public static ValidationType valueOf(String string) {
            return Enum.valueOf(ValidationType.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lnet/pwall/json/schema/validation/NumberValidator$Companion;", "", "()V", "typeKeywords", "", "", "getTypeKeywords", "()Ljava/util/List;", "findType", "Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "keyword", "json-kotlin-schema"})
    public static final class Companion {
        @NotNull
        public final List<String> getTypeKeywords() {
            return typeKeywords;
        }

        @NotNull
        public final ValidationType findType(@NotNull String keyword) {
            Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
            ValidationType[] $this$forEach$iv = ValidationType.values();
            boolean $i$f$forEach = false;
            ValidationType[] validationTypeArray = $this$forEach$iv;
            int n = validationTypeArray.length;
            for (int i = 0; i < n; ++i) {
                ValidationType element$iv;
                ValidationType it = element$iv = validationTypeArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKeyword(), (Object)keyword)) continue;
                return it;
            }
            throw (Throwable)new RuntimeException("Can't find validation type - should not happen");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

