/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.parser;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.pwall.json.JSONBoolean;
import net.pwall.json.JSONDecimal;
import net.pwall.json.JSONDouble;
import net.pwall.json.JSONFloat;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONMapping;
import net.pwall.json.JSONNumberValue;
import net.pwall.json.JSONSequence;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.JSONZero;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.pointer.JSONPointerException;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.parser.JSONReader;
import net.pwall.json.schema.parser.Parser;
import net.pwall.json.schema.subschema.AdditionalItemsSchema;
import net.pwall.json.schema.subschema.AdditionalPropertiesSchema;
import net.pwall.json.schema.subschema.AllOfSchema;
import net.pwall.json.schema.subschema.AnyOfSchema;
import net.pwall.json.schema.subschema.ExtensionSchema;
import net.pwall.json.schema.subschema.IfThenElseSchema;
import net.pwall.json.schema.subschema.ItemsArraySchema;
import net.pwall.json.schema.subschema.ItemsSchema;
import net.pwall.json.schema.subschema.OneOfSchema;
import net.pwall.json.schema.subschema.PatternPropertiesSchema;
import net.pwall.json.schema.subschema.PropertiesSchema;
import net.pwall.json.schema.subschema.PropertyNamesSchema;
import net.pwall.json.schema.subschema.RefSchema;
import net.pwall.json.schema.subschema.RequiredSchema;
import net.pwall.json.schema.validation.ArrayValidator;
import net.pwall.json.schema.validation.ConstValidator;
import net.pwall.json.schema.validation.ContainsValidator;
import net.pwall.json.schema.validation.DefaultValidator;
import net.pwall.json.schema.validation.DelegatingValidator;
import net.pwall.json.schema.validation.EnumValidator;
import net.pwall.json.schema.validation.FormatValidator;
import net.pwall.json.schema.validation.NumberValidator;
import net.pwall.json.schema.validation.PatternValidator;
import net.pwall.json.schema.validation.PropertiesValidator;
import net.pwall.json.schema.validation.StringValidator;
import net.pwall.json.schema.validation.TypeValidator;
import net.pwall.json.schema.validation.UniqueItemsValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 f2\u00020\u0001:\u0002fgB'\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\r2\u0006\u0010%\u001a\u00020\fH\u0002J\u001a\u0010&\u001a\u00020\u000b2\b\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\fH\u0002J(\u0010(\u001a\u0004\u0018\u00010\u000b2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\b\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\fH\u0002J\u000e\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-J\u000e\u0010+\u001a\u00020!2\u0006\u0010'\u001a\u00020\u0006J\u000e\u0010+\u001a\u00020!2\u0006\u0010.\u001a\u00020/J\u000e\u0010+\u001a\u00020!2\u0006\u00100\u001a\u00020\u000bJ\u001a\u0010+\u001a\u00020!2\u0006\u00101\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010\u0006H\u0002J,\u00102\u001a\u0002032\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J&\u00107\u001a\u0004\u0018\u0001082\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u00106\u001a\u0004\u0018\u00010\rH\u0002JT\u00109\u001a\u00020!2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u0010:\u001a\u0004\u0018\u00010\r2&\u0010;\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0=\u0012\u0004\u0012\u00020!0<H\u0002J\"\u0010>\u001a\u00020?2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u0006H\u0002J\"\u0010@\u001a\u00020!2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\f2\b\u0010A\u001a\u0004\u0018\u00010\u0006H\u0002J$\u0010B\u001a\u00020C2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010D\u001a\u00020!2\u0006\u0010E\u001a\u00020\u000bJ$\u0010F\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010G\u001a\u00020!2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u0006H\u0002J,\u0010H\u001a\u00020I2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J,\u0010J\u001a\u00020K2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u00104\u001a\u00020L2\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J$\u0010M\u001a\u00020N2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J,\u0010O\u001a\u00020P2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J,\u0010Q\u001a\u00020R2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J,\u0010S\u001a\u00020T2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u00104\u001a\u00020U2\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J\"\u0010V\u001a\u00020W2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u0006H\u0002J,\u0010X\u001a\u00020Y2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J$\u0010Z\u001a\u00020[2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J \u0010\\\u001a\u00020!2\u0006\u00101\u001a\u00020\r2\u0006\u0010%\u001a\u00020\f2\b\u0010A\u001a\u0004\u0018\u00010\u0006J,\u0010]\u001a\u00020^2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u00104\u001a\u00020_2\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J$\u0010`\u001a\u00020a2\u0006\u0010%\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\u00062\b\u00106\u001a\u0004\u0018\u00010\rH\u0002J\u000e\u0010b\u001a\u00020!2\u0006\u0010c\u001a\u00020\u000bJ\u000e\u0010d\u001a\u00020e2\u0006\u0010,\u001a\u00020-J\u000e\u0010d\u001a\u00020e2\u0006\u0010.\u001a\u00020/J\u000e\u0010d\u001a\u00020e2\u0006\u0010E\u001a\u00020\u000bR>\u0010\t\u001a&\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006h"}, d2={"Lnet/pwall/json/schema/parser/Parser;", "", "options", "Lnet/pwall/json/schema/parser/Parser$Options;", "uriResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "(Lnet/pwall/json/schema/parser/Parser$Options;Lkotlin/jvm/functions/Function1;)V", "customValidationHandler", "Lkotlin/Function4;", "", "Lnet/pwall/json/pointer/JSONPointer;", "Lnet/pwall/json/JSONValue;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "getCustomValidationHandler", "()Lkotlin/jvm/functions/Function4;", "setCustomValidationHandler", "(Lkotlin/jvm/functions/Function4;)V", "jsonReader", "Lnet/pwall/json/schema/parser/JSONReader;", "nonstandardFormatHandler", "Lnet/pwall/json/schema/validation/FormatValidator$FormatChecker;", "getNonstandardFormatHandler", "()Lkotlin/jvm/functions/Function1;", "setNonstandardFormatHandler", "(Lkotlin/jvm/functions/Function1;)V", "getOptions", "()Lnet/pwall/json/schema/parser/Parser$Options;", "setOptions", "(Lnet/pwall/json/schema/parser/Parser$Options;)V", "schemaCache", "", "Lnet/pwall/json/schema/JSONSchema;", "checkType", "Lnet/pwall/json/schema/JSONSchema$Type;", "item", "pointer", "errorPointer", "uri", "getDescription", "schemaJSON", "Lnet/pwall/json/JSONMapping;", "parse", "file", "Ljava/io/File;", "path", "Ljava/nio/file/Path;", "string", "json", "parseArrayNumberOfItems", "Lnet/pwall/json/schema/validation/ArrayValidator;", "condition", "Lnet/pwall/json/schema/validation/ArrayValidator$ValidationType;", "value", "parseArrayUniqueItems", "Lnet/pwall/json/schema/validation/UniqueItemsValidator;", "parseCombinationSchema", "array", "creator", "Lkotlin/Function3;", "", "parseContains", "Lnet/pwall/json/schema/validation/ContainsValidator;", "parseDraft07", "parentUri", "parseEnum", "Lnet/pwall/json/schema/validation/EnumValidator;", "parseFile", "filename", "parseFormat", "parseIf", "parseItems", "Lnet/pwall/json/schema/JSONSchema$SubSchema;", "parseNumberLimit", "Lnet/pwall/json/schema/validation/NumberValidator;", "Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "parsePattern", "Lnet/pwall/json/schema/validation/PatternValidator;", "parsePatternProperties", "Lnet/pwall/json/schema/subschema/PatternPropertiesSchema;", "parseProperties", "Lnet/pwall/json/schema/subschema/PropertiesSchema;", "parsePropertiesSize", "Lnet/pwall/json/schema/validation/PropertiesValidator;", "Lnet/pwall/json/schema/validation/PropertiesValidator$ValidationType;", "parsePropertyNames", "Lnet/pwall/json/schema/subschema/PropertyNamesSchema;", "parseRef", "Lnet/pwall/json/schema/subschema/RefSchema;", "parseRequired", "Lnet/pwall/json/schema/subschema/RequiredSchema;", "parseSchema", "parseStringLength", "Lnet/pwall/json/schema/validation/StringValidator;", "Lnet/pwall/json/schema/validation/StringValidator$ValidationType;", "parseType", "Lnet/pwall/json/schema/validation/TypeValidator;", "parseURI", "uriString", "preLoad", "", "Companion", "Options", "json-kotlin-schema"})
public final class Parser {
    @NotNull
    private Function4<? super String, ? super URI, ? super JSONPointer, ? super JSONValue, ? extends JSONSchema.Validator> customValidationHandler;
    @NotNull
    private Function1<? super String, ? extends FormatValidator.FormatChecker> nonstandardFormatHandler;
    private final JSONReader jsonReader;
    private final Map<URI, JSONSchema> schemaCache;
    @NotNull
    private Options options;
    @NotNull
    private static final List<String> schemaVersion202012;
    @NotNull
    private static final List<String> schemaVersion201909;
    @NotNull
    private static final List<String> schemaVersionDraft07;
    @NotNull
    private static final Function1<URI, InputStream> defaultURIResolver;
    public static final Companion Companion;

    @NotNull
    public final Function4<String, URI, JSONPointer, JSONValue, JSONSchema.Validator> getCustomValidationHandler() {
        return this.customValidationHandler;
    }

    public final void setCustomValidationHandler(@NotNull Function4<? super String, ? super URI, ? super JSONPointer, ? super JSONValue, ? extends JSONSchema.Validator> function4) {
        Intrinsics.checkNotNullParameter(function4, (String)"<set-?>");
        this.customValidationHandler = function4;
    }

    @NotNull
    public final Function1<String, FormatValidator.FormatChecker> getNonstandardFormatHandler() {
        return this.nonstandardFormatHandler;
    }

    public final void setNonstandardFormatHandler(@NotNull Function1<? super String, ? extends FormatValidator.FormatChecker> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.nonstandardFormatHandler = function1;
    }

    public final void preLoad(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.jsonReader.preLoad(filename);
    }

    public final void preLoad(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.jsonReader.preLoad(file);
    }

    public final void preLoad(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.jsonReader.preLoad(path);
    }

    @NotNull
    public final JSONSchema parseFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.parse(new File(filename));
    }

    @NotNull
    public final JSONSchema parseURI(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        return this.parse(new URI(uriString));
    }

    @NotNull
    public final JSONSchema parse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) {
            throw (Throwable)((Object)new JSONSchemaException("Invalid file - " + file));
        }
        URI uri = file.toURI();
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema jSONSchema2 = jSONSchema;
            boolean bl = false;
            boolean bl2 = false;
            JSONSchema it = jSONSchema2;
            boolean bl3 = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(file);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema jSONSchema2 = jSONSchema;
            boolean bl = false;
            boolean bl2 = false;
            JSONSchema it = jSONSchema2;
            boolean bl3 = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(uri);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw (Throwable)((Object)new JSONSchemaException("Invalid file - " + path));
        }
        URI uri = path.toUri();
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema jSONSchema2 = jSONSchema;
            boolean bl = false;
            boolean bl2 = false;
            JSONSchema it = jSONSchema2;
            boolean bl3 = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(path);
        return this.parse(json, uri);
    }

    @NotNull
    public final JSONSchema parse(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        JSONValue json = this.jsonReader.readJSON(string);
        return this.parse(json, null);
    }

    private final JSONSchema parse(JSONValue json, URI uri) {
        JSONSchema jSONSchema;
        String string;
        JSONValue jSONValue = json;
        if (!(jSONValue instanceof JSONMapping)) {
            jSONValue = null;
        }
        JSONMapping jSONMapping = (JSONMapping)jSONValue;
        if (jSONMapping != null) {
            JSONPointer jSONPointer = JSONPointer.root.child("$schema");
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"JSONPointer.root.child(\"\\$schema\")");
            string = Companion.getStringOrNull(jSONMapping, jSONPointer);
        } else {
            string = null;
        }
        String schemaVersion = string;
        JSONPointer pointer = JSONPointer.root;
        String string2 = schemaVersion;
        if (CollectionsKt.contains((Iterable)schemaVersion201909, (Object)string2)) {
            JSONPointer jSONPointer = pointer;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer");
            jSONSchema = this.parseSchema(json, jSONPointer, uri);
        } else if (CollectionsKt.contains((Iterable)schemaVersionDraft07, (Object)string2)) {
            JSONPointer jSONPointer = pointer;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer");
            jSONSchema = this.parseDraft07(json, jSONPointer, uri);
        } else {
            JSONPointer jSONPointer = pointer;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer");
            jSONSchema = this.parseSchema(json, jSONPointer, uri);
        }
        return jSONSchema;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONSchema parseSchema(@NotNull JSONValue json, @NotNull JSONPointer pointer, @Nullable URI parentUri) {
        Unit unit;
        Unit unit2;
        URI uri;
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        JSONValue schemaJSON = pointer.eval(json);
        if (schemaJSON instanceof JSONBoolean) {
            return JSONSchema.Companion.booleanSchema(((JSONBoolean)schemaJSON).booleanValue(), parentUri, pointer);
        }
        if (!(schemaJSON instanceof JSONMapping)) {
            throw (Throwable)((Object)new JSONSchemaException("Schema is not boolean or object - " + Companion.pointerOrRoot(pointer)));
        }
        String id = Companion.getIdOrNull(schemaJSON);
        if (id == null) {
            uRI = parentUri;
        } else if (parentUri == null) {
            uRI = Companion.dropFragment(new URI(id));
        } else {
            URI uRI2 = parentUri.resolve(id);
            Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"parentUri.resolve(id)");
            uRI = Companion.dropFragment(uRI2);
        }
        URI uRI3 = uri = uRI;
        if (uRI3 != null) {
            URI uRI4 = uRI3;
            boolean bl = false;
            boolean bl2 = false;
            URI it = uRI4;
            boolean bl3 = false;
            URI fragmentURI = uri.resolve(pointer.toURIFragment());
            JSONSchema jSONSchema = this.schemaCache.get(fragmentURI);
            if (jSONSchema != null) {
                JSONSchema jSONSchema2 = jSONSchema;
                boolean bl4 = false;
                boolean bl5 = false;
                JSONSchema it2 = jSONSchema2;
                boolean bl6 = false;
                if (it2 instanceof JSONSchema.False) {
                    throw (Throwable)new JSONPointerException("Recursive $ref - " + pointer);
                }
                return it2;
            }
            URI uRI5 = fragmentURI;
            Intrinsics.checkNotNullExpressionValue((Object)uRI5, (String)"fragmentURI");
            this.schemaCache.put(uRI5, new JSONSchema.False(uri, pointer));
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = null;
        }
        String title = Companion.getStringOrNull((JSONMapping)schemaJSON, "title");
        String description = this.getDescription((JSONMapping)schemaJSON, uri, pointer);
        boolean it = false;
        List children = new ArrayList();
        JSONSchema.General result = new JSONSchema.General(schemaVersion201909.get(0), title, description, uri, pointer, children);
        Iterator iterator = ((JSONMapping)schemaJSON).entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator.next();
            boolean bl = false;
            String string = (String)entry2.getKey();
            entry2 = entry;
            bl = false;
            JSONValue value = (JSONValue)entry2.getValue();
            JSONPointer childPointer = pointer.child((String)key);
            void var16_29 = key;
            if (Intrinsics.areEqual((Object)var16_29, (Object)"$schema")) {
                if (Intrinsics.areEqual((Object)pointer, (Object)JSONPointer.root) ^ true) {
                    throw (Throwable)((Object)new JSONSchemaException("May only appear in the root of the document - " + childPointer));
                }
                if (!(value instanceof JSONString)) {
                    throw (Throwable)((Object)new JSONSchemaException("String expected - " + childPointer));
                }
            } else if (!(Intrinsics.areEqual((Object)var16_29, (Object)"$id") || Intrinsics.areEqual((Object)var16_29, (Object)"$defs") || Intrinsics.areEqual((Object)var16_29, (Object)"title") || Intrinsics.areEqual((Object)var16_29, (Object)"description") || Intrinsics.areEqual((Object)var16_29, (Object)"then") || Intrinsics.areEqual((Object)var16_29, (Object)"else") || Intrinsics.areEqual((Object)var16_29, (Object)"minContains") || Intrinsics.areEqual((Object)var16_29, (Object)"maxContains"))) {
                UniqueItemsValidator it3;
                JSONSchema.Validator validator;
                boolean bl7;
                boolean bl8;
                if (Intrinsics.areEqual((Object)var16_29, (Object)"$comment")) {
                    if (!(value instanceof JSONString)) {
                        throw (Throwable)((Object)new JSONSchemaException("String expected - " + childPointer));
                    }
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"examples")) {
                    if (!(value instanceof JSONSequence)) {
                        throw (Throwable)((Object)new JSONSchemaException("Must be array - " + childPointer));
                    }
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"$ref")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseRef(json, jSONPointer, uri, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"default")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(new DefaultValidator(uri, jSONPointer, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"allOf")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseCombinationSchema(json, jSONPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AllOfSchema>(JSONSchema.Companion){

                        @NotNull
                        public final AllOfSchema invoke(@Nullable URI p1, @NotNull JSONPointer p2, @NotNull List<? extends JSONSchema> p3) {
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            Intrinsics.checkNotNullParameter(p3, (String)"p3");
                            return ((JSONSchema.Companion)this.receiver).allOf(p1, p2, p3);
                        }
                    })));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"anyOf")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseCombinationSchema(json, jSONPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AnyOfSchema>(JSONSchema.Companion){

                        @NotNull
                        public final AnyOfSchema invoke(@Nullable URI p1, @NotNull JSONPointer p2, @NotNull List<? extends JSONSchema> p3) {
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            Intrinsics.checkNotNullParameter(p3, (String)"p3");
                            return ((JSONSchema.Companion)this.receiver).anyOf(p1, p2, p3);
                        }
                    })));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"oneOf")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseCombinationSchema(json, jSONPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, OneOfSchema>(JSONSchema.Companion){

                        @NotNull
                        public final OneOfSchema invoke(@Nullable URI p1, @NotNull JSONPointer p2, @NotNull List<? extends JSONSchema> p3) {
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            Intrinsics.checkNotNullParameter(p3, (String)"p3");
                            return ((JSONSchema.Companion)this.receiver).oneOf(p1, p2, p3);
                        }
                    })));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"not")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    JSONPointer jSONPointer2 = pointer.child("not");
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(\"not\")");
                    children.add(new JSONSchema.Not(uri, jSONPointer, this.parseSchema(json, jSONPointer2, uri)));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"if")) {
                    children.add(this.parseIf(json, pointer, uri));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"type")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseType(jSONPointer, uri, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"enum")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseEnum(jSONPointer, uri, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"const")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(new ConstValidator(uri, jSONPointer, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"properties")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseProperties(json, jSONPointer, uri, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"patternProperties")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parsePatternProperties(json, jSONPointer, uri, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"propertyNames")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parsePropertyNames(json, jSONPointer, uri));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"minProperties")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parsePropertiesSize(jSONPointer, uri, PropertiesValidator.ValidationType.MIN_PROPERTIES, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"maxProperties")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parsePropertiesSize(jSONPointer, uri, PropertiesValidator.ValidationType.MAX_PROPERTIES, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"required")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseRequired(jSONPointer, uri, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"items")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseItems(json, jSONPointer, uri, value));
                } else if (NumberValidator.Companion.getTypeKeywords().contains(var16_29)) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    void v24 = key;
                    Intrinsics.checkNotNullExpressionValue((Object)v24, (String)"key");
                    children.add(this.parseNumberLimit(jSONPointer, uri, NumberValidator.Companion.findType((String)v24), value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"maxItems")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseArrayNumberOfItems(jSONPointer, uri, ArrayValidator.ValidationType.MAX_ITEMS, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"minItems")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseArrayNumberOfItems(jSONPointer, uri, ArrayValidator.ValidationType.MIN_ITEMS, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"uniqueItems")) {
                    Boolean bl9;
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    if (this.parseArrayUniqueItems(jSONPointer, uri, value) != null) {
                        bl8 = false;
                        bl7 = false;
                        it3 = validator;
                        boolean bl10 = false;
                        bl9 = children.add(it3);
                    } else {
                        bl9 = null;
                    }
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"maxLength")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseStringLength(jSONPointer, uri, StringValidator.ValidationType.MAX_LENGTH, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"minLength")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseStringLength(jSONPointer, uri, StringValidator.ValidationType.MIN_LENGTH, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"pattern")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parsePattern(jSONPointer, uri, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"format")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseFormat(jSONPointer, uri, value));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"additionalProperties")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(new AdditionalPropertiesSchema(result, uri, jSONPointer, this.parseSchema(json, childPointer, uri)));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"additionalItems")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(new AdditionalItemsSchema(result, uri, jSONPointer, this.parseSchema(json, childPointer, uri)));
                } else if (Intrinsics.areEqual((Object)var16_29, (Object)"contains")) {
                    children.add(this.parseContains(json, pointer, uri));
                } else {
                    Boolean bl11;
                    void v35 = key;
                    Intrinsics.checkNotNullExpressionValue((Object)v35, (String)"key");
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    if ((JSONSchema.Validator)this.customValidationHandler.invoke((Object)v35, (Object)uri, (Object)jSONPointer, (Object)value) != null) {
                        bl8 = false;
                        bl7 = false;
                        it3 = validator;
                        boolean bl12 = false;
                        bl11 = children.add(new DelegatingValidator(it3.getUri(), it3.getLocation(), (String)key, it3));
                    } else {
                        bl11 = null;
                    }
                }
            }
            void v38 = key;
            Intrinsics.checkNotNullExpressionValue((Object)v38, (String)"key");
            if (!StringsKt.startsWith$default((String)v38, (String)"x-", (boolean)false, (int)2, null)) continue;
            JSONPointer jSONPointer = childPointer;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
            JSONValue jSONValue = value;
            children.add(new ExtensionSchema(uri, jSONPointer, (String)key, jSONValue != null ? jSONValue.toSimpleValue() : null));
        }
        URI uRI6 = uri;
        if (uRI6 != null) {
            URI uRI7 = uRI6;
            boolean bl = false;
            boolean bl13 = false;
            URI it4 = uRI7;
            boolean bl14 = false;
            URI uRI8 = uri.resolve(pointer.toURIFragment());
            Intrinsics.checkNotNullExpressionValue((Object)uRI8, (String)"uri.resolve(pointer.toURIFragment())");
            this.schemaCache.put(uRI8, result);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return result;
    }

    private final String getDescription(JSONMapping<?> schemaJSON, URI uri, JSONPointer pointer) {
        JSONValue ref;
        JSONValue jSONValue = (JSONValue)schemaJSON.get((Object)"description");
        if (jSONValue == null) {
            return null;
        }
        JSONValue value = jSONValue;
        if (value instanceof JSONString) {
            return ((JSONString)value).getValue();
        }
        if (this.options.getAllowDescriptionRef() && value instanceof JSONMapping && ((JSONMapping)value).size() == 1 && (ref = (JSONValue)((JSONMapping)value).get((Object)"$ref")) instanceof JSONString) {
            try {
                URL uRL = (uri == null ? new URI(((JSONString)ref).getValue()) : uri.resolve(((JSONString)ref).getValue())).toURL();
                Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"(if (uri == null) URI(re\u2026solve(ref.value)).toURL()");
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                boolean bl2 = false;
                boolean bl3 = false;
                return new String(byArray, charset);
            }
            catch (Exception e) {
                throw (Throwable)((Object)new JSONSchemaException("Error reading external description - " + this.errorPointer(uri, pointer)));
            }
        }
        throw (Throwable)((Object)new JSONSchemaException("Invalid description - " + this.errorPointer(uri, pointer)));
    }

    private final String errorPointer(URI uri, JSONPointer pointer) {
        String fragment = pointer.toURIFragment();
        Object object = uri;
        if (object == null || (object = Companion.dropFragment((URI)object)) == null || (object = ((URI)object).resolve(fragment)) == null || (object = ((URI)object).toString()) == null) {
            String string = fragment;
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fragment");
        }
        return object;
    }

    private final JSONSchema parseIf(JSONValue json, JSONPointer pointer, URI uri) {
        JSONSchema jSONSchema;
        JSONSchema jSONSchema2;
        JSONPointer jSONPointer = pointer.child("if");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(\"if\")");
        JSONSchema ifSchema = this.parseSchema(json, jSONPointer, uri);
        JSONPointer jSONPointer2 = pointer.child("then");
        boolean bl = false;
        boolean bl2 = false;
        JSONPointer it = jSONPointer2;
        boolean bl3 = false;
        if (it.exists(json)) {
            JSONPointer jSONPointer3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer3, (String)"it");
            jSONSchema2 = this.parseSchema(json, jSONPointer3, uri);
        } else {
            jSONSchema2 = null;
        }
        JSONSchema thenSchema = jSONSchema2;
        JSONPointer jSONPointer4 = pointer.child("else");
        bl2 = false;
        boolean bl4 = false;
        JSONPointer it2 = jSONPointer4;
        boolean bl5 = false;
        if (it2.exists(json)) {
            JSONPointer jSONPointer5 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer5, (String)"it");
            jSONSchema = this.parseSchema(json, jSONPointer5, uri);
        } else {
            jSONSchema = null;
        }
        JSONSchema elseSchema = jSONSchema;
        return new IfThenElseSchema(uri, pointer, ifSchema, thenSchema, elseSchema);
    }

    private final ContainsValidator parseContains(JSONValue json, JSONPointer pointer, URI uri) {
        Integer n;
        Integer n2;
        JSONPointer jSONPointer = pointer.child("contains");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(\"contains\")");
        JSONSchema containsSchema = this.parseSchema(json, jSONPointer, uri);
        JSONPointer jSONPointer2 = pointer.child("minContains");
        boolean bl = false;
        boolean bl2 = false;
        JSONPointer it = jSONPointer2;
        boolean bl3 = false;
        if (it.exists(json)) {
            JSONPointer jSONPointer3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer3, (String)"it");
            n2 = Companion.getNonNegativeInteger(json, jSONPointer3);
        } else {
            n2 = null;
        }
        Integer minContains = n2;
        JSONPointer jSONPointer4 = pointer.child("maxContains");
        bl2 = false;
        boolean bl4 = false;
        JSONPointer it2 = jSONPointer4;
        boolean bl5 = false;
        if (it2.exists(json)) {
            JSONPointer jSONPointer5 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer5, (String)"it");
            n = Companion.getNonNegativeInteger(json, jSONPointer5);
        } else {
            n = null;
        }
        Integer maxContains = n;
        JSONPointer jSONPointer6 = pointer.child("contains");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer6, (String)"pointer.child(\"contains\")");
        return new ContainsValidator(uri, jSONPointer6, containsSchema, minContains, maxContains);
    }

    private final JSONSchema.Validator parseFormat(JSONPointer pointer, URI uri, JSONValue value) {
        FormatValidator.FormatChecker formatChecker;
        if (!(value instanceof JSONString)) {
            throw (Throwable)((Object)new JSONSchemaException("String expected - " + pointer));
        }
        String string = ((JSONString)value).getValue();
        boolean bl = false;
        boolean bl2 = false;
        String keyword = string;
        boolean bl3 = false;
        String string2 = keyword;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"keyword");
        FormatValidator.FormatChecker formatChecker2 = (FormatValidator.FormatChecker)this.nonstandardFormatHandler.invoke((Object)string2);
        if (formatChecker2 == null) {
            formatChecker2 = formatChecker = FormatValidator.Companion.findChecker(keyword);
        }
        if (formatChecker2 == null) {
            formatChecker = new FormatValidator.NullFormatChecker(keyword);
        }
        FormatValidator.FormatChecker checker = formatChecker;
        return new FormatValidator(uri, pointer, checker);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema parseCombinationSchema(JSONValue json, JSONPointer pointer, URI uri, JSONValue array, Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> creator) {
        Collection<JSONSchema> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!(array instanceof JSONSequence)) {
            throw (Throwable)((Object)new JSONSchemaException("Compound must take array - " + pointer));
        }
        Iterable iterable = (Iterable)array;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> function3 = creator;
        boolean $i$f$mapIndexed = false;
        void var8_11 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSONValue jSONValue = (JSONValue)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            JSONPointer jSONPointer2 = pointer.child((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(i)");
            JSONSchema jSONSchema = this.parseSchema(json, jSONPointer2, uri);
            collection.add(jSONSchema);
        }
        collection = (List)destination$iv$iv;
        return (JSONSchema)function3.invoke((Object)uRI, (Object)jSONPointer, (Object)collection);
    }

    private final RefSchema parseRef(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        JSONPointer refPointer;
        JSONValue refJSON;
        JSONPointer refURIFragment;
        String refURIPath;
        block12: {
            JSONPointer jSONPointer;
            block11: {
                Object object;
                int n;
                String string;
                if (!(value instanceof JSONString)) {
                    throw (Throwable)((Object)new JSONSchemaException("$ref must be string - " + pointer));
                }
                String string2 = (uri == null ? new URI(((JSONString)value).getValue()) : uri.resolve(((JSONString)value).getValue())).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(if (uri == null) URI(va\u2026(value.value)).toString()");
                String refURIString = string2;
                int hashIndex = StringsKt.indexOf$default((CharSequence)refURIString, (char)'#', (int)0, (boolean)false, (int)6, null);
                if (hashIndex < 0) {
                    string = refURIString;
                } else {
                    String string3 = refURIString;
                    int n2 = 0;
                    n = 0;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string5 = string4.substring(n2, hashIndex);
                    string = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                }
                refURIPath = string;
                if (hashIndex < 0) {
                    object = null;
                } else {
                    String string6 = refURIString;
                    n = hashIndex + 1;
                    boolean bl = false;
                    String string7 = string6;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.substring(n);
                    object = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
                }
                refURIFragment = object;
                JSONValue jSONValue = refJSON = hashIndex == 0 || Intrinsics.areEqual((Object)refURIPath, (Object)String.valueOf(uri)) ? json : this.jsonReader.readJSON(new URI(StringsKt.endsWith$default((CharSequence)refURIPath, (char)'/', (boolean)false, (int)2, null) ? StringsKt.dropLast((String)refURIPath, (int)1) : refURIPath));
                jSONPointer = refURIFragment;
                if (jSONPointer == null) break block11;
                JSONPointer jSONPointer2 = jSONPointer;
                boolean bl = false;
                boolean bl2 = false;
                JSONPointer it = jSONPointer2;
                boolean bl3 = false;
                jSONPointer = JSONPointer.fromURIFragment((String)('#' + (String)it));
                if (jSONPointer != null) break block12;
            }
            jSONPointer = refPointer = JSONPointer.root;
        }
        if (!refPointer.exists(refJSON)) {
            throw (Throwable)((Object)new JSONSchemaException("$ref not found " + value + " - " + pointer));
        }
        JSONPointer jSONPointer = refPointer;
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"refPointer");
        JSONSchema target = this.parseSchema(refJSON, jSONPointer, new URI(refURIPath));
        return new RefSchema(uri, pointer, target, (String)refURIFragment);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema.SubSchema parseItems(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        JSONSchema.SubSchema subSchema;
        if (value instanceof JSONSequence) {
            Collection<JSONSchema> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable iterable = (Iterable)value;
            JSONPointer jSONPointer = pointer;
            URI uRI = uri;
            boolean $i$f$mapIndexed = false;
            void var7_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JSONValue jSONValue = (JSONValue)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl2 = false;
                JSONPointer jSONPointer2 = pointer.child((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(i)");
                JSONSchema jSONSchema = this.parseSchema(json, jSONPointer2, uri);
                collection.add(jSONSchema);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            JSONPointer jSONPointer3 = jSONPointer;
            URI uRI2 = uRI;
            subSchema = new ItemsArraySchema(uRI2, jSONPointer3, list);
        } else {
            subSchema = new ItemsSchema(uri, pointer, this.parseSchema(json, pointer, uri));
        }
        return subSchema;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertiesSchema parseProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(value instanceof JSONMapping)) {
            throw (Throwable)((Object)new JSONSchemaException("properties must be object - " + pointer));
        }
        Set set = ((JSONMapping)value).keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value.keys");
        Iterable iterable = set;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JSONPointer jSONPointer2 = pointer.child((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(it)");
            Pair pair = TuplesKt.to((Object)it, (Object)this.parseSchema(json, jSONPointer2, uri));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer3 = jSONPointer;
        URI uRI2 = uRI;
        return new PropertiesSchema(uRI2, jSONPointer3, list);
    }

    /*
     * WARNING - void declaration
     */
    private final PatternPropertiesSchema parsePatternProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(value instanceof JSONMapping)) {
            throw (Throwable)((Object)new JSONSchemaException("patternProperties must be object - " + pointer));
        }
        Set set = ((JSONMapping)value).keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value.keys");
        Iterable iterable = set;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Regex regex;
            void key;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JSONPointer childPointer = pointer.child((String)key);
            try {
                void v1 = key;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"key");
                regex = new Regex((String)v1);
            }
            catch (Exception e) {
                throw (Throwable)((Object)new JSONSchemaException("Invalid regex in patternProperties - " + childPointer));
            }
            Regex regex2 = regex;
            JSONPointer jSONPointer2 = childPointer;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"childPointer");
            Pair pair = TuplesKt.to((Object)regex2, (Object)this.parseSchema(json, jSONPointer2, uri));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer3 = jSONPointer;
        URI uRI2 = uRI;
        return new PatternPropertiesSchema(uRI2, jSONPointer3, list);
    }

    private final PropertyNamesSchema parsePropertyNames(JSONValue json, JSONPointer pointer, URI uri) {
        return new PropertyNamesSchema(uri, pointer, this.parseSchema(json, pointer, uri));
    }

    private final PropertiesValidator parsePropertiesSize(JSONPointer pointer, URI uri, PropertiesValidator.ValidationType condition, JSONValue value) {
        return new PropertiesValidator(uri, pointer, condition, Companion.getInteger(value, pointer));
    }

    /*
     * WARNING - void declaration
     */
    private final RequiredSchema parseRequired(JSONPointer pointer, URI uri, JSONValue value) {
        Collection<String> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!(value instanceof JSONSequence)) {
            throw (Throwable)((Object)new JSONSchemaException("required must be array - " + Companion.pointerOrRoot(pointer)));
        }
        Iterable iterable = (Iterable)value;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$mapIndexed = false;
        void var6_8 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void entry;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSONValue jSONValue = (JSONValue)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            if (!(entry instanceof JSONString)) {
                void i;
                throw (Throwable)((Object)new JSONSchemaException("required items must be string - " + pointer.child((int)i)));
            }
            String string = ((JSONString)entry).getValue();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer2 = jSONPointer;
        URI uRI2 = uRI;
        return new RequiredSchema(uRI2, jSONPointer2, list);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeValidator parseType(JSONPointer pointer, URI uri, JSONValue value) {
        List list;
        JSONValue jSONValue = value;
        if (jSONValue instanceof JSONString) {
            list = CollectionsKt.listOf((Object)((Object)this.checkType(value, pointer)));
        } else if (jSONValue instanceof JSONSequence) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = (Iterable)value;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void item;
                void index;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JSONValue jSONValue2 = (JSONValue)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                JSONPointer jSONPointer = pointer.child((int)index);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(index)");
                JSONSchema.Type type = this.checkType((JSONValue)item, jSONPointer);
                collection.add(type);
            }
            list = (List)destination$iv$iv;
        } else {
            throw (Throwable)((Object)new JSONSchemaException("Invalid type " + pointer));
        }
        List types = list;
        return new TypeValidator(uri, pointer, types);
    }

    private final JSONSchema.Type checkType(JSONValue item, JSONPointer pointer) {
        if (item instanceof JSONString) {
            for (JSONSchema.Type type : JSONSchema.Type.values()) {
                if (!Intrinsics.areEqual((Object)((JSONString)item).getValue(), (Object)type.getValue())) continue;
                return type;
            }
        }
        throw (Throwable)((Object)new JSONSchemaException("Invalid type " + pointer));
    }

    private final EnumValidator parseEnum(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONSequence)) {
            throw (Throwable)((Object)new JSONSchemaException("enum must be array - " + Companion.pointerOrRoot(pointer)));
        }
        return new EnumValidator(uri, pointer, (JSONSequence)value);
    }

    private final NumberValidator parseNumberLimit(JSONPointer pointer, URI uri, NumberValidator.ValidationType condition, JSONValue value) {
        Number number;
        Number number2;
        if (!(value instanceof JSONNumberValue)) {
            throw (Throwable)((Object)new JSONSchemaException("Must be number (was " + JSONSchema.Companion.toErrorDisplay(value) + ") - " + Companion.pointerOrRoot(pointer)));
        }
        JSONValue jSONValue = value;
        if (jSONValue instanceof JSONDouble || jSONValue instanceof JSONFloat || jSONValue instanceof JSONDecimal) {
            BigDecimal bigDecimal = ((JSONNumberValue)value).bigDecimalValue();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.bigDecimalValue()");
            number2 = bigDecimal;
        } else {
            number2 = number = jSONValue instanceof JSONLong ? (Number)((JSONNumberValue)value).longValue() : (Number)((JSONNumberValue)value).intValue();
        }
        if (condition == NumberValidator.ValidationType.MULTIPLE_OF && !Companion.isPositive(number)) {
            throw (Throwable)((Object)new JSONSchemaException("multipleOf must be greater than 0 - " + Companion.pointerOrRoot(pointer)));
        }
        return new NumberValidator(uri, pointer, number, condition);
    }

    private final StringValidator parseStringLength(JSONPointer pointer, URI uri, StringValidator.ValidationType condition, JSONValue value) {
        return new StringValidator(uri, pointer, condition, Companion.getInteger(value, pointer));
    }

    private final ArrayValidator parseArrayNumberOfItems(JSONPointer pointer, URI uri, ArrayValidator.ValidationType condition, JSONValue value) {
        return new ArrayValidator(uri, pointer, condition, Companion.getInteger(value, pointer));
    }

    private final UniqueItemsValidator parseArrayUniqueItems(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONBoolean)) {
            throw (Throwable)((Object)new JSONSchemaException("Must be boolean - " + Companion.pointerOrRoot(pointer)));
        }
        return ((JSONBoolean)value).booleanValue() ? new UniqueItemsValidator(uri, pointer) : null;
    }

    private final PatternValidator parsePattern(JSONPointer pointer, URI uri, JSONValue value) {
        Regex regex;
        if (!(value instanceof JSONString)) {
            throw (Throwable)((Object)new JSONSchemaException("Must be string - " + Companion.pointerOrRoot(pointer)));
        }
        try {
            String string = ((JSONString)value).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.value");
            regex = new Regex(string);
        }
        catch (Exception e) {
            throw (Throwable)((Object)new JSONSchemaException("Pattern invalid (" + JSONSchema.Companion.toErrorDisplay(value) + ") - " + Companion.pointerOrRoot(pointer)));
        }
        Regex regex2 = regex;
        return new PatternValidator(uri, pointer, regex2);
    }

    private final JSONSchema parseDraft07(JSONValue json, JSONPointer pointer, URI parentUri) {
        return this.parseSchema(json, pointer, parentUri);
    }

    @NotNull
    public final Options getOptions() {
        return this.options;
    }

    public final void setOptions(@NotNull Options options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"<set-?>");
        this.options = options;
    }

    public Parser(@NotNull Options options, @NotNull Function1<? super URI, ? extends InputStream> uriResolver) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(uriResolver, (String)"uriResolver");
        this.options = options;
        this.customValidationHandler = customValidationHandler.1.INSTANCE;
        this.nonstandardFormatHandler = nonstandardFormatHandler.1.INSTANCE;
        this.jsonReader = new JSONReader(uriResolver);
        boolean bl = false;
        this.schemaCache = new LinkedHashMap();
    }

    public /* synthetic */ Parser(Options options, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            options = new Options(false, 1, null);
        }
        if ((n & 2) != 0) {
            function1 = defaultURIResolver;
        }
        this(options, function1);
    }

    public Parser() {
        this(null, null, 3, null);
    }

    static {
        Companion = new Companion(null);
        schemaVersion202012 = CollectionsKt.listOf((Object[])new String[]{"http://json-schema.org/draft/2020-12/schema", "https://json-schema.org/draft/2020-12/schema"});
        schemaVersion201909 = CollectionsKt.listOf((Object[])new String[]{"http://json-schema.org/draft/2019-09/schema", "https://json-schema.org/draft/2019-09/schema"});
        schemaVersionDraft07 = CollectionsKt.listOf((Object[])new String[]{"http://json-schema.org/draft-07/schema", "https://json-schema.org/draft-07/schema"});
        defaultURIResolver = Companion.defaultURIResolver.1.INSTANCE;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lnet/pwall/json/schema/parser/Parser$Options;", "", "allowDescriptionRef", "", "(Z)V", "getAllowDescriptionRef", "()Z", "setAllowDescriptionRef", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "json-kotlin-schema"})
    public static final class Options {
        private boolean allowDescriptionRef;

        public final boolean getAllowDescriptionRef() {
            return this.allowDescriptionRef;
        }

        public final void setAllowDescriptionRef(boolean bl) {
            this.allowDescriptionRef = bl;
        }

        public Options(boolean allowDescriptionRef) {
            this.allowDescriptionRef = allowDescriptionRef;
        }

        public /* synthetic */ Options(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public Options() {
            this(false, 1, null);
        }

        public final boolean component1() {
            return this.allowDescriptionRef;
        }

        @NotNull
        public final Options copy(boolean allowDescriptionRef) {
            return new Options(allowDescriptionRef);
        }

        public static /* synthetic */ Options copy$default(Options options, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = options.allowDescriptionRef;
            }
            return options.copy(bl);
        }

        @NotNull
        public String toString() {
            return "Options(allowDescriptionRef=" + this.allowDescriptionRef + ")";
        }

        public int hashCode() {
            int n = this.allowDescriptionRef ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            return n;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Options)) break block3;
                    Options options = (Options)object;
                    if (this.allowDescriptionRef != options.allowDescriptionRef) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0004\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001aJ\n\u0010\u001e\u001a\u00020\u0005*\u00020\u0005J\"\u0010\u001f\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u001d\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\"\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030 2\u0006\u0010#\u001a\u00020\u000bJ\u0018\u0010\"\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u001d\u001a\u00020\u001aJ\n\u0010$\u001a\u00020%*\u00020&J\n\u0010'\u001a\u00020%*\u00020&J\n\u0010(\u001a\u00020\u000b*\u00020\u001aR\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\rR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\r\u00a8\u0006)"}, d2={"Lnet/pwall/json/schema/parser/Parser$Companion;", "", "()V", "defaultURIResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "getDefaultURIResolver", "()Lkotlin/jvm/functions/Function1;", "schemaVersion201909", "", "", "getSchemaVersion201909", "()Ljava/util/List;", "schemaVersion202012", "getSchemaVersion202012$annotations", "getSchemaVersion202012", "schemaVersionDraft07", "getSchemaVersionDraft07", "getIdOrNull", "jsonValue", "Lnet/pwall/json/JSONValue;", "getInteger", "", "value", "refPointer", "Lnet/pwall/json/pointer/JSONPointer;", "getNonNegativeInteger", "json", "pointer", "dropFragment", "getStringOrDefault", "Lnet/pwall/json/JSONMapping;", "default", "getStringOrNull", "key", "isPositive", "", "", "isZero", "pointerOrRoot", "json-kotlin-schema"})
    public static final class Companion {
        public static /* synthetic */ void getSchemaVersion202012$annotations() {
        }

        @NotNull
        public final List<String> getSchemaVersion202012() {
            return schemaVersion202012;
        }

        @NotNull
        public final List<String> getSchemaVersion201909() {
            return schemaVersion201909;
        }

        @NotNull
        public final List<String> getSchemaVersionDraft07() {
            return schemaVersionDraft07;
        }

        @NotNull
        public final Function1<URI, InputStream> getDefaultURIResolver() {
            return defaultURIResolver;
        }

        @NotNull
        public final URI dropFragment(@NotNull URI $this$dropFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$dropFragment, (String)"$this$dropFragment");
            String string = $this$dropFragment.getFragment();
            return string == null ? $this$dropFragment : new URI($this$dropFragment.getScheme(), $this$dropFragment.getAuthority(), $this$dropFragment.getPath(), $this$dropFragment.getQuery(), null);
        }

        @NotNull
        public final String pointerOrRoot(@NotNull JSONPointer $this$pointerOrRoot) {
            String string;
            Intrinsics.checkNotNullParameter((Object)$this$pointerOrRoot, (String)"$this$pointerOrRoot");
            if (Intrinsics.areEqual((Object)$this$pointerOrRoot, (Object)JSONPointer.root)) {
                string = "root";
            } else {
                String string2 = $this$pointerOrRoot.toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
            }
            return string;
        }

        public final int getInteger(@Nullable JSONValue value, @NotNull JSONPointer refPointer) {
            Intrinsics.checkNotNullParameter((Object)refPointer, (String)"refPointer");
            if (value instanceof JSONZero) {
                return 0;
            }
            if (value instanceof JSONInteger) {
                return ((JSONInteger)value).getValue();
            }
            throw (Throwable)((Object)new JSONSchemaException("Must be integer - " + this.pointerOrRoot(refPointer)));
        }

        public final int getNonNegativeInteger(@NotNull JSONValue json, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            JSONValue value = pointer.find(json);
            if (value instanceof JSONZero) {
                return 0;
            }
            if (value instanceof JSONInteger && ((JSONInteger)value).getValue() >= 0) {
                return ((JSONInteger)value).getValue();
            }
            throw (Throwable)((Object)new JSONSchemaException("Must be non-negative integer at " + pointer + ", was " + value));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String getStringOrNull(@NotNull JSONMapping<?> $this$getStringOrNull, @NotNull String key) {
            Intrinsics.checkNotNullParameter($this$getStringOrNull, (String)"$this$getStringOrNull");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            JSONValue jSONValue = (JSONValue)$this$getStringOrNull.get((Object)key);
            if (jSONValue == null) return null;
            JSONValue jSONValue2 = jSONValue;
            boolean bl = false;
            boolean bl2 = false;
            JSONValue it = jSONValue2;
            boolean bl3 = false;
            if (!(it instanceof JSONString)) throw (Throwable)((Object)new JSONSchemaException("Incorrect " + key));
            String string = ((JSONString)it).getValue();
            return string;
        }

        @Nullable
        public final String getStringOrNull(@NotNull JSONMapping<?> $this$getStringOrNull, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter($this$getStringOrNull, (String)"$this$getStringOrNull");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (!pointer.exists((JSONValue)$this$getStringOrNull)) {
                return null;
            }
            JSONValue value = pointer.eval((JSONValue)$this$getStringOrNull);
            if (!(value instanceof JSONString)) {
                throw (Throwable)((Object)new JSONSchemaException("Incorrect " + pointer));
            }
            return ((JSONString)value).getValue();
        }

        @Nullable
        public final String getStringOrDefault(@NotNull JSONMapping<?> $this$getStringOrDefault, @NotNull JSONPointer pointer, @Nullable String string) {
            Intrinsics.checkNotNullParameter($this$getStringOrDefault, (String)"$this$getStringOrDefault");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (!pointer.exists((JSONValue)$this$getStringOrDefault)) {
                return string;
            }
            JSONValue value = pointer.eval((JSONValue)$this$getStringOrDefault);
            if (!(value instanceof JSONString)) {
                throw (Throwable)((Object)new JSONSchemaException("Incorrect " + pointer));
            }
            return ((JSONString)value).getValue();
        }

        public final boolean isZero(@NotNull Number $this$isZero) {
            Intrinsics.checkNotNullParameter((Object)$this$isZero, (String)"$this$isZero");
            Number number = $this$isZero;
            return number instanceof BigDecimal ? ((BigDecimal)$this$isZero).compareTo(BigDecimal.ZERO) == 0 : (number instanceof BigInteger ? Intrinsics.areEqual((Object)$this$isZero, (Object)BigInteger.ZERO) : (number instanceof Double ? $this$isZero.doubleValue() == 0.0 : (number instanceof Float ? $this$isZero.floatValue() == 0.0f : (number instanceof Long ? Intrinsics.areEqual((Object)$this$isZero, (Object)0L) : $this$isZero.intValue() == 0))));
        }

        public final boolean isPositive(@NotNull Number $this$isPositive) {
            Intrinsics.checkNotNullParameter((Object)$this$isPositive, (String)"$this$isPositive");
            Number number = $this$isPositive;
            return number instanceof BigDecimal ? ((BigDecimal)$this$isPositive).compareTo(BigDecimal.ZERO) > 0 : (number instanceof BigInteger ? ((BigInteger)$this$isPositive).compareTo(BigInteger.ZERO) > 0 : (number instanceof Double ? $this$isPositive.doubleValue() > 0.0 : (number instanceof Float ? $this$isPositive.floatValue() > 0.0f : (number instanceof Long ? $this$isPositive.longValue() > 0L : $this$isPositive.intValue() > 0))));
        }

        @Nullable
        public final String getIdOrNull(@NotNull JSONValue jsonValue) {
            Intrinsics.checkNotNullParameter((Object)jsonValue, (String)"jsonValue");
            JSONValue jSONValue = jsonValue;
            if (!(jSONValue instanceof JSONMapping)) {
                jSONValue = null;
            }
            JSONMapping jSONMapping = (JSONMapping)jSONValue;
            JSONValue jSONValue2 = jSONMapping != null ? (JSONValue)jSONMapping.get((Object)"$id") : null;
            if (!(jSONValue2 instanceof JSONString)) {
                jSONValue2 = null;
            }
            JSONString jSONString = (JSONString)jSONValue2;
            return jSONString != null ? jSONString.getValue() : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

