/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.parser;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.pwall.json.JSONBoolean;
import net.pwall.json.JSONDecimal;
import net.pwall.json.JSONDouble;
import net.pwall.json.JSONFloat;
import net.pwall.json.JSONInteger;
import net.pwall.json.JSONLong;
import net.pwall.json.JSONMapping;
import net.pwall.json.JSONNumberValue;
import net.pwall.json.JSONSequence;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.pointer.JSONPointerException;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.parser.JSONReader;
import net.pwall.json.schema.parser.Parser;
import net.pwall.json.schema.subschema.AdditionalItemsSchema;
import net.pwall.json.schema.subschema.AdditionalPropertiesSchema;
import net.pwall.json.schema.subschema.AllOfSchema;
import net.pwall.json.schema.subschema.AnyOfSchema;
import net.pwall.json.schema.subschema.IfThenElseSchema;
import net.pwall.json.schema.subschema.ItemsArraySchema;
import net.pwall.json.schema.subschema.ItemsSchema;
import net.pwall.json.schema.subschema.OneOfSchema;
import net.pwall.json.schema.subschema.PatternPropertiesSchema;
import net.pwall.json.schema.subschema.PropertiesSchema;
import net.pwall.json.schema.subschema.RefSchema;
import net.pwall.json.schema.subschema.RequiredSchema;
import net.pwall.json.schema.validation.ArrayValidator;
import net.pwall.json.schema.validation.ConstValidator;
import net.pwall.json.schema.validation.DefaultValidator;
import net.pwall.json.schema.validation.DelegatingValidator;
import net.pwall.json.schema.validation.EnumValidator;
import net.pwall.json.schema.validation.FormatValidator;
import net.pwall.json.schema.validation.NumberValidator;
import net.pwall.json.schema.validation.PatternValidator;
import net.pwall.json.schema.validation.StringValidator;
import net.pwall.json.schema.validation.TypeValidator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 L2\u00020\u0001:\u0001LB\u001d\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0004J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J,\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002JT\u0010$\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010%\u001a\u0004\u0018\u00010\u000b2&\u0010&\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150(\u0012\u0004\u0012\u00020\u00150'H\u0002J\"\u0010)\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010*\u001a\u0004\u0018\u00010\u0004H\u0002J$\u0010+\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\tJ$\u0010/\u001a\u0002002\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J\"\u00101\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0002J,\u00102\u001a\u0002032\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J,\u00104\u001a\u0002052\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u0002062\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J$\u00107\u001a\u0002082\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J,\u00109\u001a\u00020:2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J,\u0010;\u001a\u00020<2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J,\u0010=\u001a\u00020>2\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J$\u0010?\u001a\u00020@2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J \u0010A\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010*\u001a\u0004\u0018\u00010\u0004J,\u0010B\u001a\u00020C2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020D2\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J$\u0010E\u001a\u00020F2\u0006\u0010\u0019\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0002J\u000e\u0010G\u001a\u00020\u00152\u0006\u0010H\u001a\u00020\tJ\u000e\u0010I\u001a\u00020J2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010I\u001a\u00020J2\u0006\u0010.\u001a\u00020\tJ\f\u0010K\u001a\u00020\t*\u00020\nH\u0002R>\u0010\u0007\u001a&\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lnet/pwall/json/schema/parser/Parser;", "", "uriResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "(Lkotlin/jvm/functions/Function1;)V", "customValidationHandler", "Lkotlin/Function4;", "", "Lnet/pwall/json/pointer/JSONPointer;", "Lnet/pwall/json/JSONValue;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "getCustomValidationHandler", "()Lkotlin/jvm/functions/Function4;", "setCustomValidationHandler", "(Lkotlin/jvm/functions/Function4;)V", "jsonReader", "Lnet/pwall/json/schema/parser/JSONReader;", "schemaCache", "", "Lnet/pwall/json/schema/JSONSchema;", "checkType", "Lnet/pwall/json/schema/JSONSchema$Type;", "item", "pointer", "parse", "file", "Ljava/io/File;", "uri", "json", "parseArrayNumberOfItems", "Lnet/pwall/json/schema/validation/ArrayValidator;", "condition", "Lnet/pwall/json/schema/validation/ArrayValidator$ValidationType;", "value", "parseCombinationSchema", "array", "creator", "Lkotlin/Function3;", "", "parseDraft07", "parentUri", "parseEnum", "Lnet/pwall/json/schema/validation/EnumValidator;", "parseFile", "filename", "parseFormat", "Lnet/pwall/json/schema/validation/FormatValidator;", "parseIf", "parseItems", "Lnet/pwall/json/schema/JSONSchema$SubSchema;", "parseNumberLimit", "Lnet/pwall/json/schema/validation/NumberValidator;", "Lnet/pwall/json/schema/validation/NumberValidator$ValidationType;", "parsePattern", "Lnet/pwall/json/schema/validation/PatternValidator;", "parsePatternProperties", "Lnet/pwall/json/schema/subschema/PatternPropertiesSchema;", "parseProperties", "Lnet/pwall/json/schema/subschema/PropertiesSchema;", "parseRef", "Lnet/pwall/json/schema/subschema/RefSchema;", "parseRequired", "Lnet/pwall/json/schema/subschema/RequiredSchema;", "parseSchema", "parseStringLength", "Lnet/pwall/json/schema/validation/StringValidator;", "Lnet/pwall/json/schema/validation/StringValidator$ValidationType;", "parseType", "Lnet/pwall/json/schema/validation/TypeValidator;", "parseURI", "uriString", "preLoad", "", "pointerOrRoot", "Companion", "json-kotlin-schema"})
public final class Parser {
    @NotNull
    private Function4<? super String, ? super URI, ? super JSONPointer, ? super JSONValue, ? extends JSONSchema.Validator> customValidationHandler;
    private final JSONReader jsonReader;
    private final Map<URI, JSONSchema> schemaCache;
    @NotNull
    private static final List<String> schemaVersion201909;
    @NotNull
    private static final List<String> schemaVersionDraft07;
    @NotNull
    private static final Function1<URI, InputStream> defaultURIResolver;
    public static final Companion Companion;

    @NotNull
    public final Function4<String, URI, JSONPointer, JSONValue, JSONSchema.Validator> getCustomValidationHandler() {
        return this.customValidationHandler;
    }

    public final void setCustomValidationHandler(@NotNull Function4<? super String, ? super URI, ? super JSONPointer, ? super JSONValue, ? extends JSONSchema.Validator> function4) {
        Intrinsics.checkNotNullParameter(function4, (String)"<set-?>");
        this.customValidationHandler = function4;
    }

    public final void preLoad(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.jsonReader.preLoad(filename);
    }

    public final void preLoad(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.jsonReader.preLoad(file);
    }

    @NotNull
    public final JSONSchema parseFile(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this.parse(new File(filename));
    }

    @NotNull
    public final JSONSchema parseURI(@NotNull String uriString) {
        Intrinsics.checkNotNullParameter((Object)uriString, (String)"uriString");
        return this.parse(new URI(uriString));
    }

    @NotNull
    public final JSONSchema parse(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isFile()) {
            throw (Throwable)((Object)new JSONSchemaException("Invalid file - " + file));
        }
        URI uri = file.toURI();
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema jSONSchema2 = jSONSchema;
            boolean bl = false;
            boolean bl2 = false;
            JSONSchema it = jSONSchema2;
            boolean bl3 = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(file);
        URI uRI = uri;
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri");
        return this.parse(json, uRI);
    }

    @NotNull
    public final JSONSchema parse(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        JSONSchema jSONSchema = this.schemaCache.get(uri);
        if (jSONSchema != null) {
            JSONSchema jSONSchema2 = jSONSchema;
            boolean bl = false;
            boolean bl2 = false;
            JSONSchema it = jSONSchema2;
            boolean bl3 = false;
            return it;
        }
        JSONValue json = this.jsonReader.readJSON(uri);
        return this.parse(json, uri);
    }

    private final JSONSchema parse(JSONValue json, URI uri) {
        JSONSchema jSONSchema;
        String string;
        JSONValue jSONValue = json;
        if (!(jSONValue instanceof JSONMapping)) {
            jSONValue = null;
        }
        JSONMapping jSONMapping = (JSONMapping)jSONValue;
        if (jSONMapping != null) {
            JSONPointer jSONPointer = JSONPointer.root.child("$schema");
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"JSONPointer.root.child(\"\\$schema\")");
            string = Companion.getStringOrNull(jSONMapping, jSONPointer);
        } else {
            string = null;
        }
        String schemaVersion = string;
        JSONPointer pointer = JSONPointer.root;
        String string2 = schemaVersion;
        if (CollectionsKt.contains((Iterable)schemaVersion201909, (Object)string2)) {
            JSONPointer jSONPointer = pointer;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer");
            jSONSchema = this.parseSchema(json, jSONPointer, uri);
        } else if (CollectionsKt.contains((Iterable)schemaVersionDraft07, (Object)string2)) {
            JSONPointer jSONPointer = pointer;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer");
            jSONSchema = this.parseDraft07(json, jSONPointer, uri);
        } else {
            JSONPointer jSONPointer = pointer;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer");
            jSONSchema = this.parseSchema(json, jSONPointer, uri);
        }
        return jSONSchema;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONSchema parseSchema(@NotNull JSONValue json, @NotNull JSONPointer pointer, @Nullable URI parentUri) {
        JSONSchema.General result;
        block35: {
            URI uri;
            URI uRI;
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            JSONValue schemaJSON = pointer.eval(json);
            if (schemaJSON instanceof JSONBoolean) {
                return ((JSONBoolean)schemaJSON).booleanValue() ? (JSONSchema)new JSONSchema.True(parentUri, pointer) : (JSONSchema)new JSONSchema.False(parentUri, pointer);
            }
            if (!(schemaJSON instanceof JSONMapping)) {
                throw (Throwable)((Object)new JSONSchemaException("Schema is not boolean or object - " + this.pointerOrRoot(pointer)));
            }
            String id = Companion.getStringOrNull((JSONMapping)schemaJSON, "$id");
            if (id == null) {
                uRI = parentUri;
            } else if (parentUri == null) {
                uRI = Companion.dropFragment(new URI(id));
            } else {
                URI uRI2 = parentUri.resolve(id);
                Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"parentUri.resolve(id)");
                uRI = Companion.dropFragment(uRI2);
            }
            URI uRI3 = uri = uRI;
            if (uRI3 != null) {
                URI uRI4 = uRI3;
                boolean bl = false;
                boolean bl2 = false;
                URI it = uRI4;
                boolean bl3 = false;
                URI fragmentURI = uri.resolve(pointer.toURIFragment());
                JSONSchema jSONSchema = this.schemaCache.get(fragmentURI);
                if (jSONSchema != null) {
                    JSONSchema jSONSchema2 = jSONSchema;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    JSONSchema it2 = jSONSchema2;
                    boolean bl6 = false;
                    if (it2 instanceof JSONSchema.False) {
                        throw (Throwable)new JSONPointerException("Recursive $ref - " + pointer);
                    }
                    return it2;
                }
                URI uRI5 = fragmentURI;
                Intrinsics.checkNotNullExpressionValue((Object)uRI5, (String)"fragmentURI");
                this.schemaCache.put(uRI5, new JSONSchema.False(uri, pointer));
            }
            String title = Companion.getStringOrNull((JSONMapping)schemaJSON, "title");
            String description = Companion.getStringOrNull((JSONMapping)schemaJSON, "description");
            boolean it = false;
            List children = new ArrayList();
            result = new JSONSchema.General(schemaVersion201909.get(0), title, description, uri, pointer, children);
            Iterator iterator = ((JSONMapping)schemaJSON).entrySet().iterator();
            while (iterator.hasNext()) {
                JSONSchema.Validator validator;
                void key;
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)iterator.next();
                boolean bl = false;
                String string = (String)entry2.getKey();
                entry2 = entry;
                bl = false;
                JSONValue value = (JSONValue)entry2.getValue();
                JSONPointer childPointer = pointer.child((String)key);
                void var16_29 = key;
                if (Intrinsics.areEqual((Object)var16_29, (Object)"$defs") || Intrinsics.areEqual((Object)var16_29, (Object)"then") || Intrinsics.areEqual((Object)var16_29, (Object)"else")) continue;
                if (Intrinsics.areEqual((Object)var16_29, (Object)"$schema") || Intrinsics.areEqual((Object)var16_29, (Object)"$id") || Intrinsics.areEqual((Object)var16_29, (Object)"$comment") || Intrinsics.areEqual((Object)var16_29, (Object)"title") || Intrinsics.areEqual((Object)var16_29, (Object)"description")) {
                    if (value instanceof JSONString) continue;
                    throw (Throwable)((Object)new JSONSchemaException("String expected - " + childPointer));
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"examples")) {
                    if (value instanceof JSONSequence) continue;
                    throw (Throwable)((Object)new JSONSchemaException("Must be array - " + childPointer));
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"$ref")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseRef(json, jSONPointer, uri, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"default")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(new DefaultValidator(uri, jSONPointer, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"allOf")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseCombinationSchema(json, jSONPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AllOfSchema>(JSONSchema.Companion){

                        @NotNull
                        public final AllOfSchema invoke(@Nullable URI p1, @NotNull JSONPointer p2, @NotNull List<? extends JSONSchema> p3) {
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            Intrinsics.checkNotNullParameter(p3, (String)"p3");
                            return ((JSONSchema.Companion)this.receiver).allOf(p1, p2, p3);
                        }
                    })));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"anyOf")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseCombinationSchema(json, jSONPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, AnyOfSchema>(JSONSchema.Companion){

                        @NotNull
                        public final AnyOfSchema invoke(@Nullable URI p1, @NotNull JSONPointer p2, @NotNull List<? extends JSONSchema> p3) {
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            Intrinsics.checkNotNullParameter(p3, (String)"p3");
                            return ((JSONSchema.Companion)this.receiver).anyOf(p1, p2, p3);
                        }
                    })));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"oneOf")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseCombinationSchema(json, jSONPointer, uri, value, (Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema>)((Function3)new Function3<URI, JSONPointer, List<? extends JSONSchema>, OneOfSchema>(JSONSchema.Companion){

                        @NotNull
                        public final OneOfSchema invoke(@Nullable URI p1, @NotNull JSONPointer p2, @NotNull List<? extends JSONSchema> p3) {
                            Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                            Intrinsics.checkNotNullParameter(p3, (String)"p3");
                            return ((JSONSchema.Companion)this.receiver).oneOf(p1, p2, p3);
                        }
                    })));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"not")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    JSONPointer jSONPointer2 = pointer.child("not");
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(\"not\")");
                    children.add(new JSONSchema.Not(uri, jSONPointer, this.parseSchema(json, jSONPointer2, uri)));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"if")) {
                    children.add(this.parseIf(json, pointer, uri));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"type")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseType(jSONPointer, uri, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"enum")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseEnum(jSONPointer, uri, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"const")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(new ConstValidator(uri, jSONPointer, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"properties")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseProperties(json, jSONPointer, uri, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"patternProperties")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parsePatternProperties(json, jSONPointer, uri, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"required")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseRequired(jSONPointer, uri, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"items")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseItems(json, jSONPointer, uri, value));
                    continue;
                }
                if (NumberValidator.Companion.getTypeKeywords().contains(var16_29)) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    void v20 = key;
                    Intrinsics.checkNotNullExpressionValue((Object)v20, (String)"key");
                    children.add(this.parseNumberLimit(jSONPointer, uri, NumberValidator.Companion.findType((String)v20), value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"maxItems")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseArrayNumberOfItems(jSONPointer, uri, ArrayValidator.ValidationType.MAX_ITEMS, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"minItems")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseArrayNumberOfItems(jSONPointer, uri, ArrayValidator.ValidationType.MIN_ITEMS, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"maxLength")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseStringLength(jSONPointer, uri, StringValidator.ValidationType.MAX_LENGTH, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"minLength")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseStringLength(jSONPointer, uri, StringValidator.ValidationType.MIN_LENGTH, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"pattern")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parsePattern(jSONPointer, uri, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"format")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(this.parseFormat(jSONPointer, uri, value));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"additionalProperties")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(new AdditionalPropertiesSchema(result, uri, jSONPointer, this.parseSchema(json, childPointer, uri)));
                    continue;
                }
                if (Intrinsics.areEqual((Object)var16_29, (Object)"additionalItems")) {
                    JSONPointer jSONPointer = childPointer;
                    Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                    children.add(new AdditionalItemsSchema(result, uri, jSONPointer, this.parseSchema(json, childPointer, uri)));
                    continue;
                }
                void v29 = key;
                Intrinsics.checkNotNullExpressionValue((Object)v29, (String)"key");
                JSONPointer jSONPointer = childPointer;
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"childPointer");
                if ((JSONSchema.Validator)this.customValidationHandler.invoke((Object)v29, (Object)uri, (Object)jSONPointer, (Object)value) == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                JSONSchema.Validator it3 = validator;
                boolean bl9 = false;
                children.add(new DelegatingValidator(it3.getUri(), it3.getLocation(), (String)key, it3));
            }
            URI uRI6 = uri;
            if (uRI6 == null) break block35;
            URI uRI7 = uRI6;
            boolean bl = false;
            boolean bl10 = false;
            URI it4 = uRI7;
            boolean bl11 = false;
            URI uRI8 = uri.resolve(pointer.toURIFragment());
            Intrinsics.checkNotNullExpressionValue((Object)uRI8, (String)"uri.resolve(pointer.toURIFragment())");
            this.schemaCache.put(uRI8, result);
        }
        return result;
    }

    private final JSONSchema parseIf(JSONValue json, JSONPointer pointer, URI uri) {
        JSONSchema jSONSchema;
        JSONSchema jSONSchema2;
        JSONPointer jSONPointer = pointer.child("if");
        Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(\"if\")");
        JSONSchema ifSchema = this.parseSchema(json, jSONPointer, uri);
        JSONPointer jSONPointer2 = pointer.child("then");
        boolean bl = false;
        boolean bl2 = false;
        JSONPointer it = jSONPointer2;
        boolean bl3 = false;
        if (it.exists(json)) {
            JSONPointer jSONPointer3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer3, (String)"it");
            jSONSchema2 = this.parseSchema(json, jSONPointer3, uri);
        } else {
            jSONSchema2 = null;
        }
        JSONSchema thenSchema = jSONSchema2;
        JSONPointer jSONPointer4 = pointer.child("else");
        bl2 = false;
        boolean bl4 = false;
        JSONPointer it2 = jSONPointer4;
        boolean bl5 = false;
        if (it2.exists(json)) {
            JSONPointer jSONPointer5 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer5, (String)"it");
            jSONSchema = this.parseSchema(json, jSONPointer5, uri);
        } else {
            jSONSchema = null;
        }
        JSONSchema elseSchema = jSONSchema;
        return new IfThenElseSchema(uri, pointer, ifSchema, thenSchema, elseSchema);
    }

    private final FormatValidator parseFormat(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONString)) {
            throw (Throwable)((Object)new JSONSchemaException("String expected - " + pointer));
        }
        String string = ((JSONString)value).get();
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        if (!FormatValidator.Companion.getTypeKeywords().contains(it)) {
            throw (Throwable)((Object)new JSONSchemaException("Format not recognised - " + it + " - " + pointer));
        }
        String string2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
        return new FormatValidator(uri, pointer, FormatValidator.Companion.findType(string2));
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema parseCombinationSchema(JSONValue json, JSONPointer pointer, URI uri, JSONValue array, Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> creator) {
        Collection<JSONSchema> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!(array instanceof JSONSequence)) {
            throw (Throwable)new JSONPointerException("Compound must take array - " + pointer);
        }
        Iterable iterable = (Iterable)array;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        Function3<? super URI, ? super JSONPointer, ? super List<? extends JSONSchema>, ? extends JSONSchema> function3 = creator;
        boolean $i$f$mapIndexed = false;
        void var8_11 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSONValue jSONValue = (JSONValue)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            JSONPointer jSONPointer2 = pointer.child((int)i);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(i)");
            JSONSchema jSONSchema = this.parseSchema(json, jSONPointer2, uri);
            collection.add(jSONSchema);
        }
        collection = (List)destination$iv$iv;
        return (JSONSchema)function3.invoke((Object)uRI, (Object)jSONPointer, (Object)collection);
    }

    /*
     * WARNING - void declaration
     */
    private final RefSchema parseRef(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        String refPointer;
        void refURIPath;
        JSONValue refJSON;
        String refURIFragment;
        block6: {
            String string;
            block5: {
                if (!(value instanceof JSONString)) {
                    throw (Throwable)new JSONPointerException("$ref must be string - " + pointer);
                }
                String string2 = (uri == null ? new URI(((JSONString)value).get()) : uri.resolve(((JSONString)value).get())).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(if (uri == null) URI(va\u2026(value.get())).toString()");
                String refURIString = string2;
                Pair pair = StringsKt.contains$default((CharSequence)refURIString, (char)'#', (boolean)false, (int)2, null) ? TuplesKt.to((Object)StringsKt.substringBefore$default((String)refURIString, (char)'#', null, (int)2, null), (Object)StringsKt.substringAfter$default((String)refURIString, (char)'#', null, (int)2, null)) : TuplesKt.to((Object)refURIString, null);
                String string3 = (String)pair.component1();
                refURIFragment = (String)pair.component2();
                JSONValue jSONValue = refJSON = Intrinsics.areEqual((Object)refURIPath, (Object)String.valueOf(uri)) ? json : this.jsonReader.readJSON(new URI((String)(StringsKt.endsWith$default((CharSequence)((CharSequence)refURIPath), (char)'/', (boolean)false, (int)2, null) ? StringsKt.dropLast((String)refURIPath, (int)1) : refURIPath)));
                string = refURIFragment;
                if (string == null) break block5;
                String string4 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string4;
                boolean bl3 = false;
                string = JSONPointer.fromURIFragment((String)('#' + it));
                if (string != null) break block6;
            }
            string = refPointer = JSONPointer.root;
        }
        if (!refPointer.exists(refJSON)) {
            throw (Throwable)((Object)new JSONSchemaException("$ref not found " + value + " - " + pointer));
        }
        String string = refPointer;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"refPointer");
        JSONSchema target = this.parseSchema(refJSON, (JSONPointer)string, new URI((String)refURIPath));
        return new RefSchema(uri, pointer, target, refURIFragment);
    }

    /*
     * WARNING - void declaration
     */
    private final JSONSchema.SubSchema parseItems(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        JSONSchema.SubSchema subSchema;
        if (value instanceof JSONSequence) {
            Collection<JSONSchema> collection;
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Iterable iterable = (Iterable)value;
            JSONPointer jSONPointer = pointer;
            URI uRI = uri;
            boolean $i$f$mapIndexed = false;
            void var7_9 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JSONValue jSONValue = (JSONValue)item$iv$iv;
                int n2 = n;
                collection = destination$iv$iv;
                boolean bl2 = false;
                JSONPointer jSONPointer2 = pointer.child((int)i);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(i)");
                JSONSchema jSONSchema = this.parseSchema(json, jSONPointer2, uri);
                collection.add(jSONSchema);
            }
            collection = (List)destination$iv$iv;
            List list = collection;
            JSONPointer jSONPointer3 = jSONPointer;
            URI uRI2 = uRI;
            subSchema = new ItemsArraySchema(uRI2, jSONPointer3, list);
        } else {
            subSchema = new ItemsSchema(uri, pointer, this.parseSchema(json, pointer, uri));
        }
        return subSchema;
    }

    /*
     * WARNING - void declaration
     */
    private final PropertiesSchema parseProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(value instanceof JSONMapping)) {
            throw (Throwable)((Object)new JSONSchemaException("properties must be object - " + pointer));
        }
        Set set = ((JSONMapping)value).keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value.keys");
        Iterable iterable = set;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JSONPointer jSONPointer2 = pointer.child((String)it);
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"pointer.child(it)");
            Pair pair = TuplesKt.to((Object)it, (Object)this.parseSchema(json, jSONPointer2, uri));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer3 = jSONPointer;
        URI uRI2 = uRI;
        return new PropertiesSchema(uRI2, jSONPointer3, list);
    }

    /*
     * WARNING - void declaration
     */
    private final PatternPropertiesSchema parsePatternProperties(JSONValue json, JSONPointer pointer, URI uri, JSONValue value) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (!(value instanceof JSONMapping)) {
            throw (Throwable)((Object)new JSONSchemaException("patternProperties must be object - " + pointer));
        }
        Set set = ((JSONMapping)value).keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"value.keys");
        Iterable iterable = set;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Regex regex;
            void key;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            JSONPointer childPointer = pointer.child((String)key);
            try {
                void v1 = key;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"key");
                regex = new Regex((String)v1);
            }
            catch (Exception e) {
                throw (Throwable)((Object)new JSONSchemaException("Invalid regex in patternProperties - " + childPointer));
            }
            Regex regex2 = regex;
            JSONPointer jSONPointer2 = childPointer;
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer2, (String)"childPointer");
            Pair pair = TuplesKt.to((Object)regex2, (Object)this.parseSchema(json, jSONPointer2, uri));
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer3 = jSONPointer;
        URI uRI2 = uRI;
        return new PatternPropertiesSchema(uRI2, jSONPointer3, list);
    }

    /*
     * WARNING - void declaration
     */
    private final RequiredSchema parseRequired(JSONPointer pointer, URI uri, JSONValue value) {
        Collection<String> collection;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        if (!(value instanceof JSONSequence)) {
            throw (Throwable)((Object)new JSONSchemaException("required must be array - " + this.pointerOrRoot(pointer)));
        }
        Iterable iterable = (Iterable)value;
        JSONPointer jSONPointer = pointer;
        URI uRI = uri;
        boolean $i$f$mapIndexed = false;
        void var6_8 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void entry;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            JSONValue jSONValue = (JSONValue)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            if (!(entry instanceof JSONString)) {
                void i;
                throw (Throwable)((Object)new JSONSchemaException("required items must be string - " + pointer.child((int)i)));
            }
            String string = ((JSONString)entry).get();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        List list = collection;
        JSONPointer jSONPointer2 = jSONPointer;
        URI uRI2 = uRI;
        return new RequiredSchema(uRI2, jSONPointer2, list);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeValidator parseType(JSONPointer pointer, URI uri, JSONValue value) {
        List list;
        JSONValue jSONValue = value;
        if (jSONValue instanceof JSONString) {
            list = CollectionsKt.listOf((Object)((Object)this.checkType(value, pointer)));
        } else if (jSONValue instanceof JSONSequence) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = (Iterable)value;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void item;
                void index;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                JSONValue jSONValue2 = (JSONValue)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                JSONPointer jSONPointer = pointer.child((int)index);
                Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"pointer.child(index)");
                JSONSchema.Type type = this.checkType((JSONValue)item, jSONPointer);
                collection.add(type);
            }
            list = (List)destination$iv$iv;
        } else {
            throw (Throwable)((Object)new JSONSchemaException("Invalid type " + pointer));
        }
        List types = list;
        return new TypeValidator(uri, pointer, types);
    }

    private final JSONSchema.Type checkType(JSONValue item, JSONPointer pointer) {
        if (item instanceof JSONString) {
            for (JSONSchema.Type type : JSONSchema.Type.values()) {
                if (!Intrinsics.areEqual((Object)((JSONString)item).get(), (Object)type.getValue())) continue;
                return type;
            }
        }
        throw (Throwable)((Object)new JSONSchemaException("Invalid type " + pointer));
    }

    private final EnumValidator parseEnum(JSONPointer pointer, URI uri, JSONValue value) {
        if (!(value instanceof JSONSequence)) {
            throw (Throwable)((Object)new JSONSchemaException("enum must be array - " + this.pointerOrRoot(pointer)));
        }
        return new EnumValidator(uri, pointer, (JSONSequence)value);
    }

    private final NumberValidator parseNumberLimit(JSONPointer pointer, URI uri, NumberValidator.ValidationType condition, JSONValue value) {
        Number number;
        Number number2;
        if (!(value instanceof JSONNumberValue)) {
            throw (Throwable)((Object)new JSONSchemaException("Must be number (was " + JSONSchema.Companion.toErrorDisplay(value) + ") - " + this.pointerOrRoot(pointer)));
        }
        JSONValue jSONValue = value;
        if (jSONValue instanceof JSONDouble || jSONValue instanceof JSONFloat || jSONValue instanceof JSONDecimal) {
            BigDecimal bigDecimal = ((JSONNumberValue)value).bigDecimalValue();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"value.bigDecimalValue()");
            number2 = bigDecimal;
        } else {
            number2 = number = jSONValue instanceof JSONLong ? (Number)((JSONNumberValue)value).longValue() : (Number)((JSONNumberValue)value).intValue();
        }
        if (condition == NumberValidator.ValidationType.MULTIPLE_OF && !Companion.isPositive(number)) {
            throw (Throwable)((Object)new JSONSchemaException("multipleOf must be greater than 0 - " + this.pointerOrRoot(pointer)));
        }
        return new NumberValidator(uri, pointer, number, condition);
    }

    private final StringValidator parseStringLength(JSONPointer pointer, URI uri, StringValidator.ValidationType condition, JSONValue value) {
        if (!(value instanceof JSONInteger)) {
            throw (Throwable)((Object)new JSONSchemaException("Must be integer - " + this.pointerOrRoot(pointer)));
        }
        return new StringValidator(uri, pointer, condition, ((JSONInteger)value).get());
    }

    private final ArrayValidator parseArrayNumberOfItems(JSONPointer pointer, URI uri, ArrayValidator.ValidationType condition, JSONValue value) {
        if (!(value instanceof JSONInteger)) {
            throw (Throwable)((Object)new JSONSchemaException("Must be integer - " + this.pointerOrRoot(pointer)));
        }
        return new ArrayValidator(uri, pointer, condition, ((JSONInteger)value).get());
    }

    private final PatternValidator parsePattern(JSONPointer pointer, URI uri, JSONValue value) {
        Regex regex;
        if (!(value instanceof JSONString)) {
            throw (Throwable)((Object)new JSONSchemaException("Must be string - " + this.pointerOrRoot(pointer)));
        }
        try {
            String string = ((JSONString)value).get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value.get()");
            regex = new Regex(string);
        }
        catch (Exception e) {
            throw (Throwable)((Object)new JSONSchemaException("Pattern invalid (" + JSONSchema.Companion.toErrorDisplay(value) + ") - " + this.pointerOrRoot(pointer)));
        }
        Regex regex2 = regex;
        return new PatternValidator(uri, pointer, regex2);
    }

    private final String pointerOrRoot(JSONPointer $this$pointerOrRoot) {
        String string;
        if (Intrinsics.areEqual((Object)$this$pointerOrRoot, (Object)JSONPointer.root)) {
            string = "root";
        } else {
            String string2 = $this$pointerOrRoot.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        }
        return string;
    }

    private final JSONSchema parseDraft07(JSONValue json, JSONPointer pointer, URI parentUri) {
        return this.parseSchema(json, pointer, parentUri);
    }

    public Parser(@NotNull Function1<? super URI, ? extends InputStream> uriResolver) {
        Intrinsics.checkNotNullParameter(uriResolver, (String)"uriResolver");
        this.customValidationHandler = customValidationHandler.1.INSTANCE;
        this.jsonReader = new JSONReader(uriResolver);
        boolean bl = false;
        this.schemaCache = new LinkedHashMap();
    }

    public /* synthetic */ Parser(Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function1 = defaultURIResolver;
        }
        this(function1);
    }

    public Parser() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        schemaVersion201909 = CollectionsKt.listOf((Object[])new String[]{"http://json-schema.org/draft/2019-09/schema", "https://json-schema.org/draft/2019-09/schema"});
        schemaVersionDraft07 = CollectionsKt.listOf((Object[])new String[]{"http://json-schema.org/draft-07/schema", "https://json-schema.org/draft-07/schema"});
        defaultURIResolver = Companion.defaultURIResolver.1.INSTANCE;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0010\u0004\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0012\u001a\u00020\u0005*\u00020\u0005J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0019\u001a\u00020\u000bJ\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u000b*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\n\u0010\u001a\u001a\u00020\u001b*\u00020\u001cJ\n\u0010\u001d\u001a\u00020\u001b*\u00020\u001cR\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0002\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\u0002\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lnet/pwall/json/schema/parser/Parser$Companion;", "", "()V", "defaultURIResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "getDefaultURIResolver", "()Lkotlin/jvm/functions/Function1;", "schemaVersion201909", "", "", "getSchemaVersion201909$annotations", "getSchemaVersion201909", "()Ljava/util/List;", "schemaVersionDraft07", "getSchemaVersionDraft07$annotations", "getSchemaVersionDraft07", "dropFragment", "getStringOrDefault", "Lnet/pwall/json/JSONMapping;", "pointer", "Lnet/pwall/json/pointer/JSONPointer;", "default", "getStringOrNull", "key", "isPositive", "", "", "isZero", "json-kotlin-schema"})
    public static final class Companion {
        public static /* synthetic */ void getSchemaVersion201909$annotations() {
        }

        @NotNull
        public final List<String> getSchemaVersion201909() {
            return schemaVersion201909;
        }

        public static /* synthetic */ void getSchemaVersionDraft07$annotations() {
        }

        @NotNull
        public final List<String> getSchemaVersionDraft07() {
            return schemaVersionDraft07;
        }

        @NotNull
        public final Function1<URI, InputStream> getDefaultURIResolver() {
            return defaultURIResolver;
        }

        @NotNull
        public final URI dropFragment(@NotNull URI $this$dropFragment) {
            Intrinsics.checkNotNullParameter((Object)$this$dropFragment, (String)"$this$dropFragment");
            String string = $this$dropFragment.toString();
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            String string2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
            return StringsKt.contains$default((CharSequence)string2, (char)'#', (boolean)false, (int)2, null) ? new URI(StringsKt.substringBefore$default((String)it, (char)'#', null, (int)2, null)) : $this$dropFragment;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Nullable
        public final String getStringOrNull(@NotNull JSONMapping<?> $this$getStringOrNull, @NotNull String key) {
            Intrinsics.checkNotNullParameter($this$getStringOrNull, (String)"$this$getStringOrNull");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            JSONValue jSONValue = (JSONValue)$this$getStringOrNull.get((Object)key);
            if (jSONValue == null) return null;
            JSONValue jSONValue2 = jSONValue;
            boolean bl = false;
            boolean bl2 = false;
            JSONValue it = jSONValue2;
            boolean bl3 = false;
            if (!(it instanceof JSONString)) throw (Throwable)((Object)new JSONSchemaException("Incorrect " + key));
            String string = ((JSONString)it).get();
            return string;
        }

        @Nullable
        public final String getStringOrNull(@NotNull JSONMapping<?> $this$getStringOrNull, @NotNull JSONPointer pointer) {
            Intrinsics.checkNotNullParameter($this$getStringOrNull, (String)"$this$getStringOrNull");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (!pointer.exists((JSONValue)$this$getStringOrNull)) {
                return null;
            }
            JSONValue value = pointer.eval((JSONValue)$this$getStringOrNull);
            if (!(value instanceof JSONString)) {
                throw (Throwable)((Object)new JSONSchemaException("Incorrect " + pointer));
            }
            return ((JSONString)value).get();
        }

        @Nullable
        public final String getStringOrDefault(@NotNull JSONMapping<?> $this$getStringOrDefault, @NotNull JSONPointer pointer, @Nullable String string) {
            Intrinsics.checkNotNullParameter($this$getStringOrDefault, (String)"$this$getStringOrDefault");
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            if (!pointer.exists((JSONValue)$this$getStringOrDefault)) {
                return string;
            }
            JSONValue value = pointer.eval((JSONValue)$this$getStringOrDefault);
            if (!(value instanceof JSONString)) {
                throw (Throwable)((Object)new JSONSchemaException("Incorrect " + pointer));
            }
            return ((JSONString)value).get();
        }

        public final boolean isZero(@NotNull Number $this$isZero) {
            Intrinsics.checkNotNullParameter((Object)$this$isZero, (String)"$this$isZero");
            Number number = $this$isZero;
            return number instanceof BigDecimal ? Intrinsics.areEqual((Object)$this$isZero, (Object)BigDecimal.ZERO) : (number instanceof BigInteger ? Intrinsics.areEqual((Object)$this$isZero, (Object)BigInteger.ZERO) : (number instanceof Double ? $this$isZero.doubleValue() == 0.0 : (number instanceof Float ? $this$isZero.floatValue() == 0.0f : (number instanceof Long ? Intrinsics.areEqual((Object)$this$isZero, (Object)0L) : $this$isZero.intValue() == 0))));
        }

        public final boolean isPositive(@NotNull Number $this$isPositive) {
            Intrinsics.checkNotNullParameter((Object)$this$isPositive, (String)"$this$isPositive");
            Number number = $this$isPositive;
            return number instanceof BigDecimal ? ((BigDecimal)$this$isPositive).compareTo(BigDecimal.ZERO) > 0 : (number instanceof BigInteger ? ((BigInteger)$this$isPositive).compareTo(BigInteger.ZERO) > 0 : (number instanceof Double ? $this$isPositive.doubleValue() > 0.0 : (number instanceof Float ? $this$isPositive.floatValue() > 0.0f : (number instanceof Long ? $this$isPositive.longValue() > 0L : $this$isPositive.intValue() > 0))));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

