/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.parser;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.pwall.json.JSON;
import net.pwall.json.JSONMapping;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchemaException;
import net.pwall.json.schema.parser.Parser;
import net.pwall.yaml.YAMLNode;
import net.pwall.yaml.YAMLSimple;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0004J\f\u0010\u0014\u001a\u00020\r*\u00020\tH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnet/pwall/json/schema/parser/JSONReader;", "", "uriResolver", "Lkotlin/Function1;", "Ljava/net/URI;", "Ljava/io/InputStream;", "(Lkotlin/jvm/functions/Function1;)V", "jsonCache", "", "Lnet/pwall/json/JSONValue;", "getUriResolver", "()Lkotlin/jvm/functions/Function1;", "preLoad", "", "file", "Ljava/io/File;", "filename", "", "readJSON", "uri", "cacheByURI", "json-kotlin-schema"})
public final class JSONReader {
    private final Map<URI, JSONValue> jsonCache;
    @NotNull
    private final Function1<URI, InputStream> uriResolver;

    public final void preLoad(@NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        this.preLoad(new File(filename));
    }

    public final void preLoad(@NotNull File file) {
        block3: {
            block4: {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    if (!file.isDirectory()) break block2;
                    File[] fileArray = file.listFiles();
                    if (fileArray == null) break block3;
                    File[] $this$forEach$iv = fileArray;
                    boolean $i$f$forEach = false;
                    File[] fileArray2 = $this$forEach$iv;
                    int n = fileArray2.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File it = element$iv = fileArray2[i];
                        boolean bl = false;
                        File file2 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it");
                        String string = file2.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        if (StringsKt.startsWith$default((CharSequence)string, (char)'.', (boolean)false, (int)2, null)) continue;
                        this.preLoad(it);
                    }
                    break block3;
                }
                if (!file.isFile()) break block3;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (!StringsKt.endsWith((String)string, (String)".json", (boolean)true)) break block4;
                JSONValue jSONValue = JSON.parse((File)file);
                if (jSONValue == null) break block3;
                JSONValue jSONValue2 = jSONValue;
                boolean bl = false;
                boolean bl2 = false;
                JSONValue it = jSONValue2;
                boolean bl3 = false;
                URI uRI = file.toURI();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"file.toURI()");
                this.jsonCache.put(uRI, it);
                this.cacheByURI(it);
                break block3;
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            if (!StringsKt.endsWith((String)string, (String)".yaml", (boolean)true)) break block3;
            YAMLNode yAMLNode = YAMLSimple.INSTANCE.process(file).getRootNode();
            if (yAMLNode != null) {
                YAMLNode yAMLNode2 = yAMLNode;
                boolean bl = false;
                boolean bl4 = false;
                YAMLNode it = yAMLNode2;
                boolean bl5 = false;
                URI uRI = file.toURI();
                Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"file.toURI()");
                this.jsonCache.put(uRI, (JSONValue)it);
                this.cacheByURI((JSONValue)it);
            }
        }
    }

    @NotNull
    public final JSONValue readJSON(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        URI uri = file.toURI();
        JSONValue jSONValue = this.jsonCache.get(uri);
        if (jSONValue == null) {
            JSONValue jSONValue2;
            try {
                JSONValue jSONValue3;
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                if (StringsKt.endsWith((String)string, (String)".yaml", (boolean)true)) {
                    YAMLNode yAMLNode = YAMLSimple.INSTANCE.process(file).getRootNode();
                    if (yAMLNode == null) {
                        throw (Throwable)((Object)new JSONSchemaException("Schema file is null - " + file));
                    }
                    jSONValue3 = (JSONValue)yAMLNode;
                } else {
                    jSONValue3 = JSON.parse((File)file);
                    if (jSONValue3 == null) {
                        throw (Throwable)((Object)new JSONSchemaException("Schema file is null - " + file));
                    }
                }
                jSONValue2 = jSONValue3;
            }
            catch (Exception e) {
                throw (Throwable)((Object)new JSONSchemaException("Error reading schema file - " + file, e));
            }
            boolean bl = false;
            boolean bl2 = false;
            JSONValue it = jSONValue2;
            boolean bl3 = false;
            URI uRI = uri;
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"uri");
            this.jsonCache.put(uRI, it);
            this.cacheByURI(it);
            jSONValue = jSONValue2;
        }
        return jSONValue;
    }

    @NotNull
    public final JSONValue readJSON(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        JSONValue jSONValue = this.jsonCache.get(uri);
        if (jSONValue == null) {
            JSONValue jSONValue2;
            try {
                JSONValue jSONValue3;
                InputStream inputStream = (InputStream)this.uriResolver.invoke((Object)uri);
                if (inputStream == null) {
                    throw (Throwable)((Object)new JSONSchemaException("Can't resolve name - " + uri));
                }
                InputStream inputStream2 = inputStream;
                String string = uri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.path");
                if (StringsKt.endsWith((String)string, (String)".yaml", (boolean)true)) {
                    YAMLNode yAMLNode = YAMLSimple.INSTANCE.process(inputStream2).getRootNode();
                    if (yAMLNode == null) {
                        throw (Throwable)((Object)new JSONSchemaException("Schema file is null - " + uri));
                    }
                    jSONValue3 = (JSONValue)yAMLNode;
                } else {
                    jSONValue3 = JSON.parse((InputStream)inputStream2);
                    if (jSONValue3 == null) {
                        throw (Throwable)((Object)new JSONSchemaException("Schema file is null - " + uri));
                    }
                }
                jSONValue2 = jSONValue3;
            }
            catch (Exception e) {
                throw (Throwable)((Object)new JSONSchemaException("Error reading schema file - " + uri, e));
            }
            boolean bl = false;
            boolean bl2 = false;
            JSONValue it = jSONValue2;
            boolean bl3 = false;
            this.jsonCache.put(uri, it);
            this.cacheByURI(it);
            jSONValue = jSONValue2;
        }
        return jSONValue;
    }

    private final void cacheByURI(JSONValue $this$cacheByURI) {
        block1: {
            if (!($this$cacheByURI instanceof JSONMapping)) break block1;
            JSONMapping jSONMapping = (JSONMapping)$this$cacheByURI;
            JSONPointer jSONPointer = JSONPointer.root.child("$id");
            Intrinsics.checkNotNullExpressionValue((Object)jSONPointer, (String)"JSONPointer.root.child(\"\\$id\")");
            String string = Parser.Companion.getStringOrNull(jSONMapping, jSONPointer);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                this.jsonCache.put(Parser.Companion.dropFragment(new URI(it)), $this$cacheByURI);
            }
        }
    }

    @NotNull
    public final Function1<URI, InputStream> getUriResolver() {
        return this.uriResolver;
    }

    public JSONReader(@NotNull Function1<? super URI, ? extends InputStream> uriResolver) {
        Intrinsics.checkNotNullParameter(uriResolver, (String)"uriResolver");
        this.uriResolver = uriResolver;
        boolean bl = false;
        this.jsonCache = new LinkedHashMap();
    }
}

