/*
 * Decompiled with CFR 0.152.
 */
package net.pwall.json.schema.validation;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import net.pwall.json.JSONString;
import net.pwall.json.JSONValue;
import net.pwall.json.pointer.JSONPointer;
import net.pwall.json.schema.JSONSchema;
import net.pwall.json.schema.output.Output;
import net.pwall.json.schema.validation.FormatValidator$WhenMappings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator;", "Lnet/pwall/json/schema/JSONSchema$Validator;", "uri", "Ljava/net/URI;", "location", "Lnet/pwall/json/pointer/JSONPointer;", "type", "Lnet/pwall/json/schema/validation/FormatValidator$FormatType;", "(Ljava/net/URI;Lnet/pwall/json/pointer/JSONPointer;Lnet/pwall/json/schema/validation/FormatValidator$FormatType;)V", "childLocation", "pointer", "validate", "Lnet/pwall/json/schema/output/Output;", "relativeLocation", "json", "Lnet/pwall/json/JSONValue;", "instanceLocation", "Companion", "FormatType", "json-kotlin-schema"})
public final class FormatValidator
extends JSONSchema.Validator {
    private final FormatType type;
    @NotNull
    private static final List<String> typeKeywords;
    public static final Companion Companion;

    @Override
    @NotNull
    public JSONPointer childLocation(@NotNull JSONPointer pointer) {
        Intrinsics.checkParameterIsNotNull((Object)pointer, (String)"pointer");
        return pointer.child("format");
    }

    @Override
    @NotNull
    public Output validate(@NotNull JSONPointer relativeLocation, @Nullable JSONValue json, @NotNull JSONPointer instanceLocation) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)relativeLocation, (String)"relativeLocation");
        Intrinsics.checkParameterIsNotNull((Object)instanceLocation, (String)"instanceLocation");
        JSONValue instance = instanceLocation.eval(json);
        if (!(instance instanceof JSONString)) {
            return JSONSchema.Companion.getTrueOutput();
        }
        String str = ((JSONString)instance).get();
        switch (FormatValidator$WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                String string = str;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str");
                bl = Companion.isValidDateTime(string);
                break;
            }
            case 2: {
                String string = str;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str");
                bl = Companion.isValidDate(string);
                break;
            }
            case 3: {
                String string = str;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str");
                bl = Companion.isValidTime(string);
                break;
            }
            case 4: {
                String string = str;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str");
                bl = Companion.isValidDuration(string);
                break;
            }
            case 5: {
                bl = true;
                break;
            }
            case 6: {
                bl = true;
                break;
            }
            case 7: {
                bl = true;
                break;
            }
            case 8: {
                bl = true;
                break;
            }
            case 9: {
                bl = true;
                break;
            }
            case 10: {
                bl = true;
                break;
            }
            case 11: {
                String string = str;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str");
                bl = Companion.isValidURI(string);
                break;
            }
            case 12: {
                bl = true;
                break;
            }
            case 13: {
                bl = true;
                break;
            }
            case 14: {
                bl = true;
                break;
            }
            case 15: {
                String string = str;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str");
                bl = Companion.isValidUUID(string);
                break;
            }
            case 16: {
                bl = true;
                break;
            }
            case 17: {
                String string = str;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str");
                bl = Companion.isValidJSONPointer(string);
                break;
            }
            case 18: {
                bl = true;
                break;
            }
            case 19: {
                String string = str;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"str");
                bl = Companion.isValidRegex(string);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean result = bl;
        return result ? JSONSchema.Companion.getTrueOutput() : (Output)JSONSchema.createError$default(this, relativeLocation, instanceLocation, "String fails format check: " + this.type.getKeyword() + ", was " + str, null, null, 24, null);
    }

    public FormatValidator(@Nullable URI uri, @NotNull JSONPointer location, @NotNull FormatType type) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        super(uri, location);
        this.type = type;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        FormatType[] $this$map$iv = FormatType.values();
        boolean $i$f$map = false;
        FormatType[] formatTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var5_5 = $this$mapTo$iv$iv;
        int n = ((void)var5_5).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = var5_5[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getKeyword();
            collection.add(string);
        }
        typeKeywords = (List)var3_3;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$FormatType;", "", "keyword", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getKeyword", "()Ljava/lang/String;", "DATE_TIME", "DATE", "TIME", "DURATION", "EMAIL", "IDN_EMAIL", "HOSTNAME", "IDN_HOSTNAME", "IPV4", "IPV6", "URI", "URI_REFERENCE", "IRI", "IRI_REFERENCE", "UUID", "URI_TEMPLATE", "JSON_POINTER", "RELATIVE_JSON_POINTER", "REGEX", "json-kotlin-schema"})
    public static final class FormatType
    extends Enum<FormatType> {
        public static final /* enum */ FormatType DATE_TIME;
        public static final /* enum */ FormatType DATE;
        public static final /* enum */ FormatType TIME;
        public static final /* enum */ FormatType DURATION;
        public static final /* enum */ FormatType EMAIL;
        public static final /* enum */ FormatType IDN_EMAIL;
        public static final /* enum */ FormatType HOSTNAME;
        public static final /* enum */ FormatType IDN_HOSTNAME;
        public static final /* enum */ FormatType IPV4;
        public static final /* enum */ FormatType IPV6;
        public static final /* enum */ FormatType URI;
        public static final /* enum */ FormatType URI_REFERENCE;
        public static final /* enum */ FormatType IRI;
        public static final /* enum */ FormatType IRI_REFERENCE;
        public static final /* enum */ FormatType UUID;
        public static final /* enum */ FormatType URI_TEMPLATE;
        public static final /* enum */ FormatType JSON_POINTER;
        public static final /* enum */ FormatType RELATIVE_JSON_POINTER;
        public static final /* enum */ FormatType REGEX;
        private static final /* synthetic */ FormatType[] $VALUES;
        @NotNull
        private final String keyword;

        static {
            FormatType[] formatTypeArray = new FormatType[19];
            FormatType[] formatTypeArray2 = formatTypeArray;
            formatTypeArray[0] = DATE_TIME = new FormatType("date-time");
            formatTypeArray[1] = DATE = new FormatType("date");
            formatTypeArray[2] = TIME = new FormatType("time");
            formatTypeArray[3] = DURATION = new FormatType("duration");
            formatTypeArray[4] = EMAIL = new FormatType("email");
            formatTypeArray[5] = IDN_EMAIL = new FormatType("idn-email");
            formatTypeArray[6] = HOSTNAME = new FormatType("hostname");
            formatTypeArray[7] = IDN_HOSTNAME = new FormatType("idn-hostname");
            formatTypeArray[8] = IPV4 = new FormatType("ipv4");
            formatTypeArray[9] = IPV6 = new FormatType("ipv6");
            formatTypeArray[10] = URI = new FormatType("uri");
            formatTypeArray[11] = URI_REFERENCE = new FormatType("uri-reference");
            formatTypeArray[12] = IRI = new FormatType("iri");
            formatTypeArray[13] = IRI_REFERENCE = new FormatType("iri-reference");
            formatTypeArray[14] = UUID = new FormatType("uuid");
            formatTypeArray[15] = URI_TEMPLATE = new FormatType("uri-template");
            formatTypeArray[16] = JSON_POINTER = new FormatType("json-pointer");
            formatTypeArray[17] = RELATIVE_JSON_POINTER = new FormatType("relative-json-pointer");
            formatTypeArray[18] = REGEX = new FormatType("regex");
            $VALUES = formatTypeArray;
        }

        @NotNull
        public final String getKeyword() {
            return this.keyword;
        }

        private FormatType(String keyword) {
            this.keyword = keyword;
        }

        public static FormatType[] values() {
            return (FormatType[])$VALUES.clone();
        }

        public static FormatType valueOf(String string) {
            return Enum.valueOf(FormatType.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\n\u0010\u000b\u001a\u00020\f*\u00020\u0005J\n\u0010\r\u001a\u00020\f*\u00020\u0005J\n\u0010\u000e\u001a\u00020\f*\u00020\u0005J\n\u0010\u000f\u001a\u00020\f*\u00020\u0005J\n\u0010\u0010\u001a\u00020\f*\u00020\u0005J\n\u0010\u0011\u001a\u00020\f*\u00020\u0005J\n\u0010\u0012\u001a\u00020\f*\u00020\u0005J\n\u0010\u0013\u001a\u00020\f*\u00020\u0005R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lnet/pwall/json/schema/validation/FormatValidator$Companion;", "", "()V", "typeKeywords", "", "", "getTypeKeywords", "()Ljava/util/List;", "findType", "Lnet/pwall/json/schema/validation/FormatValidator$FormatType;", "keyword", "isValidDate", "", "isValidDateTime", "isValidDuration", "isValidJSONPointer", "isValidRegex", "isValidTime", "isValidURI", "isValidUUID", "json-kotlin-schema"})
    public static final class Companion {
        public final boolean isValidDateTime(@NotNull String $this$isValidDateTime) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)$this$isValidDateTime, (String)"$this$isValidDateTime");
            try {
                DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse($this$isValidDateTime);
                bl = true;
            }
            catch (DateTimeParseException ignored) {
                bl = false;
            }
            return bl;
        }

        public final boolean isValidDate(@NotNull String $this$isValidDate) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)$this$isValidDate, (String)"$this$isValidDate");
            try {
                DateTimeFormatter.ISO_LOCAL_DATE.parse($this$isValidDate);
                bl = true;
            }
            catch (DateTimeParseException ignored) {
                bl = false;
            }
            return bl;
        }

        public final boolean isValidTime(@NotNull String $this$isValidTime) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)$this$isValidTime, (String)"$this$isValidTime");
            try {
                DateTimeFormatter.ISO_OFFSET_TIME.parse($this$isValidTime);
                bl = true;
            }
            catch (DateTimeParseException ignored) {
                bl = false;
            }
            return bl;
        }

        public final boolean isValidDuration(@NotNull String $this$isValidDuration) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)$this$isValidDuration, (String)"$this$isValidDuration");
            try {
                Duration.parse($this$isValidDuration);
                bl = true;
            }
            catch (DateTimeParseException ignored) {
                bl = false;
            }
            return bl;
        }

        public final boolean isValidURI(@NotNull String $this$isValidURI) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)$this$isValidURI, (String)"$this$isValidURI");
            try {
                new URI($this$isValidURI);
                bl = true;
            }
            catch (URISyntaxException ignored) {
                bl = false;
            }
            return bl;
        }

        public final boolean isValidUUID(@NotNull String $this$isValidUUID) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)$this$isValidUUID, (String)"$this$isValidUUID");
            try {
                UUID.fromString($this$isValidUUID);
                bl = true;
            }
            catch (Exception ignored) {
                bl = false;
            }
            return bl;
        }

        public final boolean isValidJSONPointer(@NotNull String $this$isValidJSONPointer) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)$this$isValidJSONPointer, (String)"$this$isValidJSONPointer");
            try {
                new JSONPointer($this$isValidJSONPointer);
                bl = true;
            }
            catch (Exception ignored) {
                bl = false;
            }
            return bl;
        }

        public final boolean isValidRegex(@NotNull String $this$isValidRegex) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)$this$isValidRegex, (String)"$this$isValidRegex");
            try {
                new Regex($this$isValidRegex);
                bl = true;
            }
            catch (Exception ignored) {
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final List<String> getTypeKeywords() {
            return typeKeywords;
        }

        @NotNull
        public final FormatType findType(@NotNull String keyword) {
            Intrinsics.checkParameterIsNotNull((Object)keyword, (String)"keyword");
            FormatType[] $this$forEach$iv = FormatType.values();
            boolean $i$f$forEach = false;
            FormatType[] formatTypeArray = $this$forEach$iv;
            int n = formatTypeArray.length;
            for (int i = 0; i < n; ++i) {
                FormatType element$iv;
                FormatType it = element$iv = formatTypeArray[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKeyword(), (Object)keyword)) continue;
                return it;
            }
            throw (Throwable)new RuntimeException("Can't find format type - should not happen");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

