/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import java.net.HttpURLConnection;
import java.net.URL;

public class URLDriller {
    private static final String TAG = URLDriller.class.getSimpleName();
    private String mUserAgent = null;
    private int mDrillSize = 0;
    protected Listener mListener;
    protected Handler mHandler;

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void setUserAgent(String userAgent) {
        this.mUserAgent = userAgent;
    }

    public void setDrillSize(int drillSize) {
        this.mDrillSize = drillSize;
    }

    public void drill(final String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.invokeFail(url, new IllegalArgumentException("URLDrill error: url is null or empty"));
        } else {
            this.mHandler = new Handler(Looper.getMainLooper());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    URLDriller.this.invokeStart(url);
                    URLDriller.this.doDrill(url);
                }
            }).start();
        }
    }

    protected void doDrill(String url) {
        this.doDrill(url, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDrill(String url, int counter) {
        Log.v((String)TAG, (String)("doDrill: " + url));
        HttpURLConnection connection = null;
        try {
            URL urlObj = new URL(url);
            connection = (HttpURLConnection)urlObj.openConnection();
            if (this.mUserAgent != null) {
                connection.setRequestProperty("User-Agent", this.mUserAgent);
            }
            connection.setInstanceFollowRedirects(false);
            connection.connect();
            connection.setReadTimeout(5000);
            int status = connection.getResponseCode();
            Log.v((String)TAG, (String)(" - Status: " + status));
            switch (status) {
                case 200: {
                    Log.v((String)TAG, (String)(" - Done: " + url));
                    this.invokeFinish(url);
                    break;
                }
                case 301: 
                case 302: 
                case 303: {
                    String newUrl = connection.getHeaderField("Location");
                    Log.v((String)TAG, (String)(" - Redirecting: " + newUrl));
                    if (newUrl.startsWith("/")) {
                        String protocol = urlObj.getProtocol();
                        String host = urlObj.getHost();
                        newUrl = protocol + "://" + host + newUrl;
                    }
                    this.invokeRedirect(newUrl);
                    if (this.mDrillSize == 0) {
                        this.doDrill(newUrl);
                        break;
                    }
                    if (this.mDrillSize > 0 && counter < this.mDrillSize) {
                        this.doDrill(newUrl, counter + 1);
                        break;
                    }
                    this.invokeFinish(url);
                    break;
                }
                default: {
                    Exception statusException = new Exception("Drilling error: Invalid URL, Status: " + status);
                    Log.e((String)TAG, (String)statusException.toString());
                    this.invokeFail(url, statusException);
                }
            }
            connection.getInputStream().close();
            connection.getOutputStream().close();
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Drilling error: " + exception));
            this.invokeFail(url, exception);
        }
        catch (Error error) {
            Log.e((String)TAG, (String)("Drilling error: with URL = [" + url + "]"), (Throwable)error);
            this.invokeFinish(null);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected void invokeStart(final String url) {
        Log.v((String)TAG, (String)"invokeStart");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (URLDriller.this.mListener != null) {
                    URLDriller.this.mListener.onURLDrillerStart(url);
                }
            }
        });
    }

    protected void invokeRedirect(final String url) {
        Log.v((String)TAG, (String)"invokeRedirect");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (URLDriller.this.mListener != null) {
                    URLDriller.this.mListener.onURLDrillerRedirect(url);
                }
            }
        });
    }

    protected void invokeFinish(final String url) {
        Log.v((String)TAG, (String)"invokeFinish");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (URLDriller.this.mListener != null) {
                    URLDriller.this.mListener.onURLDrillerFinish(url);
                }
                URLDriller.this.mListener = null;
            }
        });
    }

    protected void invokeFail(final String url, final Exception exception) {
        Log.v((String)TAG, (String)("invokeFail: " + exception));
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (URLDriller.this.mListener != null) {
                    URLDriller.this.mListener.onURLDrillerFail(url == null ? "" : url, exception);
                }
                URLDriller.this.mListener = null;
            }
        });
    }

    public static interface Listener {
        public void onURLDrillerStart(String var1);

        public void onURLDrillerRedirect(String var1);

        public void onURLDrillerFinish(String var1);

        public void onURLDrillerFail(String var1, Exception var2);
    }
}

