/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import java.net.HttpURLConnection;
import java.net.URL;

public class URLDriller {
    private static final String TAG = URLDriller.class.getSimpleName();
    protected Listener mListener;
    protected Handler mHandler;

    public void setListener(Listener listener) {
        this.mListener = listener;
    }

    public void drill(final String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            this.invokeFail(url, new IllegalArgumentException("URLDrill error: url is null or empty"));
        } else {
            this.mHandler = new Handler(Looper.getMainLooper());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    URLDriller.this.invokeStart(url);
                    URLDriller.this.doDrill(url);
                }
            }).start();
        }
    }

    protected void doDrill(String url) {
        Log.v((String)TAG, (String)("doDrill: " + url));
        try {
            URL urlObj = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)urlObj.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.connect();
            conn.setReadTimeout(5000);
            int status = conn.getResponseCode();
            Log.v((String)TAG, (String)(" - Status: " + status));
            switch (status) {
                case 200: {
                    Log.v((String)TAG, (String)(" - Done: " + url));
                    this.invokeFinish(url);
                    break;
                }
                case 301: 
                case 302: 
                case 303: {
                    String newUrl = conn.getHeaderField("Location");
                    Log.v((String)TAG, (String)(" - Redirecting: " + newUrl));
                    this.invokeRedirect(newUrl);
                    this.doDrill(newUrl);
                    break;
                }
                default: {
                    Exception statusException = new Exception("Drilling error: Invalid URL, Status: " + status);
                    Log.e((String)TAG, (String)statusException.toString());
                    this.invokeFail(url, statusException);
                    break;
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("Drilling error: " + exception));
            this.invokeFail(url, exception);
        }
    }

    protected void invokeStart(final String url) {
        Log.v((String)TAG, (String)"invokeStart");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (URLDriller.this.mListener != null) {
                    URLDriller.this.mListener.onURLDrillerStart(url);
                }
            }
        });
    }

    protected void invokeRedirect(final String url) {
        Log.v((String)TAG, (String)"invokeRedirect");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (URLDriller.this.mListener != null) {
                    URLDriller.this.mListener.onURLDrillerRedirect(url);
                }
            }
        });
    }

    protected void invokeFinish(final String url) {
        Log.v((String)TAG, (String)"invokeFinish");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (URLDriller.this.mListener != null) {
                    URLDriller.this.mListener.onURLDrillerFinish(url);
                }
                URLDriller.this.mListener = null;
            }
        });
    }

    protected void invokeFail(final String url, final Exception exception) {
        Log.v((String)TAG, (String)("invokeFail: " + exception));
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (URLDriller.this.mListener != null) {
                    URLDriller.this.mListener.onURLDrillerFail(url, exception);
                }
                URLDriller.this.mListener = null;
            }
        });
    }

    public static interface Listener {
        public void onURLDrillerStart(String var1);

        public void onURLDrillerRedirect(String var1);

        public void onURLDrillerFinish(String var1);

        public void onURLDrillerFail(String var1, Exception var2);
    }
}

