/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.layouts.adapter.medium;

import android.content.Context;
import android.graphics.Typeface;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.Map;
import net.pubnative.api.core.request.model.PNAPIAdModel;
import net.pubnative.api.layouts.PNAPILayout;
import net.pubnative.api.layouts.PNAPILayoutView;
import net.pubnative.sdk.core.PNSettings;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.core.request.PNAdModel;
import net.pubnative.sdk.layouts.PNMediumLayoutView;
import net.pubnative.sdk.layouts.adapter.PNAPI;
import net.pubnative.sdk.layouts.adapter.PNLayoutFeedAdapter;
import net.pubnative.sdk.layouts.adapter.medium.PNMediumLayoutContainerView;

public class PubnativeLibraryNetworkAdapter
extends PNLayoutFeedAdapter
implements PNAPILayout.LoadListener,
PNAPILayoutView.Listener,
PNAdModel.Listener {
    protected PNAPILayout mLayout;
    protected PNAPILayoutView mLayoutView;
    protected PNLibraryAdapterView mCachedView;

    @Override
    protected void request(Context context, Map<String, String> map) {
        if (context == null || map == null) {
            this.invokeLoadFail(PNException.ADAPTER_ILLEGAL_ARGUMENTS);
        } else {
            this.mCachedView = null;
            this.mLayoutView = null;
            this.mLayout = new PNAPILayout();
            for (String object : map.keySet()) {
                String string = map.get(object);
                this.mLayout.setParameter(object, string);
            }
            if (!PNSettings.isCoppaModeEnabled && PNSettings.targeting != null) {
                Map map2 = PNSettings.targeting.toDictionary();
                for (String string : map2.keySet()) {
                    String string2 = (String)map2.get(string);
                    this.mLayout.setParameter(string, string2);
                }
            }
            this.mLayout.setTestMode(PNSettings.isTestModeEnabled);
            this.mLayout.setCoppaMode(PNSettings.isCoppaModeEnabled);
            this.mLayout.load(context, PNAPILayout.Size.MEDIUM, this);
        }
    }

    @Override
    public void startTracking() {
        if (this.mLayoutView != null) {
            this.mLayoutView.setListener(this);
            this.mLayoutView.startTracking();
        }
    }

    @Override
    public void stopTracking() {
        if (this.mLayoutView != null) {
            this.mLayoutView.stopTracking();
            this.mLayoutView.setListener(null);
        }
    }

    public PNMediumLayoutView getView(Context context) {
        if (this.mCachedView == null && this.mLayoutView != null) {
            this.mCachedView = new PNLibraryAdapterView(this.mContext);
            this.mCachedView.loadWithView((View)this.mLayoutView);
        }
        return this.mCachedView;
    }

    @Override
    public void onPubnativeLayoutLoadFinish(PNAPILayout pNAPILayout, PNAPIAdModel pNAPIAdModel) {
        PNAPIAdModel pNAPIAdModel2 = PNAPI.filterAd(this.mContext, pNAPIAdModel, this.mIsCPICacheEnabled, PNAPILayout.Size.MEDIUM);
        this.processResponse(pNAPIAdModel2);
    }

    protected void processResponse(PNAPIAdModel pNAPIAdModel) {
        this.mLayout.setAdModel(pNAPIAdModel);
        this.mLayout.fetch(new PNAPILayout.FetchListener(){

            @Override
            public void onPubnativeLayoutFetchFinish(PNAPILayout pNAPILayout, PNAPILayoutView pNAPILayoutView) {
                PubnativeLibraryNetworkAdapter.this.mLayoutView = pNAPILayoutView;
                PubnativeLibraryNetworkAdapter.this.invokeLoadSuccess();
            }

            @Override
            public void onPubnativeLayoutFetchFail(PNAPILayout pNAPILayout, Exception exception) {
                PubnativeLibraryNetworkAdapter.this.invokeLoadFail(exception);
            }
        });
    }

    @Override
    public void onPubnativeLayoutLoadFail(PNAPILayout pNAPILayout, Exception exception) {
        PNAPIAdModel pNAPIAdModel = PNAPI.filterAd(this.mContext, null, this.mIsCPICacheEnabled, PNAPILayout.Size.MEDIUM);
        if (pNAPIAdModel == null) {
            this.invokeLoadFail(exception);
        } else {
            this.processResponse(pNAPIAdModel);
        }
    }

    @Override
    public void onPubnativeLayoutViewImpressionConfirmed(PNAPILayoutView pNAPILayoutView) {
        this.invokeImpression();
    }

    @Override
    public void onPubnativeLayoutViewClick(PNAPILayoutView pNAPILayoutView) {
        this.invokeClick();
    }

    @Override
    public void onPNAdImpression(PNAdModel pNAdModel) {
        this.invokeImpression();
    }

    @Override
    public void onPNAdClick(PNAdModel pNAdModel) {
        this.invokeClick();
    }

    public class PNLibraryAdapterView
    extends PNMediumLayoutContainerView {
        protected ImageView mIcon;
        protected TextView mTitle;
        protected TextView mDescription;
        protected ImageView mBanner;
        protected TextView mCallToAction;

        public PNLibraryAdapterView(Context context) {
            super(context);
        }

        @Override
        public void setIconPosition(PNMediumLayoutView.IconPosition iconPosition) {
        }

        public void setBackgroundColor(int n) {
            if (PubnativeLibraryNetworkAdapter.this.mLayoutView != null) {
                PubnativeLibraryNetworkAdapter.this.mLayoutView.setBackgroundColor(n);
            }
        }

        @Override
        public void setTitleTextColor(int n) {
            if (this.mTitle != null) {
                this.mTitle.setTextColor(n);
            }
        }

        @Override
        public void setTitleTextSize(float f) {
            if (this.mTitle != null) {
                this.mTitle.setTextSize(f);
            }
        }

        @Override
        public void setTitleTextFont(Typeface typeface) {
            if (this.mTitle != null) {
                this.mTitle.setTypeface(typeface);
            }
        }

        @Override
        public void setDescriptionTextColor(int n) {
            if (this.mDescription != null) {
                this.mDescription.setTextColor(n);
            }
        }

        @Override
        public void setDescriptionTextSize(float f) {
            if (this.mDescription != null) {
                this.mDescription.setTextSize(f);
            }
        }

        @Override
        public void setDescriptionTextFont(Typeface typeface) {
            if (this.mDescription != null) {
                this.mDescription.setTypeface(typeface);
            }
        }

        @Override
        public void setCallToActionTextColor(int n) {
            if (this.mCallToAction != null) {
                this.mCallToAction.setTextColor(n);
            }
        }

        @Override
        public void setCallToActionTextSize(float f) {
            if (this.mCallToAction != null) {
                this.mCallToAction.setTextSize(f);
            }
        }

        @Override
        public void setCallToActionTextFont(Typeface typeface) {
            if (this.mCallToAction != null) {
                this.mCallToAction.setTypeface(typeface);
            }
        }

        @Override
        public void setCallToActionBackgroundColor(int n) {
            if (this.mCallToAction != null) {
                this.mCallToAction.setBackgroundColor(n);
            }
        }

        @Override
        protected void loadWithView(View view) {
            super.loadWithView(view);
            if (PubnativeLibraryNetworkAdapter.this.mLayoutView != null && PubnativeLibraryNetworkAdapter.this.mLayoutView.getIDMap() != null) {
                this.mIcon = (ImageView)PubnativeLibraryNetworkAdapter.this.mLayoutView.findViewById(PubnativeLibraryNetworkAdapter.this.mLayoutView.getIDMap().icon);
                this.mTitle = (TextView)PubnativeLibraryNetworkAdapter.this.mLayoutView.findViewById(PubnativeLibraryNetworkAdapter.this.mLayoutView.getIDMap().title);
                this.mDescription = (TextView)PubnativeLibraryNetworkAdapter.this.mLayoutView.findViewById(PubnativeLibraryNetworkAdapter.this.mLayoutView.getIDMap().description);
                this.mBanner = (ImageView)PubnativeLibraryNetworkAdapter.this.mLayoutView.findViewById(PubnativeLibraryNetworkAdapter.this.mLayoutView.getIDMap().banner);
                this.mCallToAction = (TextView)PubnativeLibraryNetworkAdapter.this.mLayoutView.findViewById(PubnativeLibraryNetworkAdapter.this.mLayoutView.getIDMap().callToAction);
            }
        }
    }
}

