/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.layouts.adapter.medium;

import android.content.Context;
import android.graphics.Typeface;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import net.pubnative.sdk.R;
import net.pubnative.sdk.core.request.PNAdModel;
import net.pubnative.sdk.layouts.PNMediumLayoutView;

public class PNMediumLayoutRequestView
extends PNMediumLayoutView {
    private static final String TAG = PNMediumLayoutRequestView.class.getSimpleName();
    protected ImageView mIcon;
    protected TextView mTitle;
    protected TextView mDescription;
    protected TextView mCallToAction;
    protected RelativeLayout mRootView;
    protected RelativeLayout mHeaderView;
    protected RelativeLayout mBodyView;
    protected RelativeLayout mFooterView;
    protected RelativeLayout mContentInfoView;
    protected RelativeLayout mSocialContext;

    public PNMediumLayoutRequestView(Context context) {
        super(context);
    }

    @Override
    public void setAdBackgroundColor(int n) {
        if (this.mRootView != null) {
            this.mRootView.setBackgroundColor(n);
        }
    }

    @Override
    public void setTitleTextColor(int n) {
        if (this.mTitle != null) {
            this.mTitle.setTextColor(n);
        }
    }

    @Override
    public void setTitleTextSize(float f) {
        if (this.mTitle != null) {
            this.mTitle.setTextSize(f);
        }
    }

    @Override
    public void setTitleTextFont(Typeface typeface) {
        if (this.mTitle != null) {
            this.mTitle.setTypeface(typeface);
        }
    }

    @Override
    public void setDescriptionTextColor(int n) {
        if (this.mDescription != null) {
            this.mDescription.setTextColor(n);
        }
    }

    @Override
    public void setDescriptionTextSize(float f) {
        if (this.mDescription != null) {
            this.mDescription.setTextSize(f);
        }
    }

    @Override
    public void setDescriptionTextFont(Typeface typeface) {
        if (this.mDescription != null) {
            this.mDescription.setTypeface(typeface);
        }
    }

    @Override
    public void setCallToActionBackgroundColor(int n) {
        if (this.mCallToAction != null) {
            this.mCallToAction.setBackgroundColor(n);
        }
    }

    @Override
    public void setCallToActionTextColor(int n) {
        if (this.mCallToAction != null) {
            this.mCallToAction.setTextColor(n);
        }
    }

    @Override
    public void setCallToActionTextSize(float f) {
        if (this.mCallToAction != null) {
            this.mCallToAction.setTextSize(f);
        }
    }

    @Override
    public void setCallToActionTextFont(Typeface typeface) {
        if (this.mCallToAction != null) {
            this.mCallToAction.setTypeface(typeface);
        }
    }

    @Override
    public void setIconPosition(PNMediumLayoutView.IconPosition iconPosition) {
        Log.v((String)TAG, (String)"setIconPosition");
        if (this.mIcon != null && this.mTitle != null) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mIcon.getLayoutParams();
            RelativeLayout.LayoutParams layoutParams2 = (RelativeLayout.LayoutParams)this.mTitle.getLayoutParams();
            switch (iconPosition) {
                case RIGHT: {
                    layoutParams.addRule(11);
                    layoutParams.addRule(9, 0);
                    layoutParams2.addRule(1, 0);
                    layoutParams2.addRule(0, this.mIcon.getId());
                    layoutParams2.addRule(11, 0);
                    layoutParams2.addRule(9);
                    break;
                }
                case LEFT: {
                    layoutParams.addRule(11, 0);
                    layoutParams.addRule(9);
                    layoutParams2.addRule(1, this.mIcon.getId());
                    layoutParams2.addRule(0, 0);
                    layoutParams2.addRule(11);
                    layoutParams2.addRule(9, 0);
                }
            }
            this.mIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mTitle.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        }
    }

    @Override
    public void setBannerPosition(PNMediumLayoutView.BannerPosition bannerPosition) {
        if (this.mHeaderView != null && this.mBodyView != null && this.mFooterView != null) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mHeaderView.getLayoutParams();
            RelativeLayout.LayoutParams layoutParams2 = (RelativeLayout.LayoutParams)this.mBodyView.getLayoutParams();
            RelativeLayout.LayoutParams layoutParams3 = (RelativeLayout.LayoutParams)this.mFooterView.getLayoutParams();
            switch (bannerPosition) {
                case TOP: {
                    layoutParams2.addRule(3, 0);
                    layoutParams2.addRule(10);
                    layoutParams.addRule(10, 0);
                    layoutParams.addRule(3, this.mBodyView.getId());
                    layoutParams3.addRule(3, this.mHeaderView.getId());
                    break;
                }
                case CENTER: {
                    layoutParams.addRule(3, 0);
                    layoutParams.addRule(10);
                    layoutParams2.addRule(10, 0);
                    layoutParams2.addRule(3, this.mHeaderView.getId());
                    layoutParams3.addRule(3, this.mBodyView.getId());
                    break;
                }
                case BOTTOM: {
                    layoutParams.addRule(3, 0);
                    layoutParams.addRule(10);
                    layoutParams3.addRule(3, this.mHeaderView.getId());
                    layoutParams2.addRule(10, 0);
                    layoutParams2.addRule(3, this.mFooterView.getId());
                }
            }
            this.mHeaderView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mBodyView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            this.mFooterView.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        }
    }

    protected RelativeLayout.LayoutParams getBodyContentParams() {
        return new RelativeLayout.LayoutParams(-1, -1);
    }

    public void loadWithAd(Context context, PNAdModel pNAdModel) {
        this.mRootView = (RelativeLayout)LayoutInflater.from((Context)context).inflate(R.layout.pubnative_asset_group_5, (ViewGroup)this, true);
        this.mHeaderView = (RelativeLayout)this.mRootView.findViewById(R.id.pubnative_header);
        this.mBodyView = (RelativeLayout)this.mRootView.findViewById(R.id.pubnative_body);
        this.mFooterView = (RelativeLayout)this.mRootView.findViewById(R.id.pubnative_footer);
        this.mIcon = (ImageView)this.mHeaderView.findViewById(R.id.pubnative_icon);
        this.mTitle = (TextView)this.mHeaderView.findViewById(R.id.pubnative_title);
        this.mDescription = (TextView)this.mFooterView.findViewById(R.id.pubnative_description);
        this.mCallToAction = (TextView)this.mFooterView.findViewById(R.id.pubnative_callToAction);
        this.mContentInfoView = (RelativeLayout)this.mRootView.findViewById(R.id.pubnative_content_info_container);
        this.mSocialContext = (RelativeLayout)this.mRootView.findViewById(R.id.pubnative_social_context);
        pNAdModel.withTitle(this.mTitle).withDescription(this.mDescription).withCallToAction(this.mCallToAction).withBanner((ViewGroup)this.mBodyView).withIcon(this.mIcon).withContentInfoContainer((ViewGroup)this.mContentInfoView).withSocialContext((ViewGroup)this.mSocialContext);
    }
}

