/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.request;

import android.content.Context;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.Map;
import net.pubnative.core.utils.PNDeviceUtils;
import net.pubnative.sdk.core.PNSettings;
import net.pubnative.sdk.core.adapter.request.PNAdapter;
import net.pubnative.sdk.core.adapter.request.PNAdapterFactory;
import net.pubnative.sdk.core.config.PNPlacement;
import net.pubnative.sdk.core.config.model.PNNetworkModel;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.core.insights.model.PNInsightDataModel;
import net.pubnative.sdk.core.insights.model.PNInsightModel;

public abstract class PNWaterfall {
    private static String TAG = PNWaterfall.class.getSimpleName();
    protected static final String TRACKING_PARAMETER_APP_TOKEN = "app_token";
    protected static final String TRACKING_PARAMETER_REQUEST_ID = "reqid";
    protected Context mContext;
    protected String mAppToken;
    protected PNPlacement mPlacement;
    protected PNInsightModel mInsight;

    protected synchronized void initialize(Context context, String string, String string2) {
        if (context == null || TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            this.onWaterfallError(PNException.REQUEST_PARAMETERS_INVALID);
        } else if (PNDeviceUtils.isNetworkAvailable(context)) {
            this.mContext = context;
            this.mAppToken = string;
            this.mPlacement = new PNPlacement();
            Map map = this.getExtras();
            this.mPlacement.load(this.mContext, string, string2, map, new PNPlacement.Listener(){

                @Override
                public void onPlacementReady(PNPlacement pNPlacement) {
                    PNWaterfall.this.startTracking();
                }

                @Override
                public void onPlacementLoadFail(PNPlacement pNPlacement, Exception exception) {
                    PNWaterfall.this.onWaterfallError(exception);
                }
            });
        } else {
            this.onWaterfallError(PNException.REQUEST_NO_INTERNET);
        }
    }

    protected void startTracking() {
        String string = (String)this.mPlacement.getConfig().getGlobal("request_beacon");
        String string2 = (String)this.mPlacement.getConfig().getGlobal("impression_beacon");
        String string3 = (String)this.mPlacement.getConfig().getGlobal("click_beacon");
        String string4 = (String)this.mPlacement.getConfig().getGlobal("recovered_network_url");
        this.mInsight = new PNInsightModel(this.mContext);
        this.mInsight.setInsightURLs(string, string2, string3, string4);
        this.mInsight.addExtra(TRACKING_PARAMETER_APP_TOKEN, this.mPlacement.getAppToken());
        this.mInsight.addExtra(TRACKING_PARAMETER_REQUEST_ID, this.mPlacement.getTrackingUUID());
        this.mInsight.addExtras(this.mPlacement.getConfig().request_params);
        PNInsightDataModel pNInsightDataModel = this.mInsight.getData();
        pNInsightDataModel.placement_name = this.mPlacement.getName();
        pNInsightDataModel.ad_format_code = this.mPlacement.getAdFormatCode();
        pNInsightDataModel.coppa = PNSettings.isCoppaModeEnabled ? "1" : "0";
        pNInsightDataModel.user_uid = PNSettings.advertisingId;
        this.mInsight.setData(pNInsightDataModel);
        this.onWaterfallLoadFinish(false);
    }

    protected void getNextNetwork() {
        this.mPlacement.next();
        PNNetworkModel pNNetworkModel = this.mPlacement.getCurrentNetwork();
        if (pNNetworkModel == null) {
            this.sendRequestInsight();
            this.onWaterfallError(PNException.REQUEST_NO_FILL);
        } else {
            PNAdapter pNAdapter = PNAdapterFactory.create(pNNetworkModel);
            if (pNAdapter == null) {
                this.trackUnreachableNetwork(0L, PNException.ADAPTER_NOT_FOUND);
                this.getNextNetwork();
            } else {
                this.onWaterfallNextNetwork(pNAdapter, this.getExtras());
            }
        }
    }

    protected Map getExtras() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(TRACKING_PARAMETER_REQUEST_ID, this.mPlacement.getTrackingUUID());
        if (!PNSettings.isCoppaModeEnabled && PNSettings.targeting != null) {
            hashMap.putAll(PNSettings.targeting.toDictionary());
        }
        return hashMap;
    }

    protected synchronized void trackSuccededNetwork(long l) {
        this.mInsight.trackSuccededNetwork(this.mPlacement.getCurrentPriority(), l);
        this.sendRequestInsight();
    }

    protected void sendRequestInsight() {
        this.mInsight.sendRequestInsight(null);
    }

    protected void trackAttemptedNetwork(long l, Exception exception) {
        if (this.mPlacement != null) {
            Exception exception2 = null;
            PNNetworkModel pNNetworkModel = this.mPlacement.getCurrentNetwork();
            if (pNNetworkModel != null && pNNetworkModel.isCrashReportEnabled()) {
                exception2 = exception;
            }
            this.mInsight.trackAttemptedNetwork(this.mPlacement.getCurrentPriority(), l, exception2);
        }
    }

    protected void trackUnreachableNetwork(long l, Exception exception) {
        if (this.mPlacement != null) {
            Exception exception2 = null;
            PNNetworkModel pNNetworkModel = this.mPlacement.getCurrentNetwork();
            if (pNNetworkModel != null && pNNetworkModel.isCrashReportEnabled()) {
                exception2 = exception;
            }
            this.mInsight.trackUnreachableNetwork(this.mPlacement.getCurrentPriority(), l, exception2);
        }
    }

    protected abstract void onWaterfallLoadFinish(boolean var1);

    protected abstract void onWaterfallError(Exception var1);

    protected abstract void onWaterfallNextNetwork(PNAdapter var1, Map var2);
}

