/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.request;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import java.util.Map;
import net.pubnative.sdk.core.adapter.request.PNAdapter;
import net.pubnative.sdk.core.config.model.PNNetworkModel;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.core.request.PNAdModel;
import net.pubnative.sdk.core.request.PNAdModelCache;
import net.pubnative.sdk.core.request.PNCacheManager;
import net.pubnative.sdk.core.request.PNWaterfall;

public class PNRequest
extends PNWaterfall
implements PNAdapter.LoadListener {
    private static String TAG = PNRequest.class.getSimpleName();
    protected Listener mListener = null;
    protected boolean mIsRunning = false;
    protected Handler mHandler = null;
    protected PNAdModel mAd = null;
    protected boolean mIsCachingResourceEnabled = true;

    public synchronized void start(Context context, String string, String string2, Listener listener) {
        if (listener == null) {
            Log.w((String)TAG, (String)"start - Error: listener not specified, dropping the call");
        } else if (this.mIsRunning) {
            Log.w((String)TAG, (String)"start - Error: request already loading, dropping the call");
        } else {
            this.mIsRunning = true;
            this.mListener = listener;
            this.initialize(context, string, string2);
        }
    }

    public void setCacheResources(boolean bl) {
        this.mIsCachingResourceEnabled = bl;
    }

    protected Handler getMainHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    @Override
    protected void onWaterfallLoadFinish(boolean bl) {
        if (bl && this.mAd == null) {
            this.invokeFail(PNException.PLACEMENT_PACING_CAP);
        } else if (bl) {
            this.onRequestLoad(this.mAd);
        } else {
            this.getNextNetwork();
        }
    }

    @Override
    protected void onWaterfallError(Exception exception) {
        this.invokeFail(exception);
    }

    @Override
    protected void onWaterfallNextNetwork(PNAdapter pNAdapter, Map map) {
        PNNetworkModel pNNetworkModel = this.mPlacement.getCurrentNetwork();
        if (this.canUseCache(pNNetworkModel)) {
            PNAdModelCache pNAdModelCache = PNCacheManager.getCachedAd(this.mPlacement.getName(), this.mPlacement.getCurrentNetworkIndex());
            if (pNAdModelCache == null) {
                this.getNextNetwork();
            } else if (pNAdModelCache.isValid()) {
                this.onRequestLoad(pNAdModelCache.ad);
            } else {
                this.request(pNAdapter, pNNetworkModel, map);
            }
        } else {
            this.request(pNAdapter, pNNetworkModel, map);
        }
    }

    protected boolean canUseCache(PNNetworkModel pNNetworkModel) {
        return this.mPlacement.isAdCacheEnabled() && pNNetworkModel.isAdCacheEnabled();
    }

    protected void request(PNAdapter pNAdapter, PNNetworkModel pNNetworkModel, Map map) {
        if (pNAdapter == null) {
            this.trackUnreachableNetwork(0L, PNException.ADAPTER_TYPE_NOT_IMPLEMENTED);
            this.getNextNetwork();
        } else {
            pNAdapter.setCPICacheEnabled(pNNetworkModel.isCPACacheEnabled());
            pNAdapter.setInsight(this.mInsight);
            pNAdapter.setExtras(map);
            pNAdapter.setLoadListener(this);
            pNAdapter.execute(this.mContext, this.getRequestTimeout(pNNetworkModel));
        }
    }

    protected int getRequestTimeout(PNNetworkModel pNNetworkModel) {
        int n = 0;
        if (pNNetworkModel != null) {
            n = pNNetworkModel.getTimeout();
        }
        return n;
    }

    protected void cache() {
        if (this.mPlacement != null && this.mPlacement.isAdCacheEnabled() && this.mPlacement.hasNetworkCacheEnabled()) {
            PNCacheManager.cachePlacement(this.mContext, this.mPlacement.getAppToken(), this.mPlacement.getName(), this.mPlacement.getConfig());
        }
    }

    protected void onRequestLoad(PNAdModel pNAdModel) {
        if (this.mIsCachingResourceEnabled) {
            pNAdModel.fetchAssets(new PNAdModel.FetchListener(){

                @Override
                public void onFetchFinish(PNAdModel pNAdModel) {
                    PNRequest.this.invokeLoad(pNAdModel);
                }

                @Override
                public void onFetchFail(PNAdModel pNAdModel, Exception exception) {
                    PNRequest.this.invokeFail(exception);
                }
            });
        } else {
            this.invokeLoad(pNAdModel);
        }
    }

    protected void invokeLoad(final PNAdModel pNAdModel) {
        this.cache();
        final Listener listener = this.mListener;
        this.mListener = null;
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    PNRequest.this.mIsRunning = false;
                    listener.onPNRequestLoadFinish(PNRequest.this, pNAdModel);
                }
            }
        });
    }

    protected void invokeFail(final Exception exception) {
        this.cache();
        final Listener listener = this.mListener;
        this.mListener = null;
        this.getMainHandler().post(new Runnable(){

            @Override
            public void run() {
                if (listener != null) {
                    PNRequest.this.mIsRunning = false;
                    listener.onPNRequestLoadFail(PNRequest.this, exception);
                }
            }
        });
    }

    @Override
    public void onAdapterLoadFinish(PNAdapter pNAdapter, PNAdModel pNAdModel) {
        long l = -1L;
        if (pNAdapter != null) {
            l = pNAdapter.getElapsedTime();
        }
        if (pNAdModel == null) {
            this.trackAttemptedNetwork(l, PNException.ADAPTER_NO_FILL);
            this.getNextNetwork();
        } else {
            this.trackSuccededNetwork(l);
            this.mAd = pNAdModel;
            this.mAd.setInsightModel(this.mInsight);
            this.onRequestLoad(this.mAd);
        }
    }

    @Override
    public void onAdapterLoadFail(PNAdapter pNAdapter, Exception exception) {
        long l = -1L;
        if (pNAdapter != null) {
            l = pNAdapter.getElapsedTime();
        }
        if (exception.getClass().isAssignableFrom(PNException.class)) {
            this.trackUnreachableNetwork(l, exception);
        } else {
            this.trackAttemptedNetwork(l, exception);
        }
        this.getNextNetwork();
    }

    public static interface Listener {
        public void onPNRequestLoadFinish(PNRequest var1, PNAdModel var2);

        public void onPNRequestLoadFail(PNRequest var1, Exception var2);
    }
}

