/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.insights.model;

import android.content.Context;
import android.text.TextUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import net.pubnative.sdk.core.config.model.PNPriorityRuleModel;
import net.pubnative.sdk.core.insights.PNInsightsManager;
import net.pubnative.sdk.core.insights.model.PNInsightCrashModel;
import net.pubnative.sdk.core.insights.model.PNInsightDataModel;

public class PNInsightModel {
    private static final String TAG = PNInsightModel.class.getSimpleName();
    public static final int ERORR_LINES_COUNT = 10;
    protected String mRequestInsightURL;
    protected String mImpressionInsightURL;
    protected String mClickInsightURL;
    protected String mRescueRequestURL;
    protected Context mContext;
    protected PNInsightDataModel mData;
    protected Map<String, String> mExtras;

    public PNInsightModel(Context context) {
        this.mContext = context;
        this.mData = new PNInsightDataModel(context);
    }

    public PNInsightDataModel getData() {
        return this.mData;
    }

    public void setData(PNInsightDataModel pNInsightDataModel) {
        this.mData = pNInsightDataModel;
    }

    public void addExtras(Map<String, String> map) {
        if (map != null) {
            if (this.mExtras == null) {
                this.mExtras = new HashMap<String, String>();
            }
            this.mExtras.putAll(map);
        }
    }

    public void addExtra(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string2)) {
            if (this.mExtras == null) {
                this.mExtras = new HashMap<String, String>();
            }
            this.mExtras.put(string, string2);
        }
    }

    public void setInsightURLs(String string, String string2, String string3, String string4) {
        this.mRequestInsightURL = string;
        this.mImpressionInsightURL = string2;
        this.mClickInsightURL = string3;
        this.mRescueRequestURL = string4;
    }

    public void trackUnreachableNetwork(PNPriorityRuleModel pNPriorityRuleModel, long l, Exception exception) {
        if (pNPriorityRuleModel != null && !TextUtils.isEmpty((CharSequence)pNPriorityRuleModel.network_code)) {
            this.mData.addUnreachableNetwork(pNPriorityRuleModel.network_code);
        }
        PNInsightCrashModel pNInsightCrashModel = null;
        if (exception != null) {
            pNInsightCrashModel = new PNInsightCrashModel();
            pNInsightCrashModel.error = this.getExceptionDescription(exception);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            pNInsightCrashModel.details = stringWriter.toString();
        }
        this.mData.addNetwork(pNPriorityRuleModel, l, pNInsightCrashModel);
    }

    public void trackAttemptedNetwork(PNPriorityRuleModel pNPriorityRuleModel, long l, Exception exception) {
        if (pNPriorityRuleModel != null && !TextUtils.isEmpty((CharSequence)pNPriorityRuleModel.network_code)) {
            this.mData.addAttemptedNetwork(pNPriorityRuleModel.network_code);
        }
        PNInsightCrashModel pNInsightCrashModel = null;
        if (exception != null) {
            pNInsightCrashModel = new PNInsightCrashModel();
            pNInsightCrashModel.error = this.getExceptionDescription(exception);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            pNInsightCrashModel.details = stringWriter.toString();
        }
        this.mData.addNetwork(pNPriorityRuleModel, l, pNInsightCrashModel);
    }

    public void trackSuccededNetwork(PNPriorityRuleModel pNPriorityRuleModel, long l) {
        if (pNPriorityRuleModel != null && !TextUtils.isEmpty((CharSequence)pNPriorityRuleModel.network_code)) {
            this.mData.network = pNPriorityRuleModel.network_code;
        }
        this.mData.addNetwork(pNPriorityRuleModel, l, null);
    }

    public void sendRequestInsight(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.mExtras != null) {
            hashMap.putAll(this.mExtras);
        }
        if (map != null) {
            hashMap.putAll(map);
        }
        PNInsightsManager.trackData(this.mContext, this.mRequestInsightURL, hashMap, this.mData);
    }

    public void sendImpressionInsight() {
        PNInsightsManager.trackData(this.mContext, this.mImpressionInsightURL, this.mExtras, this.mData);
    }

    public void sendClickInsight() {
        PNInsightsManager.trackData(this.mContext, this.mClickInsightURL, this.mExtras, this.mData);
    }

    public void sendRescueInsight(String string, long l) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            this.mData.network = string;
            this.mData.response_time = l;
            PNInsightsManager.trackData(this.mContext, this.mRescueRequestURL, this.mExtras, this.mData);
        }
    }

    private String getExceptionDescription(Exception exception) {
        StringBuilder stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        for (int i = 0; i < 10 && i < stackTraceElementArray.length; ++i) {
            stringBuilder.append(stackTraceElementArray[i]).append("\n");
        }
        return stringBuilder.toString();
    }
}

