/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.insights.model;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import net.pubnative.core.utils.PNDeviceUtils;
import net.pubnative.sdk.core.PNSettings;
import net.pubnative.sdk.core.config.model.PNPriorityRuleModel;
import net.pubnative.sdk.core.insights.model.PNInsightCrashModel;
import net.pubnative.sdk.core.insights.model.PNInsightNetworkModel;
import net.pubnative.sdk.core.request.PNAdTargetingModel;

public class PNInsightDataModel {
    private static final String TAG = PNInsightDataModel.class.getName();
    public String network;
    public List<String> attempted_networks;
    public List<String> unreachable_networks;
    public List<Integer> delivery_segment_ids;
    public List<PNInsightNetworkModel> networks;
    public String placement_name;
    public String pub_app_version;
    public String pub_app_bundle_id;
    public String os_version;
    public String sdk_version;
    public String user_uid;
    public String connection_type;
    public String device_name;
    public String ad_format_code;
    public String creative_url;
    public Boolean video_start;
    public Boolean video_complete;
    public int retry;
    public String retry_error;
    public String coppa;
    public Integer age;
    public String education;
    public List<String> interests;
    public String gender;
    public Boolean iap;
    public Float iap_total;
    public Long generated_at;
    public Long response_time;

    public PNInsightDataModel(Context context) {
        this.fillDefaults(context);
    }

    public boolean equals(Object object) {
        Log.v((String)TAG, (String)"equals");
        if (this == object) {
            return true;
        }
        if (!(object instanceof PNInsightDataModel)) {
            return false;
        }
        PNInsightDataModel pNInsightDataModel = (PNInsightDataModel)object;
        boolean bl = this.isEqual(this.network, pNInsightDataModel.network);
        if (bl) {
            bl = this.isEqual(this.attempted_networks, pNInsightDataModel.attempted_networks);
        }
        if (bl) {
            bl = this.isEqual(this.placement_name, pNInsightDataModel.placement_name);
        }
        if (bl) {
            bl = this.isEqual(this.pub_app_version, pNInsightDataModel.pub_app_version);
        }
        if (bl) {
            bl = this.isEqual(this.pub_app_bundle_id, pNInsightDataModel.pub_app_bundle_id);
        }
        if (bl) {
            bl = this.isEqual(this.os_version, pNInsightDataModel.os_version);
        }
        if (bl) {
            bl = this.isEqual(this.sdk_version, pNInsightDataModel.sdk_version);
        }
        if (bl) {
            bl = this.isEqual(this.user_uid, pNInsightDataModel.user_uid);
        }
        if (bl) {
            bl = this.isEqual(this.connection_type, pNInsightDataModel.connection_type);
        }
        if (bl) {
            bl = this.isEqual(this.device_name, pNInsightDataModel.device_name);
        }
        if (bl) {
            bl = this.isEqual(this.ad_format_code, pNInsightDataModel.ad_format_code);
        }
        if (bl) {
            bl = this.isEqual(this.creative_url, pNInsightDataModel.creative_url);
        }
        if (bl) {
            bl = this.isEqual(this.video_start, pNInsightDataModel.video_start);
        }
        if (bl) {
            bl = this.isEqual(this.video_complete, pNInsightDataModel.video_complete);
        }
        if (bl) {
            bl = this.isEqual(this.coppa, pNInsightDataModel.coppa);
        }
        if (bl) {
            bl = this.isEqual(this.age, pNInsightDataModel.age);
        }
        if (bl) {
            bl = this.isEqual(this.education, pNInsightDataModel.education);
        }
        if (bl) {
            bl = this.isEqual(this.interests, pNInsightDataModel.interests);
        }
        if (bl) {
            bl = this.isEqual(this.gender, pNInsightDataModel.gender);
        }
        if (bl) {
            bl = this.isEqual(this.iap, pNInsightDataModel.iap);
        }
        if (bl) {
            bl = this.isEqual(this.iap_total, pNInsightDataModel.iap_total);
        }
        return bl;
    }

    private boolean isEqual(Object object, Object object2) {
        return object != null ? object.equals(object2) : object2 == null;
    }

    public void addNetwork(PNPriorityRuleModel pNPriorityRuleModel, long l, PNInsightCrashModel pNInsightCrashModel) {
        if (this.networks == null) {
            this.networks = new ArrayList<PNInsightNetworkModel>();
        }
        PNInsightNetworkModel pNInsightNetworkModel = new PNInsightNetworkModel();
        if (pNPriorityRuleModel != null) {
            pNInsightNetworkModel.code = pNPriorityRuleModel.network_code;
            pNInsightNetworkModel.priority_rule_id = pNPriorityRuleModel.id;
            pNInsightNetworkModel.priority_segment_ids = pNPriorityRuleModel.segment_ids;
        }
        pNInsightNetworkModel.response_time = l;
        if (pNInsightCrashModel != null) {
            pNInsightNetworkModel.crash_report = pNInsightCrashModel;
        }
        this.networks.add(pNInsightNetworkModel);
    }

    public void addAttemptedNetwork(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (this.attempted_networks == null) {
                this.attempted_networks = new ArrayList<String>();
            }
            this.attempted_networks.add(string);
        }
    }

    public void addUnreachableNetwork(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (this.unreachable_networks == null) {
                this.unreachable_networks = new ArrayList<String>();
            }
            this.unreachable_networks.add(string);
        }
    }

    public void reset() {
        this.retry = 0;
        this.retry_error = null;
        this.network = null;
        this.networks = null;
        this.delivery_segment_ids = null;
        this.attempted_networks = null;
        this.unreachable_networks = null;
        this.generated_at = null;
    }

    protected void fillDefaults(Context context) {
        if (context != null) {
            this.retry = 0;
            this.os_version = PNSettings.osVersion;
            this.device_name = PNSettings.deviceName;
            this.sdk_version = PNSettings.sdkVersion;
            this.pub_app_version = PNSettings.appVersion;
            this.pub_app_bundle_id = PNSettings.appBundleID;
            PNDeviceUtils.ConnectionType connectionType = PNDeviceUtils.getConnectionType(context);
            switch (connectionType) {
                case CELLULAR: {
                    this.connection_type = "cellular";
                    break;
                }
                case WIFI: {
                    this.connection_type = "wifi";
                }
            }
        }
    }

    public void setTargeting(PNAdTargetingModel pNAdTargetingModel) {
        this.age = pNAdTargetingModel.age;
        this.education = pNAdTargetingModel.education;
        this.interests = pNAdTargetingModel.interests;
        this.gender = pNAdTargetingModel.gender;
        this.iap = pNAdTargetingModel.iap;
        this.iap_total = pNAdTargetingModel.iap_total;
    }
}

