/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.insights;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pubnative.core.network.PNHttpRequest;
import net.pubnative.core.utils.PNStringUtils;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.core.insights.model.PNInsightDataModel;
import net.pubnative.sdk.core.insights.model.PNInsightRequestModel;
import net.pubnative.sdk.core.insights.model.PNInsightsAPIResponseModel;

public class PNInsightsManager {
    private static String TAG = PNInsightsManager.class.getSimpleName();
    protected static final String INSIGHTS_PREFERENCES_KEY = "net.pubnative.mediation.tracking.PNInsightsManager";
    protected static final String INSIGHTS_PENDING_DATA = "pending_data";
    protected static final String INSIGHTS_FAILED_DATA = "failed_data";
    protected static boolean sIdle = true;

    public static synchronized void trackData(Context context, String string, Map<String, String> map, PNInsightDataModel pNInsightDataModel) {
        if (context == null) {
            Log.w((String)TAG, (String)"trackData - context can't be null. Dropping call");
        } else if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)"trackData - baseURL can't be empty. Dropping call");
        } else if (pNInsightDataModel == null) {
            Log.w((String)TAG, (String)"trackData - dataModel can't be null. Dropping call");
        } else {
            Uri.Builder builder = Uri.parse((String)string).buildUpon();
            if (map != null && map.size() > 0) {
                for (String object2 : map.keySet()) {
                    builder.appendQueryParameter(object2, map.get(object2));
                }
            }
            pNInsightDataModel.generated_at = System.currentTimeMillis() * 1000L;
            PNInsightRequestModel pNInsightRequestModel = new PNInsightRequestModel(builder.build().toString(), pNInsightDataModel);
            List<PNInsightRequestModel> list = PNInsightsManager.getTrackingList(context, INSIGHTS_FAILED_DATA);
            PNInsightsManager.enqueueInsightList(context, INSIGHTS_PENDING_DATA, list);
            PNInsightsManager.setTrackingList(context, INSIGHTS_FAILED_DATA, null);
            PNInsightsManager.enqueueInsightItem(context, INSIGHTS_PENDING_DATA, pNInsightRequestModel);
            PNInsightsManager.trackNext(context);
        }
    }

    protected static synchronized void trackNext(final Context context) {
        if (context == null) {
            Log.w((String)TAG, (String)"trackNext - context can't be null. Dropping call");
        } else if (sIdle) {
            sIdle = false;
            final PNInsightRequestModel pNInsightRequestModel = PNInsightsManager.dequeueInsightItem(context, INSIGHTS_PENDING_DATA);
            if (pNInsightRequestModel == null) {
                Log.w((String)TAG, (String)"trackNext - Dequeued item is null. Dropping call");
                sIdle = true;
            } else {
                String string = new Gson().toJson((Object)pNInsightRequestModel.dataModel);
                if (!TextUtils.isEmpty((CharSequence)pNInsightRequestModel.url) && !TextUtils.isEmpty((CharSequence)string)) {
                    PNHttpRequest.Listener listener = new PNHttpRequest.Listener(){

                        @Override
                        public void onPNHttpRequestFinish(PNHttpRequest pNHttpRequest, String string) {
                            if (TextUtils.isEmpty((CharSequence)string)) {
                                PNInsightsManager.trackingFailed(context, pNInsightRequestModel, "invalid insight response (empty or null)");
                            } else {
                                try {
                                    PNInsightsAPIResponseModel pNInsightsAPIResponseModel = (PNInsightsAPIResponseModel)new Gson().fromJson(string, PNInsightsAPIResponseModel.class);
                                    if ("ok".equals(pNInsightsAPIResponseModel.status)) {
                                        PNInsightsManager.trackingFinished(context, pNInsightRequestModel);
                                    } else {
                                        PNInsightsManager.trackingFailed(context, pNInsightRequestModel, pNInsightsAPIResponseModel.error_message);
                                    }
                                }
                                catch (Exception exception) {
                                    HashMap<String, String> hashMap = new HashMap<String, String>();
                                    hashMap.put("parsingException", exception.toString());
                                    hashMap.put("serverResponse", string);
                                    PNInsightsManager.trackingFailed(context, pNInsightRequestModel, PNException.extraException(hashMap).toString());
                                }
                            }
                        }

                        @Override
                        public void onPNHttpRequestFail(PNHttpRequest pNHttpRequest, Exception exception) {
                            PNInsightsManager.trackingFailed(context, pNInsightRequestModel, exception.toString());
                        }
                    };
                    PNInsightsManager.sendTrackingDataToServer(context, string, pNInsightRequestModel.url, listener);
                } else {
                    PNInsightsManager.trackingFinished(context, pNInsightRequestModel);
                }
            }
        } else {
            Log.w((String)TAG, (String)"trackNext - Already tracking one request. Dropping call");
        }
    }

    protected static void trackingFailed(Context context, PNInsightRequestModel pNInsightRequestModel, String string) {
        ++pNInsightRequestModel.dataModel.retry;
        pNInsightRequestModel.dataModel.retry_error = string;
        PNInsightsManager.enqueueInsightItem(context, INSIGHTS_FAILED_DATA, pNInsightRequestModel);
        sIdle = true;
        PNInsightsManager.trackNext(context);
    }

    protected static void trackingFinished(Context context, PNInsightRequestModel pNInsightRequestModel) {
        sIdle = true;
        PNInsightsManager.trackNext(context);
    }

    protected static void sendTrackingDataToServer(Context context, String string, String string2, PNHttpRequest.Listener listener) {
        PNHttpRequest pNHttpRequest = new PNHttpRequest();
        pNHttpRequest.setPOSTString(string);
        pNHttpRequest.start(context, string2, listener);
    }

    protected static void enqueueInsightItem(Context context, String string, PNInsightRequestModel pNInsightRequestModel) {
        if (context != null && pNInsightRequestModel != null) {
            List<PNInsightRequestModel> list = PNInsightsManager.getTrackingList(context, string);
            if (list == null) {
                list = new ArrayList<PNInsightRequestModel>();
            }
            list.add(pNInsightRequestModel);
            PNInsightsManager.setTrackingList(context, string, list);
        }
    }

    protected static void enqueueInsightList(Context context, String string, List<PNInsightRequestModel> list) {
        if (context != null && list != null) {
            List<PNInsightRequestModel> list2 = PNInsightsManager.getTrackingList(context, string);
            if (list2 == null) {
                list2 = new ArrayList<PNInsightRequestModel>();
            }
            list2.addAll(list);
            PNInsightsManager.setTrackingList(context, string, list2);
        }
    }

    protected static PNInsightRequestModel dequeueInsightItem(Context context, String string) {
        List<PNInsightRequestModel> list;
        PNInsightRequestModel pNInsightRequestModel = null;
        if (context != null && (list = PNInsightsManager.getTrackingList(context, string)) != null && list.size() > 0) {
            pNInsightRequestModel = list.get(0);
            list.remove(0);
            PNInsightsManager.setTrackingList(context, string, list);
        }
        return pNInsightRequestModel;
    }

    protected static List<PNInsightRequestModel> getTrackingList(Context context, String string) {
        String string2;
        SharedPreferences sharedPreferences;
        List<PNInsightRequestModel> list = null;
        if (context != null && (sharedPreferences = PNInsightsManager.getSharedPreferences(context)) != null && !TextUtils.isEmpty((CharSequence)(string2 = sharedPreferences.getString(string, null)))) {
            try {
                list = PNStringUtils.convertStringToObjects(string2, PNInsightRequestModel.class);
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                Log.e((String)TAG, (String)"getTrackingList: ", (Throwable)jsonSyntaxException);
            }
        }
        return list;
    }

    protected static void setTrackingList(Context context, String string, List<PNInsightRequestModel> list) {
        SharedPreferences.Editor editor;
        if (context != null && (editor = PNInsightsManager.getSharedPreferencesEditor(context)) != null) {
            if (list == null || list.size() == 0) {
                editor.remove(string);
            } else {
                String string2 = PNStringUtils.convertObjectsToJson(list);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    editor.putString(string, string2);
                }
            }
            editor.apply();
        }
    }

    protected static SharedPreferences.Editor getSharedPreferencesEditor(Context context) {
        SharedPreferences.Editor editor = null;
        SharedPreferences sharedPreferences = PNInsightsManager.getSharedPreferences(context);
        if (sharedPreferences != null) {
            editor = sharedPreferences.edit();
        }
        return editor;
    }

    protected static SharedPreferences getSharedPreferences(Context context) {
        SharedPreferences sharedPreferences = null;
        if (context != null) {
            sharedPreferences = context.getSharedPreferences(INSIGHTS_PREFERENCES_KEY, 0);
        }
        return sharedPreferences;
    }
}

