/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.config;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.pubnative.sdk.core.config.PNConfigManager;
import net.pubnative.sdk.core.config.model.PNConfigModel;
import net.pubnative.sdk.core.config.model.PNNetworkModel;
import net.pubnative.sdk.core.config.model.PNPlacementModel;
import net.pubnative.sdk.core.config.model.PNPriorityRuleModel;
import net.pubnative.sdk.core.exceptions.PNException;

public class PNPlacement {
    private static final String TAG = PNPlacement.class.getSimpleName();
    protected Context mContext;
    protected Listener mListener;
    protected String mAppToken;
    protected String mRequestID;
    protected String mPlacementName;
    protected PNPlacementModel mPlacementModel;
    protected PNConfigModel mConfigModel;
    protected int mCurrentNetworkIndex;

    public void load(Context context, String string, String string2, Map map, Listener listener) {
        if (listener == null) {
            Log.w((String)TAG, (String)"initialize", (Throwable)new IllegalArgumentException("listener cannot be null, dropping this call"));
        } else {
            this.mListener = listener;
            if (context == null || TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
                this.invokeOnLoadFail(PNException.REQUEST_PARAMETERS_INVALID);
            } else if (this.mConfigModel != null) {
                this.invokeOnLoadFail(new Exception("initialize - Error: placement is loaded"));
            } else {
                this.mContext = context;
                this.mAppToken = string;
                this.mPlacementName = string2;
                this.mCurrentNetworkIndex = -1;
                this.mRequestID = UUID.randomUUID().toString();
                PNConfigManager.getConfig(this.mContext, this.mAppToken, new PNConfigManager.Listener(){

                    @Override
                    public void onConfigLoaded(PNConfigModel pNConfigModel) {
                        PNPlacement.this.loadPlacement(pNConfigModel);
                    }
                });
            }
        }
    }

    public String getTrackingUUID() {
        return this.mRequestID;
    }

    public String getAppToken() {
        return this.mAppToken;
    }

    public String getAdFormatCode() {
        String string = null;
        if (this.mPlacementModel != null) {
            string = this.mPlacementModel.ad_format_code;
        }
        return string;
    }

    public PNConfigModel getConfig() {
        return this.mConfigModel;
    }

    public String getName() {
        return this.mPlacementName;
    }

    public int getSize() {
        int n = 0;
        if (this.mPlacementModel != null && this.mPlacementModel.priority_rules != null) {
            n = this.mPlacementModel.priority_rules.size();
        }
        return n;
    }

    public PNPriorityRuleModel getCurrentPriority() {
        return this.getPriorityRule(this.mCurrentNetworkIndex);
    }

    public PNPriorityRuleModel getPriorityRule(int n) {
        PNPriorityRuleModel pNPriorityRuleModel = null;
        if (this.mPlacementModel != null) {
            pNPriorityRuleModel = this.mPlacementModel.getPriorityRule(n);
        }
        return pNPriorityRuleModel;
    }

    public List<PNPriorityRuleModel> getPriorities() {
        List<PNPriorityRuleModel> list = null;
        if (this.mPlacementModel != null) {
            list = this.mPlacementModel.priority_rules;
        }
        return list;
    }

    public String getCurrentNetworkName() {
        String string = null;
        PNPriorityRuleModel pNPriorityRuleModel = this.getCurrentPriority();
        if (pNPriorityRuleModel != null) {
            string = pNPriorityRuleModel.network_code;
        }
        return string;
    }

    public PNNetworkModel getCurrentNetwork() {
        return this.getNetwork(this.mCurrentNetworkIndex);
    }

    public int getCurrentNetworkIndex() {
        return this.mCurrentNetworkIndex;
    }

    public PNNetworkModel getNetwork(int n) {
        PNNetworkModel pNNetworkModel = null;
        PNPriorityRuleModel pNPriorityRuleModel = this.getPriorityRule(n);
        if (pNPriorityRuleModel != null && !TextUtils.isEmpty((CharSequence)pNPriorityRuleModel.network_code)) {
            pNNetworkModel = this.getNetwork(pNPriorityRuleModel.network_code);
        }
        return pNNetworkModel;
    }

    public PNNetworkModel getNetwork(String string) {
        PNNetworkModel pNNetworkModel = null;
        if (!TextUtils.isEmpty((CharSequence)string)) {
            pNNetworkModel = this.mConfigModel.getNetwork(string);
        }
        return pNNetworkModel;
    }

    public boolean isAdCacheEnabled() {
        boolean bl = false;
        if (this.mPlacementModel != null) {
            bl = this.mPlacementModel.ad_cache;
        }
        return bl;
    }

    public boolean hasNetworkCacheEnabled() {
        boolean bl = false;
        if (this.mPlacementModel != null) {
            for (Map.Entry<String, PNNetworkModel> entry : this.mConfigModel.networks.entrySet()) {
                PNNetworkModel pNNetworkModel = entry.getValue();
                if (!pNNetworkModel.ad_cache.booleanValue()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void next() {
        ++this.mCurrentNetworkIndex;
    }

    protected void loadPlacement(PNConfigModel pNConfigModel) {
        this.mConfigModel = pNConfigModel;
        if (this.mConfigModel == null || this.mConfigModel.isEmpty()) {
            this.invokeOnLoadFail(PNException.REQUEST_CONFIG_INVALID);
        } else {
            this.mPlacementModel = this.mConfigModel.getPlacement(this.mPlacementName);
            if (this.mPlacementModel == null) {
                this.invokeOnLoadFail(PNException.PLACEMENT_NOT_FOUND);
            } else {
                this.invokeOnReady();
            }
        }
    }

    protected void invokeOnReady() {
        if (this.mListener != null) {
            this.mListener.onPlacementReady(this);
        }
    }

    protected void invokeOnLoadFail(Exception exception) {
        if (this.mListener != null) {
            this.mListener.onPlacementLoadFail(this, exception);
        }
    }

    public static interface Listener {
        public void onPlacementReady(PNPlacement var1);

        public void onPlacementLoadFail(PNPlacement var1, Exception var2);
    }
}

