/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.adapter.request;

import android.content.Context;
import android.text.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pubnative.api.core.request.PNAPIRequest;
import net.pubnative.api.core.request.model.PNAPIAdModel;
import net.pubnative.sdk.core.PNSettings;
import net.pubnative.sdk.core.adapter.request.PNAdapter;
import net.pubnative.sdk.core.adapter.request.PubnativeLibraryAdModel;
import net.pubnative.sdk.core.adapter.request.PubnativeLibraryCPICache;
import net.pubnative.sdk.core.exceptions.PNException;

public class PubnativeLibraryNetworkAdapter
extends PNAdapter
implements PNAPIRequest.Listener {
    private static final String TAG = PubnativeLibraryNetworkAdapter.class.getSimpleName();
    private Context mContext = null;

    public PubnativeLibraryNetworkAdapter(Map map) {
        super(map);
    }

    @Override
    protected void request(Context context) {
        if (context == null || this.mData == null) {
            this.invokeLoadFail(PNException.ADAPTER_MISSING_DATA);
        } else {
            this.mContext = context;
            this.createRequest(context);
        }
    }

    protected void createRequest(Context context) {
        PNAPIRequest pNAPIRequest = new PNAPIRequest();
        for (Object object : this.mData.keySet()) {
            Object object2 = this.mData.get(object);
            pNAPIRequest.setParameter((String)object, object2.toString());
        }
        if (this.mExtras != null) {
            for (Object object : this.mExtras.keySet()) {
                pNAPIRequest.setParameter((String)object, (String)this.mExtras.get(object));
            }
        }
        if (!PNSettings.isCoppaModeEnabled && PNSettings.targeting != null) {
            Map map = PNSettings.targeting.toDictionary();
            for (Object object2 : map.keySet()) {
                String string = (String)map.get(object2);
                pNAPIRequest.setParameter((String)object2, string);
            }
        }
        pNAPIRequest.setTestMode(PNSettings.isTestModeEnabled);
        pNAPIRequest.setCoppaMode(PNSettings.isCoppaModeEnabled);
        pNAPIRequest.start(context, this);
    }

    @Override
    public void onPNAPIRequestFinish(PNAPIRequest pNAPIRequest, List<PNAPIAdModel> list) {
        PNAPIAdModel pNAPIAdModel;
        PNAPIAdModel pNAPIAdModel2 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (list != null && list.size() > 0) {
            pNAPIAdModel2 = list.get(0);
        }
        if (this.mIsCPICacheEnabled && (pNAPIAdModel2 == null || pNAPIAdModel2.isRevenueModelCPA()) && (pNAPIAdModel = PubnativeLibraryCPICache.get(this.mContext)) != null) {
            String string = (String)this.mData.get("zoneid");
            if (!TextUtils.isEmpty((CharSequence)string)) {
                hashMap.put("zoneid", string);
            }
            pNAPIAdModel2 = pNAPIAdModel;
        }
        if (pNAPIAdModel2 == null) {
            this.invokeLoadFinish(null);
        } else {
            this.invokeLoadFinish(new PubnativeLibraryAdModel(this.mContext, pNAPIAdModel2, hashMap));
        }
    }

    @Override
    public void onPNAPIRequestFail(PNAPIRequest pNAPIRequest, Exception exception) {
        PNAPIAdModel pNAPIAdModel = PubnativeLibraryCPICache.get(this.mContext);
        if (pNAPIAdModel == null) {
            this.invokeLoadFail(exception);
        } else {
            this.invokeLoadFinish(new PubnativeLibraryAdModel(this.mContext, pNAPIAdModel));
        }
    }
}

