/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.adapter.request;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.pubnative.api.core.request.PNAPIRequest;
import net.pubnative.api.core.request.model.PNAPIAdModel;
import net.pubnative.sdk.core.PNSettings;
import net.pubnative.sdk.core.config.model.PNConfigModel;

public class PubnativeLibraryCPICache
implements PNAPIRequest.Listener {
    private static final String TAG = PubnativeLibraryCPICache.class.getSimpleName();
    protected static List<CacheItem> sAdQueue = new ArrayList<CacheItem>();
    protected static boolean sIsRequesting = false;
    protected static Map<String, String> sRequestParameters = new HashMap<String, String>();
    protected static Listener sListener = null;
    protected static int sCacheMinSize = 2;
    protected static boolean sIsCacheEnabled = false;
    protected static int sCacheThreshold = 60;
    private static PubnativeLibraryCPICache sInstance;

    private PubnativeLibraryCPICache() {
    }

    protected static synchronized PubnativeLibraryCPICache getInstance() {
        if (sInstance == null) {
            sInstance = new PubnativeLibraryCPICache();
        }
        return sInstance;
    }

    public static void init(Context context, String string, PNConfigModel pNConfigModel, Listener listener) {
        sListener = listener;
        if (context == null) {
            Log.w((String)TAG, (String)"context is null or empty and required, dropping this call");
            PubnativeLibraryCPICache.getInstance().invokeLoadFinish();
        } else if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)"app token is null or empty and required, dropping this call");
            PubnativeLibraryCPICache.getInstance().invokeLoadFinish();
        } else if (pNConfigModel == null || pNConfigModel.isEmpty()) {
            Log.w((String)TAG, (String)"config is null or empty and required, dropping this call");
            PubnativeLibraryCPICache.getInstance().invokeLoadFinish();
        } else if (PubnativeLibraryCPICache.getInstance().isCacheSizeCritical()) {
            Constable constable;
            sRequestParameters.put("apptoken", string);
            if (pNConfigModel.ad_cache_params != null) {
                sRequestParameters.putAll(pNConfigModel.ad_cache_params);
            }
            if (pNConfigModel.globals.containsKey("ad_cache_min_size")) {
                constable = (Double)pNConfigModel.getGlobal("ad_cache_min_size");
                sCacheMinSize = ((Double)constable).intValue();
            }
            if (pNConfigModel.globals.containsKey("refresh_ad_cache")) {
                constable = (Double)pNConfigModel.getGlobal("refresh_ad_cache");
                sCacheThreshold = ((Double)constable).intValue();
            }
            if (pNConfigModel.globals.containsKey("cpa_cache")) {
                constable = (Boolean)pNConfigModel.getGlobal("cpa_cache");
                sIsCacheEnabled = (Boolean)constable;
            }
            PubnativeLibraryCPICache.getInstance().request(context);
        } else {
            PubnativeLibraryCPICache.getInstance().invokeLoadFinish();
        }
    }

    public static synchronized PNAPIAdModel get(Context context) {
        PNAPIAdModel pNAPIAdModel = PubnativeLibraryCPICache.getInstance().dequeue();
        if (PubnativeLibraryCPICache.getInstance().isCacheSizeCritical()) {
            PubnativeLibraryCPICache.getInstance().request(context);
        }
        return pNAPIAdModel;
    }

    private void request(Context context) {
        if (context == null) {
            Log.w((String)TAG, (String)"context is nil and required, dropping this call");
        } else if (sIsRequesting) {
            Log.v((String)TAG, (String)"currently requesting, dropping this call");
        } else if (sIsCacheEnabled) {
            sIsRequesting = true;
            PNAPIRequest pNAPIRequest = new PNAPIRequest();
            for (String object : sRequestParameters.keySet()) {
                String string = sRequestParameters.get(object);
                pNAPIRequest.setParameter(object, string);
            }
            if (!PNSettings.isCoppaModeEnabled && PNSettings.targeting != null) {
                Map map = PNSettings.targeting.toDictionary();
                for (String string : map.keySet()) {
                    String string2 = (String)map.get(string);
                    pNAPIRequest.setParameter(string, string2);
                }
            }
            pNAPIRequest.setTestMode(PNSettings.isTestModeEnabled);
            pNAPIRequest.setCoppaMode(PNSettings.isCoppaModeEnabled);
            pNAPIRequest.start(context, this);
        } else {
            this.invokeLoadFinish();
        }
    }

    private void invokeLoadFinish() {
        sIsRequesting = false;
        Listener listener = sListener;
        sListener = null;
        if (listener != null) {
            listener.onPubnativeCpiCacheLoadFinish();
        }
    }

    protected boolean isCacheSizeCritical() {
        return sAdQueue.size() <= sCacheMinSize;
    }

    protected void enqueue(List<PNAPIAdModel> list) {
        for (PNAPIAdModel pNAPIAdModel : list) {
            pNAPIAdModel.setUseClickCaching(true);
            pNAPIAdModel.fetch();
            this.enqueue(pNAPIAdModel);
        }
    }

    protected void enqueue(PNAPIAdModel pNAPIAdModel) {
        sAdQueue.add(new CacheItem(pNAPIAdModel));
    }

    protected void enqueue(CacheItem cacheItem) {
        sAdQueue.add(cacheItem);
    }

    protected PNAPIAdModel dequeue() {
        PNAPIAdModel pNAPIAdModel = null;
        if (sAdQueue.size() > 0) {
            CacheItem cacheItem = sAdQueue.remove(0);
            pNAPIAdModel = System.currentTimeMillis() > cacheItem.timestamp + TimeUnit.MINUTES.toMillis(sCacheThreshold) ? this.dequeue() : cacheItem.ad;
        }
        return pNAPIAdModel;
    }

    protected void clear() {
        sAdQueue.clear();
    }

    protected int getQueueSize() {
        return sAdQueue.size();
    }

    @Override
    public void onPNAPIRequestFinish(PNAPIRequest pNAPIRequest, List<PNAPIAdModel> list) {
        if (list != null) {
            this.enqueue(list);
        }
        this.invokeLoadFinish();
    }

    @Override
    public void onPNAPIRequestFail(PNAPIRequest pNAPIRequest, Exception exception) {
        this.invokeLoadFinish();
    }

    public static interface Listener {
        public void onPubnativeCpiCacheLoadFinish();
    }

    public class CacheItem {
        public PNAPIAdModel ad = null;
        public long timestamp = -1L;

        public CacheItem(PNAPIAdModel pNAPIAdModel) {
            this.ad = pNAPIAdModel;
            this.timestamp = System.currentTimeMillis();
        }
    }
}

