/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.adapter.request;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import java.util.Map;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.core.insights.model.PNInsightModel;
import net.pubnative.sdk.core.request.PNAdModel;

public abstract class PNAdapter {
    private static String TAG = PNAdapter.class.getSimpleName();
    protected static final String DEFAULT_ERROR = "Unknown";
    protected PubnativeNetworkAdapterRunnable mTimeoutRunnable;
    protected Context mContext;
    protected Map mData;
    protected Map<String, String> mExtras;
    protected Handler mHandler;
    protected PNInsightModel mInsight;
    protected String mNetworkName;
    protected boolean mIsCPICacheEnabled;
    protected long mRequestStartTimeStamp;
    protected LoadListener mLoadListener;

    public PNAdapter(Map map) {
        this.mData = map;
    }

    public void setLoadListener(LoadListener loadListener) {
        this.mLoadListener = loadListener;
    }

    public void setExtras(Map<String, String> map) {
        this.mExtras = map;
    }

    public void setCPICacheEnabled(boolean bl) {
        this.mIsCPICacheEnabled = bl;
    }

    public void setInsight(PNInsightModel pNInsightModel) {
        this.mInsight = pNInsightModel;
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.mRequestStartTimeStamp;
    }

    public void execute(Context context, int n) {
        this.mRequestStartTimeStamp = System.currentTimeMillis();
        this.mContext = context;
        this.startTimeout(n);
        this.request(context);
    }

    protected void startTimeout(int n) {
        if (n > 0) {
            this.mTimeoutRunnable = new PubnativeNetworkAdapterRunnable();
            this.mHandler = new Handler(Looper.getMainLooper());
            this.mHandler.postDelayed((Runnable)this.mTimeoutRunnable, (long)n);
        }
    }

    protected void cancelTimeout() {
        if (this.mHandler != null && this.mTimeoutRunnable != null) {
            this.mHandler.removeCallbacks((Runnable)this.mTimeoutRunnable);
            this.mHandler = null;
        }
    }

    protected void onTimeout() {
        this.invokeLoadFail(PNException.ADAPTER_TIMEOUT);
    }

    protected void invokeLoadFinish(PNAdModel pNAdModel) {
        this.cancelTimeout();
        LoadListener loadListener = this.mLoadListener;
        this.mLoadListener = null;
        if (loadListener != null) {
            loadListener.onAdapterLoadFinish(this, pNAdModel);
        } else if (this.mInsight != null) {
            this.mInsight.sendRescueInsight(this.mNetworkName, this.getElapsedTime());
        }
    }

    protected void invokeLoadFail(Exception exception) {
        this.cancelTimeout();
        LoadListener loadListener = this.mLoadListener;
        this.mLoadListener = null;
        if (loadListener != null) {
            loadListener.onAdapterLoadFail(this, exception);
        }
    }

    protected abstract void request(Context var1);

    protected class PubnativeNetworkAdapterRunnable
    implements Runnable {
        private final String TAG = PubnativeNetworkAdapterRunnable.class.getSimpleName();

        protected PubnativeNetworkAdapterRunnable() {
        }

        @Override
        public void run() {
            PNAdapter.this.onTimeout();
        }
    }

    public static interface LoadListener {
        public void onAdapterLoadFinish(PNAdapter var1, PNAdModel var2);

        public void onAdapterLoadFail(PNAdapter var1, Exception var2);
    }
}

