/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.core.utils;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import net.pubnative.core.utils.PNPermissionUtil;

public class PNSystemUtils {
    private static final String TAG = PNSystemUtils.class.getSimpleName();
    private static String sWebViewUserAgent = null;

    public static String getUserAgent() {
        if (sWebViewUserAgent == null) {
            try {
                sWebViewUserAgent = System.getProperty("http.agent");
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"getUserAgent - Error: cannot inject user agent");
            }
        }
        return sWebViewUserAgent;
    }

    private static boolean hasFinePermission(Context context) {
        return PNPermissionUtil.hasPermission(context, "android.permission.ACCESS_FINE_LOCATION");
    }

    private static boolean hasCoarsePermission(Context context) {
        return PNPermissionUtil.hasPermission(context, "android.permission.ACCESS_COARSE_LOCATION");
    }

    private static boolean hasPermission(Context context) {
        return PNSystemUtils.hasCoarsePermission(context) || PNSystemUtils.hasFinePermission(context);
    }

    public static Location getLocation(Context context) {
        Location location = null;
        if (PNSystemUtils.hasPermission(context)) {
            LocationManager locationManager = (LocationManager)context.getSystemService("location");
            LocationListener locationListener = new LocationListener(){

                public void onLocationChanged(Location location) {
                }

                public void onStatusChanged(String string, int n, Bundle bundle) {
                }

                public void onProviderEnabled(String string) {
                }

                public void onProviderDisabled(String string) {
                }
            };
            Criteria criteria = new Criteria();
            criteria.setPowerRequirement(1);
            criteria.setAccuracy(2);
            criteria.setSpeedRequired(true);
            String string = locationManager.getBestProvider(criteria, true);
            if (string != null && (location = locationManager.getLastKnownLocation(string)) == null) {
                locationManager.requestLocationUpdates(string, 0L, 0.0f, locationListener);
            }
        }
        return location;
    }

    public static int dpToPx(Context context, int n) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return Math.round((float)n * (displayMetrics.xdpi / 160.0f));
    }
}

