/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.core.utils;

import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.LruCache;

public class PNBitmapLruCache {
    public static final String TAG = PNBitmapLruCache.class.getSimpleName();
    private static final int BYTES_IN_KILOBYTES = 1024;
    private static final int MAX_MEMORY_SIZE = 0x1E00000;
    private static LruCache<String, Bitmap> mMemoryCache;

    public static void addBitmapToMemoryCache(String string, Bitmap bitmap) {
        if (TextUtils.isEmpty((CharSequence)string) || bitmap == null) {
            return;
        }
        String string2 = String.valueOf(string.hashCode());
        if (PNBitmapLruCache.getBitmapFromMemCache(string2) == null) {
            mMemoryCache.put((Object)string2, (Object)bitmap);
        }
    }

    public static Bitmap getBitmapFromMemCache(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = String.valueOf(string.hashCode());
        return (Bitmap)mMemoryCache.get((Object)string2);
    }

    static {
        int n = (int)(Runtime.getRuntime().maxMemory() / 1024L);
        int n2 = n <= 0x1E00000 ? n : 0x1E00000;
        mMemoryCache = new LruCache<String, Bitmap>(n2){

            protected int sizeOf(String string, Bitmap bitmap) {
                return bitmap.getByteCount() / 1024;
            }
        };
    }
}

