/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.core.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.URLUtil;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import net.pubnative.core.utils.PNBitmapLruCache;

public class PNBitmapDownloader {
    private static final String TAG = PNBitmapDownloader.class.getSimpleName();
    private DownloadListener mDownloadListener;
    private String mURL;
    private Handler mHandler;
    private int mHeight;
    private int mWidth;
    private Runnable downloadTask = new Runnable(){
        HttpURLConnection connection = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                URL uRL = new URL(PNBitmapDownloader.this.mURL);
                this.connection = (HttpURLConnection)uRL.openConnection();
                InputStream inputStream = uRL.openConnection().getInputStream();
                BitmapFactory.decodeStream((InputStream)inputStream, (Rect)new Rect(), (BitmapFactory.Options)PNBitmapDownloader.this.getBitmapOptionsDecodingBounds(true));
                inputStream.close();
                InputStream inputStream2 = uRL.openConnection().getInputStream();
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream2, null, (BitmapFactory.Options)PNBitmapDownloader.this.getBitmapOptionsDecodingBounds(false));
                inputStream2.close();
                PNBitmapLruCache.addBitmapToMemoryCache(PNBitmapDownloader.this.mURL, bitmap);
                PNBitmapDownloader.this.invokeLoad(bitmap);
            }
            catch (Error error) {
                PNBitmapDownloader.this.invokeFail(new Exception(error.toString()));
            }
            catch (Exception exception) {
                PNBitmapDownloader.this.invokeFail(exception);
            }
            finally {
                if (this.connection != null) {
                    this.connection.disconnect();
                }
            }
        }
    };
    private Runnable loadFromFileSystemTask = new Runnable(){

        @Override
        public void run() {
            try {
                Uri uri = Uri.parse((String)PNBitmapDownloader.this.mURL);
                Bitmap bitmap = BitmapFactory.decodeFile((String)uri.getEncodedPath(), (BitmapFactory.Options)PNBitmapDownloader.this.getBitmapOptionsDecodingBounds(false));
                PNBitmapLruCache.addBitmapToMemoryCache(PNBitmapDownloader.this.mURL, bitmap);
                PNBitmapDownloader.this.invokeLoad(bitmap);
            }
            catch (Error error) {
                PNBitmapDownloader.this.invokeFail(new Exception(error.toString()));
            }
            catch (Exception exception) {
                PNBitmapDownloader.this.invokeFail(exception);
            }
        }
    };

    public void download(String string, DownloadListener downloadListener) {
        this.download(string, 0, 0, downloadListener);
    }

    public void download(String string, int n, int n2, DownloadListener downloadListener) {
        this.mHandler = new Handler(Looper.getMainLooper());
        if (downloadListener == null) {
            Log.w((String)TAG, (String)"download won't start since there is no assigned listener to It");
        } else {
            this.mDownloadListener = downloadListener;
            this.mURL = string;
            this.mWidth = n;
            this.mHeight = n2;
            if (TextUtils.isEmpty((CharSequence)string)) {
                this.invokeFail(new Exception("Image URL is empty"));
            } else if (URLUtil.isHttpUrl((String)string) || URLUtil.isHttpsUrl((String)string)) {
                this.downloadImage();
            } else if (URLUtil.isFileUrl((String)string)) {
                this.loadCachedImage();
            } else {
                this.invokeFail(new Exception("Wrong file URL!"));
            }
        }
    }

    private void downloadImage() {
        new Thread(this.downloadTask).start();
    }

    private void loadCachedImage() {
        new Thread(this.loadFromFileSystemTask).start();
    }

    private BitmapFactory.Options getBitmapOptionsDecodingBounds(boolean bl) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        if (this.mWidth > 0 && this.mHeight > 0 && !bl) {
            options.inSampleSize = this.calculateInSampleSize(options, this.mWidth, this.mHeight);
        }
        options.inJustDecodeBounds = bl;
        return options;
    }

    protected int calculateInSampleSize(BitmapFactory.Options options, int n, int n2) {
        int n3 = options.outHeight;
        int n4 = options.outWidth;
        int n5 = 1;
        if (n3 > n2 || n4 > n) {
            int n6 = n3 / 2;
            int n7 = n4 / 2;
            while (n6 / n5 >= n2 && n7 / n5 >= n) {
                n5 *= 2;
            }
        }
        return n5;
    }

    protected void invokeLoad(final Bitmap bitmap) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                DownloadListener downloadListener = PNBitmapDownloader.this.mDownloadListener;
                PNBitmapDownloader.this.mDownloadListener = null;
                if (downloadListener != null) {
                    downloadListener.onDownloadFinish(PNBitmapDownloader.this.mURL, bitmap);
                }
            }
        });
    }

    protected void invokeFail(final Exception exception) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                DownloadListener downloadListener = PNBitmapDownloader.this.mDownloadListener;
                PNBitmapDownloader.this.mDownloadListener = null;
                if (downloadListener != null) {
                    downloadListener.onDownloadFailed(PNBitmapDownloader.this.mURL, exception);
                }
            }
        });
    }

    public static interface DownloadListener {
        public void onDownloadFinish(String var1, Bitmap var2);

        public void onDownloadFailed(String var1, Exception var2);
    }
}

