/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.core.utils;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.util.Log;
import java.util.concurrent.LinkedBlockingQueue;

public class PNAdvertisingId {
    private static final String TAG = PNAdvertisingId.class.getSimpleName();
    protected Listener mListener;
    protected Handler mHadler;

    public void request(Context context, Listener listener) {
        this.mListener = listener;
        this.mHadler = new Handler(Looper.getMainLooper());
        this.getAdvertisingId(context);
    }

    protected void getAdvertisingId(final Context context) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object;
                AdInfo adInfo = null;
                try {
                    object = new Intent("com.google.android.gms.ads.identifier.service.START");
                    object.setPackage("com.google.android.gms");
                    AdvertisingConnection advertisingConnection = new AdvertisingConnection();
                    try {
                        if (context.bindService(object, (ServiceConnection)advertisingConnection, 1)) {
                            AdvertisingInterface advertisingInterface = new AdvertisingInterface(advertisingConnection.getBinder());
                            adInfo = new AdInfo(advertisingInterface.getId(), advertisingInterface.isLimitAdTrackingEnabled(true));
                        }
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)("getAdvertisingIdInfo - Error: " + exception));
                    }
                    finally {
                        context.unbindService((ServiceConnection)advertisingConnection);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)("getAdvertisingIdInfo - Error: " + exception));
                }
                object = null;
                if (adInfo != null) {
                    if (adInfo.isLimitAdTrackingEnabled()) {
                        Log.i((String)TAG, (String)"Error: cannot get advertising id, limit ad tracking is enabled");
                    } else {
                        object = adInfo.getId();
                    }
                }
                PNAdvertisingId.this.invokeOnFinish((String)object);
            }
        }).start();
    }

    protected void invokeOnFinish(final String string) {
        this.mHadler.post(new Runnable(){

            @Override
            public void run() {
                if (PNAdvertisingId.this.mListener != null) {
                    PNAdvertisingId.this.mListener.onPNAdvertisingIdFinish(string);
                }
            }
        });
    }

    protected class AdvertisingInterface
    implements IInterface {
        private IBinder binder;

        public AdvertisingInterface(IBinder iBinder) {
            this.binder = iBinder;
        }

        public IBinder asBinder() {
            return this.binder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getId() {
            Parcel parcel = Parcel.obtain();
            Parcel parcel2 = Parcel.obtain();
            String string = null;
            try {
                parcel.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                this.binder.transact(1, parcel, parcel2, 0);
                parcel2.readException();
                string = parcel2.readString();
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Error: Can't read AdvertisingId from the service", (Throwable)exception);
            }
            finally {
                parcel2.recycle();
                parcel.recycle();
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLimitAdTrackingEnabled(boolean bl) {
            Parcel parcel = Parcel.obtain();
            Parcel parcel2 = Parcel.obtain();
            boolean bl2 = false;
            try {
                parcel.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                parcel.writeInt(bl ? 1 : 0);
                this.binder.transact(2, parcel, parcel2, 0);
                parcel2.readException();
                bl2 = 0 != parcel2.readInt();
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Error: Can't get is limit Ad tracking enabled", (Throwable)exception);
            }
            finally {
                parcel2.recycle();
                parcel.recycle();
            }
            return bl2;
        }
    }

    protected class AdvertisingConnection
    implements ServiceConnection {
        boolean retrieved = false;
        private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

        protected AdvertisingConnection() {
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                this.queue.put(iBinder);
            }
            catch (InterruptedException interruptedException) {
                Log.e((String)TAG, (String)"Error: can't connect to AdvertisingId service", (Throwable)interruptedException);
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
        }

        public IBinder getBinder() {
            if (this.retrieved) {
                throw new IllegalStateException();
            }
            this.retrieved = true;
            return this.queue.take();
        }
    }

    public class AdInfo {
        private final String mAdvertisingId;
        private final boolean mLimitAdTrackingEnabled;

        AdInfo(String string, boolean bl) {
            this.mAdvertisingId = string;
            this.mLimitAdTrackingEnabled = bl;
        }

        public String getId() {
            return this.mAdvertisingId;
        }

        public boolean isLimitAdTrackingEnabled() {
            return this.mLimitAdTrackingEnabled;
        }
    }

    public static interface Listener {
        public void onPNAdvertisingIdFinish(String var1);
    }
}

