/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.layouts.asset_group;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import net.pubnative.api.core.request.model.PNAPIAdModel;
import net.pubnative.api.layouts.PNAPILayoutView;
import net.pubnative.api.layouts.asset_group.PNAPIAssetGroup;
import net.pubnative.core.utils.PNBitmapDownloader;
import net.pubnative.sdk.R;

public class PNAPIAssetGroup2
extends PNAPIAssetGroup
implements PNAPIAdModel.Listener {
    protected PNAPILayoutView.IDMap mIdMap;
    protected RelativeLayout mRoot;
    protected TextView mTitle;
    protected TextView mDescription;
    protected TextView mCallToAction;
    protected ImageView mIcon;
    protected RelativeLayout mContentInfo;

    public PNAPIAssetGroup2(Context context) {
        super(context);
    }

    @Override
    public void load() {
        this.mRoot = (RelativeLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pubnative_asset_group_2, (ViewGroup)this, true);
        this.mTitle = (TextView)this.mRoot.findViewById(R.id.pubnative_title);
        this.mDescription = (TextView)this.mRoot.findViewById(R.id.pubnative_description);
        this.mCallToAction = (TextView)this.mRoot.findViewById(R.id.pubnative_callToAction);
        this.mIcon = (ImageView)this.mRoot.findViewById(R.id.pubnative_icon);
        this.mContentInfo = (RelativeLayout)this.mRoot.findViewById(R.id.pubnative_content_info_container);
        this.mTitle.setText((CharSequence)this.mAdModel.getTitle());
        this.mDescription.setText((CharSequence)this.mAdModel.getDescription());
        this.mCallToAction.setText((CharSequence)this.mAdModel.getCtaText());
        new PNBitmapDownloader().download(this.mAdModel.getIconUrl(), this.mIcon.getWidth(), this.mIcon.getHeight(), new PNBitmapDownloader.DownloadListener(){

            @Override
            public void onDownloadFinish(String string, Bitmap bitmap) {
                PNAPIAssetGroup2.this.mIcon.setImageBitmap(bitmap);
                PNAPIAssetGroup2.this.invokeOnLoadFinish();
            }

            @Override
            public void onDownloadFailed(String string, Exception exception) {
                PNAPIAssetGroup2.this.invokeOnLoadFail(exception);
            }
        });
        View view = this.mAdModel.getContentInfo(this.mContext);
        if (view != null) {
            this.mContentInfo.addView(view);
        }
    }

    @Override
    public void startTracking() {
        this.mAdModel.startTracking((View)this.mRoot, this);
    }

    @Override
    public void stopTracking() {
        this.mAdModel.stopTracking();
    }

    @Override
    public PNAPILayoutView.IDMap getIDMap() {
        if (this.mIdMap == null) {
            this.mIdMap = new PNAPILayoutView.IDMap(this);
            this.mIdMap.title = this.mTitle.getId();
            this.mIdMap.callToAction = this.mCallToAction.getId();
            this.mIdMap.icon = this.mIcon.getId();
            this.mIdMap.description = this.mDescription.getId();
        }
        return this.mIdMap;
    }

    @Override
    public void onPNAPIAdModelImpression(PNAPIAdModel pNAPIAdModel, View view) {
        this.invokeOnImpressionConfirmed();
    }

    @Override
    public void onPNAPIAdModelClick(PNAPIAdModel pNAPIAdModel, View view) {
        this.invokeOnClick();
    }

    @Override
    public void onPNAPIAdModelOpenOffer(PNAPIAdModel pNAPIAdModel) {
    }
}

