/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.view;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import net.pubnative.api.core.view.PNAPILoadingView;

public class PNAPILoadingViewManager {
    protected static final String TAG = PNAPILoadingViewManager.class.getSimpleName();
    protected Context mContext;
    protected WindowManager mWindowManager;
    protected PNAPILoadingView mLoadingView;
    protected boolean isDisplayed;

    public PNAPILoadingViewManager(Context context) {
        this.mContext = context;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mLoadingView = new PNAPILoadingView(this.mContext);
        this.isDisplayed = false;
    }

    protected WindowManager.LayoutParams getWindowManagerParams() {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.width = -1;
        layoutParams.height = -1;
        layoutParams.flags = 262152;
        layoutParams.format = -3;
        return layoutParams;
    }

    public void show() {
        if (this.isDisplayed) {
            Log.i((String)TAG, (String)"Loader is already showing. Dropping call");
        } else {
            this.mWindowManager.addView((View)this.mLoadingView, (ViewGroup.LayoutParams)this.getWindowManagerParams());
            this.isDisplayed = true;
        }
    }

    public void hide() {
        if (this.isDisplayed) {
            this.mWindowManager.removeView((View)this.mLoadingView);
            this.isDisplayed = false;
        } else {
            Log.i((String)TAG, (String)"Loader is not showing. Dropping call");
        }
    }
}

