/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.tracking;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;
import net.pubnative.api.core.tracking.model.PNAPITrackingURLModel;
import net.pubnative.core.network.PNHttpRequest;
import net.pubnative.core.utils.PNStringUtils;

public class PNAPITrackingManager {
    private static final String TAG = PNAPITrackingManager.class.getSimpleName();
    private static final String SHARED_PREFERENCES = "PNAPITrackingManager";
    protected static final String SHARED_PENDING_LIST = "pending";
    protected static final String SHARED_FAILED_LIST = "failed";
    private static final long ITEM_VALIDITY_TIME = 1800000L;
    private static boolean sIsTracking = false;

    public static synchronized void track(Context context, String string) {
        if (context == null) {
            Log.w((String)TAG, (String)"track - ERROR: Context parameter is null");
        } else if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)"track - ERROR: url parameter is null");
        } else {
            PNAPITrackingManager.enqueueFailedList(context);
            PNAPITrackingURLModel pNAPITrackingURLModel = new PNAPITrackingURLModel();
            pNAPITrackingURLModel.url = string;
            pNAPITrackingURLModel.startTimestamp = System.currentTimeMillis();
            PNAPITrackingManager.enqueueItem(context, SHARED_PENDING_LIST, pNAPITrackingURLModel);
            PNAPITrackingManager.trackNextItem(context);
        }
    }

    protected static synchronized void trackNextItem(final Context context) {
        if (sIsTracking) {
            Log.w((String)TAG, (String)"trackNextItem - Currently tracking, dropping the call, will be resumed soon");
        } else {
            sIsTracking = true;
            final PNAPITrackingURLModel pNAPITrackingURLModel = PNAPITrackingManager.dequeueItem(context, SHARED_PENDING_LIST);
            if (pNAPITrackingURLModel == null) {
                sIsTracking = false;
            } else if (pNAPITrackingURLModel.startTimestamp + 1800000L < System.currentTimeMillis()) {
                sIsTracking = false;
                PNAPITrackingManager.trackNextItem(context);
            } else {
                new PNHttpRequest().start(context, pNAPITrackingURLModel.url, new PNHttpRequest.Listener(){

                    @Override
                    public void onPNHttpRequestFinish(PNHttpRequest pNHttpRequest, String string) {
                        sIsTracking = false;
                        PNAPITrackingManager.trackNextItem(context);
                    }

                    @Override
                    public void onPNHttpRequestFail(PNHttpRequest pNHttpRequest, Exception exception) {
                        PNAPITrackingManager.enqueueItem(context, PNAPITrackingManager.SHARED_FAILED_LIST, pNAPITrackingURLModel);
                        sIsTracking = false;
                        PNAPITrackingManager.trackNextItem(context);
                    }
                });
            }
        }
    }

    protected static void enqueueFailedList(Context context) {
        List<PNAPITrackingURLModel> list = PNAPITrackingManager.getList(context, SHARED_FAILED_LIST);
        List<PNAPITrackingURLModel> list2 = PNAPITrackingManager.getList(context, SHARED_PENDING_LIST);
        list2.addAll(list);
        PNAPITrackingManager.setList(context, SHARED_PENDING_LIST, list2);
        list.clear();
        PNAPITrackingManager.setList(context, SHARED_FAILED_LIST, list);
    }

    protected static void enqueueItem(Context context, String string, PNAPITrackingURLModel pNAPITrackingURLModel) {
        List<PNAPITrackingURLModel> list = PNAPITrackingManager.getList(context, string);
        list.add(pNAPITrackingURLModel);
        PNAPITrackingManager.setList(context, string, list);
    }

    protected static PNAPITrackingURLModel dequeueItem(Context context, String string) {
        PNAPITrackingURLModel pNAPITrackingURLModel = null;
        List<PNAPITrackingURLModel> list = PNAPITrackingManager.getList(context, string);
        if (list.size() > 0) {
            pNAPITrackingURLModel = list.get(0);
            list.remove(0);
            PNAPITrackingManager.setList(context, string, list);
        }
        return pNAPITrackingURLModel;
    }

    protected static List<PNAPITrackingURLModel> getList(Context context, String string) {
        List<Object> list = null;
        SharedPreferences sharedPreferences = PNAPITrackingManager.getSharedPreferences(context);
        String string2 = sharedPreferences.getString(string, null);
        list = string2 == null ? new ArrayList() : PNStringUtils.convertStringToObjects(string2, PNAPITrackingURLModel.class);
        return list;
    }

    protected static void setList(Context context, String string, List<PNAPITrackingURLModel> list) {
        SharedPreferences sharedPreferences = PNAPITrackingManager.getSharedPreferences(context);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        if (list == null) {
            editor.remove(string);
        } else {
            String string2 = PNStringUtils.convertObjectsToJson(list);
            editor.putString(string, string2);
        }
        editor.apply();
    }

    protected static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(SHARED_PREFERENCES, 0);
    }
}

