/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.URLUtil;
import java.io.InputStream;
import java.net.URL;

public class PNBitmapDownloader {
    private static final String TAG = PNBitmapDownloader.class.getSimpleName();
    private DownloadListener mDownloadListener;
    private String mURL;

    public void download(String string, DownloadListener downloadListener) {
        if (downloadListener == null) {
            Log.w((String)TAG, (String)"download won't start since there is no assigned listener to It");
        } else {
            this.mDownloadListener = downloadListener;
            this.mURL = string;
            if (TextUtils.isEmpty((CharSequence)string)) {
                this.invokeFail(new Exception("image download "));
            } else if (URLUtil.isHttpUrl((String)string) || URLUtil.isHttpsUrl((String)string)) {
                this.downloadImage();
            } else if (URLUtil.isFileUrl((String)string)) {
                this.loadCachedImage();
            } else {
                this.invokeFail(new Exception("Wrong file URL!"));
            }
        }
    }

    private void downloadImage() {
        try {
            URL uRL = new URL(this.mURL);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)uRL.openConnection().getInputStream(), (Rect)new Rect(), (BitmapFactory.Options)options);
            int n = this.calculateInSampleSize(options);
            if (n == 0) {
                this.invokeFail(new Exception("Not enough memory"));
            } else {
                options.inSampleSize = n;
                options.inJustDecodeBounds = false;
                Bitmap bitmap = BitmapFactory.decodeStream((InputStream)uRL.openConnection().getInputStream(), null, (BitmapFactory.Options)options);
                this.invokeLoad(bitmap);
            }
        }
        catch (Error error) {
            this.invokeFail(new Exception(error.toString()));
        }
        catch (Exception exception) {
            this.invokeFail(exception);
        }
    }

    private void loadCachedImage() {
        try {
            Uri uri = Uri.parse((String)this.mURL);
            BitmapFactory.Options options = new BitmapFactory.Options();
            int n = this.calculateInSampleSize(options);
            if (n == 0) {
                this.invokeFail(new Exception("Not enough memory"));
            } else {
                options.inSampleSize = n;
                options.inJustDecodeBounds = false;
                Bitmap bitmap = BitmapFactory.decodeFile((String)uri.getEncodedPath(), (BitmapFactory.Options)options);
                this.invokeLoad(bitmap);
            }
        }
        catch (Error error) {
            this.invokeFail(new Exception(error.toString()));
        }
        catch (Exception exception) {
            this.invokeFail(exception);
        }
    }

    protected int calculateInSampleSize(BitmapFactory.Options options) {
        int n = 1;
        int n2 = (int)Runtime.getRuntime().freeMemory();
        int n3 = 4;
        int n4 = options.outWidth * options.outHeight * n3;
        if (n2 == 0) {
            n = 0;
        } else if (n4 > n2 && n2 > 0) {
            n = n4 / n2;
        }
        return n;
    }

    protected void invokeLoad(Bitmap bitmap) {
        DownloadListener downloadListener = this.mDownloadListener;
        this.mDownloadListener = null;
        if (downloadListener != null) {
            downloadListener.onDownloadFinish(this.mURL, bitmap);
        }
    }

    protected void invokeFail(Exception exception) {
        DownloadListener downloadListener = this.mDownloadListener;
        this.mDownloadListener = null;
        if (downloadListener != null) {
            downloadListener.onDownloadFailed(this.mURL, exception);
        }
    }

    public static interface DownloadListener {
        public void onDownloadFinish(String var1, Bitmap var2);

        public void onDownloadFailed(String var1, Exception var2);
    }
}

