/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core.request;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;
import android.util.LruCache;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import net.pubnative.api.core.utils.PNAPIImageDownloader;
import net.pubnative.sdk.core.insights.model.PNInsightDataModel;
import net.pubnative.sdk.core.insights.model.PNInsightModel;

public abstract class PNAdModel {
    private static final String TAG = PNAdModel.class.getSimpleName();
    protected Context mContext = null;
    protected Listener mListener = null;
    protected List<FetchListener> mFetchListeners = null;
    protected PNInsightModel mInsightModel = null;
    protected TextView mTitleView = null;
    protected TextView mDescriptionView = null;
    protected ImageView mIconView = null;
    protected ViewGroup mBannerView = null;
    protected RatingBar mRatingView = null;
    protected View mCallToActionView = null;
    protected ViewGroup mContentInfoView = null;
    protected LruCache<String, Bitmap> mCachedAssets = null;
    protected int mRemainingCacheableAssets = 0;

    public void setListener(Listener listener) {
        Log.v((String)TAG, (String)"setLoadListener");
        this.mListener = listener;
    }

    public PNAdModel(Context context) {
        this.mContext = context;
    }

    public abstract String getTitle();

    public abstract String getDescription();

    public View getBanner() {
        Bitmap bitmap = this.getAsset(this.getBannerUrl());
        final ImageView imageView = new ImageView(this.mContext);
        if (this.mBannerView == null) {
            this.mBannerView = new RelativeLayout(this.mContext);
            this.mBannerView.addView((View)imageView, -1, -1);
        }
        if (bitmap == null) {
            this.fetchAssets(new FetchListener(){

                @Override
                public void onFetchFinish(PNAdModel pNAdModel) {
                    Bitmap bitmap = PNAdModel.this.getAsset(PNAdModel.this.getBannerUrl());
                    imageView.setImageBitmap(bitmap);
                }

                @Override
                public void onFetchFail(PNAdModel pNAdModel, Exception exception) {
                    Log.w((String)TAG, (String)"error fetching assets", (Throwable)exception);
                }
            });
        } else {
            imageView.setImageBitmap(bitmap);
        }
        return this.mBannerView;
    }

    public View getIcon() {
        Bitmap bitmap = this.getAsset(this.getIconUrl());
        if (this.mIconView == null) {
            this.mIconView = new ImageView(this.mContext);
        }
        if (bitmap == null) {
            this.fetchAssets(new FetchListener(){

                @Override
                public void onFetchFinish(PNAdModel pNAdModel) {
                    Bitmap bitmap = PNAdModel.this.getAsset(PNAdModel.this.getIconUrl());
                    PNAdModel.this.mIconView.setImageBitmap(bitmap);
                }

                @Override
                public void onFetchFail(PNAdModel pNAdModel, Exception exception) {
                    Log.w((String)TAG, (String)"error fetching assets", (Throwable)exception);
                }
            });
        } else {
            this.mIconView.setImageBitmap(bitmap);
        }
        return this.mIconView;
    }

    public abstract String getCallToAction();

    public abstract float getStarRating();

    public abstract View getContentInfoView();

    protected String getContentInfoClickUrl() {
        return null;
    }

    protected String getContentInfoImageUrl() {
        return null;
    }

    protected String getBannerUrl() {
        return null;
    }

    protected String getIconUrl() {
        return null;
    }

    public PNAdModel withTitle(TextView textView) {
        this.mTitleView = textView;
        if (this.mTitleView != null) {
            this.mTitleView.setText((CharSequence)this.getTitle());
        }
        return this;
    }

    public PNAdModel withDescription(TextView textView) {
        this.mDescriptionView = textView;
        if (this.mDescriptionView != null) {
            this.mDescriptionView.setText((CharSequence)this.getDescription());
        }
        return this;
    }

    public PNAdModel withIcon(ImageView imageView) {
        this.mIconView = imageView;
        if (this.mIconView != null) {
            this.getIcon();
        }
        return this;
    }

    public PNAdModel withBanner(ViewGroup viewGroup) {
        if (viewGroup != null) {
            View view = this.getBanner();
            viewGroup.addView(view);
            view.bringToFront();
        }
        return this;
    }

    public PNAdModel withRating(RatingBar ratingBar) {
        this.mRatingView = ratingBar;
        if (this.mRatingView != null) {
            this.mRatingView.setRating(this.getStarRating());
        }
        return this;
    }

    public PNAdModel withCallToAction(Button button) {
        this.mCallToActionView = button;
        if (this.mCallToActionView != null) {
            ((Button)this.mCallToActionView).setText((CharSequence)this.getCallToAction());
        }
        return this;
    }

    public PNAdModel withCallToAction(TextView textView) {
        this.mCallToActionView = textView;
        if (this.mCallToActionView != null) {
            ((TextView)this.mCallToActionView).setText((CharSequence)this.getCallToAction());
        }
        return this;
    }

    public PNAdModel withContentInfoContainer(ViewGroup viewGroup) {
        this.mContentInfoView = viewGroup;
        View view = this.getContentInfoView();
        if (this.mContentInfoView != null && view != null) {
            this.mContentInfoView.addView(view);
        }
        return this;
    }

    public abstract void startTracking(ViewGroup var1);

    public abstract void stopTracking();

    public void setInsightModel(PNInsightModel pNInsightModel) {
        this.mInsightModel = pNInsightModel;
        if (this.mInsightModel != null) {
            PNInsightDataModel pNInsightDataModel = this.mInsightModel.getData();
            pNInsightDataModel.creative_url = "icon".equals(pNInsightDataModel.ad_format_code) ? this.getIconUrl() : this.getBannerUrl();
            pNInsightModel.setData(pNInsightDataModel);
        }
    }

    protected void fetchAssets(FetchListener fetchListener) {
        if (this.mFetchListeners == null) {
            this.mRemainingCacheableAssets = 2;
            this.mFetchListeners = new ArrayList<FetchListener>();
            this.mFetchListeners.add(fetchListener);
            this.fetchAsset(this.getIconUrl());
            this.fetchAsset(this.getBannerUrl());
            Log.w((String)TAG, (String)"LoadListener is not set");
        } else {
            this.mFetchListeners.add(fetchListener);
        }
    }

    protected void fetchAsset(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.checkFetchProgress();
        } else {
            new PNAPIImageDownloader().load(string, new PNAPIImageDownloader.Listener(){

                @Override
                public void onImageLoad(String string, Bitmap bitmap) {
                    PNAdModel.this.cacheAsset(string, bitmap);
                    PNAdModel.this.checkFetchProgress();
                }

                @Override
                public void onImageFailed(String string, Exception exception) {
                    Log.w((String)TAG, (String)("Asset download error: " + string), (Throwable)exception);
                    PNAdModel.this.invokeFetchFail(exception);
                }
            });
        }
    }

    protected void cacheAsset(String string, Bitmap bitmap) {
        if (this.mCachedAssets == null) {
            this.mCachedAssets = new LruCache(2);
        }
        if (!TextUtils.isEmpty((CharSequence)string) && bitmap != null) {
            this.mCachedAssets.put((Object)string, (Object)bitmap);
        }
    }

    protected void checkFetchProgress() {
        --this.mRemainingCacheableAssets;
        if (this.mRemainingCacheableAssets == 0) {
            this.invokeFetchFinish();
        }
    }

    protected Bitmap getAsset(String string) {
        Bitmap bitmap = null;
        if (this.mCachedAssets != null) {
            bitmap = (Bitmap)this.mCachedAssets.get((Object)string);
        }
        return bitmap;
    }

    protected void invokeImpressionConfirmed() {
        if (this.mInsightModel != null) {
            this.mInsightModel.sendImpressionInsight();
        }
        if (this.mListener != null) {
            this.mListener.onPNAdImpression(this);
        }
    }

    protected void invokeClick() {
        if (this.mInsightModel != null) {
            this.mInsightModel.sendClickInsight();
        }
        if (this.mListener != null) {
            this.mListener.onPNAdClick(this);
        }
    }

    protected void invokeFetchFinish() {
        List<FetchListener> list = this.mFetchListeners;
        this.mFetchListeners = null;
        if (list != null) {
            for (FetchListener fetchListener : list) {
                if (fetchListener == null) continue;
                fetchListener.onFetchFinish(this);
            }
        }
    }

    protected void invokeFetchFail(Exception exception) {
        List<FetchListener> list = this.mFetchListeners;
        this.mFetchListeners = null;
        if (list != null) {
            for (FetchListener fetchListener : list) {
                if (fetchListener == null) continue;
                fetchListener.onFetchFail(this, exception);
            }
        }
    }

    protected static interface FetchListener {
        public void onFetchFinish(PNAdModel var1);

        public void onFetchFail(PNAdModel var1, Exception var2);
    }

    public static interface Listener {
        public void onPNAdImpression(PNAdModel var1);

        public void onPNAdClick(PNAdModel var1);
    }
}

