/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.core;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.location.Location;
import android.os.Build;
import java.util.Locale;
import net.pubnative.api.core.utils.PNAPISystemUtils;
import net.pubnative.sdk.core.request.PNAdTargetingModel;
import net.pubnative.sdk.core.utils.PNAdvertisingId;
import net.pubnative.sdk.core.utils.PNDeviceUtils;

public class PNSettings {
    public static boolean isTestModeEnabled;
    public static boolean isCoppaModeEnabled;
    public static PNAdTargetingModel targeting;
    public static String advertisingId;
    public static String os;
    public static String osVersion;
    public static String deviceName;
    public static String locale;
    public static String sdkVersion;
    public static String appBundleID;
    public static String appVersion;
    public static Location location;

    public static void init(Context context, final Listener listener) {
        os = "android";
        deviceName = Build.MODEL;
        osVersion = Build.VERSION.RELEASE;
        locale = Locale.getDefault().getLanguage();
        sdkVersion = "2.0.7 (50)";
        PackageInfo packageInfo = PNDeviceUtils.getPackageInfo(context);
        if (packageInfo != null) {
            appBundleID = packageInfo.packageName;
            appVersion = packageInfo.versionName;
        }
        if (isCoppaModeEnabled) {
            listener.onInitFinish();
        } else {
            location = PNAPISystemUtils.getLocation(context);
            PNAdvertisingId pNAdvertisingId = new PNAdvertisingId();
            pNAdvertisingId.request(context, new PNAdvertisingId.Listener(){

                @Override
                public void onPubnativeAdvertisingIdFinish(String string) {
                    PNSettings.invokeFinish(string, listener);
                }
            });
        }
    }

    protected static void invokeFinish(String string, Listener listener) {
        advertisingId = string;
        if (listener != null) {
            listener.onInitFinish();
        }
    }

    public static interface Listener {
        public void onInitFinish();
    }
}

