/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.request.model;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.pubnative.URLDriller;
import net.pubnative.api.core.request.model.api.PNAPIV3AdModel;
import net.pubnative.api.core.request.model.api.PNAPIV3DataModel;
import net.pubnative.api.core.tracking.PNAPIImpressionManager;
import net.pubnative.api.core.tracking.PNAPIImpressionTracker;
import net.pubnative.api.core.tracking.PNAPITrackingManager;
import net.pubnative.api.core.utils.PNAPISystemUtils;
import net.pubnative.api.core.view.PNAPIContentInfoView;
import net.pubnative.api.core.view.PNAPIWebView;

public class PNAPIAdModel
implements Serializable,
URLDriller.Listener,
PNAPIImpressionTracker.Listener {
    private static String TAG = PNAPIAdModel.class.getSimpleName();
    private static final String DATA_CONTENTINFO_LINK_KEY = "link";
    private static final String DATA_CONTENTINFO_ICON_KEY = "icon";
    private static final String DATA_TRACKING_KEY = "tracking";
    private static final int URL_DRILLER_DEPTH = 15;
    protected transient Listener mListener;
    protected PNAPIV3AdModel mData;
    protected List<String> mUsedAssets;
    protected UUID mUUID;
    protected Map<String, String> mTrackingExtras;
    private transient boolean mIsImpressionConfirmed;
    private transient View mClickableView;
    private transient View mAdView;
    private transient RelativeLayout mLoadingView;
    protected boolean mIsWaitingForClickCache = false;
    protected boolean mIsClickLoaderEnabled = true;
    protected boolean mIsClickInBackgroundEnabled = true;
    protected boolean mIsClickCachingEnabled = false;
    protected boolean mIsClickPreparing = false;
    protected String mClickFinalURL = null;

    public static PNAPIAdModel create(PNAPIV3AdModel pNAPIV3AdModel) {
        PNAPIAdModel pNAPIAdModel = new PNAPIAdModel();
        pNAPIAdModel.mData = pNAPIV3AdModel;
        return pNAPIAdModel;
    }

    public PNAPIV3DataModel getMeta(String string) {
        PNAPIV3DataModel pNAPIV3DataModel = null;
        if (this.mData == null) {
            Log.w((String)TAG, (String)"getMeta - Error: ad data not present");
        } else {
            pNAPIV3DataModel = this.mData.getMeta(string);
        }
        return pNAPIV3DataModel;
    }

    public PNAPIV3DataModel getAsset(String string) {
        return this.getAsset(string, true);
    }

    protected PNAPIV3DataModel getAsset(String string, boolean bl) {
        PNAPIV3DataModel pNAPIV3DataModel = null;
        if (this.mData == null) {
            Log.w((String)TAG, (String)"getAsset - Error: ad data not present");
        } else {
            pNAPIV3DataModel = this.mData.getAsset(string);
            if (pNAPIV3DataModel != null) {
                this.recordAsset(pNAPIV3DataModel.getStringField(DATA_TRACKING_KEY));
            }
        }
        return pNAPIV3DataModel;
    }

    protected void recordAsset(String string) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (this.mUsedAssets == null) {
                this.mUsedAssets = new ArrayList<String>();
            }
            if (!this.mUsedAssets.contains(string)) {
                this.mUsedAssets.add(string);
            }
        }
    }

    public String getTitle() {
        String string = null;
        PNAPIV3DataModel pNAPIV3DataModel = this.getAsset("title");
        if (pNAPIV3DataModel != null) {
            string = pNAPIV3DataModel.getText();
        }
        return string;
    }

    public String getDescription() {
        String string = null;
        PNAPIV3DataModel pNAPIV3DataModel = this.getAsset("description");
        if (pNAPIV3DataModel != null) {
            string = pNAPIV3DataModel.getText();
        }
        return string;
    }

    public String getCtaText() {
        String string = null;
        PNAPIV3DataModel pNAPIV3DataModel = this.getAsset("cta");
        if (pNAPIV3DataModel != null) {
            string = pNAPIV3DataModel.getText();
        }
        return string;
    }

    public String getIconUrl() {
        String string = null;
        PNAPIV3DataModel pNAPIV3DataModel = this.getAsset(DATA_CONTENTINFO_ICON_KEY);
        if (pNAPIV3DataModel != null) {
            string = pNAPIV3DataModel.getURL();
        }
        return string;
    }

    public String getVast() {
        String string = null;
        PNAPIV3DataModel pNAPIV3DataModel = this.getAsset("vast2");
        if (pNAPIV3DataModel != null) {
            string = pNAPIV3DataModel.getStringField("vast2");
        }
        return string;
    }

    public String getBannerUrl() {
        String string = null;
        PNAPIV3DataModel pNAPIV3DataModel = this.getAsset("banner");
        if (pNAPIV3DataModel != null) {
            string = pNAPIV3DataModel.getURL();
        }
        return string;
    }

    public String getAssetUrl(String string) {
        String string2 = null;
        PNAPIV3DataModel pNAPIV3DataModel = this.getAsset(string);
        if (pNAPIV3DataModel != null) {
            string2 = pNAPIV3DataModel.getURL();
        }
        return string2;
    }

    public String getAssetHtml(String string) {
        String string2 = null;
        PNAPIV3DataModel pNAPIV3DataModel = this.getAsset(string);
        if (pNAPIV3DataModel != null) {
            string2 = pNAPIV3DataModel.getHtml();
        }
        return string2;
    }

    public int getAssetGroupId() {
        int n = 0;
        if (this.mData != null) {
            n = this.mData.assetgroupid;
        }
        return n;
    }

    public void setAssetGroupId(int n) {
        if (this.mData != null) {
            this.mData.assetgroupid = n;
        }
    }

    public String getClickUrl() {
        String string = null;
        if (this.mData != null) {
            string = this.injectExtras(this.mData.link);
        }
        return string;
    }

    public int getRating() {
        Double d;
        int n = 0;
        PNAPIV3DataModel pNAPIV3DataModel = this.getAsset("rating");
        if (pNAPIV3DataModel != null && (d = pNAPIV3DataModel.getNumber()) != null) {
            n = d.intValue();
        }
        return n;
    }

    public View getContentInfo(Context context) {
        PNAPIContentInfoView pNAPIContentInfoView = null;
        PNAPIV3DataModel pNAPIV3DataModel = this.getMeta("contentinfo");
        if (context == null) {
            Log.e((String)TAG, (String)"getContentInfo - not a valid context");
        } else if (pNAPIV3DataModel == null) {
            Log.e((String)TAG, (String)"getContentInfo - contentInfo data not found");
        } else if (TextUtils.isEmpty((CharSequence)pNAPIV3DataModel.getStringField(DATA_CONTENTINFO_ICON_KEY))) {
            Log.e((String)TAG, (String)"getContentInfo - contentInfo icon not found");
        } else if (TextUtils.isEmpty((CharSequence)pNAPIV3DataModel.getStringField(DATA_CONTENTINFO_LINK_KEY))) {
            Log.e((String)TAG, (String)"getContentInfo - contentInfo link not found");
        } else if (TextUtils.isEmpty((CharSequence)pNAPIV3DataModel.getText())) {
            Log.e((String)TAG, (String)"getContentInfo - contentInfo text not found");
        } else {
            pNAPIContentInfoView = new PNAPIContentInfoView(context);
            pNAPIContentInfoView.setIconUrl(pNAPIV3DataModel.getStringField(DATA_CONTENTINFO_ICON_KEY));
            pNAPIContentInfoView.setIconClickUrl(pNAPIV3DataModel.getStringField(DATA_CONTENTINFO_LINK_KEY));
            pNAPIContentInfoView.setContextText(pNAPIV3DataModel.getText());
            pNAPIContentInfoView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    ((PNAPIContentInfoView)view).openLayout();
                }
            });
        }
        return pNAPIContentInfoView;
    }

    public String getContentInfoIconUrl() {
        PNAPIV3DataModel pNAPIV3DataModel = this.getMeta("contentinfo");
        return pNAPIV3DataModel.getStringField(DATA_CONTENTINFO_ICON_KEY);
    }

    public String getContentInfoClickUrl() {
        PNAPIV3DataModel pNAPIV3DataModel = this.getMeta("contentinfo");
        return pNAPIV3DataModel.getStringField(DATA_CONTENTINFO_LINK_KEY);
    }

    public boolean isRevenueModelCPA() {
        PNAPIV3DataModel pNAPIV3DataModel = this.getMeta("revenuemodel");
        if (pNAPIV3DataModel != null) {
            return pNAPIV3DataModel.getText().equalsIgnoreCase("cpa");
        }
        return false;
    }

    public void setUseClickLoader(boolean bl) {
        this.mIsClickLoaderEnabled = bl;
    }

    public void setUseClickInBackground(boolean bl) {
        this.mIsClickInBackgroundEnabled = bl;
    }

    public void setUseClickCaching(boolean bl) {
        this.mIsClickCachingEnabled = bl;
    }

    public void fetch() {
        this.prepareClickURL();
    }

    protected void prepareClickURL() {
        if (this.isRevenueModelCPA() && this.mIsClickCachingEnabled && this.mClickFinalURL == null && !this.mIsClickPreparing) {
            this.mIsClickPreparing = true;
            this.mUUID = UUID.randomUUID();
            String string = this.getClickUrl() + "&uxc=true&uuid=" + this.mUUID.toString();
            URLDriller uRLDriller = new URLDriller();
            uRLDriller.setDrillSize(15);
            uRLDriller.setListener(new URLDriller.Listener(){

                public void onURLDrillerStart(String string) {
                }

                public void onURLDrillerRedirect(String string) {
                }

                public void onURLDrillerFinish(String string) {
                    PNAPIAdModel.this.onPrepareClickURLFinish(string);
                }

                public void onURLDrillerFail(String string, Exception exception) {
                    PNAPIAdModel.this.onPrepareClickURLFinish(string);
                }
            });
            uRLDriller.drill(string);
        }
    }

    protected void onPrepareClickURLFinish(String string) {
        this.mClickFinalURL = string;
        this.mIsClickPreparing = false;
        if (this.mIsWaitingForClickCache) {
            this.mIsWaitingForClickCache = false;
            this.openCachedClick();
            this.hideLoadingView();
        }
    }

    protected void openCachedClick() {
        URLDriller uRLDriller = new URLDriller();
        uRLDriller.setDrillSize(15);
        uRLDriller.setUserAgent(PNAPISystemUtils.getWebViewUserAgent());
        uRLDriller.setListener((URLDriller.Listener)this);
        uRLDriller.drill(this.getClickUrl() + "&cached=true&uuid=" + this.mUUID.toString());
        this.openURL(this.mClickFinalURL);
    }

    protected String injectExtras(String string) {
        String string2 = string;
        if (!TextUtils.isEmpty((CharSequence)string) && this.mTrackingExtras != null && this.mTrackingExtras.size() > 0) {
            Uri.Builder builder = Uri.parse((String)string).buildUpon();
            for (String string3 : this.mTrackingExtras.keySet()) {
                String string4 = this.mTrackingExtras.get(string3);
                builder.appendQueryParameter(string3, string4);
            }
            string2 = builder.build().toString();
        }
        return string2;
    }

    public void startTracking(View view, Listener listener) {
        this.startTracking(view, view, listener);
    }

    public void startTracking(View view, View view2, Listener listener) {
        this.startTracking(view, view2, null, listener);
    }

    public void startTracking(View view, View view2, Map<String, String> map, Listener listener) {
        if (listener == null) {
            Log.w((String)TAG, (String)"startTracking - listener is null, start tracking without callbacks");
        }
        this.mListener = listener;
        this.mTrackingExtras = map;
        this.stopTracking();
        this.startTrackingImpression(view);
        this.startTrackingClicks(view2);
    }

    protected void startTrackingImpression(View view) {
        if (view == null) {
            Log.w((String)TAG, (String)"ad view is null, cannot start tracking");
        } else if (this.mIsImpressionConfirmed) {
            Log.i((String)TAG, (String)"impression is already confirmed, dropping impression tracking");
        } else {
            this.mAdView = view;
            PNAPIImpressionManager.startTrackingView(view, this);
        }
    }

    protected void startTrackingClicks(View view) {
        if (TextUtils.isEmpty((CharSequence)this.getClickUrl())) {
            Log.w((String)TAG, (String)"click url is empty, clicks won't be tracked");
        } else if (view == null) {
            Log.w((String)TAG, (String)"click view is null, clicks won't be tracked");
        } else {
            this.prepareClickURL();
            this.mClickableView = view;
            this.mClickableView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (PNAPIAdModel.this.mIsClickLoaderEnabled) {
                        PNAPIAdModel.this.showLoadingView();
                    }
                    PNAPIAdModel.this.invokeOnClick(view);
                    PNAPIAdModel.this.confirmClickBeacons(view.getContext());
                    if (PNAPIAdModel.this.mIsClickInBackgroundEnabled) {
                        if (PNAPIAdModel.this.mIsClickCachingEnabled) {
                            if (PNAPIAdModel.this.mClickFinalURL == null) {
                                PNAPIAdModel.this.mIsWaitingForClickCache = true;
                            } else {
                                PNAPIAdModel.this.openCachedClick();
                            }
                        } else {
                            URLDriller uRLDriller = new URLDriller();
                            uRLDriller.setDrillSize(15);
                            uRLDriller.setUserAgent(PNAPISystemUtils.getWebViewUserAgent());
                            uRLDriller.setListener((URLDriller.Listener)PNAPIAdModel.this);
                            uRLDriller.drill(PNAPIAdModel.this.getClickUrl());
                        }
                    } else {
                        PNAPIAdModel.this.openURL(PNAPIAdModel.this.getClickUrl());
                    }
                }
            });
        }
    }

    public void stopTracking() {
        this.stopTrackingImpression();
        this.stopTrackingClicks();
    }

    protected void stopTrackingImpression() {
        PNAPIImpressionManager.stopTrackingAll(this);
    }

    protected void stopTrackingClicks() {
        if (this.mClickableView != null) {
            this.mClickableView.setOnClickListener(null);
        }
    }

    protected void openURL(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)("Error: ending URL cannot be opened - " + string));
        } else if (this.mClickableView == null) {
            Log.w((String)TAG, (String)"Error: clickable view not set");
        } else {
            try {
                Uri uri = Uri.parse((String)string);
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.setFlags(0x10000000);
                this.mClickableView.getContext().startActivity(intent);
                this.invokeOnOpenOffer();
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)("openURL: Error - " + exception.getMessage()));
            }
        }
    }

    protected void confirmImpressionBeacons(Context context) {
        if (this.mUsedAssets != null) {
            for (String string : this.mUsedAssets) {
                PNAPITrackingManager.track(context, string);
            }
        }
        this.confirmBeacons("impression", context);
    }

    protected void confirmClickBeacons(Context context) {
        this.confirmBeacons("click", context);
    }

    protected void confirmBeacons(String string, Context context) {
        if (this.mData == null) {
            Log.w((String)TAG, (String)"confirmBeacons - Error: ad data not present");
            return;
        }
        List<PNAPIV3DataModel> list = this.mData.getBeacons(string);
        if (list == null) {
            return;
        }
        for (PNAPIV3DataModel pNAPIV3DataModel : list) {
            String string2 = this.injectExtras(pNAPIV3DataModel.getURL());
            String string3 = pNAPIV3DataModel.getStringField("js");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                PNAPITrackingManager.track(context, string2);
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)string3)) continue;
            try {
                new PNAPIWebView(context).loadBeacon(string3);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)("confirmImpressionBeacons - JS Error: " + exception));
            }
        }
    }

    protected void showLoadingView() {
        if (this.getRootView() == null) {
            Log.w((String)TAG, (String)"showLoadingView - Error: impossible to retrieve root view");
        } else {
            this.hideLoadingView();
            this.getRootView().addView((View)this.getLoadingView(), new ViewGroup.LayoutParams(-1, -1));
        }
    }

    protected void hideLoadingView() {
        if (this.getLoadingView() == null) {
            Log.w((String)TAG, (String)"loading view is still not loaded, thus you cannot hide it");
        } else if (this.mLoadingView.getParent() == null) {
            Log.w((String)TAG, (String)"loading view is still not attached to any view");
        } else {
            ((ViewGroup)this.mLoadingView.getParent()).removeView((View)this.mLoadingView);
        }
    }

    protected ViewGroup getRootView() {
        ViewGroup viewGroup = null;
        if (this.mAdView == null) {
            Log.w((String)TAG, (String)"getRootView - Error: not assigned ad view, cannot retrieve root view");
        } else {
            viewGroup = (ViewGroup)this.mAdView.getRootView();
        }
        return viewGroup;
    }

    protected RelativeLayout getLoadingView() {
        if (this.mLoadingView == null) {
            this.mLoadingView = new RelativeLayout(this.mAdView.getContext());
            this.mLoadingView.setGravity(17);
            this.mLoadingView.setBackgroundColor(Color.argb((int)77, (int)0, (int)0, (int)0));
            this.mLoadingView.setClickable(true);
            this.mLoadingView.addView((View)new ProgressBar(this.mAdView.getContext()));
        }
        return this.mLoadingView;
    }

    protected void invokeOnImpression(View view) {
        this.mIsImpressionConfirmed = true;
        if (this.mListener != null) {
            this.mListener.onPNAPIAdModelImpression(this, view);
        }
    }

    protected void invokeOnClick(View view) {
        if (this.mListener != null) {
            this.mListener.onPNAPIAdModelClick(this, view);
        }
    }

    protected void invokeOnOpenOffer() {
        if (this.mListener != null) {
            this.mListener.onPNAPIAdModelOpenOffer(this);
        }
    }

    @Override
    public void onImpression(View view) {
        this.confirmImpressionBeacons(view.getContext());
        this.invokeOnImpression(view);
    }

    public void onURLDrillerStart(String string) {
    }

    public void onURLDrillerRedirect(String string) {
    }

    public void onURLDrillerFinish(String string) {
        if (this.mClickFinalURL == null) {
            this.openURL(string);
        }
        this.hideLoadingView();
    }

    public void onURLDrillerFail(String string, Exception exception) {
        if (this.mClickFinalURL == null) {
            this.openURL(string);
        }
        this.hideLoadingView();
    }

    public static interface Listener {
        public void onPNAPIAdModelImpression(PNAPIAdModel var1, View var2);

        public void onPNAPIAdModelClick(PNAPIAdModel var1, View var2);

        public void onPNAPIAdModelOpenOffer(PNAPIAdModel var1);
    }
}

