/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.layouts;

import android.content.Context;
import android.util.Log;
import java.util.Map;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.layouts.PNLayout;
import net.pubnative.sdk.layouts.PNSmallLayoutView;
import net.pubnative.sdk.layouts.adapter.PNLayoutAdapter;
import net.pubnative.sdk.layouts.adapter.PNLayoutFeedAdapter;
import net.pubnative.sdk.layouts.adapter.small.PNSmallLayoutAdapterFactory;

public class PNSmallLayout
extends PNLayout
implements PNLayoutAdapter.LoadListener,
PNLayoutAdapter.TrackListener {
    private static final String TAG = PNSmallLayout.class.getSimpleName();
    protected PNLayoutFeedAdapter mAdapter;

    public PNSmallLayoutView getView(Context context) {
        PNSmallLayoutView pNSmallLayoutView = null;
        if (this.mAdapter == null) {
            Log.w((String)TAG, (String)"Error: Ad not loaded, or failed during load, please reload it again");
        } else {
            pNSmallLayoutView = (PNSmallLayoutView)this.mAdapter.getView(context);
        }
        return pNSmallLayoutView;
    }

    public void startTrackingView() {
        if (this.mAdapter == null) {
            Log.w((String)TAG, (String)"Error: Ad not loaded, or failed during load, please reload it again");
        } else {
            this.mAdapter.setTrackListener(this);
            this.mAdapter.startTracking();
        }
    }

    public void stopTrackingView() {
        if (this.mAdapter == null) {
            Log.w((String)TAG, (String)"Error: Ad not loaded, or failed during load, please reload it again");
        } else {
            this.mAdapter.stopTracking();
            this.mAdapter.setTrackListener(null);
        }
    }

    @Override
    public void onAdapterLoadFinished(PNLayoutAdapter pNLayoutAdapter) {
        this.trackSuccededNetwork(pNLayoutAdapter.getElapsedTime());
        this.mAdapter = (PNLayoutFeedAdapter)pNLayoutAdapter;
        this.invokeFinish();
    }

    @Override
    public void onAdapterLoadFail(PNLayoutAdapter pNLayoutAdapter, Exception exception) {
        if (exception.getClass().isAssignableFrom(PNException.class)) {
            this.trackUnreachableNetwork(pNLayoutAdapter.getElapsedTime(), exception);
        } else {
            this.trackAttemptedNetwork(pNLayoutAdapter.getElapsedTime(), exception);
        }
        this.getNextNetwork();
    }

    @Override
    public void onAdapterTrackImpression() {
        this.invokeImpression();
    }

    @Override
    public void onAdapterTrackClick() {
        this.invokeClick();
    }

    @Override
    protected void onPubnativeNetworkLayoutWaterfallLoadFinish(boolean bl) {
        if (bl && this.mAdapter == null) {
            this.invokeFail(PNException.PLACEMENT_PACING_CAP);
        } else if (bl) {
            this.invokeFinish();
        } else {
            this.getNextNetwork();
        }
    }

    @Override
    protected void onPubnativeNetworkLayoutWaterfallLoadFail(Exception exception) {
        this.invokeFail(exception);
    }

    @Override
    protected void onPubnativeNetworkLayoutWaterfallNextNetwork(Map map) {
        PNLayoutAdapter pNLayoutAdapter = PNSmallLayoutAdapterFactory.getAdapter(this.mPlacement.getCurrentNetwork());
        if (pNLayoutAdapter == null) {
            this.trackUnreachableNetwork(0L, PNException.ADAPTER_TYPE_NOT_IMPLEMENTED);
            this.getNextNetwork();
        } else {
            pNLayoutAdapter.setCPICacheEnabled(this.mPlacement.getCurrentNetwork().isCPACacheEnabled());
            pNLayoutAdapter.setInsight(this.mInsight);
            pNLayoutAdapter.setLoadListener(this);
            pNLayoutAdapter.execute(this.mContext, this.mPlacement.getCurrentNetwork().getTimeout());
        }
    }
}

