/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.utils;

import android.content.Context;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;

public class PNAPISystemUtils {
    private static final String TAG = PNAPISystemUtils.class.getSimpleName();
    private static String sWebViewUserAgent = null;

    public static String getWebViewUserAgent() {
        if (sWebViewUserAgent == null) {
            try {
                sWebViewUserAgent = System.getProperty("http.agent");
            }
            catch (Exception exception) {
                Log.w((String)TAG, (String)"getWebViewUserAgent - Error: cannot inject user agent");
            }
        }
        return sWebViewUserAgent;
    }

    public static Location getLocation(Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        LocationListener locationListener = new LocationListener(){

            public void onLocationChanged(Location location) {
            }

            public void onStatusChanged(String string, int n, Bundle bundle) {
            }

            public void onProviderEnabled(String string) {
            }

            public void onProviderDisabled(String string) {
            }
        };
        Criteria criteria = new Criteria();
        criteria.setPowerRequirement(1);
        criteria.setAccuracy(2);
        criteria.setSpeedRequired(true);
        String string = locationManager.getBestProvider(criteria, true);
        Location location = null;
        if (string != null && (location = locationManager.getLastKnownLocation(string)) == null) {
            locationManager.requestLocationUpdates(string, 0L, 0.0f, locationListener);
        }
        return location;
    }

    public static int dpToPx(Context context, int n) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        return Math.round((float)n * (displayMetrics.xdpi / 160.0f));
    }
}

