/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.core.request;

import android.content.Context;
import android.location.Location;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pubnative.api.core.network.PNAPIHttpRequest;
import net.pubnative.api.core.request.model.PNAPIAdModel;
import net.pubnative.api.core.request.model.api.PNAPIV3AdModel;
import net.pubnative.api.core.request.model.api.PNAPIV3ResponseModel;
import net.pubnative.api.core.utils.PNAPICrypto;
import net.pubnative.sdk.core.PNSettings;

public class PNAPIRequest
implements PNAPIHttpRequest.Listener {
    private static String TAG = PNAPIRequest.class.getSimpleName();
    @Deprecated
    protected static final String BASE_URL = "https://api.pubnative.net/api/v3/native";
    protected Context mContext = null;
    protected Map<String, String> mRequestParameters = new HashMap<String, String>();
    protected Listener mListener = null;
    protected PNAPIHttpRequest mRequest = null;
    protected boolean mIsRunning = false;

    public void setParameter(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)"Invalid key passed for parameter");
        } else if (TextUtils.isEmpty((CharSequence)string2)) {
            this.mRequestParameters.remove(string);
        } else {
            this.mRequestParameters.put(string, string2);
        }
    }

    public void setParameterArray(String string, String[] stringArray) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Log.w((String)TAG, (String)"Invalid key passed for parameter");
        } else if (stringArray == null) {
            this.mRequestParameters.remove(string);
        } else {
            this.mRequestParameters.put(string, TextUtils.join((CharSequence)",", (Object[])stringArray));
        }
    }

    public void start(Context context, Listener listener) {
        if (listener == null) {
            Log.w((String)TAG, (String)"start - listener is null and required, dropping call");
        } else if (context == null) {
            Log.w((String)TAG, (String)"start - context is null and required, dropping call");
        } else if (this.mIsRunning) {
            Log.w((String)TAG, (String)"start - this request is already running, dropping the call");
        } else {
            this.mIsRunning = true;
            this.mListener = listener;
            this.mContext = context;
            this.fillDefaultParameters();
            this.doRequest();
        }
    }

    public void setTestMode(boolean bl) {
        this.setParameter("test", bl ? "1" : "0");
    }

    public void setCoppaMode(boolean bl) {
        this.setParameter("coppa", bl ? "1" : "0");
    }

    public void setTimeout(int n) {
        PNAPIHttpRequest.setConnectionTimeout(n);
    }

    protected void fillDefaultParameters() {
        this.mRequestParameters.put("os", PNSettings.os);
        this.mRequestParameters.put("osver", PNSettings.osVersion);
        this.mRequestParameters.put("devicemodel", PNSettings.deviceName);
        this.mRequestParameters.put("locale", PNSettings.locale);
        this.setAdvertisingID();
        this.setLocation();
        this.setDefaultAssetFields();
        this.setDefaultMetaFields();
    }

    protected void setAdvertisingID() {
        if (TextUtils.isEmpty((CharSequence)PNSettings.advertisingId)) {
            this.mRequestParameters.put("dnt", "1");
        } else {
            this.mRequestParameters.put("gid", PNSettings.advertisingId);
            this.mRequestParameters.put("gidsha1", PNAPICrypto.sha1(PNSettings.advertisingId));
            this.mRequestParameters.put("gidmd5", PNAPICrypto.md5(PNSettings.advertisingId));
        }
    }

    protected void setLocation() {
        Location location = PNSettings.location;
        if (location != null) {
            this.mRequestParameters.put("long", String.valueOf(location.getLongitude()));
            this.mRequestParameters.put("lat", String.valueOf(location.getLatitude()));
        }
    }

    protected void setDefaultAssetFields() {
        if (!this.mRequestParameters.containsKey("al") && !this.mRequestParameters.containsKey("af")) {
            this.setParameterArray("af", new String[]{"title", "description", "icon", "banner", "cta", "rating"});
        }
    }

    protected void setDefaultMetaFields() {
        String string = this.mRequestParameters.get("mf");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            Arrays.asList(TextUtils.split((String)string, (String)","));
        }
        arrayList.add("revenuemodel");
        arrayList.add("contentinfo");
        this.setParameterArray("mf", arrayList.toArray(new String[0]));
    }

    protected String getRequestURL() {
        Uri.Builder builder = Uri.parse((String)BASE_URL).buildUpon();
        for (String string : this.mRequestParameters.keySet()) {
            String string2 = this.mRequestParameters.get(string);
            if (string == null || string2 == null) continue;
            builder.appendQueryParameter(string, string2);
        }
        return builder.build().toString();
    }

    protected void doRequest() {
        String string = this.getRequestURL();
        if (string == null) {
            this.invokeOnFail(new Exception("PNAPIRequest - Error: invalid request URL"));
        } else {
            this.mRequest = new PNAPIHttpRequest();
            this.mRequest.start(this.mContext, string, this);
        }
    }

    protected boolean isCoppaModeEnabled() {
        boolean bl = false;
        String string = this.mRequestParameters.get("coppa");
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bl = string.equalsIgnoreCase("1");
        }
        return bl;
    }

    protected void processStream(String string) {
        PNAPIV3ResponseModel pNAPIV3ResponseModel = null;
        Exception exception = null;
        try {
            pNAPIV3ResponseModel = (PNAPIV3ResponseModel)new Gson().fromJson(string, PNAPIV3ResponseModel.class);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        catch (Error error) {
            exception = new Exception("Response can not be parsed!", error);
        }
        if (exception != null) {
            this.invokeOnFail(exception);
        } else if (pNAPIV3ResponseModel == null) {
            this.invokeOnFail(new Exception("PNAPIRequest - Parse error"));
        } else if ("ok".equals(pNAPIV3ResponseModel.status)) {
            ArrayList<PNAPIAdModel> arrayList = null;
            if (pNAPIV3ResponseModel.ads != null) {
                for (PNAPIV3AdModel pNAPIV3AdModel : pNAPIV3ResponseModel.ads) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<PNAPIAdModel>();
                    }
                    arrayList.add(PNAPIAdModel.create(pNAPIV3AdModel));
                }
            }
            this.invokeOnSuccess(arrayList);
        } else {
            this.invokeOnFail(new Exception("PNAPIRequest - Server error: " + pNAPIV3ResponseModel.error_message));
        }
    }

    protected void invokeOnSuccess(List<PNAPIAdModel> list) {
        this.mIsRunning = false;
        if (this.mListener != null) {
            this.mListener.onPNAPIRequestFinish(this, list);
        }
        this.mListener = null;
    }

    protected void invokeOnFail(Exception exception) {
        this.mIsRunning = false;
        if (this.mListener != null) {
            this.mListener.onPNAPIRequestFail(this, exception);
        }
        this.mListener = null;
    }

    @Override
    public void onPNAPIHttpRequestFinish(PNAPIHttpRequest pNAPIHttpRequest, String string, int n) {
        if (200 == n || 422 == n) {
            this.processStream(string);
        } else {
            this.invokeOnFail(new Exception("PNAPIRequest - Response error: " + n));
        }
    }

    @Override
    public void onPNAPIHttpRequestFail(PNAPIHttpRequest pNAPIHttpRequest, Exception exception) {
        this.invokeOnFail(exception);
    }

    public static interface Listener {
        public void onPNAPIRequestFinish(PNAPIRequest var1, List<PNAPIAdModel> var2);

        public void onPNAPIRequestFail(PNAPIRequest var1, Exception var2);
    }

    public static interface Parameters {
        public static final String APP_TOKEN = "apptoken";
        public static final String ANDROID_ADVERTISER_ID = "gid";
        public static final String ANDROID_ADVERTISER_ID_SHA1 = "gidsha1";
        public static final String ANDROID_ADVERTISER_ID_MD5 = "gidmd5";
        public static final String OS = "os";
        public static final String OS_VERSION = "osver";
        public static final String DEVICE_MODEL = "devicemodel";
        public static final String NO_USER_ID = "dnt";
        public static final String LOCALE = "locale";
        public static final String AD_COUNT = "adcount";
        public static final String ZONE_ID = "zoneid";
        public static final String LAT = "lat";
        public static final String LONG = "long";
        public static final String GENDER = "gender";
        public static final String AGE = "age";
        public static final String KEYWORDS = "keywords";
        public static final String APP_VERSION = "appver";
        public static final String TEST = "test";
        public static final String COPPA = "coppa";
        public static final String VIDEO = "video";
        public static final String META_FIELDS = "mf";
        public static final String ASSET_FIELDS = "af";
        public static final String ASSET_LAYOUT = "al";
    }
}

