/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.sdk.layouts;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import net.pubnative.sdk.core.exceptions.PNException;
import net.pubnative.sdk.layouts.PNLayoutWaterfall;

public abstract class PNLayout
extends PNLayoutWaterfall {
    private static final String TAG = PNLayout.class.getSimpleName();
    protected LoadListener mLoadListener;
    protected TrackListener mTrackListener;

    public void load(Context context, String string, String string2) {
        if (this.mLoadListener == null) {
            Log.w((String)TAG, (String)"load - Error: listener was not set, have you configured one using setLoadListener()?");
        }
        if (context == null || TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            Log.w((String)TAG, (String)"Error: placement was null or emtpy and required");
            this.invokeFail(PNException.REQUEST_PARAMETERS_INVALID);
        } else {
            this.initialize(context, string, string2);
        }
    }

    protected void invokeFinish() {
        if (this.mLoadListener != null) {
            this.mLoadListener.onPNLayoutLoadFinish(this);
        }
    }

    protected void invokeFail(Exception exception) {
        if (this.mLoadListener != null) {
            this.mLoadListener.onPNLayoutLoadFail(this, exception);
        }
    }

    protected void invokeImpression() {
        if (this.mInsight != null) {
            this.mInsight.sendImpressionInsight();
        }
        if (this.mTrackListener != null) {
            this.mTrackListener.onPNLayoutTrackImpression(this);
        }
    }

    protected void invokeClick() {
        if (this.mInsight != null) {
            this.mInsight.sendClickInsight();
        }
        if (this.mTrackListener != null) {
            this.mTrackListener.onPNLayoutTrackClick(this);
        }
    }

    public void setLoadListener(LoadListener loadListener) {
        this.mLoadListener = loadListener;
    }

    public void setTrackListener(TrackListener trackListener) {
        this.mTrackListener = trackListener;
    }

    public static interface TrackListener {
        public void onPNLayoutTrackImpression(PNLayout var1);

        public void onPNLayoutTrackClick(PNLayout var1);
    }

    public static interface LoadListener {
        public void onPNLayoutLoadFinish(PNLayout var1);

        public void onPNLayoutLoadFail(PNLayout var1, Exception var2);
    }
}

