/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.layouts.asset_group;

import android.content.Context;
import android.util.Log;
import java.lang.reflect.Constructor;
import net.pubnative.api.core.request.model.PNAPIAdModel;
import net.pubnative.api.layouts.asset_group.PNAPIAssetGroup;

public class PNAPIAssetGroupFactory {
    private static final String TAG = PNAPIAssetGroupFactory.class.getSimpleName();
    private static final String PACKAGE = PNAPIAssetGroupFactory.class.getPackage().getName();
    private static final String CLASS_NAME_BASE = PNAPIAssetGroup.class.getSimpleName();

    public static PNAPIAssetGroup createView(Context context, PNAPIAdModel pNAPIAdModel) {
        PNAPIAssetGroup pNAPIAssetGroup = null;
        if (pNAPIAdModel.getAssetGroupId() == 0) {
            Log.e((String)TAG, (String)"Error: Ad model used is not compatible with asset groups");
        } else {
            try {
                String string = PACKAGE + "." + CLASS_NAME_BASE + String.valueOf(pNAPIAdModel.getAssetGroupId());
                Class<?> clazz = Class.forName(string);
                Constructor<?> constructor = clazz.getConstructor(Context.class);
                pNAPIAssetGroup = (PNAPIAssetGroup)((Object)constructor.newInstance(context));
                if (pNAPIAssetGroup == null) {
                    Log.e((String)TAG, (String)"Error: cannot initialise the view");
                } else {
                    pNAPIAssetGroup.mAdModel = pNAPIAdModel;
                }
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Error creating the asset group view", (Throwable)exception);
            }
        }
        return pNAPIAssetGroup;
    }
}

