/*
 * Decompiled with CFR 0.152.
 */
package net.pubnative.api.layouts.asset_group;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RatingBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import net.pubnative.api.core.request.model.PNAPIAdModel;
import net.pubnative.api.core.utils.PNAPIImageDownloader;
import net.pubnative.api.layouts.PNAPILayoutView;
import net.pubnative.api.layouts.asset_group.PNAPIAssetGroup;
import net.pubnative.sdk.R;

public class PNAPIAssetGroup16
extends PNAPIAssetGroup
implements PNAPIAdModel.Listener {
    protected RelativeLayout mRoot;
    protected RelativeLayout mHeader;
    protected RelativeLayout mBody;
    protected TextView mTitle;
    protected TextView mDescription;
    protected TextView mCallToAction;
    protected ImageView mIcon;
    protected ImageView mBanner;
    protected RatingBar mRating;
    protected PNAPILayoutView.IDMap mIdMap;
    protected RelativeLayout mContentInfo;

    public PNAPIAssetGroup16(Context context) {
        super(context);
    }

    @Override
    public void load() {
        this.loadView();
        this.mTitle.setText((CharSequence)this.mAdModel.getTitle());
        this.mDescription.setText((CharSequence)this.mAdModel.getDescription());
        this.mCallToAction.setText((CharSequence)this.mAdModel.getCtaText());
        this.mRating.setRating((float)this.mAdModel.getRating());
        new PNAPIImageDownloader().load(this.mAdModel.getIconUrl(), new PNAPIImageDownloader.Listener(){

            @Override
            public void onImageLoad(String string, Bitmap bitmap) {
                PNAPIAssetGroup16.this.mIcon.setImageBitmap(bitmap);
                new PNAPIImageDownloader().load(PNAPIAssetGroup16.this.mAdModel.getBannerUrl(), new PNAPIImageDownloader.Listener(){

                    @Override
                    public void onImageLoad(String string, Bitmap bitmap) {
                        PNAPIAssetGroup16.this.mBanner.setImageBitmap(bitmap);
                        PNAPIAssetGroup16.this.invokeOnLoadFinish();
                    }

                    @Override
                    public void onImageFailed(String string, Exception exception) {
                        PNAPIAssetGroup16.this.invokeOnLoadFail(exception);
                    }
                });
            }

            @Override
            public void onImageFailed(String string, Exception exception) {
                PNAPIAssetGroup16.this.invokeOnLoadFail(exception);
            }
        });
        View view = this.mAdModel.getContentInfo(this.mContext);
        if (view != null) {
            this.mContentInfo.addView(view);
        }
    }

    protected void loadView() {
        this.mRoot = (RelativeLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.pubnative_asset_group_16, (ViewGroup)this, true);
        this.mHeader = (RelativeLayout)this.mRoot.findViewById(R.id.pubnative_header);
        this.mBody = (RelativeLayout)this.mRoot.findViewById(R.id.pubnative_body);
        this.mTitle = (TextView)this.mBody.findViewById(R.id.pubnative_title);
        this.mIcon = (ImageView)this.mBody.findViewById(R.id.pubnative_icon);
        this.mRating = (RatingBar)this.mBody.findViewById(R.id.pubnative_rating);
        this.mBanner = (ImageView)this.mHeader.findViewById(R.id.pubnative_banner);
        this.mDescription = (TextView)this.mRoot.findViewById(R.id.pubnative_description);
        this.mCallToAction = (TextView)this.mRoot.findViewById(R.id.pubnative_callToAction);
        this.mContentInfo = (RelativeLayout)this.mRoot.findViewById(R.id.pubnative_content_info_container);
    }

    @Override
    public void startTracking() {
        this.mAdModel.startTracking((View)this.mRoot, this);
    }

    @Override
    public void stopTracking() {
        this.mAdModel.stopTracking();
    }

    @Override
    public PNAPILayoutView.IDMap getIDMap() {
        if (this.mIdMap == null) {
            this.mIdMap = new PNAPILayoutView.IDMap(this);
            this.mIdMap.title = this.mTitle.getId();
            this.mIdMap.description = this.mDescription.getId();
            this.mIdMap.icon = this.mIcon.getId();
            this.mIdMap.banner = this.mBanner.getId();
            this.mIdMap.starRating = this.mRating.getId();
            this.mIdMap.callToAction = this.mCallToAction.getId();
        }
        return this.mIdMap;
    }

    @Override
    public void onPNAPIAdModelImpression(PNAPIAdModel pNAPIAdModel, View view) {
        this.invokeOnImpressionConfirmed();
    }

    @Override
    public void onPNAPIAdModelClick(PNAPIAdModel pNAPIAdModel, View view) {
        this.invokeOnClick();
    }

    @Override
    public void onPNAPIAdModelOpenOffer(PNAPIAdModel pNAPIAdModel) {
    }
}

